/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickIntersection;
import e3d.bezier.Needle;
import e3d.euclidean.E3DTransform;
import e3d.euclidean.E3DVector;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.history.NeedleHistoryState;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DMasterObject;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.objects.J3DTangent;
import e3d.j3d.objects.util.J3DAtomicPart;
import e3d.j3d.objects.util.J3DDependencies;
import e3d.j3d.util.J3DEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class J3DNeedle
extends J3DTangent
implements J3DMasterObject {
    protected HeadSphere head;
    protected TailCylinder tail;
    protected PeakCone peak;
    protected final Parameters parameters;
    protected final J3DDependencies dependencies = new J3DDependencies();

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DNeedle(Needle tangent, Parameters parameters) {
        super(tangent, true);
        this.parameters = parameters;
        this.createParts();
    }

    @Override
    public void recreate() {
        this.createParts();
    }

    public BranchGroup createParts() {
        BranchGroup parts = new BranchGroup();
        parts.setCapability(17);
        this.head = new HeadSphere(this.parameters.headRadius * this.parameters.scale);
        this.tail = new TailCylinder(this.parameters.tailRadius * this.parameters.scale, this.parameters.tailLength * this.parameters.scale);
        this.peak = new PeakCone(this.parameters.tailRadius * this.parameters.scale, this.parameters.peakLength * this.parameters.scale);
        TransformGroup headGroup = this.createHead(this.head, false);
        TransformGroup tailGroup = this.createTail(this.tail, false);
        TransformGroup peakGroup = this.createPeak(this.peak, false);
        parts.addChild((Node)peakGroup);
        parts.addChild((Node)tailGroup);
        parts.addChild((Node)headGroup);
        this.anchor.removeAllChildren();
        this.anchor.addChild((Node)parts);
        this.head.setTransparency(this.transparency);
        this.tail.setTransparency(this.transparency);
        this.peak.setTransparency(this.transparency);
        return parts;
    }

    public void compile() {
        throw new UnsupportedOperationException("Cannot compile needles because they must be able to change capability bits!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scale(double factor) {
        J3DTangent.TangentAnchor tangentAnchor = this.anchor;
        synchronized (tangentAnchor) {
            this.tangent.point.multiplicate(factor);
            this.reshape();
        }
    }

    @Override
    public void updated() {
        super.updated();
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        super.transformed(transformedAnchor, type);
    }

    @Override
    public void transform(J3DMasterObject.Transformation transformation) {
        switch (transformation) {
            case X_MIRRORING: {
                this.tangent.point.x = -this.tangent.point.x;
                this.tangent.normal.x = -this.tangent.normal.x;
                break;
            }
            case Y_MIRRORING: {
                this.tangent.point.y = -this.tangent.point.y;
                this.tangent.normal.y = -this.tangent.normal.y;
                break;
            }
            case Z_MIRRORING: {
                this.tangent.point.z = -this.tangent.point.z;
                this.tangent.normal.z = -this.tangent.normal.z;
                break;
            }
            case ROTATE_LEFT_Z: {
                this.tangent.point.spinZ(1.5707963267948966);
                this.tangent.normal.spinZ(1.5707963267948966);
                break;
            }
            case ROTATE_RIGHT_Z: {
                this.tangent.point.spinZ(-1.5707963267948966);
                this.tangent.normal.spinZ(-1.5707963267948966);
                break;
            }
            case ROTATE_LEFT_Y: {
                this.tangent.point.spinY(-1.5707963267948966);
                this.tangent.normal.spinY(-1.5707963267948966);
                break;
            }
            case ROTATE_RIGHT_Y: {
                this.tangent.point.spinY(1.5707963267948966);
                this.tangent.normal.spinY(1.5707963267948966);
                break;
            }
            case ROTATE_FRONT_X: {
                this.tangent.point.spinX(1.5707963267948966);
                this.tangent.normal.spinX(1.5707963267948966);
                break;
            }
            case ROTATE_BACK_X: {
                this.tangent.point.spinX(-1.5707963267948966);
                this.tangent.normal.spinX(-1.5707963267948966);
            }
        }
        this.reshape();
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            if (this.group != null) {
                this.group.getAnchor().removeChild((Node)this);
                this.anchor.clearCapability(1);
                this.group.getAnchor().addChild((Node)this);
            }
            this.head.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
            this.tail.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
            this.peak.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
        } else {
            if (this.group != null) {
                this.group.getAnchor().removeChild((Node)this);
                this.anchor.setCapability(1);
                this.group.getAnchor().addChild((Node)this);
            }
            this.head.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
            this.tail.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
            this.peak.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void setTransparency(float transparency) {
        super.setTransparency(transparency);
        this.head.setTransparency(transparency);
        this.tail.setTransparency(transparency);
        this.peak.setTransparency(transparency);
    }

    @Override
    public J3DDependencies getDependencies() {
        return this.dependencies;
    }

    public void interpolate(double interpolationRadius, Function interpolationFunction, Set<J3DInstance> objects, J3DHistory history) {
        HashSet<J3DSlaveObject> slaves = new HashSet<J3DSlaveObject>();
        slaves.addAll(this.getDependencies().getSlaves());
        if (interpolationRadius >= 0.0) {
            Needle myOrigTan = ((NeedleHistoryState)history.getCurrent(this).getPrevious()).getTangent();
            E3DVector delta = this.tangent.point.diff(myOrigTan.point);
            for (J3DInstance object : objects) {
                double comp;
                double factor;
                if (object == this || object.isSelected() || !object.isLive() || !(object instanceof J3DNeedle)) continue;
                J3DNeedle needle = (J3DNeedle)object;
                Needle origTan = ((NeedleHistoryState)history.getCurrent(needle).getPrevious()).getTangent();
                double dist = Math.min(1.0, myOrigTan.point.dist(origTan.point) / interpolationRadius);
                switch (interpolationFunction) {
                    case SIGMOIDAL: {
                        factor = 1.0 / (1.0 + Math.exp(dist * 8.0 - 4.0));
                        comp = Math.max(0.0, Math.sin(dist * Math.PI) * 1.5);
                        break;
                    }
                    case QUADRATIC: {
                        factor = 1.0 - dist * dist;
                        comp = 1.5;
                        break;
                    }
                    case PLATEAU: {
                        factor = 1.0;
                        comp = 0.0;
                        break;
                    }
                    default: {
                        factor = 1.0 - dist;
                        comp = 1.0;
                    }
                }
                if (factor > 0.0) {
                    E3DVector pos = origTan.point.sum(delta.product(factor));
                    E3DVector normal = origTan.normal.clone();
                    E3DVector dir1 = origTan.point.diff(myOrigTan.point);
                    E3DVector dir2 = pos.diff(this.tangent.point);
                    E3DVector axis = dir1.crossProduct(dir2);
                    double angle = dir1.angle(dir2);
                    if (axis.isValid() && !Double.isNaN(angle)) {
                        E3DTransform transform = new E3DTransform();
                        transform.setRotation(axis, angle * comp);
                        transform.transformNormal(normal);
                    }
                    Needle tangent = new Needle(pos, normal);
                    needle.setTangent(tangent);
                }
                slaves.addAll(needle.getDependencies().getSlaves());
            }
        }
        for (J3DSlaveObject slave : slaves) {
            slave.reshape();
        }
    }

    protected void clicked(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.clicked(this, event, intersection);
        }
    }

    protected void movedOver(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.movedOver(this, event, intersection);
        }
    }

    protected void typed(KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.typed(this, event, intersection);
        }
    }

    protected TransformGroup createHead(HeadSphere head, boolean reversed) {
        Transform3D transform = new Transform3D();
        if (reversed) {
            transform.set(new Vector3d(0.0, (double)(this.parameters.tailLength * this.parameters.scale + this.parameters.peakLength * this.parameters.scale), 0.0));
        } else {
            transform.set(new Vector3d(0.0, (double)(-this.parameters.tailLength * this.parameters.scale - this.parameters.peakLength * this.parameters.scale), 0.0));
        }
        TransformGroup headGroup = new TransformGroup(transform);
        headGroup.addChild((Node)head);
        return headGroup;
    }

    protected TransformGroup createTail(TailCylinder tail, boolean reversed) {
        Transform3D transform = new Transform3D();
        if (reversed) {
            transform.set(new Vector3d(0.0, (double)(this.parameters.tailLength * this.parameters.scale) / 2.0 + (double)(this.parameters.peakLength * this.parameters.scale), 0.0));
        } else {
            transform.set(new Vector3d(0.0, -((double)(this.parameters.tailLength * this.parameters.scale) / 2.0) - (double)(this.parameters.peakLength * this.parameters.scale), 0.0));
        }
        TransformGroup tailGroup = new TransformGroup(transform);
        tailGroup.addChild((Node)tail);
        return tailGroup;
    }

    protected TransformGroup createPeak(PeakCone peak, boolean reversed) {
        Transform3D transform = new Transform3D();
        if (reversed) {
            transform.rotZ(Math.PI);
            transform.setTranslation(new Vector3d(0.0, (double)(this.parameters.peakLength * this.parameters.scale) / 2.0, 0.0));
        } else {
            transform.set(new Vector3d(0.0, -((double)(this.parameters.peakLength * this.parameters.scale) / 2.0), 0.0));
        }
        TransformGroup peakGroup = new TransformGroup(transform);
        peakGroup.addChild((Node)peak);
        return peakGroup;
    }

    private J3DNeedle getThis() {
        return this;
    }

    public static enum Function {
        LINEAR,
        QUADRATIC,
        SIGMOIDAL,
        PLATEAU;

    }

    protected class HeadSphere
    extends Sphere
    implements J3DAtomicPart {
        protected HeadSphere(float radius) {
            super(radius);
            Material material = new Material();
            material.setAmbientColor(J3DNeedle.this.parameters.headColor);
            material.setDiffuseColor(J3DNeedle.this.parameters.headColor);
            material.setSpecularColor(J3DNeedle.this.parameters.headColor);
            material.setCapability(1);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(new PolygonAttributes(2, 1, 0.0f));
            appearance.setColoringAttributes(new ColoringAttributes(J3DNeedle.this.parameters.headColor, 0));
            appearance.setMaterial(material);
            appearance.setCapability(11);
            this.setAppearance(appearance);
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(transparency == 0.0f ? 4 : 0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DNeedle getObject() {
            return J3DNeedle.this.getThis();
        }
    }

    public static class Parameters {
        public float headRadius = 0.005f;
        public float tailRadius = 0.0015f;
        public float peakLength = 0.0025f;
        public float tailLength = 0.025f;
        public Color3f headColor = new Color3f(0.0f, 0.8f, 0.0f);
        public Color3f tailColor = new Color3f(0.5f, 0.5f, 0.5f);
        public float scale = 1.0f;
    }

    protected class PeakCone
    extends Cone
    implements J3DAtomicPart {
        protected PeakCone(float radius, float length) {
            super(radius, length);
            Material material = new Material();
            material.setAmbientColor(J3DNeedle.this.parameters.tailColor);
            material.setDiffuseColor(J3DNeedle.this.parameters.tailColor);
            material.setSpecularColor(J3DNeedle.this.parameters.tailColor);
            material.setCapability(1);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(new PolygonAttributes(2, 1, 0.0f));
            appearance.setColoringAttributes(new ColoringAttributes(J3DNeedle.this.parameters.tailColor, 0));
            appearance.setMaterial(material);
            appearance.setCapability(11);
            this.setAppearance(appearance);
            this.getShape(1).setUserData((Object)J3DNeedle.this.getThis());
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(transparency == 0.0f ? 4 : 0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DNeedle getObject() {
            return J3DNeedle.this.getThis();
        }
    }

    protected class TailCylinder
    extends Cylinder
    implements J3DAtomicPart {
        protected TailCylinder(float radius, float length) {
            super(radius, length);
            Material material = new Material();
            material.setAmbientColor(J3DNeedle.this.parameters.tailColor);
            material.setDiffuseColor(J3DNeedle.this.parameters.tailColor);
            material.setSpecularColor(J3DNeedle.this.parameters.tailColor);
            material.setCapability(1);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(new PolygonAttributes(2, 1, 0.0f));
            appearance.setColoringAttributes(new ColoringAttributes(J3DNeedle.this.parameters.tailColor, 0));
            appearance.setMaterial(material);
            appearance.setCapability(11);
            this.setAppearance(appearance);
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DNeedle.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(transparency == 0.0f ? 4 : 0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DNeedle getObject() {
            return J3DNeedle.this.getThis();
        }
    }
}

