/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickIntersection;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.objects.util.J3DAtomicPart;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class J3DInterpolationRadius
extends J3DObject {
    protected final MouseAnchor anchor;
    protected final Parameters parameters;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DInterpolationRadius(Vector3f position, float radius, Parameters parameters) {
        this.parameters = parameters;
        this.transformation.setTranslation(position);
        this.anchor = new MouseAnchor(this.transformation);
        this.anchor.setCapability(18);
        this.anchor.setCapability(17);
        this.anchor.setCapability(13);
        this.anchor.setCapability(14);
        BranchGroup group = new BranchGroup();
        group.setCapability(17);
        group.addChild((Node)new InterpolationSphere(parameters.color, parameters.transparency, radius));
        this.anchor.addChild((Node)group);
        this.setPickable(false);
        this.setCapability(17);
        this.addChild((Node)this.anchor);
    }

    @Override
    public void recreate() {
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setPosition(Point3d position) {
        this.transformation.setTranslation(new Vector3d((Tuple3d)position));
        this.anchor.setTransform(this.transformation);
    }

    public void setRadius(float radius) {
        this.anchor.removeAllChildren();
        BranchGroup group = new BranchGroup();
        group.setCapability(17);
        group.addChild((Node)new InterpolationSphere(this.parameters.color, this.parameters.transparency, radius));
        this.anchor.addChild((Node)group);
    }

    @Override
    public void setGroup(J3DGroup group) {
        this.group = group;
    }

    @Override
    protected J3DAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    public void updated() {
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
    }

    @Override
    public void reshape() {
    }

    private J3DInterpolationRadius getThis() {
        return this;
    }

    protected class InterpolationSphere
    extends Sphere
    implements J3DAtomicPart {
        protected InterpolationSphere(Color3f color, float transparency, float radius) {
            super(radius, 0, 32);
            Material material = new Material();
            material.setEmissiveColor(color);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(new PolygonAttributes(2, 1, 0.0f));
            appearance.setColoringAttributes(new ColoringAttributes(color, 0));
            appearance.setMaterial(material);
            appearance.setTransparencyAttributes(new TransparencyAttributes(0, transparency));
            appearance.setCapability(11);
            this.setAppearance(appearance);
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DInterpolationRadius getObject() {
            return J3DInterpolationRadius.this.getThis();
        }
    }

    protected class MouseAnchor
    extends J3DAnchor {
        protected MouseAnchor(Transform3D transformation) {
            super(transformation);
        }

        @Override
        public void transformed(int type) {
        }

        @Override
        public void transformationFinished(int type) {
        }
    }

    public static class Parameters {
        public Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
        public float transparency = 0.8f;
        public Bounds lightBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 50.0);
    }
}

