/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.bezier.Needle;
import e3d.j3d.objects.J3DNeedle;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;

public class J3DDoubleNeedle
extends J3DNeedle {
    protected J3DNeedle.HeadSphere head2;
    protected J3DNeedle.TailCylinder tail2;
    protected J3DNeedle.PeakCone peak2;

    public J3DDoubleNeedle(Needle tangent, J3DNeedle.Parameters parameters) {
        super(tangent, parameters);
        this.anchor.setCapability(14);
        this.createParts();
    }

    @Override
    public BranchGroup createParts() {
        BranchGroup parts = super.createParts();
        BranchGroup parts2 = new BranchGroup();
        parts2.setCapability(17);
        this.head2 = new J3DNeedle.HeadSphere(this, this.parameters.headRadius * this.parameters.scale);
        this.tail2 = new J3DNeedle.TailCylinder(this, this.parameters.tailRadius * this.parameters.scale, this.parameters.tailLength * this.parameters.scale);
        this.peak2 = new J3DNeedle.PeakCone(this, this.parameters.tailRadius * this.parameters.scale, this.parameters.peakLength * this.parameters.scale);
        TransformGroup headGroup2 = this.createHead(this.head2, true);
        TransformGroup tailGroup2 = this.createTail(this.tail2, true);
        TransformGroup peakGroup2 = this.createPeak(this.peak2, true);
        parts2.addChild((Node)peakGroup2);
        parts2.addChild((Node)tailGroup2);
        parts2.addChild((Node)headGroup2);
        this.anchor.addChild((Node)parts2);
        this.head2.setTransparency(this.transparency);
        this.tail2.setTransparency(this.transparency);
        this.peak2.setTransparency(this.transparency);
        return parts;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            this.head2.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
            this.tail2.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
            this.peak2.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
        } else {
            this.head2.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
            this.tail2.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
            this.peak2.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void setTransparency(float transparency) {
        super.setTransparency(transparency);
        this.head2.setTransparency(transparency);
        this.tail2.setTransparency(transparency);
        this.peak2.setTransparency(transparency);
    }
}

