/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.history;

import e3d.bezier.LayerMesh;
import e3d.euclidean.E3DTransform;
import e3d.j3d.history.HistoryState;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DLayerMesh;
import e3d.j3d.objects.J3DObject;
import e3d.visualization.image.E3DImageAWT;
import e3d.visualization.util.E3DColor;
import java.util.Collection;
import java.util.Vector;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;

public class LayerMeshHistoryState
extends HistoryState {
    public static final int PRIORITY = 9;
    protected final J3DLayerMesh mesh;
    protected LayerMesh attr;
    protected E3DImageAWT individualTexture;
    protected boolean useMipMapsForIndividualTexture;
    protected boolean selected;
    protected Collection<String> tags;

    protected LayerMeshHistoryState(J3DLayerMesh mesh, J3DHistory history) {
        super(history, 9);
        this.mesh = mesh;
        this.attr = mesh.getMeshAttributes().clone();
        this.store(null, null);
    }

    private LayerMeshHistoryState(J3DLayerMesh mesh, J3DHistory history, LayerMeshHistoryState predecessor, J3DHistory.Part part) {
        super(history, 9);
        this.mesh = mesh;
        this.attr = mesh.getMeshAttributes().clone();
        this.store(predecessor, part);
    }

    private void store(LayerMeshHistoryState predecessor, J3DHistory.Part part) {
        this.selected = predecessor == null || part == J3DHistory.Part.SELECTION ? this.mesh.isSelected() : predecessor.selected;
        if (predecessor == null || part == J3DHistory.Part.SHAPE || part == J3DHistory.Part.ORIENTATION) {
            this.mesh.getTransform().get(this.attr.transform.getMatrix());
        } else {
            this.attr.transform = predecessor.attr.transform;
        }
        this.tags = predecessor == null || part == J3DHistory.Part.TAGS ? new Vector<String>(this.history.getTagger().getTags(this.mesh)) : predecessor.tags;
        this.attr.color = predecessor == null || part == J3DHistory.Part.COLOR ? new E3DColor((int)(this.mesh.getColor().x * 255.0f), (int)(this.mesh.getColor().y * 255.0f), (int)(this.mesh.getColor().z * 255.0f)) : predecessor.attr.color;
        this.attr.material = predecessor == null || part == J3DHistory.Part.MATERIAL ? (this.mesh.getMaterial() == null ? null : this.mesh.getMaterial().clone()) : predecessor.attr.material;
        if (predecessor == null || part == J3DHistory.Part.TEXTURE) {
            this.attr.texture = this.mesh.getIndividualTexture();
            Texture2D tex = this.mesh.getTexture(0);
            if (tex != null) {
                ImageComponent2D imageComp = (ImageComponent2D)tex.getImage(0);
                this.individualTexture = new E3DImageAWT(imageComp.getImage()).clone();
                this.useMipMapsForIndividualTexture = tex.getMipMapMode() == 2;
            } else {
                this.individualTexture = null;
            }
        } else {
            this.attr.texture = predecessor.attr.texture;
            this.individualTexture = predecessor.individualTexture;
            this.useMipMapsForIndividualTexture = predecessor.useMipMapsForIndividualTexture;
        }
    }

    @Override
    public J3DObject getObject() {
        return this.mesh;
    }

    public E3DTransform getTransform() {
        return this.attr.transform;
    }

    @Override
    protected LayerMeshHistoryState changed(J3DHistory.Part part) {
        if (this.slice == this.history.currentSlice) {
            this.store(this, part);
            return this;
        }
        LayerMeshHistoryState historyState = new LayerMeshHistoryState(this.mesh, this.history, this, part);
        if (this.next != null) {
            this.next.previous = null;
        }
        this.next = historyState;
        historyState.previous = this;
        return historyState;
    }

    @Override
    protected void restore() {
        this.mesh.setTransform(new Transform3D(this.attr.transform.getMatrix()));
        this.mesh.setColor(new Color3f((float)this.attr.color.getRed() / 255.0f, (float)this.attr.color.getGreen() / 255.0f, (float)this.attr.color.getBlue() / 255.0f));
        this.mesh.setTransparency((float)(255 - this.attr.color.getAlpha()) / 255.0f);
        this.mesh.setSelected(this.selected);
        this.history.getTagger().removeObject(this.mesh);
        this.history.getTagger().addTags((J3DInstance)this.mesh, this.tags);
    }

    public String toString() {
        String[] pointNameParts = this.mesh.toString().split("[.@]");
        String[] stateNameParts = super.toString().split("[.@]");
        return "[" + this.slice + "]" + pointNameParts[pointNameParts.length - 2] + "@" + pointNameParts[pointNameParts.length - 1] + ":" + stateNameParts[stateNameParts.length - 1];
    }
}

