/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import e3d.j3d.examples.EulGetOrdInfo;
import e3d.j3d.examples.EulerAngles;
import e3d.j3d.examples.Quat;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;

class Euler {
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    static final int W = 3;
    static final int EulRepNo = 0;
    static final int EulRepYes = 1;
    static final int EulParEven = 0;
    static final int EulParOdd = 1;
    static final int EulFrmS = 0;
    static final int EulFrmR = 1;
    static final float FLT_EPSILON = 1.1920929E-7f;

    Euler() {
    }

    public static int EulOrdXYZs() {
        return Euler.EulOrd(0, 0, 0, 0);
    }

    public static int EulOrdXYXs() {
        return Euler.EulOrd(0, 0, 1, 0);
    }

    public static int EulOrdXZYs() {
        return Euler.EulOrd(0, 1, 0, 0);
    }

    public static int EulOrdXZXs() {
        return Euler.EulOrd(0, 1, 1, 0);
    }

    public static int EulOrdYZXs() {
        return Euler.EulOrd(1, 0, 0, 0);
    }

    public static int EulOrdYZYs() {
        return Euler.EulOrd(1, 0, 1, 0);
    }

    public static int EulOrdYXZs() {
        return Euler.EulOrd(1, 1, 0, 0);
    }

    public static int EulOrdYXYs() {
        return Euler.EulOrd(1, 1, 1, 0);
    }

    public static int EulOrdZXYs() {
        return Euler.EulOrd(2, 0, 0, 0);
    }

    public static int EulOrdZXZs() {
        return Euler.EulOrd(2, 0, 1, 0);
    }

    public static int EulOrdZYXs() {
        return Euler.EulOrd(2, 1, 0, 0);
    }

    public static int EulOrdZYZs() {
        return Euler.EulOrd(2, 1, 1, 0);
    }

    public static int EulOrdZYXr() {
        return Euler.EulOrd(0, 0, 0, 1);
    }

    public static int EulOrdXYXr() {
        return Euler.EulOrd(0, 0, 1, 1);
    }

    public static int EulOrdYZXr() {
        return Euler.EulOrd(0, 1, 0, 1);
    }

    public static int EulOrdXZXr() {
        return Euler.EulOrd(0, 1, 1, 1);
    }

    public static int EulOrdXZYr() {
        return Euler.EulOrd(1, 0, 0, 1);
    }

    public static int EulOrdYZYr() {
        return Euler.EulOrd(1, 0, 1, 1);
    }

    public static int EulOrdZXYr() {
        return Euler.EulOrd(1, 1, 0, 1);
    }

    public static int EulOrdYXYr() {
        return Euler.EulOrd(1, 1, 1, 1);
    }

    public static int EulOrdYXZr() {
        return Euler.EulOrd(2, 0, 0, 1);
    }

    public static int EulOrdZXZr() {
        return Euler.EulOrd(2, 0, 1, 1);
    }

    public static int EulOrdXYZr() {
        return Euler.EulOrd(2, 1, 0, 1);
    }

    public static int EulOrdZYZr() {
        return Euler.EulOrd(2, 1, 1, 1);
    }

    public static int EulFrm(int ord) {
        return ord & 1;
    }

    public static int EulRep(int ord) {
        return ord >> 1 & 1;
    }

    public static int EulPar(int ord) {
        return ord >> 2 & 1;
    }

    public static int EulAxI(int ord) {
        return Euler.EulSafe(ord >> 3 & 3);
    }

    public static int EulAxJ(int ord) {
        int i = 0;
        if (Euler.EulPar(ord) == 1) {
            i = 1;
        }
        return Euler.EulNext(Euler.EulAxI(ord) + i);
    }

    public static int EulAxK(int ord) {
        int i = 0;
        if (Euler.EulPar(ord) != 1) {
            i = 1;
        }
        return Euler.EulNext(Euler.EulAxI(ord) + i);
    }

    public static int EulAxH(int ord) {
        if (Euler.EulRep(ord) == 0) {
            return Euler.EulAxK(ord);
        }
        return Euler.EulAxI(ord);
    }

    public static int EulOrd(int i, int p, int r, int f) {
        return (((i << 1) + p << 1) + r << 1) + f;
    }

    static EulGetOrdInfo EulGetOrd(int ord) {
        EulGetOrdInfo info = new EulGetOrdInfo();
        int o = ord;
        info.f = o & 1;
        info.s = (o >>= 1) & 1;
        info.n = (o >>= 1) & 1;
        info.i = Euler.EulSafe((o >>= 1) & 3);
        info.j = Euler.EulNext(info.i + info.n);
        info.k = Euler.EulNext(info.i + 1 - info.n);
        info.h = info.s != 0 ? info.k : info.i;
        return info;
    }

    static int EulSafe(int val) {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] valArray = nArray;
        return valArray[val];
    }

    static int EulNext(int val) {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[3] = 1;
        int[] valArray = nArray;
        return valArray[val];
    }

    public static EulerAngles Eul_FromMatrix(float[][] M, int order) {
        EulerAngles ea = new EulerAngles();
        EulGetOrdInfo info = Euler.EulGetOrd(order);
        int i = info.i;
        int j = info.j;
        int k = info.k;
        int n = info.n;
        int s = info.s;
        int f = info.f;
        if (s == 1) {
            double sy = Math.sqrt(M[i][j] * M[i][j] + M[i][k] * M[i][k]);
            if (sy > 1.9073486328125E-6) {
                ea.x = (float)Math.atan2(M[i][j], M[i][k]);
                ea.y = (float)Math.atan2(sy, M[i][i]);
                ea.z = (float)Math.atan2(M[j][i], -M[k][i]);
            } else {
                ea.x = (float)Math.atan2(-M[j][k], M[j][j]);
                ea.y = (float)Math.atan2(sy, M[i][i]);
                ea.z = 0.0f;
            }
        } else {
            double cy = Math.sqrt(M[i][i] * M[i][i] + M[j][i] * M[j][i]);
            if (cy > 1.9073486328125E-6) {
                ea.x = (float)Math.atan2(M[k][j], M[k][k]);
                ea.y = (float)Math.atan2(-M[k][i], cy);
                ea.z = (float)Math.atan2(M[j][i], M[i][i]);
            } else {
                ea.x = (float)Math.atan2(-M[j][k], M[j][j]);
                ea.y = (float)Math.atan2(-M[k][i], cy);
                ea.z = 0.0f;
            }
        }
        if (n == 1) {
            ea.x = -ea.x;
            ea.y = -ea.y;
            ea.z = -ea.z;
        }
        if (f == 1) {
            float t = ea.x;
            ea.x = ea.z;
            ea.z = t;
        }
        ea.w = order;
        return ea;
    }

    public static EulerAngles Eul_FromQuat(Quat q, int order) {
        float[][] M = new float[4][4];
        double Nq = q.x * q.x + q.y * q.y + q.z * q.z + q.w * q.w;
        double s = Nq > 0.0 ? 2.0 / Nq : 0.0;
        double xs = (double)q.x * s;
        double ys = (double)q.y * s;
        double zs = (double)q.z * s;
        double wx = (double)q.w * xs;
        double wy = (double)q.w * ys;
        double wz = (double)q.w * zs;
        double xx = (double)q.x * xs;
        double xy = (double)q.x * ys;
        double xz = (double)q.x * zs;
        double yy = (double)q.y * ys;
        double yz = (double)q.y * zs;
        double zz = (double)q.z * zs;
        M[0][0] = (float)(1.0 - (yy + zz));
        M[0][1] = (float)(xy - wz);
        M[0][2] = (float)(xz + wy);
        M[1][0] = (float)(xy + wz);
        M[1][1] = (float)(1.0 - (xx + zz));
        M[1][2] = (float)(yz - wx);
        M[2][0] = (float)(xz - wy);
        M[2][1] = (float)(yz + wx);
        M[2][2] = (float)(1.0 - (xx + yy));
        M[2][3] = 0.0f;
        M[1][3] = 0.0f;
        M[0][3] = 0.0f;
        M[3][2] = 0.0f;
        M[3][1] = 0.0f;
        M[3][0] = 0.0f;
        M[3][3] = 1.0f;
        return Euler.Eul_FromMatrix(M, order);
    }

    public static Point3d getEulerRotation(Transform3D t3d) {
        Point3d Rotation = new Point3d();
        Matrix3d m1 = new Matrix3d();
        t3d.get(m1);
        Rotation.y = -Math.asin(m1.getElement(2, 0));
        double c = Math.cos(Rotation.y);
        if (Math.abs(Rotation.y) > 1.0E-5) {
            double tRx = m1.getElement(2, 2) / c;
            double tRy = -m1.getElement(2, 1) / c;
            Rotation.x = Math.atan2(tRy, tRx);
            tRx = m1.getElement(0, 0) / c;
            tRy = -m1.getElement(1, 0) / c;
            Rotation.z = Math.atan2(tRy, tRx);
        } else {
            Rotation.x = 0.0;
            double tRx = m1.getElement(1, 1);
            double tRy = m1.getElement(0, 1);
            Rotation.z = Math.atan2(tRy, tRx);
        }
        Rotation.x = -Rotation.x;
        Rotation.z = -Rotation.z;
        if (Rotation.x < 0.0) {
            Rotation.x += Math.PI * 2;
        }
        if (Rotation.y < 0.0) {
            Rotation.y += Math.PI * 2;
        }
        if (Rotation.z < 0.0) {
            Rotation.z += Math.PI * 2;
        }
        return Rotation;
    }
}

