/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import e3d.j3d.J3DCanvas;
import e3d.j3d.behaviors.J3DMouseBehaviorCallback;
import e3d.j3d.behaviors.J3DMouseZoom;
import e3d.j3d.behaviors.J3DPickMouseBehavior;
import e3d.j3d.behaviors.J3DPickingCallback;
import e3d.j3d.objects.util.J3DAnchor;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;

public class J3DPickZoomBehavior
extends J3DPickMouseBehavior
implements J3DMouseBehaviorCallback {
    private J3DAnchor sceneAnchor = null;
    protected final J3DMouseZoom zoom = new J3DMouseZoom(1);
    protected J3DPickingCallback callback = null;
    protected J3DAnchor currentAnchor;
    protected boolean enabled = true;

    public J3DPickZoomBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(canvas, root, bounds);
        this.zoom.setAnchor(this.anchor);
        this.anchor.addChild((Node)this.zoom);
        this.zoom.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
    }

    public J3DPickZoomBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, int pickMode) {
        super(canvas, root, bounds);
        this.zoom.setAnchor(this.anchor);
        this.anchor.addChild((Node)this.zoom);
        this.zoom.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.setMode(pickMode);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        if (this.enabled) {
            J3DAnchor anchor;
            this.pickCanvas.setShapeLocation(xpos, ypos);
            PickResult pickResult = this.pickCanvas.pickClosest();
            if (pickResult != null && (anchor = (J3DAnchor)pickResult.getNode(32)) != null && anchor.getCapability(17) && anchor.getCapability(18)) {
                if (anchor == this.sceneAnchor && pickResult.numIntersections() > 0) {
                    PickIntersection intersection = pickResult.getIntersection(0);
                    Point3d point = intersection.getPointCoordinatesVW();
                    this.zoom.setReferencePoint(point);
                } else {
                    this.zoom.setReferencePoint(null);
                }
                this.zoom.setAnchor(anchor);
                this.zoom.wakeup();
                this.currentAnchor = anchor;
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(2, this.currentAnchor);
    }

    @Override
    public void transformFinished(int type, Transform3D transform) {
        this.callback.transformFinished(2, this.currentAnchor);
    }

    @Override
    public void setupCallback(J3DPickingCallback callback) {
        this.callback = callback;
        if (callback == null) {
            this.zoom.setupCallback(null);
        } else {
            this.zoom.setupCallback(this);
        }
    }

    @Override
    public void setScalingFactor(double factor) {
        this.zoom.setScalingFactor(factor);
    }

    @Override
    public double getScalingFactor() {
        return this.zoom.getScalingFactor();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.zoom.setEnabled(enabled);
    }

    public void setSceneGroup(J3DAnchor sceneAnchor) {
        this.sceneAnchor = sceneAnchor;
        this.zoom.setSceneGroup(sceneAnchor);
    }

    public void setCanvas(J3DCanvas canvas) {
        this.zoom.setCanvas(canvas);
    }
}

