/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.utils.picking.PickResult;
import e3d.j3d.behaviors.J3DMouseBehaviorCallback;
import e3d.j3d.behaviors.J3DMouseTranslate;
import e3d.j3d.behaviors.J3DPickMouseBehavior;
import e3d.j3d.behaviors.J3DPickingCallback;
import e3d.j3d.objects.util.J3DAnchor;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;

public class J3DPickTranslateBehavior
extends J3DPickMouseBehavior
implements J3DMouseBehaviorCallback {
    protected final J3DMouseTranslate translate = new J3DMouseTranslate(1);
    protected J3DAnchor currentAnchor;
    protected J3DPickingCallback callback = null;
    protected boolean enabled = true;

    public J3DPickTranslateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(canvas, root, bounds);
        this.translate.setAnchor(this.anchor);
        this.anchor.addChild((Node)this.translate);
        this.translate.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
    }

    public J3DPickTranslateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, int pickMode) {
        super(canvas, root, bounds);
        this.translate.setAnchor(this.anchor);
        this.anchor.addChild((Node)this.translate);
        this.translate.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.setMode(pickMode);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        if (this.enabled) {
            J3DAnchor anchor;
            this.pickCanvas.setShapeLocation(xpos, ypos);
            PickResult pickResult = this.pickCanvas.pickClosest();
            if (pickResult != null && (anchor = (J3DAnchor)pickResult.getNode(32)) != null && anchor.getCapability(17) && anchor.getCapability(18)) {
                this.translate.setAnchor(anchor);
                this.translate.wakeup();
                this.currentAnchor = anchor;
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(1, this.currentAnchor);
    }

    @Override
    public void transformFinished(int type, Transform3D transform) {
        this.callback.transformFinished(1, this.currentAnchor);
    }

    @Override
    public void setupCallback(J3DPickingCallback callback) {
        this.callback = callback;
        if (callback == null) {
            this.translate.setupCallback(null);
        } else {
            this.translate.setupCallback(this);
        }
    }

    @Override
    public void setScalingFactor(double factor) {
        this.translate.setScalingFactor(factor);
    }

    @Override
    public double getScalingFactor() {
        return this.translate.getScalingFactor();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.translate.setEnabled(enabled);
    }
}

