/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import e3d.j3d.J3DCanvas;
import e3d.j3d.behaviors.J3DMouseBehavior;
import e3d.j3d.behaviors.J3DMouseBehaviorCallback;
import e3d.j3d.objects.util.J3DAnchor;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class J3DMouseZoom
extends J3DMouseBehavior {
    protected double scalingFactor = 0.04;
    private MouseBehaviorCallback callback = null;
    private J3DAnchor sceneAnchor = null;
    private J3DCanvas canvas = null;
    private boolean zoomed = false;
    protected Point3d refPoint = null;
    protected boolean enabled = true;

    public J3DMouseZoom(J3DAnchor anchor) {
        super(anchor);
    }

    public J3DMouseZoom() {
        super(0);
    }

    public J3DMouseZoom(int flags) {
        super(flags);
    }

    public J3DMouseZoom(Component component) {
        super(component, 0);
    }

    public J3DMouseZoom(Component component, J3DAnchor anchor) {
        super(component, anchor);
    }

    public J3DMouseZoom(Component component, int flags) {
        super(component, flags);
    }

    @Override
    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.scalingFactor *= -1.0;
            this.invert = true;
        }
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double factor) {
        this.scalingFactor = factor;
    }

    public void setSceneGroup(J3DAnchor sceneAnchor) {
        this.sceneAnchor = sceneAnchor;
    }

    public void setCanvas(J3DCanvas canvas) {
        this.canvas = canvas;
    }

    public Point3d getReferencePoint() {
        return this.refPoint;
    }

    public void setReferencePoint(Point3d point) {
        this.refPoint = point;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent event;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                event = (MouseEvent)events[events.length - 1];
                this.doProcess(event);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseQueue;
                synchronized (linkedList) {
                    if (this.mouseQueue.isEmpty()) {
                        continue block3;
                    }
                    event = (MouseEvent)this.mouseQueue.remove(0);
                    while (event.getID() == 506 && !this.mouseQueue.isEmpty() && ((MouseEvent)this.mouseQueue.get(0)).getID() == 506) {
                        event = (MouseEvent)this.mouseQueue.remove(0);
                    }
                }
                this.doProcess(event);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    protected void doProcess(MouseEvent event) {
        int id = event.getID();
        if (this.enabled && ((id == 501 || id == 502 || id == 506) && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0)) {
            if (id == 506 && event.isAltDown() && !event.isMetaDown()) {
                this.x = event.getX();
                this.y = event.getY();
                int dy = this.y - this.y_last;
                if (!this.reset) {
                    Transform3D worldTransform = new Transform3D();
                    this.anchor.getLocalToVworldTranslation(worldTransform);
                    worldTransform.transpose();
                    this.anchor.getTransform(this.transform);
                    if (this.canvas.getView().getProjectionPolicy() == 0 && this.anchor == this.sceneAnchor) {
                        double oldFactor = this.canvas.getZoom();
                        double newFactor = Math.max(this.canvas.getMinZoom(), oldFactor + (double)dy * this.scalingFactor);
                        if (this.refPoint != null) {
                            Vector3d translation = new Vector3d(this.refPoint.x * (oldFactor - newFactor) / newFactor, this.refPoint.y * (oldFactor - newFactor) / newFactor, 0.0);
                            this.refPoint.add((Tuple3d)translation);
                            worldTransform.transform(translation);
                            Transform3D transformXY = new Transform3D();
                            transformXY.set(translation);
                            if (this.invert) {
                                this.transform.mul(this.transform, transformXY);
                            } else {
                                this.transform.mul(transformXY, this.transform);
                            }
                            this.anchor.setTransform(this.transform);
                        }
                        this.canvas.setZoom(newFactor);
                    } else {
                        Vector3d translation = new Vector3d(0.0, 0.0, (double)dy * this.scalingFactor);
                        if (this.refPoint != null) {
                            Point3d eye = new Point3d();
                            this.canvas.getCenterEyeInImagePlate(eye);
                            Transform3D plate2world = new Transform3D();
                            this.canvas.getImagePlateToVworld(plate2world);
                            plate2world.transform(eye);
                            double d = eye.z - this.refPoint.z;
                            double gx = this.refPoint.x / d;
                            double gy = this.refPoint.y / d;
                            translation.x = -gx * translation.z;
                            translation.y = -gy * translation.z;
                            this.refPoint.add((Tuple3d)translation);
                        }
                        worldTransform.transform(translation);
                        Transform3D transformXY = new Transform3D();
                        transformXY.set(translation);
                        if (this.invert) {
                            this.transform.mul(this.transform, transformXY);
                        } else {
                            this.transform.mul(transformXY, this.transform);
                        }
                        this.anchor.setTransform(this.transform);
                    }
                    this.transformChanged(this.transform);
                    if (this.callback != null) {
                        this.callback.transformChanged(2, this.transform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
                this.zoomed = true;
            } else if (id == 501) {
                this.x_last = event.getX();
                this.y_last = event.getY();
                this.zoomed = false;
            } else if (id == 502 && this.zoomed && this.callback instanceof J3DMouseBehaviorCallback) {
                ((J3DMouseBehaviorCallback)this.callback).transformFinished(0, this.transform);
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

