/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.internal.J3dUtilsI18N;
import e3d.j3d.objects.util.J3DAnchor;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOr;

public abstract class J3DMouseBehavior
extends Behavior
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final int MANUAL_WAKEUP = 1;
    private boolean listener = false;
    protected WakeupCriterion[] mouseEvents;
    protected WakeupOr mouseCriterion;
    protected int x;
    protected int y;
    protected int x_last;
    protected int y_last;
    protected J3DAnchor anchor;
    protected Transform3D transform;
    protected boolean reset = false;
    protected boolean invert = false;
    protected boolean wakeUp = false;
    protected int flags = 0;
    protected LinkedList<MouseEvent> mouseQueue;
    protected boolean enable = true;
    public static final int INVERT_INPUT = 2;

    public J3DMouseBehavior(J3DAnchor anchor) {
        this.anchor = anchor;
        this.reset = true;
    }

    public J3DMouseBehavior(int format) {
        this.flags = format;
        this.reset = true;
    }

    public J3DMouseBehavior(Component component, J3DAnchor anchor) {
        this(anchor);
        if (component != null) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            component.addMouseWheelListener(this);
        }
        this.listener = true;
    }

    public J3DMouseBehavior(Component c, int format) {
        this(format);
        if (c != null) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
            c.addMouseWheelListener(this);
        }
        this.listener = true;
    }

    public void setAnchor(J3DAnchor anchor) {
        this.anchor = anchor;
        this.transform = new Transform3D();
        this.reset = true;
    }

    public TransformGroup getAnchor() {
        return this.anchor;
    }

    public void initialize() {
        this.mouseEvents = new WakeupCriterion[4];
        if (!this.listener) {
            this.mouseEvents[0] = new WakeupOnAWTEvent(506);
            this.mouseEvents[1] = new WakeupOnAWTEvent(501);
            this.mouseEvents[2] = new WakeupOnAWTEvent(502);
            this.mouseEvents[3] = new WakeupOnAWTEvent(507);
        } else {
            this.mouseEvents[0] = new WakeupOnBehaviorPost((Behavior)this, 506);
            this.mouseEvents[1] = new WakeupOnBehaviorPost((Behavior)this, 501);
            this.mouseEvents[2] = new WakeupOnBehaviorPost((Behavior)this, 502);
            this.mouseEvents[3] = new WakeupOnBehaviorPost((Behavior)this, 507);
            this.mouseQueue = new LinkedList();
        }
        this.mouseCriterion = new WakeupOr(this.mouseEvents);
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
        this.x = 0;
        this.y = 0;
        this.x_last = 0;
        this.y_last = 0;
    }

    public void wakeup() {
        this.wakeUp = true;
    }

    public abstract void processStimulus(Enumeration var1);

    public void addListener(Component c) {
        if (!this.listener) {
            throw new IllegalStateException(J3dUtilsI18N.getString((String)"Behavior0"));
        }
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        c.addMouseWheelListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        if (this.enable) {
            LinkedList<MouseEvent> linkedList = this.mouseQueue;
            synchronized (linkedList) {
                this.mouseQueue.add(e);
                if (this.mouseQueue.size() == 1) {
                    this.postId(501);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.enable) {
            LinkedList<MouseEvent> linkedList = this.mouseQueue;
            synchronized (linkedList) {
                this.mouseQueue.add(e);
                if (this.mouseQueue.size() == 1) {
                    this.postId(502);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.enable) {
            LinkedList<MouseEvent> linkedList = this.mouseQueue;
            synchronized (linkedList) {
                this.mouseQueue.add(e);
                if (this.mouseQueue.size() == 1) {
                    this.postId(506);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void setEnable(boolean state) {
        super.setEnable(state);
        this.enable = state;
        if (!this.enable && this.mouseQueue != null) {
            this.mouseQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.enable) {
            LinkedList<MouseEvent> linkedList = this.mouseQueue;
            synchronized (linkedList) {
                this.mouseQueue.add(e);
                if (this.mouseQueue.size() == 1) {
                    this.postId(507);
                }
            }
        }
    }
}

