/*
 * Decompiled with CFR 0.152.
 */
package e3d.io.xml;

import e3d.bezier.Needle;
import e3d.bezier.NeedleMesh;
import e3d.bezier.NeedleMeshes;
import e3d.bezier.PointMesh;
import e3d.bezier.PointMeshes;
import e3d.bezier.Position;
import e3d.bezier.Surfaces;
import e3d.euclidean.E3DVector;
import e3d.io.xml.XMLMeshObjects;
import e3d.io.xml.XMLParser;
import e3d.texture.E3DTextureFile;
import e3d.texture.TexturePlane;
import e3d.texture.TexturePlanes;
import e3d.utils.FileUtils;
import e3d.utils.Tagger;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

public class XMLMeshParser
extends XMLParser<XMLMeshObjects> {
    private static final String SCHEMA = "xsd/E3DBezierMesh.xsd";
    public static final String ROOT = "Scene";
    public static final String ID = "id";
    public static final String ID_REF = "ref";
    public static final String NEEDLES = "Tangents";
    public static final String NEEDLE = "Tangent";
    public static final String POINTS = "Points";
    public static final String POINT = "Point";
    public static final String POSITION = "Position";
    public static final String NORMAL = "Normal";
    public static final String PLANE = "Plane";
    public static final String COLS = "cols";
    public static final String ROWS = "rows";
    public static final String ROUNDNESS = "roundness";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final String D = "d";
    public static final String BEZIERS = "Beziers";
    public static final String BEZIER = "Bezier";
    public static final String POINTMESHES = "PointMeshes";
    public static final String POINTMESH = "PointMesh";
    public static final String NEEDLEMESHES = "BezierMeshes";
    public static final String NEEDLEMESH = "BezierMesh";
    public static final String COLOR = "Color";
    public static final String RED = "r";
    public static final String GREEN = "g";
    public static final String BLUE = "b";
    public static final String ALPHA = "a";
    public static final String MATERIAL = "Material";
    public static final String TEXTUREFILE = "TextureFile";
    public static final String GLOSS = "gloss";
    public static final String MIRROR = "mirror";
    public static final String GLOW = "glow";
    public static final String GLOWCOLOR = "glowcolor";
    public static final String REFRACTIVITY = "refractivity";
    public static final String POINT_REFS = "PointRefs";
    public static final String POINT_REF = "PointRef";
    public static final String REF = "ref";
    public static final String NEEDLE_REFS = "TangentRefs";
    public static final String NEEDLE_REF = "TangentRef";
    @Deprecated
    public static final String NEEDLE1 = "ref1";
    @Deprecated
    public static final String NEEDLE2 = "ref2";
    @Deprecated
    public static final String NEEDLE3 = "ref3";
    @Deprecated
    public static final String NEEDLE4 = "ref4";
    public static final String TAGS = "Tags";
    public static final String TAG = "Tag";
    public static final String TAG_REFS = "TagRefs";
    public static final String TAG_REF = "TagRef";
    public static final String TEXTURES = "Textures";
    public static final String TEXTURE = "Texture";
    public static final String FILE = "File";
    public static final String ENABLED = "enabled";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private int id = 0;
    protected File base = null;

    @Override
    public String getRootElementName() {
        return ROOT;
    }

    @Override
    public String getSchemaFileName() {
        return SCHEMA;
    }

    public File getBaseDirectory() {
        return this.base;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.base = baseDirectory;
    }

    @Override
    public Content toXML(XMLMeshObjects objects, String name) {
        this.id = 0;
        NeedleMeshes needleMeshes = objects.getNeedleMeshes();
        PointMeshes pointMeshes = objects.getPointMeshes();
        TexturePlanes texturePlanes = objects.getTexturePlanes();
        Tagger<Object> tagger = objects.getTagger();
        Map<String, String> tag2id = this.craeteTagIDs(needleMeshes, pointMeshes, texturePlanes, tagger);
        Element rootXML = new Element(name);
        rootXML.addContent(this.tagsToXML(tag2id));
        Map<Needle, String> tangent2id = this.createNeedleIDs(needleMeshes);
        rootXML.addContent(this.needlesToXML(needleMeshes, tagger, tangent2id, tag2id));
        rootXML.addContent(this.needleMeshesToXML(needleMeshes, tagger, tangent2id, tag2id));
        Map<Position, String> point2id = this.createPointIDs(pointMeshes);
        rootXML.addContent(this.pointsToXML(pointMeshes, tagger, point2id, tag2id));
        rootXML.addContent(this.pointMeshesToXML(pointMeshes, tagger, point2id, tag2id));
        rootXML.addContent(this.texturesToXML(texturePlanes, tag2id));
        return rootXML;
    }

    private Element tagsToXML(Map<String, String> tag2id) {
        Element tagsXML = new Element(TAGS);
        for (Map.Entry<String, String> tagID : tag2id.entrySet()) {
            Element tagXML = new Element(TAG);
            tagXML.setAttribute(ID, tagID.getValue());
            tagXML.setText(tagID.getKey());
            tagsXML.addContent(tagXML);
        }
        return tagsXML;
    }

    private Element needlesToXML(NeedleMeshes meshes, Tagger<Object> tagger, Map<Needle, String> needle2id, Map<String, String> tag2id) {
        Element needlesXML = new Element(NEEDLES);
        for (Map.Entry<Needle, String> needleID : needle2id.entrySet()) {
            Element needleXML = new Element(NEEDLE);
            needleXML.setAttribute(ID, needleID.getValue());
            Element pointXML = new Element(POINT);
            pointXML.setAttribute(X, String.valueOf(needleID.getKey().point.x));
            pointXML.setAttribute(Y, String.valueOf(needleID.getKey().point.y));
            pointXML.setAttribute(Z, String.valueOf(needleID.getKey().point.z));
            needleXML.addContent(pointXML);
            Element normalXML = new Element(NORMAL);
            normalXML.setAttribute(X, String.valueOf(needleID.getKey().normal.x));
            normalXML.setAttribute(Y, String.valueOf(needleID.getKey().normal.y));
            normalXML.setAttribute(Z, String.valueOf(needleID.getKey().normal.z));
            needleXML.addContent(normalXML);
            Element tagRefsXML = this.tagRefsToXML(needleID.getKey(), tag2id, tagger);
            if (tagRefsXML != null) {
                needleXML.addContent(tagRefsXML);
            }
            needlesXML.addContent(needleXML);
        }
        return needlesXML;
    }

    private Element pointsToXML(PointMeshes meshes, Tagger<Object> tagger, Map<Position, String> point2id, Map<String, String> tag2id) {
        Element pointsXML = new Element(POINTS);
        for (Map.Entry<Position, String> pointID : point2id.entrySet()) {
            Element pointXML = new Element(POINT);
            pointXML.setAttribute(ID, pointID.getValue());
            Element positionXML = new Element(POSITION);
            positionXML.setAttribute(X, String.valueOf(pointID.getKey().x));
            positionXML.setAttribute(Y, String.valueOf(pointID.getKey().y));
            positionXML.setAttribute(Z, String.valueOf(pointID.getKey().z));
            pointXML.addContent(positionXML);
            Element tagRefsXML = this.tagRefsToXML(pointID.getKey(), tag2id, tagger);
            if (tagRefsXML != null) {
                pointXML.addContent(tagRefsXML);
            }
            pointsXML.addContent(pointXML);
        }
        return pointsXML;
    }

    private Element needleMeshesToXML(NeedleMeshes meshes, Tagger<Object> tagger, Map<Needle, String> needle2id, Map<String, String> tag2id) {
        Element meshesXML = new Element(NEEDLEMESHES);
        for (NeedleMesh mesh : meshes) {
            Element meshXML = new Element(NEEDLEMESH);
            meshXML.setAttribute(ID, ID + ++this.id);
            meshXML.setAttribute(COLS, String.valueOf(mesh.width()));
            meshXML.setAttribute(ROWS, String.valueOf(mesh.height()));
            meshXML.setAttribute(ROUNDNESS, String.valueOf(mesh.getRoundness()));
            Element colorXML = new Element(COLOR);
            colorXML.setAttribute(RED, String.valueOf(mesh.getColor().getRed()));
            colorXML.setAttribute(GREEN, String.valueOf(mesh.getColor().getGreen()));
            colorXML.setAttribute(BLUE, String.valueOf(mesh.getColor().getBlue()));
            colorXML.setAttribute(ALPHA, String.valueOf(mesh.getColor().getAlpha()));
            meshXML.addContent(colorXML);
            if (mesh.getMaterial() != null) {
                Element materialXML = new Element(MATERIAL);
                materialXML.setAttribute(GLOSS, String.valueOf(mesh.getMaterial().getGlossiness()));
                materialXML.setAttribute(MIRROR, String.valueOf(mesh.getMaterial().getReflectivity()));
                materialXML.setAttribute(REFRACTIVITY, String.valueOf(mesh.getMaterial().getRefractivity()));
                materialXML.setAttribute(GLOW, String.valueOf(mesh.getMaterial().getGlow()));
                if (mesh.getMaterial().getGlowColor() != null) {
                    materialXML.setAttribute(GLOWCOLOR, "" + mesh.getMaterial().getGlowColor());
                }
                meshXML.addContent(materialXML);
            }
            if (mesh.getTexture() != null) {
                Element textureXML = new Element(TEXTUREFILE);
                textureXML.setText(FileUtils.getRelativePath(mesh.getTexture(), this.base).getPath());
                meshXML.addContent(textureXML);
            }
            Element pointRefsXML = new Element(NEEDLE_REFS);
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    Element pointRefXML = new Element(NEEDLE_REF);
                    Needle needle = (Needle)mesh.get(x, y);
                    if (needle != null) {
                        pointRefXML.setAttribute("ref", String.valueOf(needle2id.get(needle)));
                    }
                    pointRefsXML.addContent(pointRefXML);
                    ++x;
                }
                ++y;
            }
            meshXML.addContent(pointRefsXML);
            Element tagRefsXML = this.tagRefsToXML(mesh, tag2id, tagger);
            if (tagRefsXML != null) {
                meshXML.addContent(tagRefsXML);
            }
            meshesXML.addContent(meshXML);
        }
        return meshesXML;
    }

    private Element pointMeshesToXML(PointMeshes meshes, Tagger<Object> tagger, Map<Position, String> point2id, Map<String, String> tag2id) {
        Element meshesXML = new Element(POINTMESHES);
        for (PointMesh mesh : meshes) {
            Element meshXML = new Element(POINTMESH);
            meshXML.setAttribute(ID, ID + ++this.id);
            meshXML.setAttribute(COLS, String.valueOf(mesh.width()));
            meshXML.setAttribute(ROWS, String.valueOf(mesh.height()));
            meshXML.setAttribute(ROUNDNESS, String.valueOf(mesh.getRoundness()));
            Element colorXML = new Element(COLOR);
            colorXML.setAttribute(RED, String.valueOf(mesh.getColor().getRed()));
            colorXML.setAttribute(GREEN, String.valueOf(mesh.getColor().getGreen()));
            colorXML.setAttribute(BLUE, String.valueOf(mesh.getColor().getBlue()));
            colorXML.setAttribute(ALPHA, String.valueOf(mesh.getColor().getAlpha()));
            meshXML.addContent(colorXML);
            if (mesh.getMaterial() != null) {
                Element materialXML = new Element(MATERIAL);
                materialXML.setAttribute(GLOSS, String.valueOf(mesh.getMaterial().getGlossiness()));
                materialXML.setAttribute(MIRROR, String.valueOf(mesh.getMaterial().getReflectivity()));
                materialXML.setAttribute(REFRACTIVITY, String.valueOf(mesh.getMaterial().getRefractivity()));
                materialXML.setAttribute(GLOW, String.valueOf(mesh.getMaterial().getGlow()));
                if (mesh.getMaterial().getGlowColor() != null) {
                    materialXML.setAttribute(GLOWCOLOR, "" + mesh.getMaterial().getGlowColor());
                }
                meshXML.addContent(materialXML);
            }
            if (mesh.getTexture() != null) {
                Element textureXML = new Element(TEXTUREFILE);
                textureXML.setText(FileUtils.getRelativePath(mesh.getTexture(), this.base).getPath());
                meshXML.addContent(textureXML);
            }
            Element pointRefsXML = new Element(POINT_REFS);
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    Element pointRefXML = new Element(POINT_REF);
                    Position point = (Position)mesh.get(x, y);
                    if (point != null) {
                        pointRefXML.setAttribute("ref", String.valueOf(point2id.get(point)));
                    }
                    pointRefsXML.addContent(pointRefXML);
                    ++x;
                }
                ++y;
            }
            meshXML.addContent(pointRefsXML);
            Element tagRefsXML = this.tagRefsToXML(mesh, tag2id, tagger);
            if (tagRefsXML != null) {
                meshXML.addContent(tagRefsXML);
            }
            meshesXML.addContent(meshXML);
        }
        return meshesXML;
    }

    private Element tagRefsToXML(Object object, Map<String, String> tag2id, Tagger<Object> tagger) {
        Set<String> tags;
        Element tagRefsXML = null;
        if (tagger != null && !(tags = tagger.getTags(object)).isEmpty()) {
            tagRefsXML = new Element(TAG_REFS);
            for (String tag : tags) {
                Element tagRefXML = new Element(TAG_REF);
                tagRefXML.setAttribute("ref", tag2id.get(tag));
                tagRefsXML.addContent(tagRefXML);
            }
        }
        return tagRefsXML;
    }

    private Element texturesToXML(List<TexturePlane> texturePlanes, Map<String, String> tag2id) {
        Element texturesXML = new Element(TEXTURES);
        for (TexturePlane texture : texturePlanes) {
            if (texture.getFile() == null) continue;
            Element textureXML = new Element(TEXTURE);
            textureXML.setAttribute(ID, ID + ++this.id);
            textureXML.setAttribute(ENABLED, texture.isEnabled() ? TRUE : FALSE);
            Element tagRefXML = new Element(TAG_REF);
            tagRefXML.setAttribute("ref", tag2id.get(texture.getTag()));
            textureXML.addContent(tagRefXML);
            Element planeXML = new Element(PLANE);
            planeXML.setAttribute(D, String.valueOf(texture.d));
            Element normalXML = new Element(NORMAL);
            normalXML.setAttribute(X, String.valueOf(texture.n.x));
            normalXML.setAttribute(Y, String.valueOf(texture.n.y));
            normalXML.setAttribute(Z, String.valueOf(texture.n.z));
            planeXML.addContent(normalXML);
            textureXML.addContent(planeXML);
            Element fileXML = new Element(FILE);
            fileXML.addContent(FileUtils.getRelativePath(texture.getFile(), this.base).getPath());
            textureXML.addContent(fileXML);
            texturesXML.addContent(textureXML);
        }
        return texturesXML;
    }

    private Map<Needle, String> createNeedleIDs(NeedleMeshes meshes) {
        HashMap<Needle, String> needle2id = new HashMap<Needle, String>();
        for (NeedleMesh mesh : meshes) {
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    Needle needle = (Needle)mesh.get(x, y);
                    if (needle != null && !needle2id.containsKey(needle)) {
                        needle2id.put(needle, ID + ++this.id);
                    }
                    ++x;
                }
                ++y;
            }
        }
        return needle2id;
    }

    private Map<Position, String> createPointIDs(PointMeshes meshes) {
        HashMap<Position, String> point2id = new HashMap<Position, String>();
        for (PointMesh mesh : meshes) {
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    Position point = (Position)mesh.get(x, y);
                    if (point != null && !point2id.containsKey(point)) {
                        point2id.put(point, ID + ++this.id);
                    }
                    ++x;
                }
                ++y;
            }
        }
        return point2id;
    }

    private Map<String, String> craeteTagIDs(NeedleMeshes needleMeshes, PointMeshes pointMeshes, TexturePlanes texturePlanes, Tagger<Object> tagger) {
        int y;
        HashMap<String, String> tag2id = new HashMap<String, String>();
        for (NeedleMesh needleMesh : needleMeshes) {
            for (String tag : tagger.getTags(needleMesh)) {
                if (tag2id.containsKey(tag)) continue;
                tag2id.put(tag, ID + ++this.id);
            }
            y = 0;
            while (y < needleMesh.height()) {
                int x = 0;
                while (x < needleMesh.width()) {
                    Needle needle = (Needle)needleMesh.get(x, y);
                    for (String tag : tagger.getTags(needle)) {
                        if (tag2id.containsKey(tag)) continue;
                        tag2id.put(tag, ID + ++this.id);
                    }
                    ++x;
                }
                ++y;
            }
        }
        for (PointMesh pointMesh : pointMeshes) {
            for (String tag : tagger.getTags(pointMesh)) {
                if (tag2id.containsKey(tag)) continue;
                tag2id.put(tag, ID + ++this.id);
            }
            y = 0;
            while (y < pointMesh.height()) {
                int x = 0;
                while (x < pointMesh.width()) {
                    Position position = (Position)pointMesh.get(x, y);
                    for (String tag : tagger.getTags(position)) {
                        if (tag2id.containsKey(tag)) continue;
                        tag2id.put(tag, ID + ++this.id);
                    }
                    ++x;
                }
                ++y;
            }
        }
        for (TexturePlane texture : texturePlanes) {
            if (tag2id.containsKey(texture.getTag())) continue;
            tag2id.put(texture.getTag(), ID + ++this.id);
        }
        return tag2id;
    }

    @Override
    public XMLMeshObjects fromXML(Content element) throws IOException, DataConversionException {
        NeedleMeshes needleMeshes = new NeedleMeshes();
        PointMeshes pointMeshes = new PointMeshes();
        Surfaces surfaces = new Surfaces();
        TexturePlanes texturePlanes = new TexturePlanes();
        Tagger<Object> tagger = new Tagger<Object>();
        Element rootXML = (Element)element;
        Map<String, String> id2tag = this.tagsFromXML(rootXML.getChild(TAGS));
        Map<String, Needle> id2needle = this.needlesFromXML(rootXML.getChild(NEEDLES), id2tag, surfaces, tagger);
        this.needleMeshesFromXML(rootXML.getChild(NEEDLEMESHES), id2tag, id2needle, needleMeshes, tagger);
        this.beziersFromXML(rootXML.getChild(BEZIERS), id2tag, id2needle, needleMeshes, tagger);
        Map<String, Position> id2position = this.pointsFromXML(rootXML.getChild(POINTS), id2tag, tagger);
        this.pointMeshesFromXML(rootXML.getChild(POINTMESHES), id2tag, id2position, pointMeshes, tagger);
        this.texturesFromXML(rootXML.getChild(TEXTURES), id2tag, texturePlanes);
        return new XMLMeshObjects(needleMeshes, pointMeshes, surfaces, texturePlanes, tagger);
    }

    private Map<String, String> tagsFromXML(Element tagsXML) throws IOException {
        HashMap<String, String> id2tag = new HashMap<String, String>();
        if (tagsXML == null) {
            throw new IOException("Missing <Tags>");
        }
        for (Element objectXML : tagsXML.getChildren()) {
            Element tagXML = objectXML;
            Attribute idXML = tagXML.getAttribute(ID);
            if (idXML == null) {
                throw new IOException("Missing ID for a <Tag>");
            }
            String tag = tagXML.getTextTrim();
            if (tag == null || tag.length() == 0) {
                throw new IOException("Missing or empty text for a <Tag> (ID=" + idXML.getValue() + ")");
            }
            if (id2tag.containsKey(idXML.getValue())) {
                throw new IOException("Ambiguous ID for a <Tag> (ID=" + idXML.getValue() + ")");
            }
            id2tag.put(idXML.getValue(), tag);
        }
        return id2tag;
    }

    private Map<String, Needle> needlesFromXML(Element needlesXML, Map<String, String> id2tag, Surfaces surfaces, Tagger<Object> tagger) throws IOException, DataConversionException {
        HashMap<String, Needle> id2needle = new HashMap<String, Needle>();
        if (needlesXML == null) {
            return id2needle;
        }
        for (Element objectXML : needlesXML.getChildren()) {
            Element needleXML = objectXML;
            Attribute idXML = needleXML.getAttribute(ID);
            if (idXML == null) {
                throw new IOException("Missing ID for a <Tangent>");
            }
            Element pointXML = needleXML.getChild(POINT);
            if (pointXML == null) {
                throw new IOException("Missing <Point> for a <Tangent> (ID=" + idXML.getValue() + ")");
            }
            Attribute pxXML = pointXML.getAttribute(X);
            Attribute pyXML = pointXML.getAttribute(Y);
            Attribute pzXML = pointXML.getAttribute(Z);
            if (pxXML == null || pyXML == null || pzXML == null) {
                throw new IOException("Missing coordinate in <Point> for a <Tangent> (ID=" + idXML.getValue() + ")");
            }
            Position point = new Position(pxXML.getDoubleValue(), pyXML.getDoubleValue(), pzXML.getDoubleValue());
            Element normalXML = needleXML.getChild(NORMAL);
            if (normalXML == null) {
                throw new IOException("Missing <Normal> for a <Tangent> (ID=" + idXML.getValue() + ")");
            }
            Attribute nxXML = normalXML.getAttribute(X);
            Attribute nyXML = normalXML.getAttribute(Y);
            Attribute nzXML = normalXML.getAttribute(Z);
            if (nxXML == null || nyXML == null || nzXML == null) {
                throw new IOException("Missing coordinate in <Normal> for a <Tangent> (ID=" + idXML.getValue() + ")");
            }
            E3DVector normal = new E3DVector(nxXML.getDoubleValue(), nyXML.getDoubleValue(), nzXML.getDoubleValue());
            Needle needle = new Needle(point, normal);
            this.tagRefsFromXML(needleXML.getChild(TAG_REFS), id2tag, needle, tagger, NEEDLE, idXML.getValue());
            if (id2needle.containsKey(idXML.getValue())) {
                throw new IOException("Ambiguous ID for a <Tangent> (ID=" + idXML.getValue() + ")");
            }
            id2needle.put(idXML.getValue(), needle);
        }
        return id2needle;
    }

    @Deprecated
    private void beziersFromXML(Element beziersXML, Map<String, String> id2tag, Map<String, Needle> id2needle, NeedleMeshes meshes, Tagger<Object> tagger) throws IOException, DataConversionException {
        if (beziersXML == null) {
            return;
        }
        for (Element bezierXML : beziersXML.getChildren()) {
            Attribute idXML = bezierXML.getAttribute(ID);
            if (idXML == null) {
                throw new IOException("Missing ID for a <Bezier>");
            }
            E3DColor color = this.colorFromXML(bezierXML.getChild(COLOR), BEZIER, idXML.getValue());
            E3DMaterial material = this.materialFromXML(bezierXML.getChild(MATERIAL), BEZIER, idXML.getValue());
            E3DTextureFile texture = this.individualTextureFromXML(bezierXML.getChild(TEXTUREFILE));
            Element needleefsXML = bezierXML.getChild(NEEDLE_REFS);
            if (needleefsXML == null) {
                throw new IOException("Missing <TangentRefs> for a <Bezier> (ID=" + idXML.getValue() + ")");
            }
            Attribute needleRef1XML = needleefsXML.getAttribute(NEEDLE1);
            Attribute needleRef2XML = needleefsXML.getAttribute(NEEDLE2);
            Attribute needleRef3XML = needleefsXML.getAttribute(NEEDLE3);
            Attribute needleRef4XML = needleefsXML.getAttribute(NEEDLE4);
            if (needleRef1XML == null || needleRef2XML == null || needleRef3XML == null || needleRef4XML == null) {
                throw new IOException("Missing needle Id(s) in <TangentRefs> for a <Bezier> (ID=" + idXML.getValue() + ")");
            }
            Needle needle1 = id2needle.get(needleRef1XML.getValue());
            Needle needle2 = id2needle.get(needleRef2XML.getValue());
            Needle needle3 = id2needle.get(needleRef3XML.getValue());
            Needle needle4 = id2needle.get(needleRef4XML.getValue());
            if (needle1 == null || needle2 == null || needle3 == null || needle4 == null) {
                throw new IOException("Unkown needle ID in <TangentRefs> for a <Bezier> (ID=" + idXML.getValue() + ")");
            }
            NeedleMesh mesh = new NeedleMesh(2, 2);
            mesh.set(0, 0, needle1);
            mesh.set(1, 0, needle2);
            mesh.set(1, 1, needle3);
            mesh.set(0, 1, needle4);
            mesh.setColor(color);
            mesh.setMaterial(material);
            mesh.setTexture(texture);
            mesh.setRoundness(1.0);
            this.tagRefsFromXML(bezierXML.getChild(TAG_REFS), id2tag, mesh, tagger, BEZIER, idXML.getValue());
            meshes.add(mesh);
        }
    }

    private Map<String, Position> pointsFromXML(Element pointsXML, Map<String, String> id2tag, Tagger<Object> tagger) throws IOException, DataConversionException {
        HashMap<String, Position> id2position = new HashMap<String, Position>();
        if (pointsXML == null) {
            return id2position;
        }
        for (Element objectXML : pointsXML.getChildren()) {
            Element pointXML = objectXML;
            Attribute idXML = pointXML.getAttribute(ID);
            if (idXML == null) {
                throw new IOException("Missing ID for a <Point>");
            }
            Element positionXML = pointXML.getChild(POSITION);
            if (positionXML == null) {
                throw new IOException("Missing <Position> for a <Point> (ID=" + idXML.getValue() + ")");
            }
            Attribute xXML = positionXML.getAttribute(X);
            Attribute yXML = positionXML.getAttribute(Y);
            Attribute zXML = positionXML.getAttribute(Z);
            if (xXML == null || yXML == null || zXML == null) {
                throw new IOException("Missing coordinate for a <Point> (ID=" + idXML.getValue() + ")");
            }
            Position position = new Position(xXML.getDoubleValue(), yXML.getDoubleValue(), zXML.getDoubleValue());
            this.tagRefsFromXML(pointXML.getChild(TAG_REFS), id2tag, position, tagger, POINT, idXML.getValue());
            if (id2position.containsKey(idXML.getValue())) {
                throw new IOException("Ambiguous ID for a <Point> (ID=" + idXML.getValue() + ")");
            }
            id2position.put(idXML.getValue(), position);
        }
        return id2position;
    }

    private void needleMeshesFromXML(Element needleMeshesXML, Map<String, String> id2tag, Map<String, Needle> id2needle, NeedleMeshes needleMeshes, Tagger<Object> tagger) throws IOException, DataConversionException {
        if (needleMeshesXML == null) {
            return;
        }
        Iterator<Element> iterator = needleMeshesXML.getChildren().iterator();
        while (iterator.hasNext()) {
            Element objectXML;
            Element meshXML = objectXML = iterator.next();
            Attribute idXML = meshXML.getAttribute(ID);
            Attribute colsXML = meshXML.getAttribute(COLS);
            Attribute rowsXML = meshXML.getAttribute(ROWS);
            Attribute roundnessXML = meshXML.getAttribute(ROUNDNESS);
            if (idXML == null) {
                throw new IOException("Missing ID for a <PointMesh>");
            }
            if (colsXML == null || rowsXML == null) {
                throw new IOException("Missing size for a <PointMesh> (ID=" + idXML.getValue() + ")");
            }
            int width = colsXML.getIntValue();
            int height = rowsXML.getIntValue();
            double roundness = roundnessXML == null ? 1.0 : roundnessXML.getDoubleValue();
            E3DColor color = this.colorFromXML(meshXML.getChild(COLOR), POINTMESH, idXML.getValue());
            E3DMaterial material = this.materialFromXML(meshXML.getChild(MATERIAL), POINTMESH, idXML.getValue());
            E3DTextureFile texture = this.individualTextureFromXML(meshXML.getChild(TEXTUREFILE));
            NeedleMesh mesh = new NeedleMesh(width, height);
            mesh.setColor(color);
            mesh.setTexture(texture);
            mesh.setMaterial(material);
            mesh.setRoundness(roundness);
            Element needleRefsXML = meshXML.getChild(NEEDLE_REFS);
            if (needleRefsXML == null) {
                throw new IOException("Missing <TangentRefs> for a <BezierMesh> (ID=" + idXML.getValue() + ")");
            }
            int i = 0;
            for (Element subObjectXML : needleRefsXML.getChildren()) {
                Element needleRefXML = subObjectXML;
                Attribute refXML = needleRefXML.getAttribute("ref");
                if (refXML == null) {
                    mesh.set(i % width, i / width, null);
                } else {
                    Needle needle = id2needle.get(refXML.getValue());
                    if (needle == null) {
                        throw new IOException("Missing referenced needle (ID = " + refXML.getValue() + ") for a <" + NEEDLEMESH + "> (ID=" + idXML.getValue() + ")");
                    }
                    mesh.set(i % width, i / width, needle);
                }
                ++i;
            }
            if (i != width * height) {
                throw new IOException("Missing/to many needle references for a <BezierMesh> (ID=" + idXML.getValue() + "): " + width * height + " expected, found " + i);
            }
            this.tagRefsFromXML(meshXML.getChild(TAG_REFS), id2tag, mesh, tagger, POINTMESH, idXML.getValue());
            needleMeshes.add(mesh);
        }
    }

    private void pointMeshesFromXML(Element pointMeshesXML, Map<String, String> id2tag, Map<String, Position> id2position, PointMeshes pointMeshes, Tagger<Object> tagger) throws IOException, DataConversionException {
        if (pointMeshesXML == null) {
            return;
        }
        Iterator<Element> iterator = pointMeshesXML.getChildren().iterator();
        while (iterator.hasNext()) {
            Element objectXML;
            Element meshXML = objectXML = iterator.next();
            Attribute idXML = meshXML.getAttribute(ID);
            Attribute colsXML = meshXML.getAttribute(COLS);
            Attribute rowsXML = meshXML.getAttribute(ROWS);
            Attribute roundnessXML = meshXML.getAttribute(ROUNDNESS);
            if (idXML == null) {
                throw new IOException("Missing ID for a <PointMesh>");
            }
            if (colsXML == null || rowsXML == null) {
                throw new IOException("Missing size for a <PointMesh> (ID=" + idXML.getValue() + ")");
            }
            int width = colsXML.getIntValue();
            int height = rowsXML.getIntValue();
            double roundness = roundnessXML == null ? 1.0 : roundnessXML.getDoubleValue();
            E3DColor color = this.colorFromXML(meshXML.getChild(COLOR), POINTMESH, idXML.getValue());
            E3DMaterial material = this.materialFromXML(meshXML.getChild(MATERIAL), POINTMESH, idXML.getValue());
            E3DTextureFile texture = this.individualTextureFromXML(meshXML.getChild(TEXTUREFILE));
            PointMesh mesh = new PointMesh(width, height);
            mesh.setColor(color);
            mesh.setTexture(texture);
            mesh.setMaterial(material);
            mesh.setRoundness(roundness);
            Element pointRefsXML = meshXML.getChild(POINT_REFS);
            if (pointRefsXML == null) {
                throw new IOException("Missing <PointRefs> for a <PointMesh> (ID=" + idXML.getValue() + ")");
            }
            int i = 0;
            for (Element subObjectXML : pointRefsXML.getChildren()) {
                Element pointRefXML = subObjectXML;
                Attribute refXML = pointRefXML.getAttribute("ref");
                if (refXML == null) {
                    mesh.set(i % width, i / width, null);
                } else {
                    Position position = id2position.get(refXML.getValue());
                    if (position == null) {
                        throw new IOException("Missing referenced point (ID = " + refXML.getValue() + ") for a <" + POINTMESH + "> (ID=" + idXML.getValue() + ")");
                    }
                    mesh.set(i % width, i / width, position);
                }
                ++i;
            }
            if (i != width * height) {
                throw new IOException("Missing/to many point references for a <PointMesh> (ID=" + idXML.getValue() + "): " + width * height + " expected, found " + i);
            }
            this.tagRefsFromXML(meshXML.getChild(TAG_REFS), id2tag, mesh, tagger, POINTMESH, idXML.getValue());
            pointMeshes.add(mesh);
        }
    }

    private E3DColor colorFromXML(Element colorXML, String parentName, String id) throws IOException, DataConversionException {
        if (colorXML == null) {
            throw new IOException("Missing <Color> for a <" + parentName + "> (ID=" + id + ")");
        }
        Attribute redXML = colorXML.getAttribute(RED);
        Attribute greenXML = colorXML.getAttribute(GREEN);
        Attribute blueXML = colorXML.getAttribute(BLUE);
        Attribute alphaXML = colorXML.getAttribute(ALPHA);
        if (redXML == null || greenXML == null || blueXML == null || alphaXML == null) {
            throw new IOException("Missing channel attribute in <Color> for a <" + parentName + "> (ID=" + id + ")");
        }
        E3DColor color = new E3DColor(redXML.getIntValue(), greenXML.getIntValue(), blueXML.getIntValue(), alphaXML.getIntValue());
        return color;
    }

    private E3DMaterial materialFromXML(Element materialXML, String parentName, String id) throws IOException, DataConversionException {
        E3DMaterial material = null;
        if (materialXML != null) {
            Attribute glossinessXML = materialXML.getAttribute(GLOSS);
            Attribute reflectivityXML = materialXML.getAttribute(MIRROR);
            Attribute glowXML = materialXML.getAttribute(GLOW);
            Attribute glowColorXML = materialXML.getAttribute(GLOWCOLOR);
            Attribute refractivityXML = materialXML.getAttribute(REFRACTIVITY);
            if (glossinessXML == null || reflectivityXML == null) {
                throw new IOException("Missing attribute in <Material> for a <" + parentName + "> (ID=" + id + ")");
            }
            material = new E3DMaterial(glossinessXML.getDoubleValue(), reflectivityXML.getDoubleValue(), glowXML == null ? 0.0 : glowXML.getDoubleValue(), glowColorXML == null ? null : Integer.valueOf(glowColorXML.getIntValue()), refractivityXML == null ? 0.0 : refractivityXML.getDoubleValue());
        }
        return material;
    }

    private E3DTextureFile individualTextureFromXML(Element textureXML) {
        E3DTextureFile texture = null;
        if (textureXML != null) {
            texture = new E3DTextureFile(this.base, textureXML.getValue());
        }
        return texture;
    }

    private void tagRefsFromXML(Element tagRefsXML, Map<String, String> id2tag, Object object, Tagger<Object> tagger, String parentName, String id) throws IOException {
        if (tagRefsXML != null) {
            for (Element objectXML : tagRefsXML.getChildren()) {
                Element tagRefXML = objectXML;
                Attribute tagIDXML = tagRefXML.getAttribute("ref");
                if (tagIDXML == null) {
                    throw new IOException("Missing 'ref' in <TagRef> for a <" + parentName + "> (ID=" + id + ")");
                }
                String tag = id2tag.get(tagIDXML.getValue());
                if (tag == null) {
                    throw new IOException("Unnown tag ID='" + tagIDXML.getValue() + "' in <" + TAG_REF + "> for a <" + parentName + "> (ID=" + id + ")");
                }
                tagger.addTag(object, tag);
            }
        }
    }

    private void texturesFromXML(Element texturesXML, Map<String, String> id2tag, TexturePlanes texturePlanes) throws IOException, DataConversionException {
        if (texturesXML != null) {
            for (Element objectXML : texturesXML.getChildren()) {
                Element textureXML = objectXML;
                Attribute idXML = textureXML.getAttribute(ID);
                if (idXML == null) {
                    throw new IOException("Missing ID for a <Texture>");
                }
                Attribute enabledXML = textureXML.getAttribute(ENABLED);
                if (enabledXML == null) {
                    throw new IOException("Missing attribute <enabled> for a <Texture> (ID=" + idXML.getValue() + ")");
                }
                Element tagRefXML = textureXML.getChild(TAG_REF);
                if (tagRefXML == null) {
                    throw new IOException("Missing <TagRef> for a <Texture> (ID=" + idXML.getValue() + ")");
                }
                Attribute tagIDRefXML = tagRefXML.getAttribute("ref");
                if (tagIDRefXML == null) {
                    throw new IOException("Missing attribute <ref> in <TagRef> for a <Texture> (ID=" + idXML.getValue() + ")");
                }
                Element planeXML = textureXML.getChild(PLANE);
                if (planeXML == null) {
                    throw new IOException("Missing <Plane> for a <Texture> (ID=" + idXML.getValue() + ")");
                }
                Attribute distXML = planeXML.getAttribute(D);
                if (distXML == null) {
                    throw new IOException("Missing attribute <d> in <Plane> for a <Texture> (ID=" + idXML.getValue() + ")");
                }
                Element normalXML = planeXML.getChild(NORMAL);
                if (normalXML == null) {
                    throw new IOException("Missing <Normal> for the <Plane> of a <Texture> (ID=" + idXML.getValue() + ")");
                }
                Attribute nxXML = normalXML.getAttribute(X);
                Attribute nyXML = normalXML.getAttribute(Y);
                Attribute nzXML = normalXML.getAttribute(Z);
                if (nxXML == null || nyXML == null || nzXML == null) {
                    throw new IOException("Missing coordinate in <Normal> for the <Plane> of a <Texture> (ID=" + idXML.getValue() + ")");
                }
                E3DVector normal = new E3DVector(nxXML.getDoubleValue(), nyXML.getDoubleValue(), nzXML.getDoubleValue());
                Element fileXML = textureXML.getChild(FILE);
                if (fileXML == null) {
                    throw new IOException("Missing <File> for a <Texture> (ID=" + idXML.getValue() + ")");
                }
                TexturePlane texturePlane = new TexturePlane(new File(this.base, fileXML.getText()), id2tag.get(tagIDRefXML.getValue()), enabledXML.getValue().equals(TRUE));
                texturePlane.set(normal, distXML.getDoubleValue());
                texturePlanes.add(texturePlane);
            }
        }
    }
}

