/*
 * Decompiled with CFR 0.152.
 */
package e3d.io.obj;

import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.CopyOnWriteArrayList;

public class WavefrontZBufferExporter {
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public void export(float[][][] xyzBuffer, File objFile) throws InterruptedException {
        if (TaskUtils.isInterrupted()) {
            throw new InterruptedException();
        }
        if (xyzBuffer == null || xyzBuffer.length == 0 || xyzBuffer[0].length == 0) {
            throw new RuntimeException("No / empty XYZ-buffer");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.init(3 * xyzBuffer.length, "Wavefront OBJ Export");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(0, "Start exporting");
        }
        int w = xyzBuffer.length;
        int h = xyzBuffer[0].length;
        FileWriter out = null;
        try {
            try {
                out = new FileWriter(objFile);
                out.write("# OBJ Exported from E3D\n");
                out.write("# symmetry 0\n");
                out.write("usemtl (E3DMaterial)\n");
                out.write("s 0\n");
                int[][] k = new int[w][h];
                int n = 0;
                int j = 0;
                while (j < h) {
                    int i = 0;
                    while (i < w) {
                        if (!Double.isInfinite(xyzBuffer[i][j][2])) {
                            out.write("v " + xyzBuffer[i][j][0] + " " + xyzBuffer[i][j][1] + " " + xyzBuffer[i][j][2] + "\n");
                            k[i][j] = ++n;
                        }
                        ++i;
                    }
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    for (ProgressListener listener : this.progressListeners) {
                        listener.done(j, "exporting vertices");
                    }
                    ++j;
                }
                j = 0;
                while (j < h) {
                    int i = 0;
                    while (i < w) {
                        if (!Double.isInfinite(xyzBuffer[i][j][2])) {
                            out.write("vt " + (float)i / (float)w + " " + (1.0 - (double)((float)j / (float)h)) + "\n");
                        }
                        ++i;
                    }
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    for (ProgressListener listener : this.progressListeners) {
                        listener.done(j, "exporting texture coordinates");
                    }
                    ++j;
                }
                j = 0;
                while (j < h - 1) {
                    int i = 0;
                    while (i < w - 1) {
                        if (!(Double.isInfinite(xyzBuffer[i][j][2]) || Double.isInfinite(xyzBuffer[i + 1][j][2]) || Double.isInfinite(xyzBuffer[i + 1][j + 1][2]) || Double.isInfinite(xyzBuffer[i][j + 1][2]))) {
                            double dx1 = xyzBuffer[i][j][0] - xyzBuffer[i + 1][j + 1][0];
                            double dy1 = xyzBuffer[i][j][1] - xyzBuffer[i + 1][j + 1][1];
                            double dz1 = xyzBuffer[i][j][2] - xyzBuffer[i + 1][j + 1][2];
                            double dx2 = xyzBuffer[i + 1][j][0] - xyzBuffer[i][j + 1][0];
                            double dy2 = xyzBuffer[i + 1][j][1] - xyzBuffer[i][j + 1][1];
                            double dz2 = xyzBuffer[i + 1][j][2] - xyzBuffer[i][j + 1][2];
                            double d1a = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                            double d1b = Math.sqrt(dx1 * dx1 + dy1 * dy1 + dz1 * dz1);
                            double d2a = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                            double d2b = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
                            if (d1a * 4.0 > d1b && d2a * 4.0 > d2b) {
                                out.write("f " + k[i + 1][j] + "/" + k[i + 1][j] + " " + k[i][j] + "/" + k[i][j] + " " + k[i][j + 1] + "/" + k[i][j + 1] + " " + k[i + 1][j + 1] + "/" + k[i + 1][j + 1] + "\n");
                            }
                        }
                        ++i;
                    }
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    for (ProgressListener listener : this.progressListeners) {
                        listener.done(j, "exporting faces");
                    }
                    ++j;
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(listener.steps(), "Filtering complete");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }
}

