/*
 * Decompiled with CFR 0.152.
 */
package e3d.io.obj;

import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageAWT;
import e3d.visualization.space.BinarySpace;
import e3d.visualization.space.Voxel;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WavefrontSpaceExporter {
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public void export(BinarySpace<E3DAtom> space, File objFile, File imgFile) throws InterruptedException {
        if (TaskUtils.isInterrupted()) {
            throw new InterruptedException();
        }
        if (space == null || space.getSize() == 0) {
            throw new RuntimeException("No / empty space");
        }
        List<Voxel<E3DAtom>> voxels = space.getAllVoxels();
        int s = 0;
        for (ProgressListener listener : this.progressListeners) {
            listener.init(2 * voxels.size(), "Wavefront OBJ Export");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(s, "Start exporting");
        }
        int w = space.getWidth();
        int h = space.getHeight();
        int d = space.getDepth();
        int wh = w * h;
        E3DBoundingBox b = space.getBounds();
        FileWriter out = null;
        try {
            try {
                out = new FileWriter(objFile);
                out.write("# OBJ Exported from E3D\n");
                out.write("# symmetry 0\n");
                out.write("usemtl (E3DMaterial)\n");
                out.write("s 0\n");
                int verts = 0;
                HashMap<Integer, Integer> vertex2index = new HashMap<Integer, Integer>();
                for (Voxel<E3DAtom> voxel : voxels) {
                    int i = voxel.i();
                    int j = voxel.j();
                    int k = voxel.k();
                    int dk = 0;
                    while (dk < 2) {
                        int dj = 0;
                        while (dj < 2) {
                            int di = 0;
                            while (di < 2) {
                                int v = i + di + (j + dj) * w + (k + dk) * wh;
                                if (!vertex2index.containsKey(v)) {
                                    vertex2index.put(v, ++verts);
                                    out.write("v " + ((double)(i + di) * b.width() / (double)w + b.x0) + " " + ((double)(j + dj) * b.height() / (double)h + b.y0) + " " + ((double)(k + dk) * b.depth() / (double)d + b.z0) + "\n");
                                }
                                ++di;
                            }
                            ++dj;
                        }
                        ++dk;
                    }
                    if (++s % 10000 != 0) continue;
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    for (ProgressListener listener : this.progressListeners) {
                        listener.done(s, "exporting vertices from " + voxels.size() + " voxels");
                    }
                }
                int sq = (int)Math.sqrt(voxels.size()) + 1;
                E3DImageAWT img = new E3DImageAWT(sq, sq);
                int t = 0;
                for (Voxel<E3DAtom> voxel : voxels) {
                    int v4;
                    int v3;
                    int v2;
                    int v1;
                    int i = voxel.i();
                    int j = voxel.j();
                    int k = voxel.k();
                    int x = t % sq;
                    int y = t / sq;
                    ((E3DImage)img).setRGB(x, y, voxel.getAtom().getColor());
                    out.write("vt " + ((double)x + 0.5) / (double)sq + " " + (1.0 - ((double)y + 0.5) / (double)sq) + "\n");
                    ++t;
                    if (space.isEmpty(i, j, k - 1)) {
                        v1 = (Integer)vertex2index.get(i + j * w + k * wh);
                        v2 = (Integer)vertex2index.get(i + (j + 1) * w + k * wh);
                        v3 = (Integer)vertex2index.get(i + 1 + (j + 1) * w + k * wh);
                        v4 = (Integer)vertex2index.get(i + 1 + j * w + k * wh);
                        out.write("f " + v1 + "/" + t + " " + v2 + "/" + t + " " + v3 + "/" + t + " " + v4 + "/" + t + "\n");
                    }
                    if (space.isEmpty(i, j, k + 1)) {
                        v1 = (Integer)vertex2index.get(i + j * w + (k + 1) * wh);
                        v2 = (Integer)vertex2index.get(i + 1 + j * w + (k + 1) * wh);
                        v3 = (Integer)vertex2index.get(i + 1 + (j + 1) * w + (k + 1) * wh);
                        v4 = (Integer)vertex2index.get(i + (j + 1) * w + (k + 1) * wh);
                        out.write("f " + v1 + "/" + t + " " + v2 + "/" + t + " " + v3 + "/" + t + " " + v4 + "/" + t + "\n");
                    }
                    if (space.isEmpty(i - 1, j, k)) {
                        v1 = (Integer)vertex2index.get(i + j * w + k * wh);
                        v2 = (Integer)vertex2index.get(i + j * w + (k + 1) * wh);
                        v3 = (Integer)vertex2index.get(i + (j + 1) * w + (k + 1) * wh);
                        v4 = (Integer)vertex2index.get(i + (j + 1) * w + k * wh);
                        out.write("f " + v1 + "/" + t + " " + v2 + "/" + t + " " + v3 + "/" + t + " " + v4 + "/" + t + "\n");
                    }
                    if (space.isEmpty(i + 1, j, k)) {
                        v1 = (Integer)vertex2index.get(i + 1 + j * w + k * wh);
                        v2 = (Integer)vertex2index.get(i + 1 + (j + 1) * w + k * wh);
                        v3 = (Integer)vertex2index.get(i + 1 + (j + 1) * w + (k + 1) * wh);
                        v4 = (Integer)vertex2index.get(i + 1 + j * w + (k + 1) * wh);
                        out.write("f " + v1 + "/" + t + " " + v2 + "/" + t + " " + v3 + "/" + t + " " + v4 + "/" + t + "\n");
                    }
                    if (space.isEmpty(i, j - 1, k)) {
                        v1 = (Integer)vertex2index.get(i + j * w + k * wh);
                        v2 = (Integer)vertex2index.get(i + 1 + j * w + k * wh);
                        v3 = (Integer)vertex2index.get(i + 1 + j * w + (k + 1) * wh);
                        v4 = (Integer)vertex2index.get(i + j * w + (k + 1) * wh);
                        out.write("f " + v1 + "/" + t + " " + v2 + "/" + t + " " + v3 + "/" + t + " " + v4 + "/" + t + "\n");
                    }
                    if (space.isEmpty(i, j + 1, k)) {
                        v1 = (Integer)vertex2index.get(i + (j + 1) * w + k * wh);
                        v2 = (Integer)vertex2index.get(i + (j + 1) * w + (k + 1) * wh);
                        v3 = (Integer)vertex2index.get(i + 1 + (j + 1) * w + (k + 1) * wh);
                        v4 = (Integer)vertex2index.get(i + 1 + (j + 1) * w + k * wh);
                        out.write("f " + v1 + "/" + t + " " + v2 + "/" + t + " " + v3 + "/" + t + " " + v4 + "/" + t + "\n");
                    }
                    if (++s % 10000 != 0) continue;
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    for (ProgressListener listener : this.progressListeners) {
                        listener.done(s, "exporting faces and tex-coords from " + voxels.size() + " voxels");
                    }
                }
                ((E3DImage)img).save(imgFile);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(listener.steps(), "Filtering complete");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }
}

