/*
 * Decompiled with CFR 0.152.
 */
package e3d.io.obj;

import e3d.bezier.Mesh;
import e3d.bezier.Needle;
import e3d.bezier.NeedleMeshes;
import e3d.bezier.PointMeshes;
import e3d.bezier.Position;
import e3d.io.xml.XMLMeshObjects;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class WavefrontMeshExporter {
    public void export(XMLMeshObjects objects, File objFile) {
        NeedleMeshes needleMeshes = objects.getNeedleMeshes();
        PointMeshes pointMeshes = objects.getPointMeshes();
        FileWriter out = null;
        try {
            try {
                Position point;
                Needle needle;
                int i;
                int j;
                out = new FileWriter(objFile);
                out.write("# OBJ Exported from E3D\n");
                out.write("# symmetry 0\n");
                out.write("usemtl (E3DMaterial)\n");
                out.write("s 0\n");
                int n = 0;
                HashMap<Cloneable, Integer> point2index = new HashMap<Cloneable, Integer>();
                for (Mesh mesh : needleMeshes) {
                    j = 0;
                    while (j < mesh.height()) {
                        i = 0;
                        while (i < mesh.width()) {
                            needle = (Needle)mesh.get(i, j);
                            if (needle != null) {
                                out.write("v " + needle.point.x + " " + needle.point.y + " " + needle.point.z + "\n");
                                point2index.put(needle, ++n);
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                for (Mesh mesh : pointMeshes) {
                    j = 0;
                    while (j < mesh.height()) {
                        i = 0;
                        while (i < mesh.width()) {
                            point = (Position)mesh.get(i, j);
                            if (point != null) {
                                out.write("v " + point.x + " " + point.y + " " + point.z + "\n");
                                point2index.put(point, ++n);
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                for (Mesh mesh : needleMeshes) {
                    j = 0;
                    while (j < mesh.height()) {
                        i = 0;
                        while (i < mesh.width()) {
                            needle = (Needle)mesh.get(i, j);
                            if (needle != null) {
                                out.write("vt " + (needle.point.x + 1.0) / 2.0 + " " + (-needle.point.y + 1.0) / 2.0 + "\n");
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                for (Mesh mesh : pointMeshes) {
                    j = 0;
                    while (j < mesh.height()) {
                        i = 0;
                        while (i < mesh.width()) {
                            point = (Position)mesh.get(i, j);
                            if (point != null) {
                                out.write("vt " + (point.x + 1.0) / 2.0 + " " + (-point.y + 1.0) / 2.0 + "\n");
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                for (Mesh mesh : needleMeshes) {
                    j = 0;
                    while (j < mesh.height() - 1) {
                        i = 0;
                        while (i < mesh.width() - 1) {
                            Needle needle00 = (Needle)mesh.get(i, j);
                            Needle needle10 = (Needle)mesh.get(i + 1, j);
                            Needle needle11 = (Needle)mesh.get(i + 1, j + 1);
                            Needle needle01 = (Needle)mesh.get(i, j + 1);
                            if (needle00 != null && needle10 != null && needle11 != null && needle01 != null) {
                                out.write("f " + point2index.get(needle00) + "/" + point2index.get(needle00) + " " + point2index.get(needle01) + "/" + point2index.get(needle01) + " " + point2index.get(needle11) + "/" + point2index.get(needle11) + " " + point2index.get(needle10) + "/" + point2index.get(needle10) + "\n");
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                for (Mesh mesh : pointMeshes) {
                    j = 0;
                    while (j < mesh.height() - 1) {
                        i = 0;
                        while (i < mesh.width() - 1) {
                            Position point00 = (Position)mesh.get(i, j);
                            Position point10 = (Position)mesh.get(i + 1, j);
                            Position point11 = (Position)mesh.get(i + 1, j + 1);
                            Position point01 = (Position)mesh.get(i, j + 1);
                            if (point00 != null && point10 != null && point11 != null && point01 != null) {
                                out.write("f " + point2index.get(point00) + "/" + point2index.get(point00) + " " + point2index.get(point01) + "/" + point2index.get(point01) + " " + point2index.get(point11) + "/" + point2index.get(point11) + " " + point2index.get(point10) + "/" + point2index.get(point10) + "\n");
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }
}

