/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.utils;

import e3d.gui.E3DGUI;
import e3d.gui.icons.Icons;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class E3DMenu {
    private final Menu menu;
    public final Menu fileMenu;
    private final MenuItem loadItem;
    private final MenuItem saveItem;
    private final MenuItem exitItem;
    public final Menu editMenu;
    private final MenuItem undoItem;
    private final MenuItem redoItem;
    private final MenuItem copyItem;
    private final MenuItem cutItem;
    private final MenuItem pasteItem;
    private final MenuItem deleteItem;
    public final Menu viewMenu;
    public final Menu optionsMenu;
    public final Menu helpMenu;
    private final MenuItem helpItem;
    private final MenuItem aboutItem;

    public E3DMenu(Shell shell, final E3DGUI gui) {
        this.menu = new Menu(shell, 2);
        shell.setMenuBar(this.menu);
        MenuItem fileMenuHeader = new MenuItem(this.menu, 64);
        this.fileMenu = new Menu(shell, 4);
        fileMenuHeader.setText("File");
        fileMenuHeader.setMenu(this.fileMenu);
        if (gui.hasLoadItem()) {
            this.loadItem = new MenuItem(this.fileMenu, 8);
            this.loadItem.setImage(Icons.getSWTImage(shell.getDisplay(), "load_focus.png"));
            this.loadItem.setText("Load\tCtrl+O");
            this.loadItem.setAccelerator(262223);
            this.loadItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    gui.load();
                }
            });
        } else {
            this.loadItem = null;
        }
        this.saveItem = new MenuItem(this.fileMenu, 8);
        this.saveItem.setEnabled(false);
        this.saveItem.setImage(Icons.getSWTImage(shell.getDisplay(), "save_focus.png"));
        this.saveItem.setText("Save...\tCtrl+S");
        this.saveItem.setAccelerator(262227);
        this.saveItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                gui.save();
            }
        });
        new MenuItem(this.fileMenu, 2);
        this.exitItem = new MenuItem(this.fileMenu, 8);
        this.exitItem.setEnabled(true);
        this.exitItem.setImage(Icons.getSWTImage(shell.getDisplay(), "power_focus.png"));
        this.exitItem.setText("Exit...\tCtrl+Q");
        this.exitItem.setAccelerator(262225);
        this.exitItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                gui.exit();
            }
        });
        if (gui.hasEditMenu()) {
            MenuItem editMenuHeader = new MenuItem(this.menu, 64);
            this.editMenu = new Menu(shell, 4);
            editMenuHeader.setText("Edit");
            editMenuHeader.setMenu(this.editMenu);
            this.undoItem = new MenuItem(this.editMenu, 8);
            this.undoItem.setImage(Icons.getSWTImage(shell.getDisplay(), "etator_focus.png"));
            this.undoItem.setText("Undo\tCtrl+Z");
            this.undoItem.setAccelerator(262234);
            this.undoItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    gui.undo();
                }
            });
            this.redoItem = new MenuItem(this.editMenu, 8);
            this.redoItem.setImage(Icons.getSWTImage(shell.getDisplay(), "rotate_focus.png"));
            this.redoItem.setText("Redo\tCtrl+Y");
            this.redoItem.setAccelerator(262233);
            this.redoItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    gui.redo();
                }
            });
            new MenuItem(this.editMenu, 2);
            this.copyItem = new MenuItem(this.editMenu, 8);
            this.copyItem.setImage(Icons.getSWTImage(shell.getDisplay(), "get_focus.png"));
            this.copyItem.setText("Copy\tCtrl+C");
            this.copyItem.setAccelerator(262211);
            this.copyItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    gui.copy();
                    E3DMenu.this.pasteItem.setEnabled(true);
                }
            });
            this.cutItem = new MenuItem(this.editMenu, 8);
            this.cutItem.setImage(Icons.getSWTImage(shell.getDisplay(), "stop_focus.png"));
            this.cutItem.setText("Cut...\tCtrl+X");
            this.cutItem.setAccelerator(262232);
            this.cutItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    gui.cut();
                    E3DMenu.this.pasteItem.setEnabled(true);
                }
            });
            this.pasteItem = new MenuItem(this.editMenu, 8);
            this.pasteItem.setEnabled(false);
            this.pasteItem.setImage(Icons.getSWTImage(shell.getDisplay(), "add_focus.png"));
            this.pasteItem.setText("Paste...\tCtrl+V");
            this.pasteItem.setAccelerator(262230);
            this.pasteItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    gui.paste();
                }
            });
            new MenuItem(this.editMenu, 2);
            this.deleteItem = new MenuItem(this.editMenu, 8);
            this.deleteItem.setImage(Icons.getSWTImage(shell.getDisplay(), "delete_focus.png"));
            this.deleteItem.setText("Delete\tDelete");
            this.deleteItem.setAccelerator(127);
            this.deleteItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    gui.delete();
                }
            });
        } else {
            this.editMenu = null;
            this.undoItem = null;
            this.redoItem = null;
            this.copyItem = null;
            this.cutItem = null;
            this.deleteItem = null;
            this.pasteItem = null;
        }
        if (gui.hasViewMenu()) {
            MenuItem viewMenuHeader = new MenuItem(this.menu, 64);
            this.viewMenu = new Menu(shell, 4);
            viewMenuHeader.setText("View");
            viewMenuHeader.setMenu(this.viewMenu);
        } else {
            this.viewMenu = null;
        }
        if (gui.hasOptionsMenu()) {
            MenuItem optionsMenuHeader = new MenuItem(this.menu, 64);
            this.optionsMenu = new Menu(shell, 4);
            optionsMenuHeader.setText("Options");
            optionsMenuHeader.setMenu(this.optionsMenu);
        } else {
            this.optionsMenu = null;
        }
        MenuItem helpMenuHeader = new MenuItem(this.menu, 64);
        this.helpMenu = new Menu(shell, 4);
        helpMenuHeader.setText("Help");
        helpMenuHeader.setMenu(this.helpMenu);
        this.helpItem = new MenuItem(this.helpMenu, 8);
        this.helpItem.setImage(Icons.getSWTImage(shell.getDisplay(), "help_focus.png"));
        this.helpItem.setText("Help");
        this.helpItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                gui.help();
            }
        });
        this.aboutItem = new MenuItem(this.helpMenu, 8);
        this.aboutItem.setText("About");
        this.aboutItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                gui.about();
            }
        });
    }

    public void setSavable(boolean savable) {
        this.saveItem.setEnabled(savable);
    }

    public void setCopyable(boolean copyable) {
        this.copyItem.setEnabled(copyable);
        this.cutItem.setEnabled(copyable);
    }
}

