/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.utils;

import e3d.gui.groups.RadioButtonGroup;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class E3DLicenseWindow {
    private static String LICENSE = "Copyright (c) 2009, Patrick Rammelt\nAll rights reserved.\n\nRedistribution and use in source and binary forms,\nwith or without modification, are permitted provided\nthat the following conditions are met:\n\n* Redistributions of source code must retain the\n  above copyright notice, this list of conditions\n  and the following disclaimer.\n* Redistributions in binary form must reproduce the\n  above copyright notice, this list of conditions and\n  the following disclaimer in the documentation and/or\n  other materials provided with the distribution.\n* The names of its contributors may not be used to\n  endorse or promote products derived from this\n  software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS\nAND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED\nWARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\nPURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\nHOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE\nGOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\nINTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\nWHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH\nDAMAGE.";
    protected boolean agreed = false;

    public boolean open(Display display) {
        File agreement = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".e3d/agreement");
        if (agreement.exists()) {
            return true;
        }
        final Shell shell = new Shell(display);
        shell.setText("License Agreement");
        shell.setLayout(new GridLayout(1, false));
        shell.setSize(600, 300);
        StyledText text = new StyledText(shell, 770);
        text.setLayoutData(new GridData(1808));
        text.append(LICENSE);
        RadioButtonGroup agreeGroup = new RadioButtonGroup(shell, "Agreement", new String[]{"I do not agree", "I agree"}, new String[2], 0, -1, true, false);
        Composite buttonFrame = new Composite(shell, 0);
        buttonFrame.setLayoutData(new GridData());
        buttonFrame.setLayout(new GridLayout(2, true));
        Button cancelButton = new Button(buttonFrame, 2048);
        cancelButton.setLayoutData(new GridData());
        cancelButton.setText("Cancel");
        final Button okButton = new Button(buttonFrame, 2048);
        okButton.setLayoutData(new GridData());
        okButton.setEnabled(false);
        okButton.setText("Start E3D");
        agreeGroup.addSelectionListener(0, new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                E3DLicenseWindow.this.agreed = false;
                okButton.setEnabled(false);
            }
        });
        agreeGroup.addSelectionListener(1, new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                E3DLicenseWindow.this.agreed = true;
                okButton.setEnabled(true);
            }
        });
        cancelButton.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                E3DLicenseWindow.this.agreed = false;
                shell.close();
                shell.dispose();
            }
        });
        okButton.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                shell.close();
                shell.dispose();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        boolean ok = true;
        if (this.agreed) {
            if (!agreement.getParentFile().exists() && !agreement.getParentFile().mkdir()) {
                ok = false;
            }
            if (ok) {
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(agreement, false));
                    out.write("User " + System.getProperty("user.name") + " has agreed to the following conditions:\n\n" + LICENSE);
                    out.close();
                }
                catch (IOException exception) {
                    ok = false;
                }
            }
        }
        if (!ok) {
            MessageBox msgBox = new MessageBox(shell, 33);
            msgBox.setText("Could not save file: '" + agreement.getAbsolutePath() + "'");
        }
        return this.agreed;
    }
}

