/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.utils;

import e3d.gui.E3DGUI;
import e3d.gui.icons.Icons;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.ToggleButton;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class E3DCoolBar {
    protected final CoolBar coolBar;
    protected final Label startButton;
    protected final Label stopButton;
    protected final ToggleButton autoButton;
    protected final Label loadButton;
    protected final Label saveButton;
    protected final Display display;

    public E3DCoolBar(Composite parent, final E3DGUI gui) {
        this.display = parent.getDisplay();
        this.coolBar = new CoolBar(parent, 0);
        GridData gridData = new GridData(768);
        this.coolBar.setLayoutData(gridData);
        if (gui.isStartable()) {
            Composite ctrlFrame = new Composite(this.coolBar, 0);
            ctrlFrame.setLayout(new GridLayout(3, true));
            this.startButton = new IconButton(ctrlFrame, false, Icons.getSWTImage(this.display, "start.png"), Icons.getSWTImage(this.display, "start_focus.png"), Icons.getSWTImage(this.display, "start_pressed.png"), "Start").getButton();
            this.startButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                    gui.start();
                }

                @Override
                public void mouseUp(MouseEvent e) {
                }
            });
            this.stopButton = new IconButton(ctrlFrame, false, Icons.getSWTImage(this.display, "stop.png"), Icons.getSWTImage(this.display, "stop_focus.png"), Icons.getSWTImage(this.display, "stop_pressed.png"), "Stop").getButton();
            this.stopButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                    gui.stop();
                }

                @Override
                public void mouseUp(MouseEvent e) {
                }
            });
            this.autoButton = new ToggleButton(ctrlFrame, true, Icons.getSWTImage(this.display, "auto_disabled.png"), Icons.getSWTImage(this.display, "auto_focus_disabled.png"), Icons.getSWTImage(this.display, "auto_enabled.png"), Icons.getSWTImage(this.display, "auto_focus_enabled.png"), "Restart immediately after a value has changed", false);
            this.autoButton.getButton().addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                    gui.setAutomaticRestart(E3DCoolBar.this.autoButton.isOn());
                }

                @Override
                public void mouseUp(MouseEvent e) {
                }
            });
            ctrlFrame.pack();
            Point ctrlSize = ctrlFrame.getSize();
            CoolItem ctrlItem = new CoolItem(this.coolBar, 0);
            ctrlItem.setControl(ctrlFrame);
            ctrlItem.setSize(ctrlItem.computeSize(ctrlSize.x, ctrlSize.y));
        } else {
            this.startButton = null;
            this.stopButton = null;
            this.autoButton = null;
        }
        Composite fileFrame = new Composite(this.coolBar, 0);
        fileFrame.setLayout(new GridLayout(gui.hasLoadItem() ? 2 : 1, true));
        if (gui.hasLoadItem()) {
            this.loadButton = new IconButton(fileFrame, true, Icons.getSWTImage(this.display, "load.png"), Icons.getSWTImage(this.display, "load_focus.png"), Icons.getSWTImage(this.display, "load_pressed.png"), "Load").getButton();
            this.loadButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                    gui.load();
                }

                @Override
                public void mouseUp(MouseEvent e) {
                }
            });
        } else {
            this.loadButton = null;
        }
        this.saveButton = new IconButton(fileFrame, false, Icons.getSWTImage(this.display, "save.png"), Icons.getSWTImage(this.display, "save_focus.png"), Icons.getSWTImage(this.display, "save_pressed.png"), "Save").getButton();
        this.saveButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }

            @Override
            public void mouseDown(MouseEvent e) {
                gui.save();
            }

            @Override
            public void mouseUp(MouseEvent e) {
            }
        });
        fileFrame.pack();
        Point fileSize = fileFrame.getSize();
        CoolItem fileItem = new CoolItem(this.coolBar, 0);
        fileItem.setControl(fileFrame);
        fileItem.setSize(fileItem.computeSize(fileSize.x, fileSize.y));
        Composite helpFrame = new Composite(this.coolBar, 0);
        helpFrame.setLayout(new GridLayout(1, true));
        Label helpButton = new IconButton(helpFrame, true, Icons.getSWTImage(this.display, "help.png"), Icons.getSWTImage(this.display, "help_focus.png"), Icons.getSWTImage(this.display, "help_pressed.png"), "Start").getButton();
        helpButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }

            @Override
            public void mouseDown(MouseEvent e) {
                gui.help();
            }

            @Override
            public void mouseUp(MouseEvent e) {
            }
        });
        helpFrame.pack();
        Point helpSize = helpFrame.getSize();
        CoolItem helpItem = new CoolItem(this.coolBar, 0);
        helpItem.setControl(helpFrame);
        helpItem.setSize(helpItem.computeSize(helpSize.x, helpSize.y));
    }

    public void setBusy(boolean busy) {
        this.startButton.setEnabled(!busy);
        this.stopButton.setEnabled(busy);
    }

    public void setBusyFromOtherThread(final boolean busy) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                E3DCoolBar.this.setBusy(busy);
            }
        });
    }

    public void setSavable(boolean savable) {
        this.saveButton.setEnabled(savable);
    }

    public void setStartable(boolean startable) {
        this.startButton.setEnabled(startable);
        this.stopButton.setEnabled(false);
        this.autoButton.getButton().setEnabled(startable);
    }
}

