/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.images;

import e3d.visualization.image.E3DImage;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ScrollableImage {
    private static final String ERROR_FONT_NAME = "Arial";
    private static final int ERROR_FONT_HEIGHT = 16;
    private static final int ERROR_FONT_STYLE = 1;
    private static final int ERROR_LINE_HEIGHT = 20;
    protected final ScrolledComposite scroll;
    protected final Canvas canvas;
    protected Image image = null;
    protected double zoom = 1.0;
    protected final Font errorFont;
    protected final Image errorImage;

    public ScrollableImage(Composite parent) {
        this.scroll = new ScrolledComposite(parent, 2816);
        this.scroll.setLayoutData(new GridData(1808));
        this.canvas = new Canvas(this.scroll, 0x20000000);
        this.canvas.setLayoutData(new GridData(1808));
        this.scroll.setContent(this.canvas);
        this.scroll.setExpandVertical(true);
        this.scroll.setExpandHorizontal(true);
        this.errorFont = new Font((Device)parent.getDisplay(), new FontData(ERROR_FONT_NAME, 16, 1));
        this.errorImage = new Image((Device)parent.getDisplay(), 1, 1);
        this.canvas.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                int w = (int)((double)ScrollableImage.this.getWidth() * ScrollableImage.this.zoom);
                int h = (int)((double)ScrollableImage.this.getHeight() * ScrollableImage.this.zoom);
                event.gc.setForeground(ScrollableImage.this.canvas.getDisplay().getSystemColor(1));
                event.gc.setAlpha(127);
                event.gc.setLineWidth(1);
                event.gc.drawRectangle(0, 0, w, h);
                event.gc.setAlpha(255);
                if (ScrollableImage.this.image == ScrollableImage.this.errorImage) {
                    ScrollableImage.this.showErrorMessage(event.gc);
                } else if (ScrollableImage.this.image != null) {
                    try {
                        event.gc.drawImage(ScrollableImage.this.image, 0, 0, ScrollableImage.this.getWidth(), ScrollableImage.this.getHeight(), 0, 0, w, h);
                    }
                    catch (Exception exception) {
                        ScrollableImage.this.setImage(ScrollableImage.this.errorImage);
                        ScrollableImage.this.showErrorMessage(event.gc);
                    }
                    catch (SWTError error) {
                        ScrollableImage.this.setImage(ScrollableImage.this.errorImage);
                        ScrollableImage.this.showErrorMessage(event.gc);
                    }
                }
            }
        });
    }

    public void dispose() {
        this.image.dispose();
        this.errorFont.dispose();
        this.errorImage.dispose();
    }

    private void showErrorMessage(GC gc) {
        Rectangle area = this.getScroll().getClientArea();
        Point origin = this.getScroll().getOrigin();
        int x = origin.x + area.width / 2;
        int y = origin.y + area.height / 2;
        String[] lines = new String[]{"Could not display image", "Most likely reason:", "- image is too large", "Image might well be ok,", "so please, try to save it", "and use some other viewer."};
        y -= (int)((double)lines.length / 2.0 * 20.0);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            gc.setForeground(this.canvas.getDisplay().getSystemColor(3));
            gc.setFont(this.errorFont);
            Point textExtend = gc.textExtent(line, 1);
            gc.drawText(line, x - textExtend.x / 2, y - 8, true);
            y += 20;
            ++n2;
        }
    }

    public ScrolledComposite getScroll() {
        return this.scroll;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image != null && this.image != this.errorImage) {
            this.image.dispose();
        }
        this.image = image;
        this.scroll.setMinSize((int)((double)this.getWidth() * this.getZoom()), (int)((double)this.getHeight() * this.getZoom()));
        this.canvas.redraw();
        this.canvas.update();
    }

    public void setImageData(ImageData imageData) {
        if (imageData == null) {
            this.setImage(null);
        } else {
            try {
                Image image = new Image((Device)this.canvas.getDisplay(), imageData);
                this.setImage(image);
            }
            catch (Exception exception) {
                this.setImage(this.errorImage);
            }
            catch (SWTError error) {
                this.setImage(this.errorImage);
            }
        }
    }

    public void setE3DImage(E3DImage image) {
        if (image == null) {
            this.setImage(null);
        } else {
            this.setImageData(image.getImageData());
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
        this.scroll.setMinSize((int)((double)this.getWidth() * this.getZoom()), (int)((double)this.getHeight() * this.getZoom()));
        this.canvas.redraw();
        this.canvas.update();
    }

    public int getWidth() {
        if (this.image != null) {
            return this.image.getBounds().width;
        }
        return 200;
    }

    public int getHeight() {
        if (this.image != null) {
            return this.image.getBounds().height;
        }
        return 200;
    }
}

