/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.images;

import e3d.euclidean.E3DVector;
import e3d.gui.images.ScrollableImage;
import e3d.utils.Getter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ImageLocator {
    protected final ScrollableImage scrollableImage;
    final Getter<float[][][]> xyzBufferGetter;
    final Getter<double[]> dMinMaxGetter;
    final Getter<E3DVector> voxelSizeGetter;
    final Getter<E3DVector> viewPosGetter;
    protected final Color fgColor;
    protected final Color bgColor;
    protected final Font font;
    protected final MouseMoveListener mouseMoveListener;
    protected final MouseListener mouseButtonListener;
    protected final PaintListener paintListener;
    protected int x0 = -1;
    protected int y0 = -1;
    protected int x = -1;
    protected int y = -1;
    protected boolean active = false;
    protected boolean zoom = false;
    protected boolean dragged = false;
    protected final List<ZoomListener> listeners = new CopyOnWriteArrayList<ZoomListener>();

    public ImageLocator(final ScrollableImage scrollableImage, Getter<E3DVector> voxelSizeGetter, final Getter<E3DVector> viewPosGetter, final Getter<float[][][]> xyzBufferGetter, final Getter<double[]> dMinMaxGetter) {
        this.scrollableImage = scrollableImage;
        this.voxelSizeGetter = voxelSizeGetter;
        this.viewPosGetter = viewPosGetter;
        this.xyzBufferGetter = xyzBufferGetter;
        this.dMinMaxGetter = dMinMaxGetter;
        Display display = scrollableImage.getCanvas().getDisplay();
        this.fgColor = new Color(display, 255, 255, 255);
        this.bgColor = new Color(display, 0, 0, 0);
        this.font = new Font((Device)display, new FontData("Arial", 10, 0));
        this.mouseMoveListener = new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent event) {
                if (ImageLocator.this.active) {
                    ImageLocator.this.dragged = true;
                    ImageLocator.this.x = event.x;
                    ImageLocator.this.y = event.y;
                    scrollableImage.getCanvas().redraw();
                }
            }
        };
        this.mouseButtonListener = new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent event) {
            }

            @Override
            public void mouseDown(MouseEvent event) {
                if (event.button == 3) {
                    ImageLocator.this.zoom = true;
                }
                ImageLocator.this.active = true;
                ImageLocator.this.dragged = false;
                ImageLocator.this.x0 = ImageLocator.this.x = event.x;
                ImageLocator.this.y0 = ImageLocator.this.y = event.y;
                scrollableImage.getCanvas().redraw();
            }

            @Override
            public void mouseUp(MouseEvent event) {
                if (ImageLocator.this.active && ImageLocator.this.dragged && ImageLocator.this.zoom) {
                    ImageLocator.this.callZoomListeners();
                }
                ImageLocator.this.zoom = false;
                ImageLocator.this.active = false;
                ImageLocator.this.dragged = false;
                scrollableImage.getCanvas().redraw();
            }
        };
        this.paintListener = new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                if (ImageLocator.this.active) {
                    E3DVector viewPos = (E3DVector)viewPosGetter.get();
                    float[][][] xyzBuffer = (float[][][])xyzBufferGetter.get();
                    double[] dMinMax = (double[])dMinMaxGetter.get();
                    if (xyzBuffer != null && xyzBuffer.length == scrollableImage.getWidth() && xyzBuffer[0].length == scrollableImage.getHeight()) {
                        double zoomFactor = scrollableImage.getZoom();
                        int i = (int)((double)ImageLocator.this.x / zoomFactor);
                        int j = (int)((double)ImageLocator.this.y / zoomFactor);
                        event.gc.setForeground(ImageLocator.this.fgColor);
                        event.gc.setBackground(ImageLocator.this.bgColor);
                        event.gc.setFont(ImageLocator.this.font);
                        if (ImageLocator.this.zoom) {
                            int wh = Math.max(Math.abs(ImageLocator.this.x - ImageLocator.this.x0) + 1, Math.abs(ImageLocator.this.y - ImageLocator.this.y0) + 1);
                            event.gc.drawRectangle(ImageLocator.this.x0 - wh, ImageLocator.this.y0 - wh, wh * 2, wh * 2);
                            event.gc.drawRectangle(ImageLocator.this.x0 - 1, ImageLocator.this.y0 - 1, 3, 3);
                        }
                        if (i >= 0 && i < xyzBuffer.length && j >= 0 && j < xyzBuffer[0].length) {
                            int color = scrollableImage.getImage().getImageData().getPixel(i, j);
                            double d = viewPos.dist(xyzBuffer[i][j][0], xyzBuffer[i][j][1], xyzBuffer[i][j][2]);
                            String[] lines = new String[]{String.format("Pixel: (%d, %d)", i, j), String.format("Color: (r=%d, g=%d, b=%d)", color >> 0 & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF), String.format("Coord: (%g, %g, %g)", Float.valueOf(xyzBuffer[i][j][0]), Float.valueOf(xyzBuffer[i][j][1]), Float.valueOf(xyzBuffer[i][j][2])), String.format("Abs. Dist.: %g / Rel. Dist.: %g", d, (d - dMinMax[0]) / (dMinMax[1] - dMinMax[0]))};
                            Point extend = new Point(0, 0);
                            String[] stringArray = lines;
                            int n = lines.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String line = stringArray[n2];
                                Point ext = event.gc.textExtent(line, 1);
                                extend.x = Math.max(extend.x, ext.x);
                                extend.y = Math.max(extend.y, ext.y);
                                ++n2;
                            }
                            Point origin = scrollableImage.getScroll().getOrigin();
                            Rectangle area = scrollableImage.getScroll().getClientArea();
                            int xLine = Math.max(5 + origin.x, Math.min(area.width + origin.x - extend.x - 5, ImageLocator.this.x + 5 - extend.x / 2));
                            int lineDist = 5;
                            int hRect = (extend.y + 5) * lines.length + 10;
                            int yLine = ImageLocator.this.y + 20 - 5 + hRect < area.height + origin.y ? ImageLocator.this.y + 20 : ImageLocator.this.y - hRect;
                            event.gc.setAlpha(193);
                            event.gc.fillRectangle(xLine - 5, yLine - 5, extend.x + 10, hRect);
                            event.gc.setAlpha(255);
                            String[] stringArray2 = lines;
                            int n3 = lines.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String line = stringArray2[n4];
                                event.gc.drawText(line, xLine, yLine, true);
                                yLine += extend.y + 5;
                                ++n4;
                            }
                        }
                    }
                }
            }
        };
        scrollableImage.getCanvas().addMouseMoveListener(this.mouseMoveListener);
        scrollableImage.getCanvas().addMouseListener(this.mouseButtonListener);
        scrollableImage.getCanvas().addPaintListener(this.paintListener);
    }

    public void addZoomListener(ZoomListener listener) {
        this.listeners.add(listener);
    }

    public void removeZoomListener(ZoomListener listener) {
        this.listeners.remove(listener);
    }

    private void callZoomListeners() {
        E3DVector voxelSize = this.voxelSizeGetter.get();
        float[][][] xzyBuffer = this.xyzBufferGetter.get();
        double zoom = this.scrollableImage.getZoom();
        int i = (int)((double)this.x / zoom);
        int j = (int)((double)this.y / zoom);
        int i0 = (int)((double)this.x0 / zoom);
        int j0 = (int)((double)this.y0 / zoom);
        if (i0 >= 0 && i0 < xzyBuffer.length && j0 >= 0 && j0 < xzyBuffer[0].length && !Float.isInfinite(xzyBuffer[i0][j0][2])) {
            double xm = xzyBuffer[i0][j0][0];
            double ym = xzyBuffer[i0][j0][1];
            double zm = xzyBuffer[i0][j0][2];
            double dij = Math.max(Math.abs(i - i0), Math.abs(j - j0));
            double dxyz = Math.max(voxelSize.x * dij, voxelSize.y * dij);
            for (ZoomListener listener : this.listeners) {
                listener.zoom(xm, ym, zm, dxyz, dxyz, dxyz);
            }
        }
    }

    public void dispose() {
        this.scrollableImage.getCanvas().removePaintListener(this.paintListener);
        this.scrollableImage.getCanvas().removeMouseMoveListener(this.mouseMoveListener);
        this.scrollableImage.getCanvas().removeMouseListener(this.mouseButtonListener);
        this.fgColor.dispose();
        this.font.dispose();
    }

    public static interface ZoomListener {
        public void zoom(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

