/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.special;

import e3d.gui.J3DEditorGUI;
import e3d.gui.groups.special.ShapeTemplateGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.j3d.J3DCanvas;
import e3d.j3d.objects.J3DVolume;
import javax.vecmath.Point3d;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class VolumeTemplateGroup
extends ShapeTemplateGroup {
    public VolumeTemplateGroup(final J3DEditorGUI gui, Composite parent) {
        super(gui, parent, "Volume", 9);
        Label icon = new Label(this.group, 0x1000000);
        icon.setImage(Icons.getSWTImage(parent.getDisplay(), "volume_big.png"));
        icon.setToolTipText("Create an object for volume-rendering of 3D-textures. This is not a mesh! It has neither points nor needles. Its size cannot be modified. The only thing you can do is to set some images which will be shown by this object.");
        icon.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, false, false));
        ((GridData)icon.getLayoutData()).verticalSpan = 2;
        Label labelX = new Label(this.group, 0x1000000);
        labelX.setImage(Icons.getSWTImage(parent.getDisplay(), "x_focus.png"));
        labelX.setToolTipText("X-position (center)");
        labelX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelY = new Label(this.group, 0x1000000);
        labelY.setImage(Icons.getSWTImage(parent.getDisplay(), "y_focus.png"));
        labelY.setToolTipText("Y-position (center)");
        labelY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelZ = new Label(this.group, 0x1000000);
        labelZ.setImage(Icons.getSWTImage(parent.getDisplay(), "z_focus.png"));
        labelZ.setToolTipText("Z-position (center)");
        labelZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelWidth = new Label(this.group, 0x1000000);
        labelWidth.setImage(Icons.getSWTImage(parent.getDisplay(), "width_focus.png"));
        labelWidth.setToolTipText("Width");
        labelWidth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelHeight = new Label(this.group, 0x1000000);
        labelHeight.setImage(Icons.getSWTImage(parent.getDisplay(), "height_focus.png"));
        labelHeight.setToolTipText("Height");
        labelHeight.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelDepth = new Label(this.group, 0x1000000);
        labelDepth.setImage(Icons.getSWTImage(parent.getDisplay(), "depth_focus.png"));
        labelDepth.setToolTipText("Depth");
        labelDepth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelSlices = new Label(this.group, 0x1000000);
        labelSlices.setImage(Icons.getSWTImage(parent.getDisplay(), "cols_focus.png"));
        labelSlices.setToolTipText("Number of Slices (in Z-Direction)");
        labelSlices.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Composite empty = new Composite(this.group, 0);
        empty.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, 1, false, false));
        final Text textX = new Text(this.group, 2048);
        textX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textY = new Text(this.group, 2048);
        textY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textZ = new Text(this.group, 2048);
        textZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textWidth = new Text(this.group, 2048);
        textWidth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textHeight = new Text(this.group, 2048);
        textHeight.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textDepth = new Text(this.group, 2048);
        textDepth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textSlices = new Text(this.group, 2048);
        textSlices.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label create = new IconButton(this.group, true, Icons.getSWTImage(this.group.getDisplay(), "start.png"), Icons.getSWTImage(this.group.getDisplay(), "start_focus.png"), Icons.getSWTImage(this.group.getDisplay(), "start_pressed.png"), "Create").getButton();
        create.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, 35, -1, true, false));
        create.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDown(MouseEvent e) {
                try {
                    Point3d center = new Point3d(Double.parseDouble(textX.getText()), Double.parseDouble(textY.getText()), Double.parseDouble(textZ.getText()));
                    double width = Double.parseDouble(textWidth.getText());
                    double height = Double.parseDouble(textHeight.getText());
                    double depth = Double.parseDouble(textDepth.getText());
                    int slices = Integer.parseInt(textSlices.getText());
                    J3DCanvas j3DCanvas = gui.getCanvas();
                    synchronized (j3DCanvas) {
                        J3DCanvas.Lock lock = gui.getCanvas().lock();
                        try {
                            J3DVolume volume = new J3DVolume(center, width, height, depth, slices, 2, gui.volumeParameters);
                            gui.getCanvas().getScene().addObject(volume);
                        }
                        finally {
                            gui.getHistory().next();
                            gui.getCanvas().unlock(lock);
                        }
                    }
                }
                catch (RuntimeException exception) {
                    gui.showGeneralError(exception);
                }
            }

            @Override
            public void mouseUp(MouseEvent e) {
            }
        });
    }
}

