/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.special;

import e3d.gui.J3DEditorGUI;
import e3d.gui.groups.ListGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.gui.utils.ToggleButton;
import e3d.j3d.J3DCanvas;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DTexturedObject;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DPoint;
import e3d.j3d.objects.J3DSurface;
import java.util.Set;
import javax.media.j3d.Texture2D;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TagListGroup
extends ListGroup {
    public TagListGroup(Composite parent, final J3DEditorGUI gui, String[] tags) {
        super(parent, "Tags", new String[]{"Create new tags,\nDelete tags,\nGet tags from an object,\nAdd tags to an object,\nRemove tags from an object", "(De-)Select all objects\nSelect objects by selecting tags"}, Icons.getSWTImages(parent.getDisplay(), "edit_focus.png", "select_focus.png"), new String[][]{tags, tags}, 75, 350);
        Composite getSetRmButtons = this.getLeftGenericSection(0);
        getSetRmButtons.setLayout(SWTUtils.gridLayout(1, true, 0, 0, 0, 0, 0, 0, 0, 0));
        getSetRmButtons.setLayoutData(SWTUtils.gridData(1, 2, 0, 0, -1, -1, false, true));
        Label getTagsButton = new IconButton(getSetRmButtons, true, Icons.getSWTImage(parent.getDisplay(), "get.png"), Icons.getSWTImage(parent.getDisplay(), "get_focus.png"), Icons.getSWTImage(parent.getDisplay(), "get_pressed.png"), "Get tags from (1st) selected object").getButton();
        getTagsButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        getTagsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                for (J3DInstance object : gui.getSelected()) {
                    if (!TagListGroup.this.isTaggable(object)) continue;
                    TagListGroup.this.getList(0).setSelection(gui.getTagger().getTags(object).toArray(new String[gui.getTagger().getTags(object).size()]));
                    break;
                }
            }
        });
        Label addTagsButton = new IconButton(getSetRmButtons, true, Icons.getSWTImage(parent.getDisplay(), "start.png"), Icons.getSWTImage(parent.getDisplay(), "start_focus.png"), Icons.getSWTImage(parent.getDisplay(), "start_pressed.png"), "Add selected tags for all selected objects").getButton();
        addTagsButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        addTagsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                for (J3DInstance object : gui.getSelected()) {
                    if (!TagListGroup.this.isTaggable(object)) continue;
                    gui.getTagger().addTags(object, TagListGroup.this.getList(0).getSelection());
                    if (object instanceof J3DTexturedObject) {
                        TagListGroup.this.updateTextures((J3DTexturedObject)object, gui);
                    }
                    gui.getHistory().changed(object, J3DHistory.Part.TAGS);
                }
            }
        });
        Label removeTagsButton = new IconButton(getSetRmButtons, true, Icons.getSWTImage(parent.getDisplay(), "stop.png"), Icons.getSWTImage(parent.getDisplay(), "stop_focus.png"), Icons.getSWTImage(parent.getDisplay(), "stop_pressed.png"), "Remove selected tags from all selected objects").getButton();
        removeTagsButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        removeTagsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                for (J3DInstance object : gui.getSelected()) {
                    if (!TagListGroup.this.isTaggable(object)) continue;
                    gui.getTagger().removeTags(object, TagListGroup.this.getList(0).getSelection());
                    if (object instanceof J3DTexturedObject) {
                        TagListGroup.this.updateTextures((J3DTexturedObject)object, gui);
                    }
                    gui.getHistory().changed(object, J3DHistory.Part.TAGS);
                }
            }
        });
        SWTUtils.space(this.getGroup());
        Composite addDelButtons = new Composite(this.getGroup(), 0);
        addDelButtons.setLayout(SWTUtils.gridLayout(3, false, 0, 0, 0, 0, 0, 0, 5, 0));
        addDelButtons.setLayoutData(SWTUtils.gridData(4, 1, 0, 0, -1, -1, true, false));
        SWTUtils.space(this.getGroup());
        Label createTagsButton = new IconButton(addDelButtons, true, Icons.getSWTImage(parent.getDisplay(), "add.png"), Icons.getSWTImage(parent.getDisplay(), "add_focus.png"), Icons.getSWTImage(parent.getDisplay(), "add_pressed.png"), "Create a new tag (enter a name for that tag before)").getButton();
        createTagsButton.setLayoutData(SWTUtils.gridData(1, 2, 0, 0, -1, -1, false, false));
        final Text newTagName = new Text(addDelButtons, 2048);
        newTagName.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, true, false));
        createTagsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                String tag = newTagName.getText().trim();
                if (tag.length() > 0 && !gui.getTagger().getTags().contains(tag)) {
                    gui.getTagger().addTag(tag);
                    String[] tags = gui.getTagger().getSortedTags().toArray(new String[gui.getTagger().getTags().size()]);
                    TagListGroup.this.setContent(0, tags);
                    TagListGroup.this.setContent(1, tags);
                } else {
                    gui.showGeneralError(new Exception("Tag must not exist and must not be empty!"));
                }
            }
        });
        Label deleteTagsButton = new IconButton(addDelButtons, true, Icons.getSWTImage(parent.getDisplay(), "delete.png"), Icons.getSWTImage(parent.getDisplay(), "delete_focus.png"), Icons.getSWTImage(parent.getDisplay(), "delete_pressed.png"), "Delete tags (will be removed from all objects!)").getButton();
        deleteTagsButton.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, -1, -1, false, false));
        deleteTagsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                String[] stringArray = TagListGroup.this.getList(0).getSelection();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String tag = stringArray[n2];
                    gui.getTagger().removeTag(tag);
                    ++n2;
                }
                String[] tags = gui.getTagger().getSortedTags().toArray(new String[gui.getTagger().getTags().size()]);
                TagListGroup.this.setContent(0, tags);
                TagListGroup.this.setContent(1, tags);
            }
        });
        SWTUtils.space(this.getGroup());
        Composite selectButtons = new Composite(this.getGroup(), 0);
        selectButtons.setLayout(SWTUtils.gridLayout(5, true, 0, 0, 0, 0, 0, 0, 5, 0));
        selectButtons.setLayoutData(SWTUtils.gridData(2, 1, 0, 0, -1, -1, true, false));
        SWTUtils.space(this.getGroup());
        final ToggleButton andButton = new ToggleButton(selectButtons, true, Icons.getSWTImage(parent.getDisplay(), "and.png"), Icons.getSWTImage(parent.getDisplay(), "and_focus.png"), Icons.getSWTImage(parent.getDisplay(), "and_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "and_pressed_focus.png"), "AND-mode: Select all object having ALL the selected tags", true);
        andButton.getButton().setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        final ToggleButton orButton = new ToggleButton(selectButtons, true, Icons.getSWTImage(parent.getDisplay(), "or.png"), Icons.getSWTImage(parent.getDisplay(), "or_focus.png"), Icons.getSWTImage(parent.getDisplay(), "or_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "or_pressed_focus.png"), "OR-mode: Select all object having ANY of the selected tags", false);
        orButton.getButton().setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        Composite separator = new Composite(selectButtons, 0);
        separator.setLayoutData(SWTUtils.gridData(2, 1, 0, 0, 24, 1, false, false));
        Label selectAllTagsButton = new IconButton(selectButtons, true, Icons.getSWTImage(parent.getDisplay(), "all.png"), Icons.getSWTImage(parent.getDisplay(), "all_focus.png"), Icons.getSWTImage(parent.getDisplay(), "all_pressed.png"), "Select all objects").getButton();
        selectAllTagsButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        selectAllTagsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                TagListGroup.this.getList(1).setSelection(0, TagListGroup.this.getList(1).getItemCount() - 1);
                gui.selectAll();
            }
        });
        Label deselectAllTagsButton = new IconButton(selectButtons, true, Icons.getSWTImage(parent.getDisplay(), "none.png"), Icons.getSWTImage(parent.getDisplay(), "none_focus.png"), Icons.getSWTImage(parent.getDisplay(), "none_pressed.png"), "Deselect all selected objects").getButton();
        deselectAllTagsButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        deselectAllTagsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                TagListGroup.this.getList(1).deselect(0, TagListGroup.this.getList(1).getItemCount() - 1);
                gui.clearSelection();
            }
        });
        final SelectionListener selectionListListener = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent event) {
            }

            @Override
            public void widgetSelected(SelectionEvent event) {
                J3DCanvas.Lock lock = gui.getCanvas().lock();
                try {
                    gui.clearSelection();
                    String[] tags = TagListGroup.this.getList(1).getSelection();
                    if (orButton.isOn()) {
                        for (J3DInstance sel : gui.getTagger().getObjectsWithAnyTag(tags)) {
                            gui.select(sel);
                        }
                    } else {
                        for (J3DInstance sel : gui.getTagger().getObjectsWithAllTags(tags)) {
                            gui.select(sel);
                        }
                    }
                }
                finally {
                    gui.getCanvas().unlock(lock);
                }
            }
        };
        this.getList(1).addSelectionListener(selectionListListener);
        MouseAdapter andOrListener = new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                selectionListListener.widgetSelected(null);
                if (e.widget == orButton.getButton()) {
                    andButton.set(!orButton.isOn());
                } else if (e.widget == andButton.getButton()) {
                    orButton.set(!andButton.isOn());
                }
            }
        };
        orButton.getButton().addMouseListener(andOrListener);
        andButton.getButton().addMouseListener(andOrListener);
    }

    private void updateTextures(J3DTexturedObject object, J3DEditorGUI gui) {
        Set<String> tags = gui.getTagger().getTags(object);
        object.setTexture((Texture2D)(tags.contains("_FRONT") ? gui.getTexture(0) : (tags.contains("_BACK") ? gui.getTexture(3) : null)), 1);
        object.setTexture((Texture2D)(tags.contains("_LEFT") ? gui.getTexture(2) : (tags.contains("_RIGHT") ? gui.getTexture(5) : null)), 3);
        object.setTexture((Texture2D)(tags.contains("_TOP") ? gui.getTexture(1) : (tags.contains("_BOTTOM") ? gui.getTexture(4) : null)), 2);
    }

    private boolean isTaggable(Object object) {
        return object instanceof J3DSurface || object instanceof J3DNeedle || object instanceof J3DPoint;
    }
}

