/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.special;

import e3d.bezier.Needle;
import e3d.bezier.Position;
import e3d.euclidean.E3DVector;
import e3d.gui.J3DEditorGUI;
import e3d.gui.groups.special.ShapeTemplateGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.j3d.J3DCanvas;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DPoint;
import e3d.utils.ArrayFactory;
import e3d.utils.MathUtils;
import e3d.visualization.util.Matrix2D;
import javax.vecmath.Color3f;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RectangleTemplateGroup
extends ShapeTemplateGroup {
    public RectangleTemplateGroup(final J3DEditorGUI gui, Composite parent) {
        super(gui, parent, "Rectangle", 9);
        Label icon = new Label(this.group, 0x1000000);
        icon.setImage(Icons.getSWTImage(parent.getDisplay(), "rectangle_big.png"));
        icon.setToolTipText("Create a rectangle of n x m bezier surfaces");
        icon.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, false, false));
        ((GridData)icon.getLayoutData()).verticalSpan = 2;
        Label labelX = new Label(this.group, 0x1000000);
        labelX.setImage(Icons.getSWTImage(parent.getDisplay(), "x_focus.png"));
        labelX.setToolTipText("X-position (left)");
        labelX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelY = new Label(this.group, 0x1000000);
        labelY.setImage(Icons.getSWTImage(parent.getDisplay(), "y_focus.png"));
        labelY.setToolTipText("Y-position (top)");
        labelY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelZ = new Label(this.group, 0x1000000);
        labelZ.setImage(Icons.getSWTImage(parent.getDisplay(), "z_focus.png"));
        labelZ.setToolTipText("Z-position");
        labelZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelWidth = new Label(this.group, 0x1000000);
        labelWidth.setImage(Icons.getSWTImage(parent.getDisplay(), "width_focus.png"));
        labelWidth.setToolTipText("Width");
        labelWidth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelHeight = new Label(this.group, 0x1000000);
        labelHeight.setImage(Icons.getSWTImage(parent.getDisplay(), "height_focus.png"));
        labelHeight.setToolTipText("Height");
        labelHeight.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelCols = new Label(this.group, 0x1000000);
        labelCols.setImage(Icons.getSWTImage(parent.getDisplay(), "cols_focus.png"));
        labelCols.setToolTipText("Number of Columns");
        labelCols.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelRows = new Label(this.group, 0x1000000);
        labelRows.setImage(Icons.getSWTImage(parent.getDisplay(), "rows_focus.png"));
        labelRows.setToolTipText("Number of Rows");
        labelRows.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Composite empty = new Composite(this.group, 0);
        empty.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, 1, false, false));
        final Text textX = new Text(this.group, 2048);
        textX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textY = new Text(this.group, 2048);
        textY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textZ = new Text(this.group, 2048);
        textZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textWidth = new Text(this.group, 2048);
        textWidth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textHeight = new Text(this.group, 2048);
        textHeight.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textCols = new Text(this.group, 2048);
        textCols.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textRows = new Text(this.group, 2048);
        textRows.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label create = new IconButton(this.group, true, Icons.getSWTImage(this.group.getDisplay(), "start.png"), Icons.getSWTImage(this.group.getDisplay(), "start_focus.png"), Icons.getSWTImage(this.group.getDisplay(), "start_pressed.png"), "Create").getButton();
        create.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, 35, -1, true, false));
        create.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }

            @Override
            public void mouseDown(MouseEvent e) {
                try {
                    E3DVector upperLeft = new E3DVector(Double.parseDouble(textX.getText()), Double.parseDouble(textY.getText()), Double.parseDouble(textZ.getText()));
                    double width = Double.parseDouble(textWidth.getText());
                    double height = Double.parseDouble(textHeight.getText());
                    int cols = Integer.parseInt(textCols.getText());
                    int rows = Integer.parseInt(textRows.getText());
                    switch (RectangleTemplateGroup.this.shapeType) {
                        case BEZIER: {
                            RectangleTemplateGroup.this.createNeedleRectangle(upperLeft, width, height, cols, rows);
                            break;
                        }
                        case MESH: {
                            RectangleTemplateGroup.this.createMeshRectangle(upperLeft, width, height, cols, rows);
                        }
                    }
                }
                catch (RuntimeException exception) {
                    gui.showGeneralError(exception);
                }
            }

            @Override
            public void mouseUp(MouseEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNeedleRectangle(E3DVector upperLeft, double width, double height, int columns, int rows) {
        J3DCanvas j3DCanvas = this.gui.getCanvas();
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.gui.getCanvas().lock();
            try {
                Matrix2D<J3DNeedle> needles = new Matrix2D<J3DNeedle>(columns, rows, ArrayFactory.J3DNEEDLE, null);
                int j = 0;
                while (j < rows) {
                    double y = MathUtils.div0(j, rows - 1) * height + upperLeft.y;
                    int i = 0;
                    while (i < columns) {
                        double x = MathUtils.div0(i, columns - 1) * width + upperLeft.x;
                        needles.set(i, j, this.gui.createNeedle(new Needle(new Position(x, y, upperLeft.z), new E3DVector(0.0, 0.0, 1.0)), null, true));
                        ++i;
                    }
                    ++j;
                }
                this.gui.createNeedleMesh(needles, new Color3f(1.0f, 1.0f, 1.0f), null, null, 1.0, null, true);
            }
            finally {
                this.gui.getHistory().next();
                this.gui.getCanvas().unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMeshRectangle(E3DVector upperLeft, double width, double height, int columns, int rows) {
        J3DCanvas j3DCanvas = this.gui.getCanvas();
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.gui.getCanvas().lock();
            try {
                Matrix2D<J3DPoint> points = new Matrix2D<J3DPoint>(columns, rows, ArrayFactory.J3DPOINT, null);
                int j = 0;
                while (j < rows) {
                    double y = MathUtils.div0(j, rows - 1) * height + upperLeft.y;
                    int i = 0;
                    while (i < columns) {
                        double x = MathUtils.div0(i, columns - 1) * width + upperLeft.x;
                        Position position = new Position(x, y, upperLeft.z);
                        J3DPoint point = this.gui.createPoint(position, null, true);
                        points.set(i, j, point);
                        ++i;
                    }
                    ++j;
                }
                this.gui.createPointMesh(points, new Color3f(1.0f, 1.0f, 1.0f), null, null, 1.0, null, true);
            }
            finally {
                this.gui.getHistory().next();
                this.gui.getCanvas().unlock(lock);
            }
        }
    }
}

