/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.special;

import e3d.fractal.FractalColorizer;
import e3d.fractal.FractalEstimator;
import e3d.fractal.FractalType;
import e3d.fractal.MyQuaternion;
import e3d.gui.groups.ComboGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class FractalTypeComboGroup
extends ComboGroup {
    public static final int FIELD_TYPE = 0;
    protected final Combo fractalTypeCombo;
    protected final Combo estimatorTypeCombo;
    protected final Combo multiplicatorTypeCombo;
    protected final Combo summarizerTypeCombo;
    protected final Combo colorizerTypeCombo;
    protected final Combo solidTypeCombo;
    protected final Map<String, FractalEstimator> estimators = new HashMap<String, FractalEstimator>();
    protected final Map<String, MyQuaternion.QuaternionMultiplicator> multiplicators = new HashMap<String, MyQuaternion.QuaternionMultiplicator>();
    protected final Map<String, MyQuaternion.QuaternionSummarizer> summarizers = new HashMap<String, MyQuaternion.QuaternionSummarizer>();
    protected final Map<String, FractalColorizer> colorizers = new HashMap<String, FractalColorizer>();
    protected FractalType type = FractalType.JULIA;
    protected FractalEstimator estimator = FractalEstimator.FORWARD_GRADIENT_ESTIMATOR_ALL_JULIA;
    protected MyQuaternion.QuaternionMultiplicator multiplicator = MyQuaternion.QuaternionMultiplicator.DEFAULT;
    protected MyQuaternion.QuaternionSummarizer summarizer = MyQuaternion.QuaternionSummarizer.DEFAULT;
    protected FractalColorizer colorizer = FractalColorizer.FIXED_COLORIZER;
    protected boolean solid = true;

    public FractalTypeComboGroup(Composite parent, String name, int labelWidth) {
        super(parent, name);
        Field field;
        ((GridData)this.group.getLayoutData()).widthHint = 200;
        this.fractalTypeCombo = this.dropDownList("Type:", labelWidth);
        this.fractalTypeCombo.setItems(new String[]{"Julia", "Mandelbrot"});
        this.fractalTypeCombo.addSelectionListener(new SelectionListener(){

            private void selected() {
                if (FractalTypeComboGroup.this.fractalTypeCombo.getText().equals(FractalTypeComboGroup.this.fractalTypeCombo.getItem(0))) {
                    FractalTypeComboGroup.this.type = FractalType.JULIA;
                } else if (FractalTypeComboGroup.this.fractalTypeCombo.getText().equals(FractalTypeComboGroup.this.fractalTypeCombo.getItem(1))) {
                    FractalTypeComboGroup.this.type = FractalType.MANDELBROT;
                } else {
                    throw new RuntimeException("Unknown fractal type");
                }
                FractalTypeComboGroup.this.setChanged(true);
                for (WidgetGroupEditedListener listener : FractalTypeComboGroup.this.listeners) {
                    listener.edited(FractalTypeComboGroup.this.getThis(), 0, 0);
                    listener.finished(FractalTypeComboGroup.this.getThis(), 0, 0);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }
        });
        this.fractalTypeCombo.select(0);
        this.type = FractalType.JULIA;
        this.estimatorTypeCombo = this.dropDownList("Iterator:", labelWidth);
        Field[] fieldArray = FractalEstimator.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            try {
                FractalEstimator estimator = (FractalEstimator)field.get(null);
                this.estimators.put(estimator.getName(), estimator);
                this.estimatorTypeCombo.add(estimator.getName());
            }
            catch (ClassCastException estimator) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        this.estimatorTypeCombo.select(0);
        this.estimator = this.estimators.get(this.estimatorTypeCombo.getText());
        this.estimatorTypeCombo.addSelectionListener(new SelectionListener(){

            private void selected() {
                FractalTypeComboGroup.this.estimator = FractalTypeComboGroup.this.estimators.get(FractalTypeComboGroup.this.estimatorTypeCombo.getText());
                FractalTypeComboGroup.this.setChanged(true);
                for (WidgetGroupEditedListener listener : FractalTypeComboGroup.this.listeners) {
                    listener.edited(FractalTypeComboGroup.this.getThis(), 1, 0);
                    listener.finished(FractalTypeComboGroup.this.getThis(), 1, 0);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }
        });
        this.multiplicatorTypeCombo = this.dropDownList("x Operator:", labelWidth);
        fieldArray = MyQuaternion.QuaternionMultiplicator.class.getFields();
        n = fieldArray.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            try {
                MyQuaternion.QuaternionMultiplicator multiplicator = (MyQuaternion.QuaternionMultiplicator)field.get(null);
                this.multiplicators.put(multiplicator.getName(), multiplicator);
                this.multiplicatorTypeCombo.add(multiplicator.getName());
            }
            catch (ClassCastException multiplicator) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        this.multiplicatorTypeCombo.select(0);
        this.multiplicator = this.multiplicators.get(this.multiplicatorTypeCombo.getText());
        this.multiplicatorTypeCombo.addSelectionListener(new SelectionListener(){

            private void selected() {
                FractalTypeComboGroup.this.multiplicator = FractalTypeComboGroup.this.multiplicators.get(FractalTypeComboGroup.this.multiplicatorTypeCombo.getText());
                FractalTypeComboGroup.this.setChanged(true);
                for (WidgetGroupEditedListener listener : FractalTypeComboGroup.this.listeners) {
                    listener.edited(FractalTypeComboGroup.this.getThis(), 2, 0);
                    listener.finished(FractalTypeComboGroup.this.getThis(), 2, 0);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }
        });
        this.summarizerTypeCombo = this.dropDownList("+ Operator:", labelWidth);
        fieldArray = MyQuaternion.QuaternionSummarizer.class.getFields();
        n = fieldArray.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            try {
                MyQuaternion.QuaternionSummarizer summarizer = (MyQuaternion.QuaternionSummarizer)field.get(null);
                this.summarizers.put(summarizer.getName(), summarizer);
                this.summarizerTypeCombo.add(summarizer.getName());
            }
            catch (ClassCastException summarizer) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        this.summarizerTypeCombo.select(0);
        this.summarizer = this.summarizers.get(this.summarizerTypeCombo.getText());
        this.summarizerTypeCombo.addSelectionListener(new SelectionListener(){

            private void selected() {
                FractalTypeComboGroup.this.summarizer = FractalTypeComboGroup.this.summarizers.get(FractalTypeComboGroup.this.summarizerTypeCombo.getText());
                FractalTypeComboGroup.this.setChanged(true);
                for (WidgetGroupEditedListener listener : FractalTypeComboGroup.this.listeners) {
                    listener.edited(FractalTypeComboGroup.this.getThis(), 3, 0);
                    listener.finished(FractalTypeComboGroup.this.getThis(), 3, 0);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }
        });
        this.colorizerTypeCombo = this.dropDownList("Color:", labelWidth);
        fieldArray = FractalColorizer.class.getFields();
        n = fieldArray.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            try {
                FractalColorizer colorizer = (FractalColorizer)field.get(null);
                this.colorizers.put(colorizer.getName(), colorizer);
                this.colorizerTypeCombo.add(colorizer.getName());
            }
            catch (ClassCastException colorizer) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        this.colorizerTypeCombo.select(0);
        this.colorizer = this.colorizers.get(this.colorizerTypeCombo.getText());
        this.colorizerTypeCombo.addSelectionListener(new SelectionListener(){

            private void selected() {
                FractalTypeComboGroup.this.colorizer = FractalTypeComboGroup.this.colorizers.get(FractalTypeComboGroup.this.colorizerTypeCombo.getText());
                FractalTypeComboGroup.this.setChanged(true);
                for (WidgetGroupEditedListener listener : FractalTypeComboGroup.this.listeners) {
                    listener.edited(FractalTypeComboGroup.this.getThis(), 4, 0);
                    listener.finished(FractalTypeComboGroup.this.getThis(), 4, 0);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }
        });
        this.solidTypeCombo = this.dropDownList("Solid:", labelWidth);
        this.solidTypeCombo.setItems(new String[]{"Solid", "Cavernous"});
        this.solidTypeCombo.addSelectionListener(new SelectionListener(){

            private void selected() {
                if (FractalTypeComboGroup.this.solidTypeCombo.getText().equals(FractalTypeComboGroup.this.solidTypeCombo.getItem(0))) {
                    FractalTypeComboGroup.this.solid = true;
                } else if (FractalTypeComboGroup.this.solidTypeCombo.getText().equals(FractalTypeComboGroup.this.solidTypeCombo.getItem(1))) {
                    FractalTypeComboGroup.this.solid = false;
                } else {
                    throw new RuntimeException("Unknown type");
                }
                FractalTypeComboGroup.this.setChanged(true);
                for (WidgetGroupEditedListener listener : FractalTypeComboGroup.this.listeners) {
                    listener.edited(FractalTypeComboGroup.this.getThis(), 5, 0);
                    listener.finished(FractalTypeComboGroup.this.getThis(), 5, 0);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }
        });
        this.solidTypeCombo.select(0);
        this.solid = true;
    }

    public FractalType getType() {
        return this.type;
    }

    public FractalEstimator getEstimator() {
        return this.estimator;
    }

    public MyQuaternion.QuaternionMultiplicator getMultiplactor() {
        return this.multiplicator;
    }

    public MyQuaternion.QuaternionSummarizer getSummarizer() {
        return this.summarizer;
    }

    public FractalColorizer getColorizer() {
        return this.colorizer;
    }

    public boolean isSolid() {
        return this.solid;
    }
}

