/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.special;

import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.icons.Icons;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageSWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BrushGroup
extends WidgetGroup {
    protected final IconButton[] buttons = new IconButton[Icons.MASKS.length];
    protected E3DImage mask;
    protected final Color selectedBG;
    protected final Color deselectedBG;

    public BrushGroup(Composite parent) {
        super(parent, "Brushes", 10, true, false);
        Display display = this.group.getDisplay();
        MouseListener listener = new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent event) {
            }

            @Override
            public void mouseDown(MouseEvent event) {
                int index = 0;
                IconButton[] iconButtonArray = BrushGroup.this.buttons;
                int n = BrushGroup.this.buttons.length;
                int n2 = 0;
                while (n2 < n) {
                    IconButton button = iconButtonArray[n2];
                    if (event.widget == button.getButton()) {
                        button.getButton().setBackground(BrushGroup.this.selectedBG);
                        BrushGroup.this.mask = new E3DImageSWT(button.getButton().getImage());
                        for (WidgetGroupEditedListener listener : BrushGroup.this.listeners) {
                            listener.edited(BrushGroup.this.getThis(), index, 0);
                            listener.finished(BrushGroup.this.getThis(), index, 0);
                        }
                    } else {
                        button.getButton().setBackground(BrushGroup.this.deselectedBG);
                    }
                    ++index;
                    ++n2;
                }
            }

            @Override
            public void mouseUp(MouseEvent event) {
            }
        };
        int index = 0;
        while (index < Icons.MASKS.length) {
            Image image = Icons.getSWTImage(display, Icons.MASKS[index]);
            String name = String.valueOf(index < 10 ? "pencil" : "brush") + " (" + image.getImageData().width + "x" + image.getImageData().height + ")";
            IconButton button = new IconButton(this.group, true, image, image, image, name);
            button.getButton().addMouseListener(listener);
            button.getButton().setLayoutData(SWTUtils.gridData(0, 0, 5, 0, 23, 23, false, false));
            this.buttons[index] = button;
            ++index;
        }
        this.selectedBG = display.getSystemColor(7);
        this.deselectedBG = this.buttons[0].getButton().getBackground();
        this.buttons[0].getButton().setBackground(this.selectedBG);
        this.mask = new E3DImageSWT(this.buttons[0].getButton().getImage());
    }

    public E3DImage getMask() {
        return this.mask;
    }
}

