/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.scales.special;

import e3d.gui.groups.scales.HorizontalScaleGroup;
import e3d.gui.groups.scales.ScaleGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.SWTUtils;
import e3d.gui.utils.ToggleButton;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;

public class InterpolationRadiusScaleGroup
extends HorizontalScaleGroup {
    protected final ToggleButton linearButton;
    protected final ToggleButton quadraticButton;
    protected final ToggleButton sigmoidalButton;
    protected final ToggleButton plateauButton;

    public InterpolationRadiusScaleGroup(Composite parent, String name, int radius, int length, boolean fillHorizontal) {
        super(parent, name, new String[]{"Radius of influenced points/needles\naround a moved point/needle"}, Icons.getSWTImages(parent.getDisplay(), "radius_focus.png"), new double[]{radius}, new ScaleGroup.Function[]{ScaleGroup.linear(-1000.0, 1000)}, new int[1], new int[]{1000}, new int[]{256}, new int[]{length}, fillHorizontal);
        Composite buttons = this.getRightGenericSection(0);
        buttons.setLayout(SWTUtils.gridLayout(4, true, 0, 0, 0, 0, 0, 0, 0, 0));
        buttons.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, false, false));
        this.linearButton = new ToggleButton(buttons, true, Icons.getSWTImage(parent.getDisplay(), "linear.png"), Icons.getSWTImage(parent.getDisplay(), "linear_focus.png"), Icons.getSWTImage(parent.getDisplay(), "linear_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "linear_pressed_focus.png"), "Linear interpolation function", true);
        this.linearButton.getButton().setLayoutData(SWTUtils.gridData(2, 3, 0, 0, -1, -1, false, false));
        this.quadraticButton = new ToggleButton(buttons, true, Icons.getSWTImage(parent.getDisplay(), "quadratic.png"), Icons.getSWTImage(parent.getDisplay(), "quadratic_focus.png"), Icons.getSWTImage(parent.getDisplay(), "quadratic_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "quadratic_pressed_focus.png"), "Quadratic interpolation function", false);
        this.quadraticButton.getButton().setLayoutData(SWTUtils.gridData(2, 3, 0, 0, -1, -1, false, false));
        this.sigmoidalButton = new ToggleButton(buttons, true, Icons.getSWTImage(parent.getDisplay(), "sigmoid.png"), Icons.getSWTImage(parent.getDisplay(), "sigmoid_focus.png"), Icons.getSWTImage(parent.getDisplay(), "sigmoid_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "sigmoid_pressed_focus.png"), "Sigmoidal interpolation function", false);
        this.sigmoidalButton.getButton().setLayoutData(SWTUtils.gridData(2, 3, 0, 0, -1, -1, false, false));
        this.plateauButton = new ToggleButton(buttons, true, Icons.getSWTImage(parent.getDisplay(), "plateau.png"), Icons.getSWTImage(parent.getDisplay(), "plateau_focus.png"), Icons.getSWTImage(parent.getDisplay(), "plateau_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "plateau_pressed_focus.png"), "Constant offset interpolation function", false);
        this.plateauButton.getButton().setLayoutData(SWTUtils.gridData(2, 3, 0, 0, -1, -1, false, false));
        this.linearButton.getButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                if (InterpolationRadiusScaleGroup.this.linearButton.isOn()) {
                    InterpolationRadiusScaleGroup.this.quadraticButton.set(false);
                    InterpolationRadiusScaleGroup.this.sigmoidalButton.set(false);
                    InterpolationRadiusScaleGroup.this.plateauButton.set(false);
                } else {
                    InterpolationRadiusScaleGroup.this.linearButton.set(true);
                }
            }
        });
        this.quadraticButton.getButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                if (InterpolationRadiusScaleGroup.this.quadraticButton.isOn()) {
                    InterpolationRadiusScaleGroup.this.linearButton.set(false);
                    InterpolationRadiusScaleGroup.this.sigmoidalButton.set(false);
                    InterpolationRadiusScaleGroup.this.plateauButton.set(false);
                } else {
                    InterpolationRadiusScaleGroup.this.quadraticButton.set(true);
                }
            }
        });
        this.sigmoidalButton.getButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                if (InterpolationRadiusScaleGroup.this.sigmoidalButton.isOn()) {
                    InterpolationRadiusScaleGroup.this.linearButton.set(false);
                    InterpolationRadiusScaleGroup.this.quadraticButton.set(false);
                    InterpolationRadiusScaleGroup.this.plateauButton.set(false);
                } else {
                    InterpolationRadiusScaleGroup.this.sigmoidalButton.set(true);
                }
            }
        });
        this.plateauButton.getButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                if (InterpolationRadiusScaleGroup.this.plateauButton.isOn()) {
                    InterpolationRadiusScaleGroup.this.linearButton.set(false);
                    InterpolationRadiusScaleGroup.this.quadraticButton.set(false);
                    InterpolationRadiusScaleGroup.this.sigmoidalButton.set(false);
                } else {
                    InterpolationRadiusScaleGroup.this.plateauButton.set(true);
                }
            }
        });
    }

    public double getRadius() {
        return this.getValue(0);
    }

    public void setRadius(double radius) {
        this.setValue(0, radius);
    }

    public Function getFunction() {
        return this.quadraticButton.isOn() ? Function.QUADRATIC : (this.sigmoidalButton.isOn() ? Function.SIGMOIDAL : (this.plateauButton.isOn() ? Function.PLATEAU : Function.LINEAR));
    }

    public static enum Function {
        LINEAR,
        QUADRATIC,
        SIGMOIDAL,
        PLATEAU;

    }
}

