/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.scales.special;

import e3d.gui.groups.scales.ScaleGroup;
import e3d.gui.groups.scales.VerticalScaleGroup;
import e3d.gui.icons.Icons;
import org.eclipse.swt.widgets.Composite;

public class BezierScaleGroup
extends VerticalScaleGroup {
    public BezierScaleGroup(Composite parent, String name, double factor, double density, double scale, int bezResolution, int minSplits, int maxSplits, int maxDensity, int maxScale, int maxBezResolution, int maxMinSplits, int maxMaxSplits, int length, boolean fillVertical) {
        super(parent, name, new String[]{"Density (number of mesh-points per\n1 pixel distance of two bezier-mesh\ndefinition points)", "Scale factor", "Resolution for bezier to point mesh conversion (no conversion is done for values < 2)", "How many times each segment should be split up into 2x2 smaller segments?", "How many times segments connected to \"irregular\" points should be split up?"}, Icons.getSWTImages(parent.getDisplay(), "density_focus.png", "scale_focus.png", "density_focus.png", "split_focus.png", "split_focus.png"), new double[]{density, scale, bezResolution, minSplits, maxSplits}, new ScaleGroup.Function[]{ScaleGroup.linear(-factor, maxDensity), ScaleGroup.linear(-factor, maxScale), ScaleGroup.linear(-1.0, maxBezResolution), ScaleGroup.linear(-1.0, maxMinSplits), ScaleGroup.linear(-1.0, maxMaxSplits)}, new int[5], new int[]{maxDensity, maxScale, maxBezResolution - 1, maxMinSplits, maxMaxSplits}, new int[]{512, 512, 512, 512, 512}, new int[]{length, length, length, length, length}, fillVertical);
    }

    public double getDensity() {
        return this.getValue(0);
    }

    public double getScaleFactor() {
        return this.getValue(1);
    }

    public int getBezierResolution() {
        return (int)this.getValue(2);
    }

    public int getMinSplits() {
        return (int)this.getValue(3);
    }

    public int getMaxSplits() {
        return (int)this.getValue(4);
    }
}

