/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.scales;

import e3d.gui.groups.scales.ScaleGroup;
import e3d.gui.groups.scales.VerticalScaleGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.SWTUtils;
import e3d.visualization.util.E3DColor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ColorScaleGroup
extends VerticalScaleGroup {
    final Composite coloredComposite;

    public ColorScaleGroup(Composite parent, String name, int red, int green, int blue, int alpha, int length, boolean fillVertical) {
        super(parent, name, new String[]{"red", "green", "blue", "alpha"}, Icons.getSWTImages(parent.getDisplay(), "red_focus.png", "green_focus.png", "blue_focus.png", "alpha_focus.png"), new double[]{red, green, blue, alpha}, new ScaleGroup.Function[]{ScaleGroup.linear(-1.0, 255), ScaleGroup.linear(-1.0, 255), ScaleGroup.linear(-1.0, 255), ScaleGroup.linear(-1.0, 255)}, new int[4], new int[]{255, 255, 255, 255}, new int[]{512, 512, 512, 512}, new int[]{length, length, length, length}, fillVertical);
        Display display = parent.getDisplay();
        this.coloredComposite = new Composite(this.group, 0);
        this.coloredComposite.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, 20, true, false));
        this.coloredComposite.setBackground(new Color(display, (int)this.getValue(0), (int)this.getValue(1), (int)this.getValue(2)));
        ((GridData)this.coloredComposite.getLayoutData()).horizontalSpan = 4;
        SelectionListener colorListener = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                ColorScaleGroup.this.updateColor();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                ColorScaleGroup.this.updateColor();
            }
        };
        this.scales[0].addSelectionListener(colorListener);
        this.scales[1].addSelectionListener(colorListener);
        this.scales[2].addSelectionListener(colorListener);
        this.scales[3].addSelectionListener(colorListener);
        this.texts[0].addSelectionListener(colorListener);
        this.texts[1].addSelectionListener(colorListener);
        this.texts[2].addSelectionListener(colorListener);
        this.texts[3].addSelectionListener(colorListener);
    }

    public int getRed() {
        return (int)this.getValue(0);
    }

    public int getGreen() {
        return (int)this.getValue(1);
    }

    public int getBlue() {
        return (int)this.getValue(2);
    }

    public void setAlpha(int alpha) {
        this.setValue(3, alpha);
    }

    public int getAlpha() {
        return (int)this.getValue(3);
    }

    public void setColor(int red, int green, int blue) {
        super.setValue(0, red);
        super.setValue(1, green);
        super.setValue(2, blue);
        this.updateColor();
    }

    public Integer getColor() {
        return E3DColor.rgb(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    private void updateColor() {
        Color oldColor = this.coloredComposite.getBackground();
        this.coloredComposite.setBackground(new Color(this.coloredComposite.getDisplay(), (int)this.getValue(0), (int)this.getValue(1), (int)this.getValue(2)));
        if (oldColor != null) {
            oldColor.dispose();
        }
        this.coloredComposite.update();
    }
}

