/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups;

import e3d.gui.groups.WidgetGroupEditedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class WidgetGroup {
    private static final int BORDER_MARGIN = System.getProperty("os.name").contains("Windows") ? 0 : 2;
    private static final int TOP_MARGIN = BORDER_MARGIN + 10;
    protected final Group group;
    protected boolean changed = true;
    protected final List<WidgetGroupEditedListener> listeners = new CopyOnWriteArrayList<WidgetGroupEditedListener>();

    public WidgetGroup(Composite parent, String name, int columns, boolean fillHorizontal, boolean fillVertical) {
        this.group = new Group(parent, 0);
        GridData groupGridData = new GridData();
        groupGridData.horizontalAlignment = fillHorizontal ? 4 : 1;
        groupGridData.verticalAlignment = fillVertical ? 4 : 1;
        groupGridData.horizontalIndent = 0;
        groupGridData.verticalIndent = 0;
        groupGridData.grabExcessHorizontalSpace = fillHorizontal;
        groupGridData.grabExcessVerticalSpace = false;
        this.group.setLayoutData(groupGridData);
        GridLayout groupLayout = new GridLayout(columns, false);
        groupLayout.marginWidth = 0;
        groupLayout.marginLeft = BORDER_MARGIN;
        groupLayout.marginRight = BORDER_MARGIN;
        groupLayout.marginHeight = 0;
        groupLayout.marginTop = TOP_MARGIN;
        groupLayout.marginBottom = BORDER_MARGIN;
        groupLayout.verticalSpacing = 0;
        groupLayout.horizontalSpacing = 0;
        this.group.setLayout(groupLayout);
        this.group.setText(name);
    }

    public void addListener(WidgetGroupEditedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(WidgetGroupEditedListener listener) {
        this.listeners.remove(listener);
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setVisible(boolean visible) {
        this.group.setVisible(visible);
    }

    public boolean isVisible() {
        return this.group.isVisible();
    }

    public void setEnabled(boolean enabled) {
        this.group.setEnabled(enabled);
    }

    protected WidgetGroup getThis() {
        return this;
    }
}

