/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups;

import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.utils.SWTUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class RadioButtonGroup
extends WidgetGroup {
    public static final int FIELD_CHECK = 0;
    protected final Label[] labels;
    protected final Button[] radioButtons;
    protected int selected;

    public RadioButtonGroup(Composite parent, String name, String[] labels, String[] toolTips, int selectedIndex, int labelWidth, boolean fillHorizontal, boolean fillVertical) {
        super(parent, name, 2, fillHorizontal, fillVertical);
        this.radioButtons = new Button[labels.length];
        this.labels = new Label[labels.length];
        this.selected = selectedIndex;
        int index = 0;
        while (index < labels.length) {
            final int i = index;
            this.radioButtons[index] = new Button(this.group, 16);
            this.radioButtons[index].setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
            this.radioButtons[index].setSelection(index == this.selected);
            this.labels[index] = new Label(this.group, 16384);
            this.labels[index].setLayoutData(SWTUtils.gridData(1, 2, 5, 0, labelWidth, -1, false, false));
            this.labels[index].setText(labels[index]);
            this.labels[index].setToolTipText(toolTips[index]);
            this.radioButtons[index].addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent event) {
                }

                @Override
                public void widgetSelected(SelectionEvent event) {
                    RadioButtonGroup.this.select(i);
                }
            });
            this.labels[index].addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                }

                @Override
                public void mouseUp(MouseEvent e) {
                    RadioButtonGroup.this.select(i);
                }
            });
            ++index;
        }
    }

    protected void select(int index) {
        this.selected = index;
        int j = 0;
        while (j < this.radioButtons.length) {
            this.radioButtons[j].setSelection(this.selected == j);
            ++j;
        }
        this.setChanged(true);
        for (WidgetGroupEditedListener listener : this.listeners) {
            listener.edited(this.getThis(), index, 0);
            listener.finished(this.getThis(), index, 0);
        }
    }

    public void addSelectionListener(int index, final SelectionListener listener) {
        this.radioButtons[index].addSelectionListener(listener);
        this.labels[index].addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent event) {
            }

            @Override
            public void mouseDown(MouseEvent event) {
            }

            @Override
            public void mouseUp(MouseEvent event) {
                listener.widgetSelected(null);
            }
        });
    }

    public int getSelected() {
        return this.selected;
    }

    public Button getRadioButton(int index) {
        return this.radioButtons[index];
    }
}

