/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups;

import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.icons.Icons;
import e3d.gui.utils.E3DFileDialog;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.visualization.image.E3DImageSWT;
import java.io.File;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ImageGroup
extends WidgetGroup {
    public static final int FIELD_ENABLED = 0;
    public static final int FIELD_IMAGEFILE = 1;
    protected final Label[] buttons;
    protected final Composite[] leftGenericSections;
    protected final Composite[] rightGenericSections;
    protected final Text[] texts;
    protected final E3DImageSWT[][] images;
    protected final E3DImageSWT[][] lastImages;
    protected final boolean[] checked;
    protected final Button[] checkButtons;

    public ImageGroup(final Composite parent, String name, String[] labels, String[] toolTips, final File[][] files, final String[][] filterNames, final String[][] extensions, final Boolean[] read, final Boolean[] multi, Boolean[] enabled, int labelWidth, int textWidth) {
        super(parent, name, 6, true, false);
        this.images = new E3DImageSWT[files.length][];
        this.lastImages = new E3DImageSWT[files.length][];
        this.checked = new boolean[files.length];
        this.buttons = new Label[files.length];
        this.checkButtons = new Button[files.length];
        this.texts = new Text[files.length];
        this.leftGenericSections = new Composite[files.length];
        this.rightGenericSections = new Composite[files.length];
        Display display = parent.getDisplay();
        int index = 0;
        while (index < this.images.length) {
            final int i = index;
            this.lastImages[index] = this.images[index];
            this.leftGenericSections[index] = SWTUtils.space(this.group);
            boolean enable = true;
            if (enabled[index] != null) {
                enable = enabled[index];
                this.checkButtons[index] = new Button(this.group, 32);
                this.checkButtons[index].setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
                this.checkButtons[index].setSelection(enable);
                this.checked[index] = enable;
                this.checkButtons[index].addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        ImageGroup.this.buttons[i].setEnabled(ImageGroup.this.checkButtons[i].getSelection());
                        ImageGroup.this.texts[i].update();
                        ImageGroup.this.buttons[i].update();
                        ImageGroup.this.checkButtons[i].update();
                        if (ImageGroup.this.checkButtons[i].getSelection()) {
                            ImageGroup.this.images[i] = ImageGroup.this.lastImages[i];
                            ImageGroup.this.checked[i] = true;
                        } else {
                            ImageGroup.this.lastImages[i] = ImageGroup.this.images[i];
                            ImageGroup.this.images[i] = null;
                            ImageGroup.this.checked[i] = false;
                        }
                        for (WidgetGroupEditedListener listener : ImageGroup.this.listeners) {
                            listener.edited(ImageGroup.this.getThis(), i, 0);
                            listener.finished(ImageGroup.this.getThis(), i, 0);
                        }
                    }
                });
            } else {
                Composite placeHolder = new Composite(this.group, 0);
                placeHolder.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, 1, 1, false, false));
            }
            Label itemLabel = new Label(this.group, 131072);
            itemLabel.setLayoutData(SWTUtils.gridData(3, 2, 5, 0, labelWidth, -1, false, false));
            itemLabel.setText(labels[index]);
            if (toolTips[index] != null) {
                itemLabel.setToolTipText(toolTips[index]);
            }
            this.texts[index] = new Text(this.group, 0x1000800);
            this.texts[index].setLayoutData(SWTUtils.gridData(4, 2, 5, 0, textWidth, -1, true, false));
            this.texts[index].setEnabled(false);
            this.setImages(index, files[index]);
            this.setText(index, files[index]);
            this.buttons[index] = new IconButton(this.group, true, Icons.getSWTImage(display, "choose.png"), Icons.getSWTImage(display, "choose_focus.png"), Icons.getSWTImage(display, "choose_pressed.png"), "Open File").getButton();
            this.buttons[index].setLayoutData(SWTUtils.gridData(3, 2, 0, 0, -1, -1, false, false));
            this.buttons[index].setEnabled(enable);
            this.buttons[index].addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                    E3DFileDialog dialog = new E3DFileDialog(parent.getShell(), read[i] != false ? "Load" : "Save", (read[i] != false ? 4096 : 8192) | (multi[i] != false ? 2 : 0), files[i], filterNames[i], extensions[i]);
                    File[] selection = dialog.open();
                    if (selection != null) {
                        ImageGroup.this.setImages(i, selection);
                        ImageGroup.this.setText(i, selection);
                        ImageGroup.this.lastImages[i] = ImageGroup.this.images[i];
                        ImageGroup.this.setChanged(true);
                        for (WidgetGroupEditedListener listener : ImageGroup.this.listeners) {
                            listener.edited(ImageGroup.this.getThis(), i, 1);
                            listener.finished(ImageGroup.this.getThis(), i, 1);
                        }
                    }
                    ImageGroup.this.texts[i].update();
                }

                @Override
                public void mouseUp(MouseEvent e) {
                }
            });
            this.rightGenericSections[index] = SWTUtils.space(this.group);
            ++index;
        }
    }

    private void setImages(int index, File[] files) {
        if (files == null) {
            this.images[index] = null;
        } else {
            this.images[index] = new E3DImageSWT[files.length];
            int j = 0;
            while (j < files.length) {
                try {
                    this.images[index][j] = new E3DImageSWT(files[j]);
                }
                catch (Exception exception) {
                    this.images[index][j] = null;
                }
                ++j;
            }
        }
    }

    private void setText(int index, File[] files) {
        this.texts[index].setText("");
        if (files != null) {
            String sep = "";
            int j = 0;
            while (j < files.length) {
                if (this.images[index] == null || this.images[index][j] == null) {
                    this.texts[index].append(String.valueOf(sep) + "[ERROR: " + files[j].getAbsolutePath() + "]");
                } else {
                    this.texts[index].append(String.valueOf(sep) + files[j].getAbsolutePath());
                }
                sep = "; ";
                ++j;
            }
        }
    }

    public E3DImageSWT[] getImages(int index) {
        return this.images[index];
    }

    public E3DImageSWT[] getLastImages(int index) {
        return this.lastImages[index];
    }

    public boolean isChecked(int index) {
        return this.checked[index];
    }

    public void setImages(File[] files, boolean enabled, int index) throws Exception {
        if (this.checkButtons[index] != null) {
            this.checkButtons[index].setSelection(enabled);
            this.checkButtons[index].update();
        }
        this.buttons[index].setEnabled(enabled);
        this.buttons[index].update();
        this.texts[index].update();
        this.setImages(index, files);
        this.setText(index, files);
    }

    public Composite getLeftGenericSection(int index) {
        return this.leftGenericSections[index];
    }

    public Composite getRightGenericSection(int index) {
        return this.rightGenericSections[index];
    }
}

