/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups;

import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.icons.Icons;
import e3d.gui.utils.E3DDirectoryDialog;
import e3d.gui.utils.E3DFileDialog;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FileGroup
extends WidgetGroup {
    public static final int FIELD_ENABLED = 0;
    public static final int FIELD_FILE = 1;
    protected final Label[] buttons;
    protected final Composite[] leftGenericSections;
    protected final Composite[] rightGenericSections;
    protected final Text[] texts;
    protected final File[][] files;
    protected final File[][] lastFiles;
    protected final boolean[] checked;
    protected final Button[] checkButtons;

    public FileGroup(final Composite parent, String name, String[] labels, String[] toolTips, final File[][] files, final String[][] filterNames, final String[][] extensions, final Boolean[] read, final Boolean[] multi, Boolean[] enabled, int labelWidth, int textWidth, boolean fillHorizontal, boolean fillVertical) {
        super(parent, name, 6, fillHorizontal, fillVertical);
        this.files = files;
        this.lastFiles = new File[files.length][];
        this.checked = new boolean[files.length];
        this.buttons = new Label[files.length];
        this.checkButtons = new Button[files.length];
        this.texts = new Text[files.length];
        this.leftGenericSections = new Composite[files.length];
        this.rightGenericSections = new Composite[files.length];
        Display display = parent.getDisplay();
        int index = 0;
        while (index < files.length) {
            final int i = index;
            this.lastFiles[index] = files[index];
            boolean isDir = read[index] == null;
            boolean hasDialog = filterNames[index] != null;
            this.leftGenericSections[index] = SWTUtils.space(this.group);
            boolean enable = true;
            if (enabled[index] != null) {
                enable = enabled[index];
                this.checkButtons[index] = new Button(this.group, 32);
                this.checkButtons[index].setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
                this.checkButtons[index].setSelection(enable);
                this.checked[index] = enable;
                this.checkButtons[index].addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        FileGroup.this.buttons[i].setEnabled(FileGroup.this.checkButtons[i].getSelection());
                        FileGroup.this.texts[i].update();
                        FileGroup.this.buttons[i].update();
                        FileGroup.this.checkButtons[i].update();
                        if (FileGroup.this.checkButtons[i].getSelection()) {
                            files[i] = FileGroup.this.lastFiles[i];
                            FileGroup.this.checked[i] = true;
                        } else {
                            FileGroup.this.lastFiles[i] = files[i];
                            files[i] = null;
                            FileGroup.this.checked[i] = false;
                        }
                        for (WidgetGroupEditedListener listener : FileGroup.this.listeners) {
                            listener.edited(FileGroup.this.getThis(), i, 0);
                            listener.finished(FileGroup.this.getThis(), i, 0);
                        }
                    }
                });
            } else {
                SWTUtils.space(this.group);
            }
            Label itemLabel = new Label(this.group, 131072);
            itemLabel.setLayoutData(SWTUtils.gridData(3, 2, 5, 0, labelWidth, -1, false, false));
            itemLabel.setText(labels[index]);
            if (toolTips[index] != null) {
                itemLabel.setToolTipText(toolTips[index]);
            }
            this.texts[index] = new Text(this.group, 0x1000800);
            this.texts[index].setLayoutData(SWTUtils.gridData(4, 2, 5, 0, textWidth, -1, true, false));
            this.setText(index, files[index]);
            if (!hasDialog) {
                this.buttons[index] = null;
                Composite placeholder = new Composite(this.group, 0);
                placeholder.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, 1, 1, false, false));
                this.texts[index].setEnabled(true);
                this.texts[index].addModifyListener(new ModifyListener(){

                    @Override
                    public void modifyText(ModifyEvent e) {
                        File[] fileArray;
                        String txt = FileGroup.this.texts[i].getText().trim();
                        if (txt.isEmpty()) {
                            fileArray = null;
                        } else {
                            File[] fileArray2 = new File[1];
                            fileArray = fileArray2;
                            fileArray2[0] = new File(txt);
                        }
                        files[i] = fileArray;
                    }
                });
            } else {
                this.texts[index].setEnabled(false);
                this.buttons[index] = new IconButton(this.group, true, Icons.getSWTImage(display, "choose.png"), Icons.getSWTImage(display, "choose_focus.png"), Icons.getSWTImage(display, "choose_pressed.png"), "Open File").getButton();
                this.buttons[index].setLayoutData(SWTUtils.gridData(3, 2, 0, 0, -1, -1, false, false));
                this.buttons[index].setEnabled(enable);
                if (isDir) {
                    this.buttons[index].addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseDown(MouseEvent e) {
                            E3DDirectoryDialog dialog = new E3DDirectoryDialog(parent.getShell(), "Directory", files[i] != null ? files[i][0] : null);
                            File selection = dialog.open();
                            if (selection != null) {
                                File[] sel = new File[]{selection};
                                FileGroup.this.setText(i, sel);
                                files[i] = sel;
                                FileGroup.this.lastFiles[i] = files[i];
                                FileGroup.this.setChanged(true);
                                for (WidgetGroupEditedListener listener : FileGroup.this.listeners) {
                                    listener.edited(FileGroup.this.getThis(), i, 1);
                                    listener.finished(FileGroup.this.getThis(), i, 1);
                                }
                            }
                            FileGroup.this.texts[i].update();
                        }
                    });
                } else {
                    this.buttons[index].addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseDown(MouseEvent e) {
                            E3DFileDialog dialog = new E3DFileDialog(parent.getShell(), read[i] != false ? "Load" : "Save", (read[i] != false ? 4096 : 8192) | (multi[i] != false ? 2 : 0), files[i], filterNames[i], extensions[i]);
                            File[] selection = dialog.open();
                            if (selection != null) {
                                FileGroup.this.setText(i, selection);
                                files[i] = selection;
                                FileGroup.this.lastFiles[i] = files[i];
                                FileGroup.this.setChanged(true);
                                for (WidgetGroupEditedListener listener : FileGroup.this.listeners) {
                                    listener.edited(FileGroup.this.getThis(), i, 1);
                                    listener.finished(FileGroup.this.getThis(), i, 1);
                                }
                            }
                            FileGroup.this.texts[i].update();
                        }
                    });
                }
            }
            this.rightGenericSections[index] = SWTUtils.space(this.group);
            ++index;
        }
    }

    private void setText(int index, File[] files) {
        this.texts[index].setText("");
        if (files != null) {
            String sep = "";
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file != null) {
                    this.texts[index].append(String.valueOf(sep) + file.getAbsolutePath());
                    sep = "; ";
                }
                ++n2;
            }
        }
    }

    public File[] getFiles(int index) {
        return this.files[index];
    }

    public File[] getLastFiles(int index) {
        return this.lastFiles[index];
    }

    public boolean isChecked(int index) {
        return this.checked[index];
    }

    public void setFiles(File[] files, boolean enabled, int index) {
        this.setText(index, files);
        if (this.checkButtons[index] != null) {
            this.checkButtons[index].setSelection(enabled);
            this.checkButtons[index].update();
        }
        this.buttons[index].setEnabled(enabled);
        this.buttons[index].update();
        this.files[index] = enabled ? files : null;
        this.texts[index].update();
    }

    public Composite getLeftGenericSection(int index) {
        return this.leftGenericSections[index];
    }

    public Composite getRightGenericSection(int index) {
        return this.rightGenericSections[index];
    }
}

