/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui;

import e3d.bezier.SurfaceScan;
import e3d.bezier.Surfaces;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DMultiTransformation;
import e3d.euclidean.transformations.E3DRotation;
import e3d.euclidean.transformations.E3DScale;
import e3d.euclidean.transformations.E3DTranslation;
import e3d.gui.SpaceGUI;
import e3d.gui.groups.FileGroup;
import e3d.gui.groups.ImageGroup;
import e3d.gui.groups.RadioButtonGroup;
import e3d.gui.groups.TextGroup;
import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.groups.scales.ColorScaleGroup;
import e3d.gui.groups.scales.ColorShiftScaleGroup;
import e3d.gui.groups.scales.FocusScaleGroup;
import e3d.gui.groups.scales.FontScaleGroup;
import e3d.gui.groups.scales.HSBScaleGroup;
import e3d.gui.groups.scales.SingleHorizontalScaleGroup;
import e3d.gui.groups.scales.SingleVerticalScaleGroup;
import e3d.gui.groups.scales.XYZScaleGroup;
import e3d.gui.groups.scales.ZoomScaleGroup;
import e3d.gui.groups.scales.special.BezierScaleGroup;
import e3d.gui.groups.scales.special.MaterialScaleGroup;
import e3d.gui.groups.special.FontTypeComboGroup;
import e3d.gui.icons.Icons;
import e3d.gui.images.ImageLocator;
import e3d.gui.images.ImageProgress;
import e3d.gui.images.Perspective;
import e3d.gui.images.ScrollableImage;
import e3d.gui.utils.E3DHelp;
import e3d.gui.utils.SWTUtils;
import e3d.typewriter.E3DFont;
import e3d.utils.ArrayUtils;
import e3d.utils.Getter;
import e3d.utils.MathUtils;
import e3d.utils.ProgressListener;
import e3d.visualization.environment.E3DBoxEnvironment;
import e3d.visualization.environment.E3DEnvironment;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageSWT;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TypeWriterGUI
extends SpaceGUI {
    private static final String NAME = "3D Bezier Type Writer (V3.5)";
    private static final String HELP_URI = "help/typewriter/index";
    private static final int IMAGE_DEFAULT_WIDTH = 400;
    private static final int IMAGE_DEFAULT_HEIGHT = 400;
    protected File bezierMeshFile = null;
    protected File bezierImageFile = null;
    protected final ScrollableImage scrollableImage;
    protected final ImageProgress progressListener;
    protected final ImageProgress subProgressListener;
    protected Surfaces surfaces = null;
    protected final XYZScaleGroup rotationScales;
    protected final XYZScaleGroup translationScales;
    protected final TextGroup textGroup;
    protected final FileGroup fontDataGroup;
    protected final FontTypeComboGroup fontTypeComboGroup;
    protected final FontScaleGroup fontScales;
    protected final ColorScaleGroup objectColorScales;
    protected final BezierScaleGroup bezierScales;
    protected final XYZScaleGroup viewScales;
    protected final XYZScaleGroup focusScales;
    protected final SingleVerticalScaleGroup distanceScales;
    protected final XYZScaleGroup lightScales;
    protected final ColorScaleGroup lightColorScales;
    protected final SingleHorizontalScaleGroup ambientShiftScales;
    protected final SingleVerticalScaleGroup ambientScales;
    protected final ColorScaleGroup bgScales;
    protected final HSBScaleGroup hsbScales;
    protected final MaterialScaleGroup materialScales;
    protected final ColorShiftScaleGroup colorShiftScales;
    protected final ColorScaleGroup shiftColorScales;
    protected final FocusScaleGroup focusFilterScales;
    protected final ImageGroup envImageGroup;
    protected final ImageGroup texImageGroup;
    protected final ImageGroup bgImageGroup;
    protected final RadioButtonGroup texPolicyRadioButtons;
    final ZoomScaleGroup zoomScale;
    protected final SingleHorizontalScaleGroup jpgScale;

    public TypeWriterGUI() {
        this.shell.setText(NAME);
        this.extendFileMenu();
        this.extendViewMenu();
        Composite main = new Composite(this.shell, 0);
        main.setLayoutData(new GridData(1808));
        main.setLayout(new GridLayout(2, false));
        this.scrollableImage = new ScrollableImage(main);
        ((GridData)this.scrollableImage.getScroll().getLayoutData()).widthHint = 400;
        ((GridData)this.scrollableImage.getScroll().getLayoutData()).heightHint = 400;
        this.progressListener = new ImageProgress(this.scrollableImage, -36, 1.0);
        this.subProgressListener = new ImageProgress(this.scrollableImage, 37, 0.67);
        Composite controlFrame = new Composite(main, 0);
        controlFrame.setLayout(new GridLayout(1, false));
        controlFrame.setLayoutData(new GridData(4, 4, false, true));
        final TabFolder tabFolder = new TabFolder(controlFrame, 128);
        tabFolder.setLayoutData(new GridData(4, 4, true, true));
        tabFolder.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                tabFolder.update();
            }
        });
        Composite textFrame = new Composite(tabFolder, 0);
        textFrame.setLayout(new GridLayout(2, false));
        textFrame.setLayoutData(new GridData(4, 4, true, true));
        this.textGroup = new TextGroup(textFrame, "Type-Writer", new String[]{"Text:"}, new String[]{""}, 100, 200);
        ((GridData)this.textGroup.getGroup().getLayoutData()).horizontalSpan = 2;
        this.fontDataGroup = new FileGroup(textFrame, "Font", new String[]{"Zip-Archive:"}, new String[1], new File[1][], new String[][]{{"Zip Files", "All Files"}}, new String[][]{{"*.zip;*.ZIP", "*.*"}}, new Boolean[]{true}, new Boolean[]{false}, new Boolean[1], 100, 200, true, false);
        ((GridData)this.fontDataGroup.getGroup().getLayoutData()).horizontalSpan = 2;
        this.fontTypeComboGroup = new FontTypeComboGroup(textFrame, "Font-Type", 100);
        ((GridData)this.fontTypeComboGroup.getGroup().getLayoutData()).horizontalSpan = 2;
        this.texImageGroup = new ImageGroup(textFrame, "Texture Images", new String[]{"Images:"}, new String[1], new File[1][], new String[][]{{"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true}, new Boolean[]{true}, new Boolean[]{false}, 75, 200);
        ((GridData)this.texImageGroup.getGroup().getLayoutData()).horizontalSpan = 2;
        this.texPolicyRadioButtons = new RadioButtonGroup(textFrame, "Texture Choosing Policy", new String[]{"forward", "backward", "random", "split"}, new String[]{"forward", "backward", "random", "split"}, 0, 100, true, false);
        ((GridData)this.texPolicyRadioButtons.getGroup().getLayoutData()).horizontalSpan = 2;
        this.fontScales = new FontScaleGroup(textFrame, "Parameters", 10.0, 2.0, 0.0, 1.0, 5.0, 40, 20, 100, 10, 100, false);
        this.objectColorScales = new ColorScaleGroup(textFrame, "Text-Color", 255, 255, 255, 255, 100, false);
        TabItem textTab = new TabItem(tabFolder, 0);
        textTab.setText("Text");
        textTab.setControl(textFrame);
        Composite bezierFrame = new Composite(tabFolder, 0);
        bezierFrame.setLayout(new GridLayout(2, false));
        bezierFrame.setLayoutData(new GridData(4, 4, true, true));
        this.bezierScales = new BezierScaleGroup(bezierFrame, "Meshes", 10.0, 2.0, 1.0, 1, 0, 0, 50, 5000, 10, 5, 5, 100, false);
        SWTUtils.space(bezierFrame);
        this.rotationScales = new XYZScaleGroup(bezierFrame, "Rotation", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        this.translationScales = new XYZScaleGroup(bezierFrame, "Translation", 10.0, 0.0, 0.0, 0.0, -10, -10, -10, 10, 10, 10, 100, false);
        TabItem bezierTab = new TabItem(tabFolder, 0);
        bezierTab.setText("Bezier");
        bezierTab.setControl(bezierFrame);
        Composite renderingFrame = new Composite(tabFolder, 0);
        renderingFrame.setLayout(new GridLayout(3, false));
        renderingFrame.setLayoutData(new GridData(4, 4, true, true));
        this.viewScales = new XYZScaleGroup(renderingFrame, "Viewer Position", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        Perspective viewPerspective = new Perspective(this.scrollableImage, this.viewScales, new Color(this.display, 192, 255, 129), 1);
        viewPerspective.show();
        this.distanceScales = new SingleVerticalScaleGroup(renderingFrame, "Dist.", "viewer distance", "distance_focus.png", 0.1, 0.0, 0, 100, 100, false);
        this.focusScales = new XYZScaleGroup(renderingFrame, "Focus-Point (offset)", 1.0, 0.0, 0.0, 0.0, -100, -100, -100, 100, 100, 100, 100, false);
        this.lightScales = new XYZScaleGroup(renderingFrame, "Light-Point", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        Perspective lightPerspective = new Perspective(this.scrollableImage, this.lightScales, new Color(this.display, 255, 255, 129), 2);
        lightPerspective.show();
        this.ambientScales = new SingleVerticalScaleGroup(renderingFrame, "Amb.", "Ambient light", "diffusion_focus.png", 10.0, 0.1, 0, 20, 100, false);
        this.lightColorScales = new ColorScaleGroup(renderingFrame, "Light-Color", 255, 255, 255, 255, 100, false);
        ((GridData)this.lightColorScales.getGroup().getLayoutData()).verticalSpan = 2;
        this.ambientShiftScales = new SingleHorizontalScaleGroup(renderingFrame, "Ambient Light Color Shift", "Hue-Shift", "hue_focus.png", 10.0, 0.0, -10, 10, 100, true);
        ((GridData)this.ambientShiftScales.getGroup().getLayoutData()).horizontalSpan = 2;
        Composite envMaterialFrame = new Composite(renderingFrame, 0);
        envMaterialFrame.setLayout(SWTUtils.gridLayout(2, false, 5, 5, 0, 0, 0, 0, 0, 0));
        envMaterialFrame.setLayoutData(SWTUtils.gridData(4, 4, 0, 0, -1, -1, false, false));
        ((GridData)envMaterialFrame.getLayoutData()).horizontalSpan = 3;
        this.materialScales = new MaterialScaleGroup(envMaterialFrame, "Material", 0.5, 0.0, 0.0, 0.0, 100, false);
        this.envImageGroup = new ImageGroup(envMaterialFrame, "Environment Images (sourrounding box)", new String[]{"Front:", "Left:", "Upper:", "Back:", "Right:", "Lower:"}, new String[6], new File[6][], new String[][]{{"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true, true, true, true, true, true}, new Boolean[]{false, false, false, false, false, false}, new Boolean[]{false, false, false, false, false, false}, 50, 150);
        TabItem renderingTab = new TabItem(tabFolder, 0);
        renderingTab.setText("Rendering");
        renderingTab.setControl(renderingFrame);
        Composite filterFrame = new Composite(tabFolder, 0);
        filterFrame.setLayout(new GridLayout(3, false));
        filterFrame.setLayoutData(new GridData(4, 4, true, true));
        this.bgImageGroup = new ImageGroup(filterFrame, "Background Image", new String[]{"Background"}, new String[1], new File[1][], new String[][]{{"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true}, new Boolean[]{false}, new Boolean[]{false}, 75, 200);
        ((GridData)this.bgImageGroup.getGroup().getLayoutData()).horizontalSpan = 3;
        this.bgScales = new ColorScaleGroup(filterFrame, "Background Color", 0, 0, 0, 0, 100, false);
        this.focusFilterScales = new FocusScaleGroup(filterFrame, "Focus", 0.0, 0.0, 100, false);
        this.hsbScales = new HSBScaleGroup(filterFrame, "HSB-Filter", 0.0, 1.0, 1.0, 100, false);
        this.shiftColorScales = new ColorScaleGroup(filterFrame, "Shift Color", 0, 0, 255, 255, 100, false);
        this.colorShiftScales = new ColorShiftScaleGroup(filterFrame, "Shift", 0.0, 0.0, 100, false);
        TabItem filterTab = new TabItem(tabFolder, 0);
        filterTab.setText("Filter");
        filterTab.setControl(filterFrame);
        Composite imageFrame = new Composite(tabFolder, 0);
        imageFrame.setLayout(new GridLayout(2, false));
        imageFrame.setLayoutData(new GridData(4, 4, true, false));
        this.zoomScale = new ZoomScaleGroup(imageFrame, "Zoom", 100.0, true, 100, false);
        this.zoomScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                TypeWriterGUI.this.scrollableImage.setZoom((double)TypeWriterGUI.this.zoomScale.getZoom() / 100.0);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        this.jpgScale = new SingleHorizontalScaleGroup(imageFrame, "JPEG Parameters", "Quality", null, 20.0, 0.9, 10, 20, 100, true);
        TabItem imageTab = new TabItem(tabFolder, 0);
        imageTab.setText("View");
        imageTab.setControl(imageFrame);
        Point size = this.shell.computeSize(-1, -1);
        this.shell.setSize(Math.min(1800, size.x), Math.min(1200, size.y));
        try {
            this.scrollableImage.setE3DImage(Icons.getE3DImageSWT("e3d_persp.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Getter<E3DVector> voxelSizeGetter = new Getter<E3DVector>(){

            @Override
            public E3DVector get() {
                return TypeWriterGUI.this.voxelSize;
            }
        };
        Getter<E3DVector> viewPosGetter = new Getter<E3DVector>(){

            @Override
            public E3DVector get() {
                return TypeWriterGUI.this.viewPos;
            }
        };
        Getter<float[][][]> xyzBufferGetter = new Getter<float[][][]>(){

            @Override
            public float[][][] get() {
                return TypeWriterGUI.this.xyzBuffer;
            }
        };
        Getter<double[]> dMinMaxGetter = new Getter<double[]>(){

            @Override
            public double[] get() {
                return TypeWriterGUI.this.dMinMax;
            }
        };
        new ImageLocator(this.scrollableImage, voxelSizeGetter, viewPosGetter, xyzBufferGetter, dMinMaxGetter);
        this.prepare4AutomaticRestart();
        this.coolBar.setStartable(true);
        this.run();
    }

    @Override
    protected ScrollableImage getScrollableImage() {
        return this.scrollableImage;
    }

    @Override
    protected E3DMaterial getDefaultMaterial() {
        return new E3DMaterial(this.materialScales.getGloss(), this.materialScales.getMirror(), this.materialScales.getGlow(), null, this.materialScales.getRefractivity());
    }

    @Override
    protected E3DVector getViewPosition() {
        E3DVector pos = this.viewScales.getXYZ();
        double dist = this.distanceScales.getValue();
        pos.norm(dist <= 0.0 ? 100000.0 : dist);
        return pos;
    }

    @Override
    protected E3DVector getFocusPoint() {
        return this.focusScales.getXYZ();
    }

    @Override
    protected List<E3DVector> getLightPositions() {
        ArrayList<E3DVector> lightPositions = new ArrayList<E3DVector>(1);
        E3DVector lightPos = this.lightScales.getXYZ();
        lightPos.multiplicate(10000.0);
        lightPositions.add(lightPos);
        return lightPositions;
    }

    @Override
    protected int getLightColor() {
        return this.lightColorScales.getColor();
    }

    @Override
    protected int getAmbientLightColor() {
        double shift = this.ambientShiftScales.getValue();
        return E3DColor.changeHSB(this.lightColorScales.getColor(), shift, 1.0, 1.0);
    }

    @Override
    protected double getAmbient() {
        return this.ambientScales.getValue();
    }

    @Override
    protected double getHue() {
        return this.hsbScales.getHue();
    }

    @Override
    protected double getSaturation() {
        return this.hsbScales.getSaturation();
    }

    @Override
    protected double getBrightness() {
        return this.hsbScales.getBrightness();
    }

    @Override
    protected int getBGColor() {
        return this.bgScales.getColor();
    }

    @Override
    protected int getShiftColor() {
        return this.shiftColorScales.getColor();
    }

    @Override
    protected double getBlueShift() {
        return this.colorShiftScales.getBlueShift();
    }

    @Override
    protected double getWhiteShift() {
        return this.colorShiftScales.getWhiteShift();
    }

    @Override
    public double getMaxBlurRadius() {
        return this.focusFilterScales.getMaxBlurRadius();
    }

    @Override
    public double getFocalDistance() {
        return this.focusFilterScales.getFocalDistance();
    }

    @Override
    protected E3DImage getBGImage() {
        E3DImageSWT[] images = this.bgImageGroup.getImages(0);
        return images != null && images.length > 0 ? images[0] : null;
    }

    @Override
    protected E3DBoundingBox getBounds() {
        return this.scan.getTightBounds();
    }

    @Override
    protected int getImageWidth() {
        return this.scan.getWidth();
    }

    @Override
    protected int getImageHeight() {
        return this.scan.getHeight();
    }

    @Override
    protected int getZBufferDepth() {
        return this.scan.getDepth();
    }

    @Override
    protected E3DEnvironment getEnvironment() {
        E3DImage leftImg = ArrayUtils.get(this.envImageGroup.getImages(1), 0, null);
        E3DImage upperImg = ArrayUtils.get(this.envImageGroup.getImages(2), 0, null);
        E3DImage frontImg = ArrayUtils.get(this.envImageGroup.getImages(0), 0, null);
        E3DImage rightImg = ArrayUtils.get(this.envImageGroup.getImages(4), 0, null);
        E3DImage lowerImg = ArrayUtils.get(this.envImageGroup.getImages(5), 0, null);
        E3DImage backImg = ArrayUtils.get(this.envImageGroup.getImages(3), 0, null);
        if (leftImg != null || upperImg != null || frontImg != null || rightImg != null || lowerImg != null || backImg != null) {
            E3DBoundingBox bounds = this.getBounds();
            E3DBoxEnvironment box = new E3DBoxEnvironment(this.envDirectlyVisible, bounds, leftImg, rightImg, upperImg, lowerImg, frontImg, backImg);
            return box;
        }
        return null;
    }

    @Override
    protected ProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    protected ProgressListener getSubProgressListener() {
        return this.subProgressListener;
    }

    @Override
    public float getJPGQuality() {
        return (float)this.jpgScale.getValue();
    }

    @Override
    public boolean hasLoadItem() {
        return false;
    }

    @Override
    public boolean isStartable() {
        return true;
    }

    @Override
    public boolean hasEditMenu() {
        return false;
    }

    @Override
    public boolean hasViewMenu() {
        return false;
    }

    @Override
    public void load() {
    }

    @Override
    public void save() {
        this.bezierImageFile = this.saveImage("Save Bezier Image", this.filteredImage, this.bezierImageFile);
    }

    @Override
    public void start() {
        if (this.future != null) {
            this.showBusyMessage();
        } else if (this.fontDataGroup.getFiles(0) == null) {
            MessageBox msgBox = new MessageBox(this.shell, 34);
            msgBox.setText("No Font");
            msgBox.setMessage("Define a font zip archive first...");
            msgBox.open();
        } else {
            this.restart(SpaceGUI.Step.COMPLETE);
        }
    }

    protected SurfaceScan scanning() throws Exception {
        this.statistics.clear();
        if (this.fontDataGroup.getFiles(0) == null) {
            return null;
        }
        E3DFont font = this.fontTypeComboGroup.getFont();
        font.loadFontData(new ZipFile(ArrayUtils.get(this.fontDataGroup.getFiles(0), 0, null)));
        font.setColor(new E3DColor(this.objectColorScales.getColor()));
        font.setIndent(this.fontScales.getIndent());
        font.setBoldness(this.fontScales.getBoldness());
        font.setRadialPoints(this.fontScales.getRadialPoints());
        font.setHorizontalSpacing(this.fontScales.getHorizontalSpacing());
        font.setText(this.textGroup.getContent(0));
        Surfaces surfaces = font.asBezierMeshs();
        E3DMultiTransformation pointTransformations = new E3DMultiTransformation();
        E3DVector translation = this.translationScales.getXYZ();
        if (translation.x != 0.0 || translation.y != 0.0 || translation.z != 0.0) {
            E3DTranslation shift = new E3DTranslation(translation);
            pointTransformations.add(shift);
        } else {
            Object shift = null;
        }
        E3DVector rotation = this.rotationScales.getXYZ();
        if (rotation.x != 0.0 || rotation.y != 0.0 || rotation.z > 0.0) {
            E3DRotation spin = new E3DRotation(rotation, false, false, true);
            pointTransformations.add(spin);
        } else {
            Object spin = null;
        }
        double scaleFactor = this.bezierScales.getScaleFactor();
        if (scaleFactor != 1.0) {
            E3DScale scale = new E3DScale(scaleFactor);
            pointTransformations.add(scale);
        } else {
            Object scale = null;
        }
        Surfaces transformed = surfaces.transformed(pointTransformations);
        E3DBoundingBox bounds = transformed.getBounds();
        double margin = MathUtils.max(bounds.width(), bounds.height(), bounds.depth()) / 10.0;
        bounds.x0 -= margin;
        bounds.x1 += margin;
        bounds.y0 -= margin;
        bounds.y1 += margin;
        bounds.z0 -= margin;
        bounds.z1 += margin;
        int width = (int)bounds.width();
        int height = (int)bounds.height();
        int depth = (int)bounds.depth();
        SurfaceScan scan = new SurfaceScan(bounds, width, height, depth);
        scan.setDensity(this.bezierScales.getDensity());
        scan.setRandomizeColors(false);
        if (this.texImageGroup.getImages(0) != null) {
            boolean splitTextures = this.texPolicyRadioButtons.getSelected() == 3;
            E3DImage[] textures = this.texImageGroup.getImages(0);
            int splitX = splitTextures ? font.getRadialSurfacesPerSegment() : 1;
            int splitY = splitTextures ? font.getLongitudinalSurfacesPerSegment() : 1;
            scan.setTextures(this.splitTextures(textures, splitX, splitY));
        }
        switch (this.texPolicyRadioButtons.getSelected()) {
            case 0: {
                scan.setTextureChoosingPolicy(SurfaceScan.TextureChoosingPolicy.FORWARD);
                break;
            }
            case 1: {
                scan.setTextureChoosingPolicy(SurfaceScan.TextureChoosingPolicy.BACKWARD);
                break;
            }
            case 2: {
                scan.setTextureChoosingPolicy(SurfaceScan.TextureChoosingPolicy.RANDOM);
                break;
            }
            case 3: {
                scan.setTextureChoosingPolicy(SurfaceScan.TextureChoosingPolicy.FORWARD);
            }
        }
        scan.addProgressListener(this.subProgressListener);
        scan.setSurfaces(transformed);
        scan.removeProgressListener(this.subProgressListener);
        return scan;
    }

    @Override
    protected void showStatistics(String text) {
    }

    @Override
    public void help() {
        new E3DHelp(this.display, NAME, HELP_URI, this);
    }

    @Override
    public void about() {
        this.about(NAME, "V3.5");
    }

    private final E3DImage[] splitTextures(E3DImage[] textures, int splitX, int splitY) throws Exception {
        int n = splitX * splitY * textures.length;
        E3DImage[] splittedTextures = new E3DImage[n];
        int i = 0;
        int j = 0;
        while (i < textures.length) {
            E3DImage texture = textures[i];
            if (texture == null) {
                int k = 0;
                while (k < splitX * splitY) {
                    splittedTextures[j++] = null;
                    ++k;
                }
            } else {
                int w = texture.getWidth() / splitX;
                int x = 0;
                int x0 = 0;
                while (x < splitX) {
                    int h = texture.getHeight() / splitY;
                    int y = 0;
                    int y0 = 0;
                    while (y < splitY) {
                        splittedTextures[j++] = texture.crop(x0, y0, w, h);
                        h = this.div(texture.getHeight() - (y0 += h), splitY - y - 1);
                        ++y;
                    }
                    w = this.div(texture.getWidth() - (x0 += w), splitX - x - 1);
                    ++x;
                }
            }
            ++i;
        }
        return splittedTextures;
    }

    private int div(int a, int b) {
        return a == 0 && b == 0 ? 0 : a / b;
    }

    protected void prepare4AutomaticRestart() {
        WidgetGroupEditedListener scanningListener = this.getAutoListener(SpaceGUI.Step.SCANNING);
        this.bezierScales.addListener(scanningListener);
        this.rotationScales.addListener(scanningListener);
        this.translationScales.addListener(scanningListener);
        this.texImageGroup.addListener(scanningListener);
        this.texPolicyRadioButtons.addListener(scanningListener);
        this.textGroup.addListener(scanningListener);
        this.fontScales.addListener(scanningListener);
        this.objectColorScales.addListener(scanningListener);
        WidgetGroupEditedListener renderingListener = this.getAutoListener(SpaceGUI.Step.RENDERING);
        this.focusScales.addListener(renderingListener);
        this.viewScales.addListener(renderingListener);
        this.distanceScales.addListener(renderingListener);
        this.lightScales.addListener(renderingListener);
        this.lightColorScales.addListener(renderingListener);
        this.materialScales.addListener(renderingListener);
        this.ambientScales.addListener(renderingListener);
        this.envImageGroup.addListener(renderingListener);
        WidgetGroupEditedListener filteringListener = this.getAutoListener(SpaceGUI.Step.FILTERING);
        this.hsbScales.addListener(filteringListener);
        this.bgScales.addListener(filteringListener);
        this.shiftColorScales.addListener(filteringListener);
        this.colorShiftScales.addListener(filteringListener);
        this.focusFilterScales.addListener(filteringListener);
        this.bgImageGroup.addListener(filteringListener);
    }

    public static void main(String[] args) {
        new TypeWriterGUI();
    }
}

