/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui;

import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DIdentity;
import e3d.euclidean.transformations.E3DRotation;
import e3d.euclidean.transformations.E3DScale;
import e3d.euclidean.transformations.E3DTranslation;
import e3d.fractal.FractalColorizer;
import e3d.fractal.FractalEstimator;
import e3d.fractal.FractalType;
import e3d.fractal.Julia3D;
import e3d.fractal.Mandelbrot3D;
import e3d.fractal.MyQuaternion;
import e3d.gui.SpaceGUI;
import e3d.gui.groups.CheckButtonGroup;
import e3d.gui.groups.FileGroup;
import e3d.gui.groups.ImageGroup;
import e3d.gui.groups.PushButtonGroup;
import e3d.gui.groups.RadioButtonGroup;
import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.groups.scales.ColorScaleGroup;
import e3d.gui.groups.scales.ColorShiftScaleGroup;
import e3d.gui.groups.scales.FocusScaleGroup;
import e3d.gui.groups.scales.HSBScaleGroup;
import e3d.gui.groups.scales.HorizontalScaleGroup;
import e3d.gui.groups.scales.ScaleGroup;
import e3d.gui.groups.scales.SimpleColorScaleGroup;
import e3d.gui.groups.scales.SingleHorizontalScaleGroup;
import e3d.gui.groups.scales.SingleVerticalScaleGroup;
import e3d.gui.groups.scales.WHDScaleGroup;
import e3d.gui.groups.scales.XYZScaleGroup;
import e3d.gui.groups.scales.XYZTScaleGroup;
import e3d.gui.groups.scales.XYZWHDScaleGroup;
import e3d.gui.groups.scales.ZoomScaleGroup;
import e3d.gui.groups.scales.special.IterationScaleGroup;
import e3d.gui.groups.scales.special.MaterialScaleGroup;
import e3d.gui.groups.special.FractalTypeComboGroup;
import e3d.gui.groups.special.ScanTypeComboGroup;
import e3d.gui.icons.Icons;
import e3d.gui.images.ImageLocator;
import e3d.gui.images.ImageProgress;
import e3d.gui.images.Perspective;
import e3d.gui.images.ScrollableImage;
import e3d.gui.utils.E3DHelp;
import e3d.gui.utils.SWTUtils;
import e3d.numbers.Quaternion;
import e3d.utils.ArrayUtils;
import e3d.utils.Getter;
import e3d.utils.ProgressListener;
import e3d.visualization.environment.E3DBoxEnvironment;
import e3d.visualization.environment.E3DEnvironment;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageAWT;
import e3d.visualization.image.E3DImageSWT;
import e3d.visualization.object.E3DCubicSubject;
import e3d.visualization.object.E3DIntersectionSubject;
import e3d.visualization.object.E3DMultiSubject;
import e3d.visualization.object.E3DSubject;
import e3d.visualization.object.E3DTransformedSubject;
import e3d.visualization.scanner.E3DHybridSubjectScan;
import e3d.visualization.scanner.E3DObjectScan;
import e3d.visualization.scanner.E3DPhysicalObjectScan;
import e3d.visualization.scanner.E3DPhysicalSubjectScan;
import e3d.visualization.scanner.E3DVirtualSubjectScan;
import e3d.visualization.space.Space;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DLight;
import e3d.visualization.util.E3DMaterial;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class FractalGUI
extends SpaceGUI {
    private static final String NAME = "3D Fractal Renderer (V3.5)";
    private static final String HELP_URI = "help/fractal/index";
    private static final int IMAGE_DEFAULT_WIDTH = 400;
    private static final int IMAGE_DEFAULT_HEIGHT = 400;
    protected File fractalImageFile = null;
    protected final ScrollableImage scrollableImage;
    protected final ProgressListener progressListener;
    protected final ProgressListener subProgressListener;
    protected final ProgressListener movieProgressListener;
    private double x0 = -1.25;
    private double y0 = -1.25;
    private double z0 = -1.25;
    private double width = 2.5;
    private double height = 2.5;
    private double depth = 2.5;
    protected final FractalTypeComboGroup fractalType;
    protected final ScanTypeComboGroup scanType;
    protected final XYZTScaleGroup z0Scales;
    protected final XYZTScaleGroup c0Scales;
    protected final SingleVerticalScaleGroup bulbScales;
    protected final SingleVerticalScaleGroup boxScales;
    protected final CheckButtonGroup sourroundingCheckButtons;
    protected final IterationScaleGroup iterationScales;
    protected final HorizontalScaleGroup glowRadiusScales;
    protected final SimpleColorScaleGroup glowColorScales;
    protected final RadioButtonGroup glowShapeRadioButtons;
    protected final XYZScaleGroup rotationScales;
    protected final XYZScaleGroup translationScales;
    protected final SingleVerticalScaleGroup scaleScales;
    protected final ColorScaleGroup objectColorScales;
    protected final SingleVerticalScaleGroup objectColorFrequencyScales;
    protected final Text statisticsText;
    protected final XYZWHDScaleGroup boundScales;
    protected final PushButtonGroup boundControlButtons;
    protected final XYZScaleGroup viewScales;
    protected final XYZScaleGroup focusScales;
    protected final SingleVerticalScaleGroup distanceScales;
    protected final XYZScaleGroup lightScales;
    protected final ColorScaleGroup lightColorScales;
    protected final SingleHorizontalScaleGroup ambientShiftScales;
    protected final SingleVerticalScaleGroup ambientScales;
    protected final WHDScaleGroup resolutionScales;
    protected final SingleHorizontalScaleGroup scanLevelsScales;
    protected final SingleHorizontalScaleGroup normalPrecisionScales;
    protected final SingleHorizontalScaleGroup compensationScales;
    protected final ColorScaleGroup bgScales;
    protected final HSBScaleGroup hsbScales;
    protected final MaterialScaleGroup materialScales;
    protected final ColorShiftScaleGroup colorShiftScales;
    protected final ColorScaleGroup shiftColorScales;
    protected final FocusScaleGroup focusFilterScales;
    protected final ImageGroup envImageGroup;
    protected final ImageGroup bgImageGroup;
    protected final ZoomScaleGroup zoomScale;
    protected final SingleHorizontalScaleGroup jpgScale;
    protected final FileGroup movieFolderGroup;
    protected final HorizontalScaleGroup imgCountScale;
    protected final HorizontalScaleGroup movieTransScales;
    protected final CheckButtonGroup movieControlGroup;
    protected int imgIndex = 0;
    protected int imgCount = 0;
    protected int imgSkip = 0;
    private E3DBoundingBox origBounds = new E3DBoundingBox(this.x0, this.y0, this.z0, this.width, this.height, this.depth);

    public FractalGUI() {
        this.shell.setText(NAME);
        this.extendFileMenu();
        this.extendViewMenu();
        Composite main = new Composite(this.shell, 0);
        main.setLayoutData(new GridData(1808));
        main.setLayout(new GridLayout(2, false));
        this.scrollableImage = new ScrollableImage(main);
        ((GridData)this.scrollableImage.getScroll().getLayoutData()).widthHint = 400;
        ((GridData)this.scrollableImage.getScroll().getLayoutData()).heightHint = 400;
        this.movieProgressListener = new ImageProgress(this.scrollableImage, -137, 1.33);
        this.progressListener = new ImageProgress(this.scrollableImage, -36, 1.0);
        this.subProgressListener = new ImageProgress(this.scrollableImage, 37, 0.67);
        Composite controlFrame = new Composite(main, 0);
        controlFrame.setLayout(new GridLayout(1, false));
        controlFrame.setLayoutData(new GridData(4, 4, false, true));
        final TabFolder tabFolder = new TabFolder(controlFrame, 128);
        tabFolder.setLayoutData(new GridData(4, 4, true, true));
        tabFolder.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                tabFolder.update();
            }
        });
        Composite fractalFrame = new Composite(tabFolder, 0);
        fractalFrame.setLayout(new GridLayout(1, false));
        fractalFrame.setLayoutData(new GridData(4, 4, true, true));
        Composite typeFrame = new Composite(fractalFrame, 0);
        typeFrame.setLayout(SWTUtils.gridLayout(2, false, 5, 5, 0, 0, 0, 0, 0, 0));
        typeFrame.setLayoutData(SWTUtils.gridData(4, 4, 0, 0, -1, -1, false, false));
        this.fractalType = new FractalTypeComboGroup(typeFrame, "Fractal-Type", -1);
        this.fractalType.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                boolean solid = FractalGUI.this.fractalType.isSolid();
                FractalGUI.this.iterationScales.setEnabled(solid, 1);
                boolean naive = FractalGUI.this.fractalType.getEstimator() instanceof FractalEstimator.NaiveFractalEstimator;
                FractalGUI.this.iterationScales.setEnabled(!naive, 2);
                FractalGUI.this.objectColorFrequencyScales.setEnabled(FractalGUI.this.fractalType.getColorizer() instanceof FractalColorizer.SingleOrbitTrapColorizer || FractalGUI.this.fractalType.getColorizer() instanceof FractalColorizer.EstimatedDistanceColorizer);
                FractalGUI.this.glowRadiusScales.setEnabled(FractalGUI.this.fractalType.getColorizer() instanceof FractalColorizer.GlowColorizer);
                FractalGUI.this.glowShapeRadioButtons.setEnabled(FractalGUI.this.fractalType.getColorizer() instanceof FractalColorizer.GlowColorizer);
                FractalGUI.this.boxScales.setEnabled(FractalGUI.this.fractalType.getMultiplactor() instanceof MyQuaternion.QuaternionMultiplicator.BoxMultiplicator);
                FractalGUI.this.bulbScales.setEnabled(FractalGUI.this.fractalType.getMultiplactor() instanceof MyQuaternion.QuaternionMultiplicator.BulbMultiplicator);
                boolean julia = FractalGUI.this.fractalType.getType() == FractalType.JULIA;
                FractalGUI.this.c0Scales.setEnabled(julia, 0, 1, 2);
                FractalGUI.this.z0Scales.setEnabled(!julia, 0, 1, 2);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        this.iterationScales = new IterationScaleGroup(typeFrame, "Iteration", 512, 2.0, 1.0, 87, false);
        this.iterationScales.setEnabled(this.fractalType.isSolid(), 1);
        Composite basicParamFrame = new Composite(fractalFrame, 0);
        basicParamFrame.setLayout(SWTUtils.gridLayout(2, false, 5, 5, 0, 0, 0, 0, 0, 0));
        basicParamFrame.setLayoutData(SWTUtils.gridData(4, 4, 0, 0, -1, -1, false, false));
        this.c0Scales = new XYZTScaleGroup(basicParamFrame, "C0", 100.0, -0.5, 0.45, -0.35, 0.25, -200, -200, -200, -200, 200, 200, 200, 200, 100, false);
        this.z0Scales = new XYZTScaleGroup(basicParamFrame, "Z0", 100.0, 0.0, 0.0, 0.0, 0.0, -200, -200, -200, -200, 200, 200, 200, 200, 100, false);
        this.c0Scales.setEnabled(true, 0, 1, 2);
        this.z0Scales.setEnabled(false, 0, 1, 2);
        Composite optParamFrame = new Composite(fractalFrame, 0);
        optParamFrame.setLayout(SWTUtils.gridLayout(5, false, 5, 5, 0, 0, 0, 0, 0, 0));
        optParamFrame.setLayoutData(SWTUtils.gridData(4, 4, 0, 0, -1, -1, false, false));
        this.objectColorScales = new ColorScaleGroup(optParamFrame, "Wall / Fractal Color", 255, 255, 255, 255, 100, false);
        this.objectColorScales.setEnabled(true);
        ((GridData)this.objectColorScales.getGroup().getLayoutData()).verticalSpan = 3;
        this.objectColorFrequencyScales = new SingleVerticalScaleGroup(optParamFrame, "Freq.", "Frequency of color-changes for a single orbit trap colorizer", "hue_focus.png", 10.0, 1.0, 0, 100, 100, false);
        this.objectColorFrequencyScales.setEnabled(false);
        ((GridData)this.objectColorFrequencyScales.getGroup().getLayoutData()).verticalSpan = 3;
        this.bulbScales = new SingleVerticalScaleGroup(optParamFrame, "Bulb", "Order for mandelbulb fractals", "quadratic_focus.png", 1.0, 8.0, 1, 20, 100, false);
        this.bulbScales.setEnabled(false);
        ((GridData)this.bulbScales.getGroup().getLayoutData()).verticalSpan = 3;
        this.boxScales = new SingleVerticalScaleGroup(optParamFrame, "Box", "Scale-parameter for mandelbox fractals", "scale_focus.png", 10.0, 2.0, -40, 40, 100, false);
        this.boxScales.setEnabled(false);
        ((GridData)this.boxScales.getGroup().getLayoutData()).verticalSpan = 3;
        this.glowRadiusScales = new HorizontalScaleGroup(optParamFrame, "Glow Radius", new String[]{"Glowing Radius \nNotice: The center is always at (0,0,0)"}, Icons.getSWTImages(this.display, "radius_focus.png"), new double[]{2.0}, new ScaleGroup.Function[]{ScaleGroup.linear(100.0, 0)}, new int[1], new int[]{1000}, new int[]{256}, new int[]{60}, false);
        this.glowRadiusScales.setEnabled(false);
        this.glowColorScales = new SimpleColorScaleGroup(optParamFrame, "Glow Color", -1, 1.0, 1.0, -65536, 256, 60, false);
        this.glowShapeRadioButtons = new RadioButtonGroup(optParamFrame, "Glow Shape", new String[]{"Sphere", "Cube"}, new String[2], 0, 100, true, false);
        this.glowShapeRadioButtons.setEnabled(false);
        TabItem fractalTab = new TabItem(tabFolder, 0);
        fractalTab.setText("Fractal");
        fractalTab.setControl(fractalFrame);
        Composite scanFrame = new Composite(tabFolder, 0);
        scanFrame.setLayout(new GridLayout(3, false));
        scanFrame.setLayoutData(new GridData(4, 4, true, true));
        this.scanType = new ScanTypeComboGroup(scanFrame, "Scan-Method", -1);
        ((GridData)this.scanType.getGroup().getLayoutData()).horizontalSpan = 3;
        this.scanType.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                boolean enableNaiveParams = FractalGUI.this.scanType.getType() == ScanTypeComboGroup.ScanType.PHYSICAL_OBJECT;
                FractalGUI.this.scanLevelsScales.setEnabled(enableNaiveParams);
                FractalGUI.this.normalPrecisionScales.setEnabled(enableNaiveParams);
                FractalGUI.this.compensationScales.setEnabled(!enableNaiveParams);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        this.rotationScales = new XYZScaleGroup(scanFrame, "Rotation", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        this.translationScales = new XYZScaleGroup(scanFrame, "Translation", 10.0, 0.0, 0.0, 0.0, -10, -10, -10, 10, 10, 10, 100, false);
        this.scaleScales = new SingleVerticalScaleGroup(scanFrame, "Scale", "Scale", "scale_focus.png", 10.0, 1.0, 0, 100, 100, false);
        this.boundScales = new XYZWHDScaleGroup(scanFrame, "Search Space", 10.0, this.x0, this.y0, this.z0, this.width, this.height, this.depth, -100, -100, -100, 100, 100, 100, 200, 200, 200, 100, false);
        ((GridData)this.boundScales.getGroup().getLayoutData()).horizontalSpan = 2;
        this.boundScales.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                FractalGUI.this.x0 = FractalGUI.this.boundScales.getValue(0);
                FractalGUI.this.y0 = FractalGUI.this.boundScales.getValue(1);
                FractalGUI.this.z0 = FractalGUI.this.boundScales.getValue(2);
                FractalGUI.this.width = FractalGUI.this.boundScales.getValue(3);
                FractalGUI.this.height = FractalGUI.this.boundScales.getValue(4);
                FractalGUI.this.depth = FractalGUI.this.boundScales.getValue(5);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        this.boundControlButtons = new PushButtonGroup(scanFrame, "Ctrl.", new String[]{"+/-1.25", "x 0.5", "+/-2.5", "x 0.1", "+/-5", "x 2", "+/-10", "x 10", "+/-15", "d x 0.5", "+/-20", "d x 2"}, new String[]{"set range: (-1.25, -1.25, -1.25) - (1.25, 1.25, 1.25)", "shrink current range by factor 2", "set range: (-2.5, -2.5, -2.5) - (2.5, 2.5, 2.5)", "shrink current range by factor 10", "set range: (-5, -5, -5) - (5, 5, 5)", "extend current range by factor 2", "set range: (-10, -10, -10) - (10, 10, 10)", "extend current range by factor 10", "set range: (-15, -15, -15) - (15, 15, 15)", "shrink depth by factor 2", "set range: (-20, -20, -20) - (20, 20, 20)", "extend depth by factor 2"}, 2, new int[]{-1, -1}, true, false);
        this.boundControlButtons.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                if (index % 2 == 0) {
                    switch (index) {
                        case 0: {
                            FractalGUI.this.z0 = -1.25;
                            FractalGUI.this.y0 = -1.25;
                            FractalGUI.this.x0 = -1.25;
                            FractalGUI.this.depth = 2.5;
                            FractalGUI.this.height = 2.5;
                            FractalGUI.this.width = 2.5;
                            break;
                        }
                        case 2: {
                            FractalGUI.this.z0 = -2.5;
                            FractalGUI.this.y0 = -2.5;
                            FractalGUI.this.x0 = -2.5;
                            FractalGUI.this.depth = 5.0;
                            FractalGUI.this.height = 5.0;
                            FractalGUI.this.width = 5.0;
                            break;
                        }
                        case 4: {
                            FractalGUI.this.z0 = -5.0;
                            FractalGUI.this.y0 = -5.0;
                            FractalGUI.this.x0 = -5.0;
                            FractalGUI.this.depth = 10.0;
                            FractalGUI.this.height = 10.0;
                            FractalGUI.this.width = 10.0;
                            break;
                        }
                        case 6: {
                            FractalGUI.this.z0 = -10.0;
                            FractalGUI.this.y0 = -10.0;
                            FractalGUI.this.x0 = -10.0;
                            FractalGUI.this.depth = 20.0;
                            FractalGUI.this.height = 20.0;
                            FractalGUI.this.width = 20.0;
                            break;
                        }
                        case 8: {
                            FractalGUI.this.z0 = -15.0;
                            FractalGUI.this.y0 = -15.0;
                            FractalGUI.this.x0 = -15.0;
                            FractalGUI.this.depth = 30.0;
                            FractalGUI.this.height = 30.0;
                            FractalGUI.this.width = 30.0;
                            break;
                        }
                        case 10: {
                            FractalGUI.this.z0 = -20.0;
                            FractalGUI.this.y0 = -20.0;
                            FractalGUI.this.x0 = -20.0;
                            FractalGUI.this.depth = 40.0;
                            FractalGUI.this.height = 40.0;
                            FractalGUI.this.width = 40.0;
                        }
                    }
                    FractalGUI.this.boundScales.setValue(0, FractalGUI.this.x0);
                    FractalGUI.this.boundScales.setValue(1, FractalGUI.this.y0);
                    FractalGUI.this.boundScales.setValue(2, FractalGUI.this.x0);
                    FractalGUI.this.boundScales.setValue(3, FractalGUI.this.width);
                    FractalGUI.this.boundScales.setValue(4, FractalGUI.this.height);
                    FractalGUI.this.boundScales.setValue(5, FractalGUI.this.depth);
                } else if (index == 1) {
                    FractalGUI.this.boundScales.setValue(0, FractalGUI.this.boundScales.getValue(0) + FractalGUI.this.boundScales.getValue(3) / 4.0);
                    FractalGUI.this.boundScales.setValue(1, FractalGUI.this.boundScales.getValue(1) + FractalGUI.this.boundScales.getValue(4) / 4.0);
                    FractalGUI.this.boundScales.setValue(2, FractalGUI.this.boundScales.getValue(2) + FractalGUI.this.boundScales.getValue(4) / 4.0);
                    FractalGUI.this.boundScales.setValue(3, FractalGUI.this.boundScales.getValue(3) / 2.0);
                    FractalGUI.this.boundScales.setValue(4, FractalGUI.this.boundScales.getValue(4) / 2.0);
                    FractalGUI.this.boundScales.setValue(5, FractalGUI.this.boundScales.getValue(5) / 2.0);
                } else if (index == 3) {
                    FractalGUI.this.boundScales.setValue(0, FractalGUI.this.boundScales.getValue(0) + FractalGUI.this.boundScales.getValue(3) * 0.45);
                    FractalGUI.this.boundScales.setValue(1, FractalGUI.this.boundScales.getValue(1) + FractalGUI.this.boundScales.getValue(4) * 0.45);
                    FractalGUI.this.boundScales.setValue(2, FractalGUI.this.boundScales.getValue(2) + FractalGUI.this.boundScales.getValue(4) * 0.45);
                    FractalGUI.this.boundScales.setValue(3, FractalGUI.this.boundScales.getValue(3) / 10.0);
                    FractalGUI.this.boundScales.setValue(4, FractalGUI.this.boundScales.getValue(4) / 10.0);
                    FractalGUI.this.boundScales.setValue(5, FractalGUI.this.boundScales.getValue(5) / 10.0);
                } else if (index == 5) {
                    FractalGUI.this.boundScales.setValue(0, FractalGUI.this.boundScales.getValue(0) - FractalGUI.this.boundScales.getValue(3) / 2.0);
                    FractalGUI.this.boundScales.setValue(1, FractalGUI.this.boundScales.getValue(1) - FractalGUI.this.boundScales.getValue(4) / 2.0);
                    FractalGUI.this.boundScales.setValue(2, FractalGUI.this.boundScales.getValue(2) - FractalGUI.this.boundScales.getValue(4) / 2.0);
                    FractalGUI.this.boundScales.setValue(3, FractalGUI.this.boundScales.getValue(3) * 2.0);
                    FractalGUI.this.boundScales.setValue(4, FractalGUI.this.boundScales.getValue(4) * 2.0);
                    FractalGUI.this.boundScales.setValue(5, FractalGUI.this.boundScales.getValue(5) * 2.0);
                } else if (index == 7) {
                    FractalGUI.this.boundScales.setValue(0, FractalGUI.this.boundScales.getValue(0) - FractalGUI.this.boundScales.getValue(3) * 5.0);
                    FractalGUI.this.boundScales.setValue(1, FractalGUI.this.boundScales.getValue(1) - FractalGUI.this.boundScales.getValue(4) * 5.0);
                    FractalGUI.this.boundScales.setValue(2, FractalGUI.this.boundScales.getValue(2) - FractalGUI.this.boundScales.getValue(4) * 5.0);
                    FractalGUI.this.boundScales.setValue(3, FractalGUI.this.boundScales.getValue(3) * 10.0);
                    FractalGUI.this.boundScales.setValue(4, FractalGUI.this.boundScales.getValue(4) * 10.0);
                    FractalGUI.this.boundScales.setValue(5, FractalGUI.this.boundScales.getValue(5) * 10.0);
                } else if (index == 10) {
                    FractalGUI.this.boundScales.setValue(2, FractalGUI.this.boundScales.getValue(2) + FractalGUI.this.boundScales.getValue(4) / 4.0);
                    FractalGUI.this.boundScales.setValue(5, FractalGUI.this.boundScales.getValue(5) / 2.0);
                } else if (index == 11) {
                    FractalGUI.this.boundScales.setValue(2, FractalGUI.this.boundScales.getValue(2) - FractalGUI.this.boundScales.getValue(4) / 2.0);
                    FractalGUI.this.boundScales.setValue(5, FractalGUI.this.boundScales.getValue(5) * 2.0);
                }
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        this.resolutionScales = new WHDScaleGroup(scanFrame, "Resolution", 0.01, 500.0, 500.0, 500.0, 20, 20, 20, true, false, 100, false);
        ((GridData)this.resolutionScales.getGroup().getLayoutData()).verticalSpan = 3;
        this.resolutionScales.getLabel(0).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                double res = FractalGUI.this.resolutionScales.getWidth() / FractalGUI.this.boundScales.getWidth();
                FractalGUI.this.resolutionScales.setValue(1, (int)(res * FractalGUI.this.boundScales.getHeight()));
                FractalGUI.this.resolutionScales.setValue(2, (int)(res * FractalGUI.this.boundScales.getDepth()));
                if (FractalGUI.this.auto) {
                    FractalGUI.this.restart(SpaceGUI.Step.SCANNING);
                }
            }
        });
        this.resolutionScales.getLabel(1).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                double res = FractalGUI.this.resolutionScales.getHeight() / FractalGUI.this.boundScales.getHeight();
                FractalGUI.this.resolutionScales.setValue(0, (int)(res * FractalGUI.this.boundScales.getWidth()));
                FractalGUI.this.resolutionScales.setValue(2, (int)(res * FractalGUI.this.boundScales.getDepth()));
                if (FractalGUI.this.auto) {
                    FractalGUI.this.restart(SpaceGUI.Step.SCANNING);
                }
            }
        });
        this.resolutionScales.getLabel(2).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                double res = FractalGUI.this.resolutionScales.getDepth() / FractalGUI.this.boundScales.getDepth();
                FractalGUI.this.resolutionScales.setValue(0, (int)(res * FractalGUI.this.boundScales.getWidth()));
                FractalGUI.this.resolutionScales.setValue(1, (int)(res * FractalGUI.this.boundScales.getHeight()));
                if (FractalGUI.this.auto) {
                    FractalGUI.this.restart(SpaceGUI.Step.SCANNING);
                }
            }
        });
        this.scanLevelsScales = new SingleHorizontalScaleGroup(scanFrame, "Max. Nesting Levels", "Max. number of nested surfaces that could be scanned", "levels_focus.png", 1.0, 10.0, 1, 20, 100, true);
        ((GridData)this.scanLevelsScales.getGroup().getLayoutData()).horizontalSpan = 2;
        this.scanLevelsScales.setEnabled(false);
        this.normalPrecisionScales = new SingleHorizontalScaleGroup(scanFrame, "Normal Precision", "Number of sub-divisions to estimate the normal for each point", "bezier_pressed_focus.png", 1.0, 8.0, 0, 10, 100, true);
        ((GridData)this.normalPrecisionScales.getGroup().getLayoutData()).horizontalSpan = 2;
        this.normalPrecisionScales.setEnabled(false);
        this.compensationScales = new SingleHorizontalScaleGroup(scanFrame, "Compensation Factor", "Compensation factor for bad distance estimations", "percent_focus.png", 10.0, 1.5, 0, 100, 100, true);
        ((GridData)this.compensationScales.getGroup().getLayoutData()).horizontalSpan = 2;
        this.compensationScales.setEnabled(true);
        TabItem scanTab = new TabItem(tabFolder, 0);
        scanTab.setText("Scan");
        scanTab.setControl(scanFrame);
        Composite renderingFrame = new Composite(tabFolder, 0);
        renderingFrame.setLayout(new GridLayout(3, false));
        renderingFrame.setLayoutData(new GridData(4, 4, true, true));
        this.viewScales = new XYZScaleGroup(renderingFrame, "View Position", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        Perspective viewPerspective = new Perspective(this.scrollableImage, this.viewScales, new Color(this.display, 192, 255, 129), 1);
        viewPerspective.show();
        this.distanceScales = new SingleVerticalScaleGroup(renderingFrame, "Dist.", "Distance of the viewer to the scene\n(where <= 0 means +Inifinity - i.e. a parallel perspective)", "distance_focus.png", 1.0, 0.0, 0, 100, 100, false);
        this.focusScales = new XYZScaleGroup(renderingFrame, "Focus Point Offset", 10.0, 0.0, 0.0, 0.0, -100, -100, -100, 100, 100, 100, 100, false);
        this.lightScales = new XYZScaleGroup(renderingFrame, "Light-Point", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        Perspective lightPerspective = new Perspective(this.scrollableImage, this.lightScales, new Color(this.display, 255, 255, 129), 2);
        lightPerspective.show();
        this.ambientScales = new SingleVerticalScaleGroup(renderingFrame, "Amb.", "Ambient light", "diffusion_focus.png", 10.0, 0.1, 0, 20, 100, false);
        this.lightColorScales = new ColorScaleGroup(renderingFrame, "Light-Color", 255, 255, 255, 255, 100, false);
        ((GridData)this.lightColorScales.getGroup().getLayoutData()).verticalSpan = 2;
        this.ambientShiftScales = new SingleHorizontalScaleGroup(renderingFrame, "Ambient Light Color Shift", "Hue-Shift", "hue_focus.png", 10.0, 0.0, -10, 10, 125, false);
        ((GridData)this.ambientShiftScales.getGroup().getLayoutData()).horizontalSpan = 2;
        Composite envMaterialFrame = new Composite(renderingFrame, 0);
        envMaterialFrame.setLayout(SWTUtils.gridLayout(3, false, 5, 5, 0, 0, 0, 0, 0, 0));
        envMaterialFrame.setLayoutData(SWTUtils.gridData(4, 4, 0, 0, -1, -1, false, false));
        ((GridData)envMaterialFrame.getLayoutData()).horizontalSpan = 3;
        this.materialScales = new MaterialScaleGroup(envMaterialFrame, "Material", 0.5, 0.0, 0.0, 0.0, 100, false);
        this.envImageGroup = new ImageGroup(envMaterialFrame, "Environment Images (sourrounding box)", new String[]{"Front:", "Left:", "Upper:", "Back:", "Right:", "Lower:"}, new String[6], new File[6][], new String[][]{{"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true, true, true, true, true, true}, new Boolean[]{false, false, false, false, false, false}, new Boolean[]{false, false, false, false, false, false}, 50, 150);
        this.sourroundingCheckButtons = new CheckButtonGroup(envMaterialFrame, "Walls", new String[]{"Left", "Right", "Ceiling", "Floor", "Front", "Back"}, new String[6], new boolean[6], 50, true, false);
        TabItem renderingTab = new TabItem(tabFolder, 0);
        renderingTab.setText("Rendering");
        renderingTab.setControl(renderingFrame);
        Composite filterFrame = new Composite(tabFolder, 0);
        filterFrame.setLayout(new GridLayout(3, false));
        filterFrame.setLayoutData(new GridData(4, 4, true, true));
        this.bgImageGroup = new ImageGroup(filterFrame, "Background Image", new String[]{"Background"}, new String[1], new File[1][], new String[][]{{"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true}, new Boolean[]{false}, new Boolean[]{false}, 75, 200);
        ((GridData)this.bgImageGroup.getGroup().getLayoutData()).horizontalSpan = 3;
        this.bgScales = new ColorScaleGroup(filterFrame, "Background Color", 0, 0, 0, 0, 100, false);
        this.focusFilterScales = new FocusScaleGroup(filterFrame, "Focus", 0.0, 0.0, 100, false);
        this.hsbScales = new HSBScaleGroup(filterFrame, "HSB-Filter", 0.0, 1.0, 1.0, 100, false);
        this.shiftColorScales = new ColorScaleGroup(filterFrame, "Shift Color", 0, 0, 255, 255, 100, false);
        this.colorShiftScales = new ColorShiftScaleGroup(filterFrame, "Shift", 0.0, 0.0, 100, false);
        TabItem filterTab = new TabItem(tabFolder, 0);
        filterTab.setText("Filter");
        filterTab.setControl(filterFrame);
        Composite imageFrame = new Composite(tabFolder, 0);
        imageFrame.setLayout(new GridLayout(2, false));
        imageFrame.setLayoutData(new GridData(4, 4, true, false));
        this.zoomScale = new ZoomScaleGroup(imageFrame, "Zoom", 100.0, true, 100, false);
        this.zoomScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                FractalGUI.this.scrollableImage.setZoom((double)FractalGUI.this.zoomScale.getZoom() / 100.0);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        Group statisticsFrame = new Group(imageFrame, 0);
        statisticsFrame.setText("Scan Statistics");
        statisticsFrame.setLayout(new GridLayout(1, false));
        statisticsFrame.setLayoutData(new GridData(4, 4, true, false));
        ((GridData)statisticsFrame.getLayoutData()).horizontalSpan = 1;
        this.statisticsText = new Text(statisticsFrame, 10);
        this.statisticsText.setLayoutData(SWTUtils.gridData(4, 1, 0, 0, 100, 120, true, false));
        this.jpgScale = new SingleHorizontalScaleGroup(imageFrame, "JPEG Parameters", "Quality", null, 20.0, 0.9, 10, 20, 100, true);
        ((GridData)this.jpgScale.getGroup().getLayoutData()).horizontalSpan = 2;
        TabItem imageTab = new TabItem(tabFolder, 0);
        imageTab.setText("View");
        imageTab.setControl(imageFrame);
        Composite movieFrame = new Composite(tabFolder, 0);
        movieFrame.setLayout(new GridLayout(1, false));
        movieFrame.setLayoutData(new GridData(4, 4, true, false));
        String[][] stringArray = new String[2][];
        stringArray[0] = new String[0];
        String[][] stringArray2 = new String[2][];
        stringArray2[0] = new String[0];
        Boolean[] booleanArray = new Boolean[2];
        booleanArray[1] = false;
        this.movieFolderGroup = new FileGroup(movieFrame, "Output Files", new String[]{"Folder:", "Base-Name:"}, new String[]{"The directory where all images should be stored", "Pre-fix for all image names e.g. \"img\" for \"img00001.jpg\", \"img00002.jpg\", ..."}, new File[2][], stringArray, stringArray2, booleanArray, new Boolean[]{false, false}, new Boolean[2], 100, 200, true, false);
        this.imgCountScale = new HorizontalScaleGroup(movieFrame, "Number of Images", new String[]{"Number of Images", "Skip first Images (could be used to complete a prevously stopped calculation)"}, Icons.getSWTImages(this.display, "size_focus.png", "levels_focus.png"), new double[]{10.0, 0.0}, new ScaleGroup.Function[]{ScaleGroup.linear(0.1, 0), ScaleGroup.linear(0.1, 0)}, new int[2], new int[]{100, 100}, new int[]{256, 256}, new int[]{100, 100}, true);
        this.movieTransScales = new HorizontalScaleGroup(movieFrame, "Transformations", new String[]{"Change size of search area by this factor:\n< 0: zoom in\n > 0: zoom out"}, Icons.getSWTImages(this.display, "zoom_focus.png"), new double[]{0.9}, new ScaleGroup.Function[]{ScaleGroup.linear(100.0, 0)}, new int[]{50}, new int[]{200}, new int[]{256}, new int[]{100}, true);
        String[] stringArray3 = new String[2];
        stringArray3[1] = "Notice: Use view position = (0,0,-1), change rotation instead";
        this.movieControlGroup = new CheckButtonGroup(movieFrame, "Movie mode", new String[]{"Shrink/extend depth", "ENABLE/DISABLE MOVIE MODE"}, stringArray3, new boolean[2], 450, true, false);
        this.imgCountScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void finished(WidgetGroup group, int index, int field) {
                FractalGUI.this.imgCount = FractalGUI.this.movieControlGroup.isSelected(1) ? (int)(FractalGUI.this.imgCountScale.getValue(0) + 0.5) : 0;
            }

            @Override
            public void edited(WidgetGroup group, int index, int field) {
            }
        });
        this.movieControlGroup.getCheckButton(1).addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                int n = FractalGUI.this.imgCount = FractalGUI.this.movieControlGroup.isSelected(1) ? (int)(FractalGUI.this.imgCountScale.getValue(0) + 0.5) : 0;
                if (FractalGUI.this.movieControlGroup.isSelected(1)) {
                    if (FractalGUI.this.movieFolderGroup.getFiles(0) == null || FractalGUI.this.movieFolderGroup.getFiles(0)[0] == null || !FractalGUI.this.movieFolderGroup.getFiles(0)[0].isDirectory() || FractalGUI.this.movieFolderGroup.getFiles(1) == null || FractalGUI.this.movieFolderGroup.getFiles(0)[0] == null || FractalGUI.this.movieFolderGroup.getFiles(0)[0].getName().isEmpty()) {
                        FractalGUI.this.showWarning("Don't forget to set a folder and a base name for the images to be stored before starting the image creation process. Otherwise no images will be stored.");
                    }
                    FractalGUI.this.origBounds = FractalGUI.this.boundScales.getBounds();
                } else {
                    FractalGUI.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FractalGUI.this.x0 = ((FractalGUI)(this).FractalGUI.this).origBounds.x0;
                            (this).FractalGUI.this.boundScales.setValue(0, FractalGUI.this.x0);
                            FractalGUI.this.y0 = ((FractalGUI)(this).FractalGUI.this).origBounds.y0;
                            (this).FractalGUI.this.boundScales.setValue(1, FractalGUI.this.y0);
                            FractalGUI.this.z0 = ((FractalGUI)(this).FractalGUI.this).origBounds.z0;
                            (this).FractalGUI.this.boundScales.setValue(2, FractalGUI.this.z0);
                            FractalGUI.this.width = FractalGUI.this.origBounds.width();
                            (this).FractalGUI.this.boundScales.setValue(3, FractalGUI.this.width);
                            FractalGUI.this.height = FractalGUI.this.origBounds.height();
                            (this).FractalGUI.this.boundScales.setValue(4, FractalGUI.this.height);
                            FractalGUI.this.depth = FractalGUI.this.origBounds.depth();
                            (this).FractalGUI.this.boundScales.setValue(5, FractalGUI.this.depth);
                        }
                    });
                }
            }
        });
        this.movieControlGroup.getCheckButton(1).addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                FractalGUI.this.imgSkip = (int)(FractalGUI.this.imgCountScale.getValue(1) + 0.5);
            }
        });
        TabItem movieTab = new TabItem(tabFolder, 0);
        movieTab.setText("Anim.");
        movieTab.setControl(movieFrame);
        Point size = this.shell.computeSize(-1, -1);
        this.shell.setSize(Math.min(1800, size.x), Math.min(1200, size.y));
        try {
            this.scrollableImage.setE3DImage(Icons.getE3DImageSWT("e3d_persp.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Getter<E3DVector> voxelSizeGetter = new Getter<E3DVector>(){

            @Override
            public E3DVector get() {
                return FractalGUI.this.voxelSize;
            }
        };
        Getter<E3DVector> viewPosGetter = new Getter<E3DVector>(){

            @Override
            public E3DVector get() {
                return FractalGUI.this.viewPos;
            }
        };
        Getter<float[][][]> xyzBufferGetter = new Getter<float[][][]>(){

            @Override
            public float[][][] get() {
                return FractalGUI.this.xyzBuffer;
            }
        };
        Getter<double[]> dMinMaxGetter = new Getter<double[]>(){

            @Override
            public double[] get() {
                return FractalGUI.this.dMinMax;
            }
        };
        ImageLocator imageLocator = new ImageLocator(this.scrollableImage, voxelSizeGetter, viewPosGetter, xyzBufferGetter, dMinMaxGetter);
        imageLocator.addZoomListener(new ImageLocator.ZoomListener(){

            @Override
            public void zoom(double x, double y, double z, double dx, double dy, double dz) {
                double x0 = FractalGUI.this.boundScales.getValue(0);
                double y0 = FractalGUI.this.boundScales.getValue(1);
                double z0 = FractalGUI.this.boundScales.getValue(2);
                double x1 = FractalGUI.this.boundScales.getValue(3) + x0;
                double y1 = FractalGUI.this.boundScales.getValue(4) + y0;
                double z1 = FractalGUI.this.boundScales.getValue(5) + z0;
                FractalGUI.this.boundScales.setValue(0, Math.max(x0, x - dx));
                FractalGUI.this.boundScales.setValue(1, Math.max(y0, y - dy));
                FractalGUI.this.boundScales.setValue(2, Math.max(z0, z - dz));
                FractalGUI.this.boundScales.setValue(3, Math.min(x1, x + dx) - Math.max(x0, x - dx));
                FractalGUI.this.boundScales.setValue(4, Math.min(y1, y + dy) - Math.max(y0, y - dy));
                FractalGUI.this.boundScales.setValue(5, Math.min(z1, z + dz) - Math.max(z0, z - dz));
                if (FractalGUI.this.auto) {
                    FractalGUI.this.restart(SpaceGUI.Step.SCANNING);
                }
            }
        });
        this.prepare4AutomaticReStart();
        this.coolBar.setStartable(true);
        this.run();
    }

    @Override
    protected ScrollableImage getScrollableImage() {
        return this.scrollableImage;
    }

    @Override
    protected E3DMaterial getDefaultMaterial() {
        return new E3DMaterial(this.materialScales.getGloss(), this.materialScales.getMirror(), this.materialScales.getGlow(), this.glowColorScales.getColor(), this.materialScales.getRefractivity());
    }

    @Override
    protected E3DVector getViewPosition() {
        E3DVector pos = this.viewScales.getXYZ();
        double dist = this.distanceScales.getValue();
        pos.norm(dist <= 0.0 ? 100000.0 : dist);
        return pos;
    }

    @Override
    protected E3DVector getFocusPoint() {
        return this.focusScales.getXYZ();
    }

    @Override
    protected List<E3DVector> getLightPositions() {
        ArrayList<E3DVector> lightPositions = new ArrayList<E3DVector>(1);
        E3DVector pos = this.lightScales.getXYZ();
        double dist = this.distanceScales.getValue();
        pos.norm(dist <= 0.0 ? 100000.0 : dist);
        lightPositions.add(pos);
        return lightPositions;
    }

    @Override
    protected int getLightColor() {
        return this.lightColorScales.getColor();
    }

    @Override
    protected int getAmbientLightColor() {
        double shift = this.ambientShiftScales.getValue();
        return E3DColor.changeHSB(this.lightColorScales.getColor(), shift, 1.0, 1.0);
    }

    @Override
    protected double getAmbient() {
        return this.ambientScales.getValue();
    }

    @Override
    protected double getHue() {
        return this.hsbScales.getHue();
    }

    @Override
    protected double getSaturation() {
        return this.hsbScales.getSaturation();
    }

    @Override
    protected double getBrightness() {
        return this.hsbScales.getBrightness();
    }

    @Override
    protected int getBGColor() {
        return this.bgScales.getColor();
    }

    @Override
    protected int getShiftColor() {
        return this.shiftColorScales.getColor();
    }

    @Override
    protected double getBlueShift() {
        return this.colorShiftScales.getBlueShift();
    }

    @Override
    protected double getWhiteShift() {
        return this.colorShiftScales.getWhiteShift();
    }

    @Override
    public double getMaxBlurRadius() {
        return this.focusFilterScales.getMaxBlurRadius();
    }

    @Override
    public double getFocalDistance() {
        return this.focusFilterScales.getFocalDistance();
    }

    @Override
    protected E3DImage getBGImage() {
        E3DImageSWT[] images = this.bgImageGroup.getImages(0);
        return images != null && images.length > 0 ? images[0] : null;
    }

    @Override
    protected E3DBoundingBox getBounds() {
        return this.boundScales.getBounds();
    }

    @Override
    protected int getImageWidth() {
        return (int)this.resolutionScales.getWidth();
    }

    @Override
    protected int getImageHeight() {
        return (int)this.resolutionScales.getHeight();
    }

    @Override
    protected int getZBufferDepth() {
        return (int)this.resolutionScales.getDepth();
    }

    @Override
    protected E3DEnvironment getEnvironment() {
        E3DImage leftImg = ArrayUtils.get(this.envImageGroup.getImages(1), 0, null);
        E3DImage upperImg = ArrayUtils.get(this.envImageGroup.getImages(2), 0, null);
        E3DImage frontImg = ArrayUtils.get(this.envImageGroup.getImages(0), 0, null);
        E3DImage rightImg = ArrayUtils.get(this.envImageGroup.getImages(4), 0, null);
        E3DImage lowerImg = ArrayUtils.get(this.envImageGroup.getImages(5), 0, null);
        E3DImage backImg = ArrayUtils.get(this.envImageGroup.getImages(3), 0, null);
        if (leftImg != null || upperImg != null || frontImg != null || rightImg != null || lowerImg != null || backImg != null) {
            E3DBoundingBox bounds = this.getBounds();
            E3DBoxEnvironment box = new E3DBoxEnvironment(this.envDirectlyVisible, bounds, leftImg, rightImg, upperImg, lowerImg, frontImg, backImg);
            return box;
        }
        return null;
    }

    @Override
    protected ProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    protected ProgressListener getSubProgressListener() {
        return this.subProgressListener;
    }

    @Override
    protected void setViews(E3DVector viewPos, E3DVector focusPoint, Collection<E3DLight> lights) throws InterruptedException {
        if (this.scan instanceof E3DHybridSubjectScan) {
            ((E3DHybridSubjectScan)this.scan).addProgressListener(this.subProgressListener);
            ((E3DHybridSubjectScan)this.scan).setViews(viewPos, focusPoint, lights);
            ((E3DHybridSubjectScan)this.scan).removeProgressListener(this.subProgressListener);
        }
    }

    @Override
    public float getJPGQuality() {
        return (float)this.jpgScale.getValue();
    }

    @Override
    public boolean hasLoadItem() {
        return false;
    }

    @Override
    public boolean isStartable() {
        return true;
    }

    @Override
    public boolean hasEditMenu() {
        return false;
    }

    @Override
    public boolean hasViewMenu() {
        return false;
    }

    @Override
    public void load() {
    }

    @Override
    public void save() {
        this.fractalImageFile = this.saveImage("Save Fractal Image", this.filteredImage, this.fractalImageFile);
    }

    @Override
    public void start() {
        if (this.future != null) {
            this.showBusyMessage();
        } else {
            if (this.imgCount > 0) {
                this.imgIndex = 0;
                while (this.imgIndex < this.imgSkip) {
                    this.changeBounds4NextFrame();
                    ++this.imgIndex;
                }
                this.movieProgressListener.init(this.imgCount, "MOVIE");
                this.movieProgressListener.done(this.imgIndex, "Created " + this.imgIndex + " / " + this.imgCount + " images");
            } else {
                this.movieProgressListener.finish();
            }
            this.restart(SpaceGUI.Step.COMPLETE);
        }
    }

    @Override
    public void stop() {
        if (this.imgCount > 0) {
            this.imgIndex = this.imgCount;
            this.movieProgressListener.finish();
        }
        super.stop();
    }

    protected E3DObjectScan scanning() throws Exception {
        Space scan;
        this.statistics.clear();
        int width = (int)this.resolutionScales.getWidth();
        int height = (int)this.resolutionScales.getHeight();
        int depth = (int)this.resolutionScales.getDepth();
        E3DBoundingBox bounds = this.boundScales.getBounds();
        switch (this.scanType.getType()) {
            case PHYSICAL_OBJECT: {
                int scanLevels = (int)this.scanLevelsScales.getValue();
                int subDivisions = (int)this.normalPrecisionScales.getValue();
                scan = new E3DPhysicalObjectScan(bounds, width, height, depth, scanLevels, subDivisions);
                break;
            }
            case PHYSICAL_SUBJECT: {
                double compensation = this.compensationScales.getValue();
                scan = new E3DPhysicalSubjectScan(bounds, width, height, depth, compensation, false);
                break;
            }
            case VIRTUAL_SUBJECT: {
                double compensation = this.compensationScales.getValue();
                scan = new E3DVirtualSubjectScan(bounds, width, height, depth, compensation);
                break;
            }
            case HYBRID_SUBJECT: {
                double compensation = this.compensationScales.getValue();
                scan = new E3DHybridSubjectScan(bounds, width, height, depth, compensation);
                break;
            }
            default: {
                throw new RuntimeException("Unkown scan method");
            }
        }
        E3DVector voxelSize = scan.getElementSize();
        boolean solid = this.fractalType.isSolid();
        int maxIter = this.iterationScales.getMaxIter();
        double bailOut = solid ? this.iterationScales.getBailOut() : 0.0;
        double maxDist = this.iterationScales.getDistance() * voxelSize.mean();
        double minDist = Math.max(0.0, maxDist - voxelSize.min() / 2.0);
        FractalType type = this.fractalType.getType();
        FractalEstimator estimator = this.fractalType.getEstimator();
        MyQuaternion.QuaternionSummarizer summarizer = this.fractalType.getSummarizer();
        MyQuaternion.QuaternionMultiplicator multiplicator = this.fractalType.getMultiplactor();
        Integer objectColor = this.objectColorScales.getColor();
        if (multiplicator instanceof MyQuaternion.QuaternionMultiplicator.BulbMultiplicator) {
            ((MyQuaternion.QuaternionMultiplicator.BulbMultiplicator)multiplicator).n = this.bulbScales.getValue();
        } else if (multiplicator instanceof MyQuaternion.QuaternionMultiplicator.BoxMultiplicator) {
            ((MyQuaternion.QuaternionMultiplicator.BoxMultiplicator)multiplicator).s = this.boxScales.getValue();
        }
        FractalColorizer colorizer = this.fractalType.getColorizer();
        if (colorizer instanceof FractalColorizer.FixedColorizer) {
            ((FractalColorizer.FixedColorizer)colorizer).setColor(objectColor);
        }
        if (colorizer instanceof FractalColorizer.GlowColorizer) {
            ((FractalColorizer.GlowColorizer)colorizer).setGlowColor(this.glowColorScales.getColor());
            ((FractalColorizer.GlowColorizer)colorizer).setGlowRadius(this.glowRadiusScales.getValue(0));
            ((FractalColorizer.GlowColorizer)colorizer).setBlurRadius(this.glowRadiusScales.getValue(0) / 2.0);
            ((FractalColorizer.GlowColorizer)colorizer).setGlowShape(this.glowShapeRadioButtons.getSelected() == 0 ? FractalColorizer.GlowColorizer.GlowShape.SPHERE : FractalColorizer.GlowColorizer.GlowShape.CUBE);
            ((FractalColorizer.GlowColorizer)colorizer).setJulia(type == FractalType.JULIA);
        }
        if (colorizer instanceof FractalColorizer.SingleOrbitTrapColorizer) {
            ((FractalColorizer.SingleOrbitTrapColorizer)colorizer).setFrequency(this.objectColorFrequencyScales.getValue());
        }
        if (colorizer instanceof FractalColorizer.EstimatedDistanceColorizer) {
            ((FractalColorizer.EstimatedDistanceColorizer)colorizer).setFrequency(this.objectColorFrequencyScales.getValue());
        }
        E3DSubject object = null;
        switch (type) {
            case MANDELBROT: {
                double t0 = this.c0Scales.getT();
                Quaternion z0 = this.z0Scales.getXYZT();
                MyQuaternion myZ0 = new MyQuaternion(z0);
                myZ0.setMultiplicator(multiplicator);
                myZ0.setSummarizer(summarizer);
                object = new Mandelbrot3D(bailOut, maxIter, maxDist, minDist, estimator, colorizer, myZ0, t0);
                break;
            }
            case JULIA: {
                double t0 = this.z0Scales.getT();
                Quaternion c0 = this.c0Scales.getXYZT();
                MyQuaternion myC0 = new MyQuaternion(c0);
                myC0.setMultiplicator(multiplicator);
                myC0.setSummarizer(summarizer);
                object = new Julia3D(bailOut, maxIter, maxDist, minDist, estimator, colorizer, myC0, t0);
                break;
            }
            default: {
                throw new RuntimeException("Unkown fractal type: " + (Object)((Object)type));
            }
        }
        double scaleFactor = this.scaleScales.getValue();
        if (scaleFactor != 1.0) {
            E3DScale scale = new E3DScale(1.0 / scaleFactor);
            object = new E3DTransformedSubject(object, scale, E3DIdentity.IDENTITY, scaleFactor);
        }
        E3DVector translation = this.translationScales.getXYZ();
        if (translation.x != 0.0 || translation.y != 0.0 || translation.z != 0.0) {
            E3DTranslation shift = new E3DTranslation(translation);
            object = new E3DTransformedSubject(object, shift, E3DIdentity.IDENTITY, 1.0);
        }
        E3DVector rotation = this.rotationScales.getXYZ();
        if (rotation.x != 0.0 || rotation.y != 0.0 || rotation.z > 0.0) {
            E3DRotation unspin = new E3DRotation(rotation, false, false, false);
            E3DRotation spin = new E3DRotation(rotation, true, true, true);
            object = new E3DTransformedSubject(object, spin, unspin, 1.0);
        }
        if (solid) {
            object = new E3DIntersectionSubject(object, new E3DCubicSubject(bounds, -1));
        }
        double p = 0.1;
        double q = 0.9;
        double f = 0.0;
        double g = 1.0;
        double w = bounds.width();
        double h = bounds.height();
        double d = bounds.depth();
        if (this.sourroundingCheckButtons.isSelected(0)) {
            object = new E3DMultiSubject(object, new E3DCubicSubject(bounds.x0, bounds.y0 - h * 0.0, bounds.z0 - d * 0.0, bounds.x0 + w * 0.1, bounds.y0 + h * 1.0, bounds.z0 + d * 1.0, objectColor));
        }
        if (this.sourroundingCheckButtons.isSelected(1)) {
            object = new E3DMultiSubject(object, new E3DCubicSubject(bounds.x0 + w * 0.9, bounds.y0 - h * 0.0, bounds.z0 - d * 0.0, bounds.x0 + w, bounds.y0 + h * 1.0, bounds.z0 + d * 1.0, objectColor));
        }
        if (this.sourroundingCheckButtons.isSelected(2)) {
            object = new E3DMultiSubject(object, new E3DCubicSubject(bounds.x0 - w * 0.0, bounds.y0, bounds.z0 - d * 0.0, bounds.x0 + w * 1.0, bounds.y0 + h * 0.1, bounds.z0 + d * 1.0, objectColor));
        }
        if (this.sourroundingCheckButtons.isSelected(3)) {
            object = new E3DMultiSubject(object, new E3DCubicSubject(bounds.x0 - w * 0.0, bounds.y0 + h * 0.9, bounds.z0 - d * 0.0, bounds.x0 + w * 1.0, bounds.y0 + h, bounds.z0 + d * 1.0, objectColor));
        }
        if (this.sourroundingCheckButtons.isSelected(4)) {
            object = new E3DMultiSubject(object, new E3DCubicSubject(bounds.x0 - w * 0.0, bounds.y0 - h * 0.0, bounds.z0, bounds.x0 + w * 1.0, bounds.y0 + h * 1.0, bounds.z0 + d * 0.1, objectColor));
        }
        if (this.sourroundingCheckButtons.isSelected(5)) {
            object = new E3DMultiSubject(object, new E3DCubicSubject(bounds.x0 - w * 0.0, bounds.y0 - h * 0.0, bounds.z0 + d * 0.9, bounds.x0 + w * 1.0, bounds.y0 + h * 1.0, bounds.z0 + d, objectColor));
        }
        scan.addProgressListener(this.subProgressListener);
        scan.setStatistics(this.statistics);
        scan.setObject(object);
        scan.removeProgressListener(this.subProgressListener);
        return scan;
    }

    @Override
    protected void showStatistics(final String text) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FractalGUI.this.statisticsText.setText(text);
            }
        });
    }

    @Override
    public void help() {
        new E3DHelp(this.display, NAME, HELP_URI, this);
    }

    @Override
    public void about() {
        this.about(NAME, "V3.5");
    }

    @Override
    protected void finish() {
        if (this.imgCount > 0 && this.imgIndex < this.imgCount && this.movieFolderGroup.getFiles(0) != null && this.movieFolderGroup.getFiles(0)[0] != null && this.movieFolderGroup.getFiles(1) != null && this.movieFolderGroup.getFiles(1)[0] != null) {
            ++this.imgIndex;
            File file = new File(this.movieFolderGroup.getFiles(0)[0], String.format("%s%04d.jpg", this.movieFolderGroup.getFiles(1)[0].getName(), this.imgIndex));
            E3DImageAWT awtImg = new E3DImageAWT(this.filteredImage, 1);
            awtImg.setJPGQuality(this.getJPGQuality());
            try {
                ((E3DImage)awtImg).save(file, E3DImage.Format.JPG);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            this.movieProgressListener.done(this.imgIndex, "Created " + this.imgIndex + " / " + this.imgCount + " images");
            if (this.imgIndex < this.imgCount) {
                this.changeBounds4NextFrame();
                this.restart(SpaceGUI.Step.COMPLETE);
            } else {
                this.movieProgressListener.finish();
            }
        }
    }

    private void changeBounds4NextFrame() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                int i = FractalGUI.this.xyzBuffer.length / 2;
                int j = FractalGUI.this.xyzBuffer[i].length / 2;
                float xm = FractalGUI.this.xyzBuffer[i][j][0];
                float ym = FractalGUI.this.xyzBuffer[i][j][1];
                float zm = FractalGUI.this.xyzBuffer[i][j][2];
                double f = FractalGUI.this.movieTransScales.getValue(0);
                double w = FractalGUI.this.boundScales.getWidth() * f;
                double h = FractalGUI.this.boundScales.getHeight() * f;
                double d = FractalGUI.this.boundScales.getDepth() * f;
                FractalGUI.this.boundScales.setValue(0, (double)xm - w / 2.0);
                FractalGUI.this.boundScales.setValue(3, w);
                FractalGUI.this.boundScales.setValue(1, (double)ym - h / 2.0);
                FractalGUI.this.boundScales.setValue(4, h);
                if (FractalGUI.this.movieControlGroup.isSelected(0)) {
                    FractalGUI.this.boundScales.setValue(2, (double)zm - d / 2.0);
                    FractalGUI.this.boundScales.setValue(5, d);
                } else {
                    int zr = Math.max(1, (int)(FractalGUI.this.resolutionScales.getDepth() / f));
                    FractalGUI.this.resolutionScales.setValue(2, zr);
                }
            }
        });
    }

    protected void prepare4AutomaticReStart() {
        WidgetGroupEditedListener scanningListener = this.getAutoListener(SpaceGUI.Step.SCANNING);
        this.c0Scales.addListener(scanningListener);
        this.z0Scales.addListener(scanningListener);
        this.iterationScales.addListener(scanningListener);
        this.boundScales.addListener(scanningListener);
        this.boundControlButtons.addListener(scanningListener);
        this.resolutionScales.addListener(scanningListener);
        this.fractalType.addListener(scanningListener);
        this.scanLevelsScales.addListener(scanningListener);
        this.normalPrecisionScales.addListener(scanningListener);
        this.compensationScales.addListener(scanningListener);
        this.rotationScales.addListener(scanningListener);
        this.translationScales.addListener(scanningListener);
        this.scaleScales.addListener(scanningListener);
        this.objectColorScales.addListener(scanningListener);
        this.objectColorFrequencyScales.addListener(scanningListener);
        this.scanType.addListener(scanningListener);
        this.bulbScales.addListener(scanningListener);
        this.boxScales.addListener(scanningListener);
        this.sourroundingCheckButtons.addListener(scanningListener);
        this.glowColorScales.addListener(scanningListener);
        this.glowRadiusScales.addListener(scanningListener);
        this.glowShapeRadioButtons.addListener(scanningListener);
        WidgetGroupEditedListener renderingListener = this.getAutoListener(SpaceGUI.Step.RENDERING);
        this.focusScales.addListener(renderingListener);
        this.viewScales.addListener(renderingListener);
        this.distanceScales.addListener(renderingListener);
        this.lightScales.addListener(renderingListener);
        this.lightColorScales.addListener(renderingListener);
        this.materialScales.addListener(renderingListener);
        this.ambientScales.addListener(renderingListener);
        this.ambientShiftScales.addListener(renderingListener);
        this.envImageGroup.addListener(renderingListener);
        WidgetGroupEditedListener filteringListener = this.getAutoListener(SpaceGUI.Step.FILTERING);
        this.hsbScales.addListener(filteringListener);
        this.bgScales.addListener(filteringListener);
        this.shiftColorScales.addListener(filteringListener);
        this.colorShiftScales.addListener(filteringListener);
        this.focusFilterScales.addListener(filteringListener);
        this.bgImageGroup.addListener(filteringListener);
    }

    public static void main(String[] args) {
        new FractalGUI();
    }
}

