/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui;

import e3d.gui.icons.Icons;
import e3d.gui.images.ScrollableImage;
import e3d.gui.utils.E3DCoolBar;
import e3d.gui.utils.E3DFileDialog;
import e3d.gui.utils.E3DLicenseWindow;
import e3d.gui.utils.E3DMenu;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageAWT;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class E3DGUI {
    protected volatile Future<?> future = null;
    protected volatile Runnable next = null;
    protected final Object sync = new Object();
    protected final Display display;
    protected final Shell shell;
    protected final E3DMenu menu;
    protected final E3DCoolBar coolBar;
    protected final ExecutorService executorService = Executors.newCachedThreadPool();

    public E3DGUI() {
        this.display = new Display();
        if (!new E3DLicenseWindow().open(this.display)) {
            this.exit();
        }
        this.shell = new Shell(this.display);
        Icons.setIcons(this.shell);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.shell.setLayout(layout);
        this.menu = new E3DMenu(this.shell, this);
        this.coolBar = new E3DCoolBar(this.shell, this);
        this.shell.addShellListener(new ShellListener(){

            @Override
            public void shellActivated(ShellEvent e) {
            }

            @Override
            public void shellClosed(ShellEvent e) {
                E3DGUI.this.exit();
            }

            @Override
            public void shellDeactivated(ShellEvent e) {
            }

            @Override
            public void shellDeiconified(ShellEvent e) {
            }

            @Override
            public void shellIconified(ShellEvent e) {
            }
        });
    }

    protected void run() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            try {
                boolean sleep;
                boolean bl = sleep = !this.display.readAndDispatch();
                if (!sleep) continue;
                this.display.sleep();
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public abstract boolean hasLoadItem();

    public abstract boolean isStartable();

    public abstract boolean hasEditMenu();

    public abstract boolean hasViewMenu();

    public abstract boolean hasOptionsMenu();

    public abstract void setAutomaticRestart(boolean var1);

    public abstract float getJPGQuality();

    public abstract void load();

    public abstract void save();

    public abstract void start();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (this.next != null) {
                this.next = null;
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }

    public abstract void help();

    public abstract void about();

    public void exit() {
        try {
            this.executorService.shutdown();
            this.shell.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void undo() {
    }

    public void redo() {
    }

    public void copy() {
    }

    public void cut() {
    }

    public void paste() {
    }

    public void delete() {
    }

    protected File saveImage(String title, E3DImage image, File file) {
        if (image != null) {
            E3DFileDialog dialog = new E3DFileDialog(this.shell, title, 8192, new File[]{file}, new String[]{"PNG", "JPG"}, new String[]{"*.png;*.PNG", "*.jpg;*.JPG;*.jpeg;*.JPEG"});
            File[] selection = dialog.open();
            if (selection != null) {
                try {
                    String upperFileName = selection[0].getName().toUpperCase();
                    if (upperFileName.endsWith("PNG")) {
                        image.save(selection[0], E3DImage.Format.PNG);
                    } else if (upperFileName.endsWith("JPG") || upperFileName.endsWith("JPEG")) {
                        E3DImageAWT awtImg = new E3DImageAWT(image, 1);
                        awtImg.setJPGQuality(this.getJPGQuality());
                        ((E3DImage)awtImg).save(selection[0], E3DImage.Format.JPG);
                    } else {
                        MessageBox msgBox = new MessageBox(this.shell, 33);
                        msgBox.setText("Error Writing Image");
                        msgBox.setMessage("Format not supported");
                        msgBox.open();
                    }
                }
                catch (Exception exception) {
                    MessageBox msgBox = new MessageBox(this.shell, 33);
                    msgBox.setText("Error Writing Image");
                    msgBox.setMessage(exception.getMessage());
                    msgBox.open();
                }
                return selection[0];
            }
        } else {
            MessageBox msgBox = new MessageBox(this.shell, 33);
            msgBox.setText("No Image");
            msgBox.setMessage("There is no image to save - create one first...");
            msgBox.open();
        }
        return file;
    }

    protected void about(String name, String version) {
        MessageBox msgBox = new MessageBox(this.shell, 34);
        msgBox.setText("About " + name);
        msgBox.setMessage("Version: " + version + "\n" + "Author: Parick Rammelt\n" + "E-Mail: rammelt@user.cs.tu-berlin.de\n\n" + "THIS IS FREE SOFTWARE\n\n" + "ABSOLUTELY NO WARRENTY");
        msgBox.open();
    }

    protected void showBusyMessage() {
        MessageBox msgBox = new MessageBox(this.shell, 34);
        msgBox.setText("Busy");
        msgBox.setMessage("Calculation is already running...");
        msgBox.open();
    }

    public void showGeneralError(final Throwable throwable) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox msgBox = new MessageBox(E3DGUI.this.shell, 34);
                msgBox.setText("Aborted");
                msgBox.setMessage("Error: " + throwable.getMessage());
                throwable.printStackTrace();
                msgBox.open();
            }
        });
    }

    public void showWarning(final String msg) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox msgBox = new MessageBox(E3DGUI.this.shell, 34);
                msgBox.setText("Warning");
                msgBox.setMessage("Warning: " + msg);
                msgBox.open();
            }
        });
    }

    protected void showInterruptedMessage(InterruptedException exception) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox msgBox = new MessageBox(E3DGUI.this.shell, 34);
                msgBox.setText("Aborted");
                msgBox.setMessage("Calculation aborted - no result image has been created.");
                msgBox.open();
            }
        });
    }

    protected void update(ScrollableImage scrollableImage) {
        scrollableImage.getCanvas().redraw();
    }

    protected void updateFromOtherThread(final ScrollableImage scrollableImage) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                E3DGUI.this.update(scrollableImage);
            }
        });
    }
}

