/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui;

import e3d.gui.E3DGUI;
import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.groups.scales.SingleHorizontalScaleGroup;
import e3d.gui.groups.scales.ZoomScaleGroup;
import e3d.gui.groups.scales.special.BlurScaleGroup;
import e3d.gui.groups.scales.special.DWTScaleGroup;
import e3d.gui.groups.scales.special.TileScaleGroup;
import e3d.gui.groups.special.DWTFilterComboGroup;
import e3d.gui.groups.special.SyncScrollCheckGroup;
import e3d.gui.icons.Icons;
import e3d.gui.images.ImageProgress;
import e3d.gui.images.NamedScrollableImage;
import e3d.gui.images.ScrollableImage;
import e3d.gui.utils.E3DFileDialog;
import e3d.gui.utils.E3DHelp;
import e3d.visualization.image.E3DImageSWT;
import e3d.wavelet.DWTImageSmoother;
import java.io.File;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DWTSmootherGUI
extends E3DGUI {
    private static final String NAME = "Discrete Wavelet Image Smoother (V3.5)";
    private static final String HELP_URI = "help/dwt/index";
    private static final int IMAGE_DEFAULT_WIDTH = 400;
    private static final int IMAGE_DEFAULT_HEIGHT = 400;
    protected File smoothedImageFile = null;
    protected File originalImageFile = null;
    protected E3DImageSWT smoothedImage = null;
    protected E3DImageSWT unfilteredImage = null;
    protected final NamedScrollableImage smoothedScrollableImage;
    protected final NamedScrollableImage originalScrollableImage;
    protected final ImageProgress progressListener;
    protected boolean auto = false;
    protected final DWTFilterComboGroup dwtFilterDropDown;
    protected final DWTScaleGroup dwtScales;
    protected final BlurScaleGroup blurScales;
    protected final TileScaleGroup tileScales;
    final ZoomScaleGroup zoomScale;
    protected final SingleHorizontalScaleGroup jpgScale;
    final SyncScrollCheckGroup scrollingCheckButtons;

    public DWTSmootherGUI() {
        this.shell.setText(NAME);
        Composite main = new Composite(this.shell, 0);
        main.setLayoutData(new GridData(4, 4, true, true));
        main.setLayout(new GridLayout(2, false));
        SashForm verticalSash = new SashForm(main, 512);
        verticalSash.setLayoutData(new GridData(4, 4, true, true));
        ((GridData)verticalSash.getLayoutData()).widthHint = 400;
        ((GridData)verticalSash.getLayoutData()).heightHint = 400;
        this.smoothedScrollableImage = new NamedScrollableImage(verticalSash);
        this.smoothedScrollableImage.setName("SMOOTHED");
        this.progressListener = new ImageProgress(this.smoothedScrollableImage, 0, 1.0);
        this.originalScrollableImage = new NamedScrollableImage(verticalSash);
        this.originalScrollableImage.setName("ORIGINAL");
        Composite controlFrame = new Composite(main, 0);
        controlFrame.setLayout(new GridLayout(1, false));
        controlFrame.setLayoutData(new GridData(4, 4, false, true));
        final TabFolder tabFolder1 = new TabFolder(controlFrame, 128);
        tabFolder1.setLayoutData(new GridData(4, 4, true, true));
        tabFolder1.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                tabFolder1.update();
            }
        });
        Composite dwtFrame = new Composite(tabFolder1, 0);
        dwtFrame.setLayout(new GridLayout(3, false));
        dwtFrame.setLayoutData(new GridData(4, 4, true, false));
        this.dwtFilterDropDown = new DWTFilterComboGroup(dwtFrame, "Filter-Selection", -1);
        ((GridData)this.dwtFilterDropDown.getGroup().getLayoutData()).horizontalSpan = 3;
        this.dwtScales = new DWTScaleGroup(dwtFrame, "DWT", 128, 100, false);
        this.blurScales = new BlurScaleGroup(dwtFrame, "Blur", 64, 5, 1, 100, false);
        this.tileScales = new TileScaleGroup(dwtFrame, "Tiling", 512, 64, 100, false);
        TabItem dwtTab = new TabItem(tabFolder1, 0);
        dwtTab.setText("DWT");
        dwtTab.setControl(dwtFrame);
        final TabFolder tabFolder2 = new TabFolder(controlFrame, 128);
        tabFolder2.setLayoutData(new GridData(4, 4, true, true));
        tabFolder2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                tabFolder2.update();
            }
        });
        Composite imageFrame = new Composite(tabFolder2, 0);
        imageFrame.setLayout(new GridLayout(2, false));
        imageFrame.setLayoutData(new GridData(4, 4, true, false));
        this.zoomScale = new ZoomScaleGroup(imageFrame, "Zoom", 100.0, true, 100, false);
        ((GridData)this.zoomScale.getGroup().getLayoutData()).verticalSpan = 2;
        this.zoomScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                DWTSmootherGUI.this.smoothedScrollableImage.setZoom((double)DWTSmootherGUI.this.zoomScale.getZoom() / 100.0);
                DWTSmootherGUI.this.originalScrollableImage.setZoom((double)DWTSmootherGUI.this.zoomScale.getZoom() / 100.0);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        this.scrollingCheckButtons = new SyncScrollCheckGroup(imageFrame, "Scrolling", new ScrollableImage[]{this.smoothedScrollableImage, this.originalScrollableImage}, -1);
        this.jpgScale = new SingleHorizontalScaleGroup(imageFrame, "JPEG Parameters", "Quality", null, 20.0, 0.9, 10, 20, 100, true);
        TabItem imageTab = new TabItem(tabFolder2, 0);
        imageTab.setText("View");
        imageTab.setControl(imageFrame);
        Point size = this.shell.computeSize(-1, -1);
        this.shell.setSize(Math.min(1800, size.x), Math.min(1200, size.y));
        try {
            this.smoothedScrollableImage.setE3DImage(Icons.getE3DImageSWT("e3d_persp.png"));
            this.originalScrollableImage.setE3DImage(Icons.getE3DImageSWT("e3d_mosaic.png"));
        }
        catch (Exception exception) {
            this.showGeneralError(exception);
        }
        this.prepare4AutomaticRestart();
        this.run();
    }

    @Override
    public float getJPGQuality() {
        return (float)this.jpgScale.getValue();
    }

    @Override
    public boolean hasLoadItem() {
        return true;
    }

    @Override
    public boolean isStartable() {
        return true;
    }

    @Override
    public boolean hasEditMenu() {
        return false;
    }

    @Override
    public boolean hasViewMenu() {
        return false;
    }

    @Override
    public boolean hasOptionsMenu() {
        return true;
    }

    @Override
    public void setAutomaticRestart(boolean auto) {
        this.auto = auto;
        if (auto) {
            this.restart();
        }
    }

    @Override
    public void load() {
        E3DFileDialog dialog = new E3DFileDialog(this.shell, "Load Source Image", 4096, new File[]{this.originalImageFile}, new String[]{"Supported Image Files", "All Files"}, new String[]{"*.jpg;*.png;*.gif;*.JPG;*.PNG;*.GIF", "*.*"});
        File[] selection = dialog.open();
        if (selection != null) {
            this.originalImageFile = selection[0];
            try {
                this.unfilteredImage = new E3DImageSWT(this.originalImageFile);
                this.originalScrollableImage.setE3DImage(this.unfilteredImage);
                this.smoothedImage = null;
                this.smoothedScrollableImage.setE3DImage(this.smoothedImage);
                this.menu.setSavable(false);
                this.coolBar.setSavable(false);
                this.coolBar.setStartable(true);
            }
            catch (Exception exception) {
                MessageBox msgBox = new MessageBox(this.shell, 33);
                msgBox.setText("Load Error");
                msgBox.setMessage(exception.getMessage());
                msgBox.open();
            }
        }
    }

    @Override
    public void save() {
        this.smoothedImageFile = this.saveImage("Save Smoothed Image", this.smoothedImage, this.smoothedImageFile);
    }

    @Override
    public void start() {
        if (this.future != null) {
            this.showBusyMessage();
        } else if (this.unfilteredImage == null) {
            MessageBox msgBox = new MessageBox(this.shell, 34);
            msgBox.setText("No Image");
            msgBox.setMessage("Load an image first...");
            msgBox.open();
        } else {
            this.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block29: {
                    try {
                        Object object = DWTSmootherGUI.this.sync;
                        synchronized (object) {
                            DWTSmootherGUI.this.coolBar.setBusyFromOtherThread(true);
                        }
                        DWTImageSmoother smoother = new DWTImageSmoother();
                        smoother.addProgressListener(DWTSmootherGUI.this.progressListener);
                        smoother.setFilter(DWTSmootherGUI.this.dwtFilterDropDown.getLowPassFilter(), DWTSmootherGUI.this.dwtFilterDropDown.getHeighPassFilter());
                        smoother.setLevel100(DWTSmootherGUI.this.dwtScales.get100PercentLevel());
                        smoother.setBlurDelta(DWTSmootherGUI.this.blurScales.getBlurMaxDelta());
                        smoother.setBlurLevels(DWTSmootherGUI.this.blurScales.getBlurLevels());
                        smoother.setBlurRadius(DWTSmootherGUI.this.blurScales.getBlurRadius());
                        smoother.setTileSizeAndOverlap(DWTSmootherGUI.this.tileScales.getTileSize(), DWTSmootherGUI.this.tileScales.getTileOverlap());
                        DWTSmootherGUI.this.smoothedImage = (E3DImageSWT)smoother.smooth(DWTSmootherGUI.this.unfilteredImage);
                        DWTSmootherGUI.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).DWTSmootherGUI.this.smoothedScrollableImage.setE3DImage((this).DWTSmootherGUI.this.smoothedImage);
                                (this).DWTSmootherGUI.this.menu.setSavable(true);
                                (this).DWTSmootherGUI.this.coolBar.setSavable(true);
                            }
                        });
                    }
                    catch (InterruptedException smoother) {
                        Object object = DWTSmootherGUI.this.sync;
                        synchronized (object) {
                            if (DWTSmootherGUI.this.next != null) {
                                DWTSmootherGUI.this.future = DWTSmootherGUI.this.executorService.submit(DWTSmootherGUI.this.next);
                                DWTSmootherGUI.this.next = null;
                            } else {
                                DWTSmootherGUI.this.future = null;
                            }
                            DWTSmootherGUI.this.progressListener.finish();
                            DWTSmootherGUI.this.updateFromOtherThread(DWTSmootherGUI.this.smoothedScrollableImage);
                            DWTSmootherGUI.this.coolBar.setBusyFromOtherThread(false);
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        Object object;
                        try {
                            DWTSmootherGUI.this.showGeneralError(throwable);
                            object = DWTSmootherGUI.this.sync;
                        }
                        catch (Throwable throwable2) {
                            Object object2 = DWTSmootherGUI.this.sync;
                            synchronized (object2) {
                                if (DWTSmootherGUI.this.next != null) {
                                    DWTSmootherGUI.this.future = DWTSmootherGUI.this.executorService.submit(DWTSmootherGUI.this.next);
                                    DWTSmootherGUI.this.next = null;
                                } else {
                                    DWTSmootherGUI.this.future = null;
                                }
                                DWTSmootherGUI.this.progressListener.finish();
                                DWTSmootherGUI.this.updateFromOtherThread(DWTSmootherGUI.this.smoothedScrollableImage);
                                DWTSmootherGUI.this.coolBar.setBusyFromOtherThread(false);
                            }
                            throw throwable2;
                        }
                        synchronized (object) {
                            if (DWTSmootherGUI.this.next != null) {
                                DWTSmootherGUI.this.future = DWTSmootherGUI.this.executorService.submit(DWTSmootherGUI.this.next);
                                DWTSmootherGUI.this.next = null;
                            } else {
                                DWTSmootherGUI.this.future = null;
                            }
                            DWTSmootherGUI.this.progressListener.finish();
                            DWTSmootherGUI.this.updateFromOtherThread(DWTSmootherGUI.this.smoothedScrollableImage);
                            DWTSmootherGUI.this.coolBar.setBusyFromOtherThread(false);
                            break block29;
                        }
                    }
                    Object object = DWTSmootherGUI.this.sync;
                    synchronized (object) {
                        if (DWTSmootherGUI.this.next != null) {
                            DWTSmootherGUI.this.future = DWTSmootherGUI.this.executorService.submit(DWTSmootherGUI.this.next);
                            DWTSmootherGUI.this.next = null;
                        } else {
                            DWTSmootherGUI.this.future = null;
                        }
                        DWTSmootherGUI.this.progressListener.finish();
                        DWTSmootherGUI.this.updateFromOtherThread(DWTSmootherGUI.this.smoothedScrollableImage);
                        DWTSmootherGUI.this.coolBar.setBusyFromOtherThread(false);
                    }
                }
            }
        };
        Object object = this.sync;
        synchronized (object) {
            if (this.future == null || !this.future.cancel(true)) {
                this.future = this.executorService.submit(task);
            } else {
                this.next = task;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }

    @Override
    public void help() {
        new E3DHelp(this.display, NAME, HELP_URI, this);
    }

    @Override
    public void about() {
        this.about(NAME, "V3.5");
    }

    protected void prepare4AutomaticRestart() {
        WidgetGroupEditedListener renderingListener = this.getAutoListener();
        this.dwtFilterDropDown.addListener(renderingListener);
        this.dwtScales.addListener(renderingListener);
        this.blurScales.addListener(renderingListener);
        this.tileScales.addListener(renderingListener);
    }

    protected WidgetGroupEditedListener getAutoListener() {
        return new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
                if (DWTSmootherGUI.this.auto) {
                    DWTSmootherGUI.this.restart();
                }
            }
        };
    }

    public static void main(String[] args) {
        new DWTSmootherGUI();
    }
}

