/*
 * Decompiled with CFR 0.152.
 */
package e3d.fractal;

import e3d.numbers.ComplexNumber;
import e3d.numbers.E3DNumber;
import e3d.numbers.Quaternion;

public class MyQuaternion
extends Quaternion {
    protected QuaternionMultiplicator multiplicator = QuaternionMultiplicator.DEFAULT;
    protected QuaternionSummarizer summarizer = QuaternionSummarizer.DEFAULT;

    public MyQuaternion() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    public MyQuaternion(double a) {
        this.set(a);
    }

    public MyQuaternion(double a, double b, double c, double d) {
        this.set(a, b, c, d);
    }

    public MyQuaternion(Quaternion q) {
        super(q);
    }

    public MyQuaternion(ComplexNumber c1, ComplexNumber c2) {
        this.set(c1, c2);
    }

    @Override
    public MyQuaternion clone() {
        MyQuaternion quaternion = new MyQuaternion(this.r, this.i, this.j, this.k);
        quaternion.setMultiplicator(this.multiplicator);
        quaternion.setSummarizer(this.summarizer);
        return quaternion;
    }

    @Override
    public MyQuaternion origin() {
        MyQuaternion quaternion = new MyQuaternion(0.0, 0.0, 0.0, 0.0);
        quaternion.setMultiplicator(this.multiplicator);
        quaternion.setSummarizer(this.summarizer);
        return quaternion;
    }

    @Override
    public MyQuaternion quaternion(double a) {
        MyQuaternion quaternion = new MyQuaternion(a);
        quaternion.setMultiplicator(this.multiplicator);
        quaternion.setSummarizer(this.summarizer);
        return quaternion;
    }

    @Override
    public MyQuaternion quaternion(double a, double b, double c, double d) {
        MyQuaternion quaternion = new MyQuaternion(a, b, c, d);
        quaternion.setMultiplicator(this.multiplicator);
        quaternion.setSummarizer(this.summarizer);
        return quaternion;
    }

    @Override
    public Quaternion quaternion(Quaternion quaternion) {
        MyQuaternion copy = new MyQuaternion(quaternion);
        copy.setMultiplicator(this.multiplicator);
        copy.setSummarizer(this.summarizer);
        return copy;
    }

    @Override
    public Quaternion quaternion(ComplexNumber c1, ComplexNumber c2) {
        MyQuaternion quaternion = new MyQuaternion(c1, c2);
        quaternion.setMultiplicator(this.multiplicator);
        quaternion.setSummarizer(this.summarizer);
        return quaternion;
    }

    public void setMultiplicator(QuaternionMultiplicator multiplicator) {
        this.multiplicator = multiplicator;
    }

    public void setSummarizer(QuaternionSummarizer summarizer) {
        this.summarizer = summarizer;
    }

    public QuaternionMultiplicator getMultiplicator() {
        return this.multiplicator;
    }

    public QuaternionSummarizer getSummarizer() {
        return this.summarizer;
    }

    @Override
    public void plus(E3DNumber number) {
        MyQuaternion quaternion = (MyQuaternion)number;
        this.summarizer.summarize(this, quaternion);
    }

    @Override
    public void times(E3DNumber number) {
        MyQuaternion quaternion = (MyQuaternion)number;
        this.multiplicator.multiplicate(this, quaternion);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static interface QuaternionMultiplicator {
        public static final QuaternionMultiplicator DEFAULT = new QuaternionMultiplicator(){

            @Override
            public void multiplicate(Quaternion a, Quaternion b) {
                a.set(a.r * b.r - a.i * b.i - a.j * b.j - a.k * b.k, a.r * b.i + a.i * b.r + a.j * b.k - a.k * b.j, a.r * b.j + a.j * b.r + a.k * b.i - a.i * b.k, a.r * b.k + a.k * b.r + a.i * b.j - a.j * b.i);
            }

            @Override
            public String getName() {
                return "A '*' B = A*B (default)";
            }
        };
        public static final QuaternionMultiplicator BULB = new BulbMultiplicator(){

            @Override
            public String getName() {
                return "A '*' B = A ^ 8 (bulb-multiplication)";
            }
        };
        public static final QuaternionMultiplicator BULB8 = new Bulb8Multiplicator(){

            @Override
            public String getName() {
                return "A '*' B = A ^ 8 (bulb-8-multiplication)";
            }
        };
        public static final QuaternionMultiplicator BOX = new BoxMultiplicator(){

            @Override
            public String getName() {
                return "A '*' B = A * A (box-multiplication)";
            }
        };

        public void multiplicate(Quaternion var1, Quaternion var2);

        public String getName();

        public static abstract class BoxMultiplicator
        implements QuaternionMultiplicator {
            public double f = 1.0;
            public double s = 2.0;
            public double r2 = 0.25;

            @Override
            public void multiplicate(Quaternion a, Quaternion b) {
                if (a.r > 1.0) {
                    a.r = 2.0 - a.r;
                } else if (a.r < -1.0) {
                    a.r = -2.0 - a.r;
                }
                if (a.i > 1.0) {
                    a.i = 2.0 - a.i;
                } else if (a.i < -1.0) {
                    a.i = -2.0 - a.i;
                }
                if (a.j > 1.0) {
                    a.j = 2.0 - a.j;
                } else if (a.j < -1.0) {
                    a.j = -2.0 - a.j;
                }
                if (a.k > 1.0) {
                    a.k = 2.0 - a.k;
                } else if (a.k < -1.0) {
                    a.k = -2.0 - a.k;
                }
                a.r *= this.f;
                a.i *= this.f;
                a.j *= this.f;
                a.k *= this.f;
                double m2 = a.squaredLength();
                if (m2 < this.r2) {
                    a.r /= this.r2;
                    a.i /= this.r2;
                    a.j /= this.r2;
                    a.k /= this.r2;
                } else if (m2 < 1.0) {
                    a.r /= m2;
                    a.i /= m2;
                    a.j /= m2;
                    a.k /= m2;
                }
                a.r *= this.s;
                a.i *= this.s;
                a.j *= this.s;
                a.k *= this.s;
            }
        }

        public static abstract class Bulb8Multiplicator
        implements QuaternionMultiplicator {
            @Override
            public void multiplicate(Quaternion a, Quaternion b) {
                if (a.r == 0.0 && a.i == 0.0) {
                    a.set(0.0, 0.0, 0.0, 0.0);
                } else {
                    double x = a.r;
                    double y = a.i;
                    double z = a.j;
                    double x2 = x * x;
                    double y2 = y * y;
                    double z2 = z * z;
                    double x4 = x2 * x2;
                    double y4 = y2 * y2;
                    double z4 = z2 * z2;
                    double k3 = x2 + y2;
                    double k2 = 1.0 / Math.sqrt(k3 * k3 * k3 * k3 * k3 * k3 * k3);
                    double k1 = x4 + z4 + y4 - 6.0 * z2 * y2 - 6.0 * x2 * z2 + 2.0 * y2 * x2;
                    double k4 = x2 - z2 + y2;
                    a.r = 64.0 * x * z * y * (x2 - y2) * k4 * (x4 - 6.0 * x2 * y2 + y4) * k1 * k2;
                    a.j = -16.0 * z2 * k3 * k4 * k4 + k1 * k1;
                    a.i = -8.0 * z * k4 * (x4 * x4 - 28.0 * x4 * x2 * y2 + 70.0 * x4 * y4 - 28.0 * x2 * y2 * y4 + y4 * y4) * k1 * k2;
                    a.k = 0.0;
                }
            }
        }

        public static abstract class BulbMultiplicator
        implements QuaternionMultiplicator {
            public double n = 8.0;

            @Override
            public void multiplicate(Quaternion a, Quaternion b) {
                if (a.r == 0.0 && a.i == 0.0) {
                    a.set(0.0, 0.0, 0.0, 0.0);
                } else {
                    double r = Math.sqrt(a.r * a.r + a.i * a.i + a.j * a.j);
                    double theta = this.n * Math.atan2(a.i, a.r);
                    double phi = this.n * Math.asin(a.j / r);
                    double rn = Math.pow(r, this.n);
                    a.set(rn * Math.cos(theta) * Math.cos(phi), rn * Math.sin(theta) * Math.cos(phi), rn * -Math.sin(phi), 0.0);
                }
            }
        }
    }

    public static interface QuaternionSummarizer {
        public static final QuaternionSummarizer DEFAULT = new QuaternionSummarizer(){

            @Override
            public void summarize(Quaternion a, Quaternion b) {
                a.set(a.r + b.r, a.i + b.i, a.j + b.j, a.k + b.k);
            }

            @Override
            public String getName() {
                return "A '+' B = A+B (default)";
            }
        };

        public void summarize(Quaternion var1, Quaternion var2);

        public String getName();
    }
}

