/*
 * Decompiled with CFR 0.152.
 */
package e3d.fractal;

import e3d.euclidean.E3DVector;
import e3d.numbers.E3DNumber;

public abstract class FractalEstimator {
    public static final FractalEstimator FORWARD_GRADIENT_ESTIMATOR_ALL_JULIA = new ForwardGradientFractalEstimator(){

        @Override
        protected boolean isJulia() {
            return true;
        }

        @Override
        protected void step(E3DNumber c, E3DNumber z) {
            z.times(z);
            z.plus(c);
        }

        @Override
        public String getName() {
            return "Z=ZZ+C (all julia fractals)";
        }
    };
    public static final FractalEstimator FORWARD_GRADIENT_ESTIMATOR_ALL_MANDELBROT = new ForwardGradientFractalEstimator(){

        @Override
        protected boolean isJulia() {
            return false;
        }

        @Override
        protected void step(E3DNumber c, E3DNumber z) {
            z.times(z);
            z.plus(c);
        }

        @Override
        public String getName() {
            return "Z=ZZ+C (all mandelbrot fractals)";
        }
    };
    public static final FractalEstimator DERIVATIVE_ESTIMATOR_STD_JULIA = new DerivativeFractalEstimator(){

        @Override
        protected boolean isJulia() {
            return true;
        }

        @Override
        public String getName() {
            return "Z=ZZ+C | Z'=2ZZ' (std. julia - wrong normals!)";
        }
    };
    public static final FractalEstimator DERIVATIVE_ESTIMATOR_STD_MANDELBROT = new DerivativeFractalEstimator(){

        @Override
        protected boolean isJulia() {
            return false;
        }

        @Override
        public String getName() {
            return "Z=ZZ+C | Z'=2ZZ'+1 (standard mandelbrot)";
        }
    };
    public static final FractalEstimator NAIVE_ESTIMATOR = new NaiveFractalEstimator(){

        @Override
        protected void step(E3DNumber c, E3DNumber z) {
            z.times(z);
            z.plus(c);
        }

        @Override
        public String getName() {
            return "Z=ZZ+C (naive scanning, mandelbrot & julia)";
        }
    };

    public abstract void init(E3DNumber var1, E3DNumber var2, double var3);

    public abstract boolean next(E3DNumber var1, E3DNumber var2, int var3);

    public abstract void finish(E3DNumber var1, E3DNumber var2, int var3);

    public abstract double getDistance();

    public abstract void getNormal(E3DVector var1);

    public abstract String getName();

    public static abstract class DerivativeFractalEstimator
    extends FractalEstimator {
        private E3DNumber d = null;
        private double distance;

        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            this.distance = Double.POSITIVE_INFINITY;
            this.d = z.clone();
            this.d.set(1.0);
        }

        @Override
        public boolean next(E3DNumber c, E3DNumber z, int iter) {
            this.d.semit(z);
            this.d.times(2.0);
            if (!this.isJulia()) {
                this.d.plus(1.0);
            }
            z.times(z);
            z.plus(c);
            return z.squaredLength() < 1.0E20 && this.d.squaredLength() < 1.0E20;
        }

        @Override
        public void finish(E3DNumber c, E3DNumber z, int iter) {
            double dz = z.squaredLength();
            this.distance = Math.sqrt(dz / this.d.squaredLength()) * 0.5 * Math.log(dz);
            if (Double.isNaN(this.distance)) {
                this.distance = Double.POSITIVE_INFINITY;
            }
            E3DNumber p = this.d.clone();
            this.d.semit(z);
            this.d.times(2.0);
            if (!this.isJulia()) {
                this.d.plus(1.0);
            }
            this.d.divide(this.d.length());
            p.divide(p.length());
            this.d.mirror(p);
        }

        @Override
        public double getDistance() {
            return this.distance;
        }

        @Override
        public void getNormal(E3DVector normal) {
            this.d.put(normal);
            normal.y = -normal.y;
            normal.z = -normal.z;
        }

        protected abstract boolean isJulia();
    }

    public static abstract class ForwardGradientFractalEstimator
    extends GradientFractalEstimator {
        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            this.distance = Double.POSITIVE_INFINITY;
            if (this.isJulia()) {
                this.cx = c.positiveNeighbors(0.0);
                this.zx = z.positiveNeighbors(1.0E-8);
            } else {
                this.cx = c.positiveNeighbors(1.0E-8);
                this.zx = z.positiveNeighbors(0.0);
            }
        }

        @Override
        public void finish(E3DNumber c, E3DNumber z, int iter) {
            double gc = Math.log(z.squaredLength());
            double sdgc = 0.0;
            int i = 0;
            while (i < this.zx.length) {
                double gc1 = Math.log(this.zx[i].squaredLength());
                double dgc = (gc - gc1) / 1.0E-8;
                sdgc += dgc * dgc;
                switch (i) {
                    case 0: {
                        this.normal.x = dgc;
                        break;
                    }
                    case 1: {
                        this.normal.y = dgc;
                        break;
                    }
                    case 2: {
                        this.normal.z = dgc;
                    }
                }
                ++i;
            }
            if (!this.isJulia()) {
                sdgc *= 2.0;
            }
            this.distance = gc / Math.sqrt(sdgc);
            if (Double.isNaN(this.distance)) {
                this.distance = Double.POSITIVE_INFINITY;
            }
        }
    }

    public static abstract class GradientFractalEstimator
    extends FractalEstimator {
        protected final double offset = 1.0E-8;
        protected final double maxSqDist = 1.0E-6;
        protected E3DNumber[] cx;
        protected E3DNumber[] zx;
        protected double distance;
        protected E3DVector normal = new E3DVector();

        protected abstract boolean isJulia();

        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            this.distance = Double.POSITIVE_INFINITY;
            if (this.isJulia()) {
                this.cx = c.neighbors(0.0);
                this.zx = z.neighbors(1.0E-8);
            } else {
                this.cx = c.neighbors(1.0E-8);
                this.zx = z.neighbors(0.0);
            }
        }

        @Override
        public boolean next(E3DNumber c, E3DNumber z, int iter) {
            this.step(c, z);
            boolean ok = z.squaredLength() < 1.0E20;
            int i = 0;
            while (i < this.zx.length) {
                this.step(this.cx[i], this.zx[i]);
                ok &= this.zx[i].squaredDist(z) < 1.0E-6;
                ++i;
            }
            return ok;
        }

        protected abstract void step(E3DNumber var1, E3DNumber var2);

        @Override
        public void finish(E3DNumber c, E3DNumber z, int iter) {
            double gc = Math.log(z.squaredLength());
            double sdgc = 0.0;
            int i = 0;
            while (i < this.zx.length) {
                double gc1 = Math.log(this.zx[i].squaredLength());
                double gc2 = Math.log(this.zx[i + 1].squaredLength());
                double dgc1 = gc1 - gc;
                double dgc2 = gc - gc2;
                double dgc = (dgc1 + dgc2) / 2.0 / 1.0E-8;
                sdgc += dgc * dgc;
                switch (i) {
                    case 0: {
                        this.normal.x = dgc;
                        break;
                    }
                    case 2: {
                        this.normal.y = dgc;
                        break;
                    }
                    case 4: {
                        this.normal.z = dgc;
                    }
                }
                i += 2;
            }
            if (!this.isJulia()) {
                sdgc *= 2.0;
            }
            this.distance = gc / Math.sqrt(sdgc);
            if (Double.isNaN(this.distance)) {
                this.distance = Double.POSITIVE_INFINITY;
            }
        }

        @Override
        public double getDistance() {
            return this.distance;
        }

        @Override
        public void getNormal(E3DVector normal) {
            normal.set(this.normal);
        }
    }

    public static abstract class NaiveFractalEstimator
    extends FractalEstimator {
        private double sqBailOut;
        private double distance;

        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            this.sqBailOut = sqBailOut;
        }

        @Override
        public boolean next(E3DNumber c, E3DNumber z, int iter) {
            this.step(c, z);
            return z.squaredLength() < this.sqBailOut;
        }

        protected abstract void step(E3DNumber var1, E3DNumber var2);

        @Override
        public void finish(E3DNumber c, E3DNumber z, int iter) {
            this.distance = z.squaredLength() < this.sqBailOut ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        public double getDistance() {
            return this.distance;
        }

        @Override
        public void getNormal(E3DVector normal) {
            normal.set(0.0, 0.0, -1.0);
        }
    }
}

