/*
 * Decompiled with CFR 0.152.
 */
package e3d.fractal;

import e3d.euclidean.E3DVector;
import e3d.fractal.FractalEstimator;
import e3d.numbers.E3DNumber;
import e3d.numbers.Quaternion;
import e3d.utils.MathUtils;
import e3d.visualization.util.E3DColor;

public abstract class FractalColorizer {
    public static final FractalColorizer FIXED_COLORIZER = new FixedColorizer(-1);
    public static final FractalColorizer GLOW_COLORIZER = new GlowColorizer(-1, -39424, new E3DVector(0.0, 0.0, 0.0), 2.0, 0.5, GlowColorizer.GlowShape.SPHERE, true);
    public static final FractalColorizer SINGLE_ORBIT_TRAP_COLORIZER = new SingleOrbitTrapColorizer(new Quaternion(-0.25, -0.125, 0.125, 0.0), 1.0);
    public static final FractalColorizer MULTI_ORBIT_TRAP_COLORIZER = new MultiOrbitTrapColorizer(new Quaternion(-0.25, 0.0, 0.0, 0.0), new Quaternion(0.0, 0.0, 0.0, 0.0), new Quaternion(0.25, 0.0, 0.0, 0.0));
    public static final FractalColorizer AXIS_TRAP_COLORIZER = new AxisTrapColorizer();
    public static final FractalColorizer ESTIMATED_DISTANCE_COLORIZER = new EstimatedDistanceColorizer(0.1);
    public static final FractalColorizer ESTIMATED_NORMAL_COLORIZER = new EstimatedNormalColorizer();
    public static final FractalColorizer ESTIMATED_ABSOLUTE_NORMAL_COLORIZER = new EstimatedAbsoluteNormalColorizer();
    public static final FractalColorizer Z_COLORIZER = new ZColorizer();
    public static final FractalColorizer ITER_COLORIZER = new IterColorizer();

    public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
    }

    public void next(E3DNumber c, E3DNumber z, int iter) {
    }

    public void finish(E3DNumber c, E3DNumber z, int iter, FractalEstimator estimator) {
    }

    public abstract int getColor();

    public abstract String getName();

    public static class AxisTrapColorizer
    extends FractalColorizer {
        private double normDist = 0.0;
        private double minRedDist = Double.POSITIVE_INFINITY;
        private double minGreenDist = Double.POSITIVE_INFINITY;
        private double minBlueDist = Double.POSITIVE_INFINITY;

        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            this.minRedDist = Double.POSITIVE_INFINITY;
            this.minGreenDist = Double.POSITIVE_INFINITY;
            this.minBlueDist = Double.POSITIVE_INFINITY;
            this.normDist = 0.0;
        }

        @Override
        public void next(E3DNumber c, E3DNumber z, int iter) {
            this.minRedDist = Math.min(this.minRedDist, Math.abs(((Quaternion)z).r));
            this.minGreenDist = Math.min(this.minGreenDist, Math.abs(((Quaternion)z).i));
            this.minBlueDist = Math.min(this.minBlueDist, Math.abs(((Quaternion)z).j));
            this.normDist = MathUtils.max(this.normDist, this.minRedDist, this.minBlueDist, this.minGreenDist);
        }

        @Override
        public int getColor() {
            return E3DColor.rgb(Math.max(0, Math.min(255, 255 - (int)(this.minRedDist / this.normDist * 255.0))), Math.max(0, Math.min(255, 255 - (int)(this.minGreenDist / this.normDist * 255.0))), Math.max(0, Math.min(255, 255 - (int)(this.minBlueDist / this.normDist * 255.0))), 255);
        }

        @Override
        public String getName() {
            return "The 3 axes as orbit traps for red, green, blue";
        }
    }

    public static class EstimatedAbsoluteNormalColorizer
    extends EstimatedNormalColorizer {
        @Override
        public int getColor() {
            return E3DColor.rgb((int)(Math.abs(this.normal.x) * 255.0), (int)(Math.abs(this.normal.y) * 255.0), (int)(Math.abs(this.normal.z) * 255.0), 255);
        }

        @Override
        public String getName() {
            return "Normal (abolute x,y,z values)";
        }
    }

    public static class EstimatedDistanceColorizer
    extends FractalColorizer {
        private double frequency;
        private final double maxDist;
        private double distance = -1.0;

        public EstimatedDistanceColorizer(double maxDist) {
            this.maxDist = maxDist;
        }

        @Override
        public void finish(E3DNumber c, E3DNumber z, int iter, FractalEstimator estimator) {
            this.distance = estimator.getDistance();
        }

        @Override
        public int getColor() {
            return E3DColor.hsb((float)(this.distance / this.maxDist * this.frequency), 1.0f, 1.0f, 255);
        }

        @Override
        public String getName() {
            return "Distance";
        }

        public void setFrequency(double frequency) {
            this.frequency = frequency;
        }
    }

    public static class EstimatedNormalColorizer
    extends FractalColorizer {
        protected E3DVector normal = new E3DVector();

        @Override
        public void finish(E3DNumber c, E3DNumber z, int iter, FractalEstimator estimator) {
            estimator.getNormal(this.normal);
            this.normal.norm();
        }

        @Override
        public int getColor() {
            return E3DColor.rgb((int)((this.normal.x / 2.0 + 0.5) * 255.0), (int)((this.normal.y / 2.0 + 0.5) * 255.0), (int)((this.normal.z / 2.0 + 0.5) * 255.0), 255);
        }

        @Override
        public String getName() {
            return "Normal";
        }
    }

    public static class FixedColorizer
    extends FractalColorizer {
        protected int color;

        public FixedColorizer(int color) {
            this.color = color;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public String getName() {
            return "Uniform color";
        }
    }

    public static class GlowColorizer
    extends FixedColorizer {
        private int glowColor;
        private E3DVector glowCenter = new E3DVector();
        private GlowShape shape;
        private double glowRadius;
        private double blurRadius;
        private final E3DVector point = new E3DVector();
        private boolean isJulia;

        public GlowColorizer(int color, int glowColor, E3DVector glowCenter, double glowRadius, double blurRadius, GlowShape shape, boolean isJulia) {
            super(color);
            this.glowCenter.set(glowCenter);
            this.glowColor = glowColor;
            this.glowRadius = glowRadius;
            this.blurRadius = blurRadius;
            this.shape = shape;
            this.isJulia = isJulia;
        }

        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            super.init(c, z, sqBailOut);
            if (this.isJulia) {
                z.put(this.point);
            } else {
                c.put(this.point);
            }
        }

        @Override
        public int getColor() {
            switch (this.shape) {
                case CUBE: {
                    double dist = MathUtils.absMax(this.point.x - this.glowCenter.x, this.point.y - this.glowCenter.y, this.point.z - this.glowCenter.z);
                    double opacity = 1.0 / (1.0 + Math.exp((dist - this.glowRadius) / this.blurRadius * 8.0));
                    return E3DColor.overlay(E3DColor.illuminate(this.glowColor, opacity + 0.667), opacity, this.color);
                }
                case SPHERE: {
                    double dist = this.point.dist(this.glowCenter);
                    double opacity = 1.0 / (1.0 + Math.exp((dist - this.glowRadius) / this.blurRadius * 8.0));
                    return E3DColor.overlay(E3DColor.illuminate(this.glowColor, opacity + 0.667), opacity, this.color);
                }
            }
            return 0;
        }

        public void setGlowColor(int glowColor) {
            this.glowColor = glowColor;
        }

        public void setGlowCenter(E3DVector glowCenter) {
            this.glowCenter = glowCenter;
        }

        public void setGlowRadius(double glowRadius) {
            this.glowRadius = glowRadius;
        }

        public void setBlurRadius(double blurRadius) {
            this.blurRadius = blurRadius;
        }

        public void setGlowShape(GlowShape shape) {
            this.shape = shape;
        }

        public void setJulia(boolean isJulia) {
            this.isJulia = isJulia;
        }

        @Override
        public String getName() {
            return "Glowing";
        }

        public static enum GlowShape {
            SPHERE,
            CUBE;

        }
    }

    public static class IterColorizer
    extends FractalColorizer {
        private int iter;

        @Override
        public void next(E3DNumber c, E3DNumber z, int iter) {
            this.iter = iter;
        }

        @Override
        public int getColor() {
            if (this.iter == 0) {
                return -16777216;
            }
            return E3DColor.rgb(this.iter / 9 % 3 * 129 - 1, this.iter / 3 % 3 * 128 - 1, this.iter / 1 % 3 * 128 - 1, 255);
        }

        @Override
        public String getName() {
            return "Number of iterations";
        }
    }

    public static class MultiOrbitTrapColorizer
    extends FractalColorizer {
        private final E3DNumber redOrbit;
        private final E3DNumber greenOrbit;
        private final E3DNumber blueOrbit;
        private double normDist = 0.0;
        private double minRedDist = Double.POSITIVE_INFINITY;
        private double minGreenDist = Double.POSITIVE_INFINITY;
        private double minBlueDist = Double.POSITIVE_INFINITY;

        public MultiOrbitTrapColorizer(E3DNumber redOrbit, E3DNumber greenOrbit, E3DNumber blueOrbit) {
            this.redOrbit = redOrbit;
            this.greenOrbit = greenOrbit;
            this.blueOrbit = blueOrbit;
        }

        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            super.init(c, z, sqBailOut);
            this.minRedDist = Double.POSITIVE_INFINITY;
            this.minGreenDist = Double.POSITIVE_INFINITY;
            this.minBlueDist = Double.POSITIVE_INFINITY;
            this.normDist = 0.0;
        }

        @Override
        public void next(E3DNumber c, E3DNumber z, int iter) {
            this.minRedDist = Math.min(this.minRedDist, z.dist(this.redOrbit));
            this.minGreenDist = Math.min(this.minGreenDist, z.dist(this.greenOrbit));
            this.minBlueDist = Math.min(this.minBlueDist, z.dist(this.blueOrbit));
            this.normDist = MathUtils.max(this.normDist, this.minRedDist, this.minBlueDist, this.minGreenDist);
        }

        @Override
        public int getColor() {
            return E3DColor.rgb(Math.max(0, Math.min(255, (int)(this.minRedDist / this.normDist * 255.0))), Math.max(0, Math.min(255, (int)(this.minGreenDist / this.normDist * 255.0))), Math.max(0, Math.min(255, (int)(this.minBlueDist / this.normDist * 255.0))), 255);
        }

        @Override
        public String getName() {
            return "Min. dist. to 3 orbit traps for red, green, blue";
        }
    }

    public static class SingleOrbitTrapColorizer
    extends FractalColorizer {
        private final E3DNumber orbit;
        private double frequency;
        private double normDist = 0.0;
        private double minDist = Double.POSITIVE_INFINITY;

        public SingleOrbitTrapColorizer(E3DNumber orbit, double frequency) {
            this.orbit = orbit;
            this.frequency = frequency;
        }

        @Override
        public void init(E3DNumber c, E3DNumber z, double sqBailOut) {
            super.init(c, z, sqBailOut);
            this.minDist = Double.POSITIVE_INFINITY;
            this.normDist = 0.0;
        }

        @Override
        public void next(E3DNumber c, E3DNumber z, int iter) {
            this.minDist = Math.min(this.minDist, z.dist(this.orbit));
            this.normDist = MathUtils.max(this.normDist, this.minDist);
        }

        @Override
        public int getColor() {
            return E3DColor.hsb((float)(this.minDist / this.normDist * this.frequency), 1.0f, 1.0f, 255);
        }

        @Override
        public String getName() {
            return "Min. dist. to one orbit trap as the hue value";
        }

        public void setFrequency(double frequency) {
            this.frequency = frequency;
        }
    }

    public static class ZColorizer
    extends FractalColorizer {
        private E3DNumber z = null;

        @Override
        public void next(E3DNumber c, E3DNumber z, int iter) {
            this.z = z;
        }

        @Override
        public int getColor() {
            if (this.z == null) {
                return -16777216;
            }
            Quaternion zi = (Quaternion)this.z;
            double red = Math.abs(zi.imagI());
            double green = Math.abs(zi.imagJ());
            double blue = Math.abs(zi.real());
            double norm = MathUtils.max(red, green, blue);
            if (norm == 0.0) {
                return E3DColor.rgb(85, 85, 85, 255);
            }
            return E3DColor.rgb((int)(red / norm * 255.0), (int)(green / norm * 255.0), (int)(blue / norm * 255.0), 255);
        }

        @Override
        public String getName() {
            return "Last Z.{x,y,z} for red, green, blue";
        }
    }
}

