/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean.transformations;

import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DTransformation;

public class E3DRotation
extends E3DTransformation {
    public double cosX;
    public double sinX;
    public double cosY;
    public double sinY;

    public E3DRotation() {
        this.cosX = 1.0;
        this.sinX = 0.0;
        this.cosY = 1.0;
        this.sinY = 0.0;
    }

    public E3DRotation(E3DRotation rotation) {
        this.set(rotation);
    }

    public E3DRotation(E3DVector viewPoint, boolean revertX, boolean revertY, boolean revertZ) {
        this.set(viewPoint, revertX, revertY, revertZ);
    }

    public void set(E3DRotation rotation) {
        this.cosX = rotation.cosX;
        this.sinX = rotation.sinX;
        this.cosY = rotation.cosY;
        this.sinY = rotation.sinY;
    }

    public void set(E3DVector viewPoint, boolean revertX, boolean revertY, boolean revertZ) {
        double distanceXZ;
        E3DVector vector = new E3DVector(viewPoint);
        if (!revertX) {
            vector.x = -vector.x;
        }
        if (!revertY) {
            vector.y = -vector.y;
        }
        if (revertZ) {
            vector.z = -vector.z;
        }
        if ((distanceXZ = Math.sqrt(vector.z * vector.z + vector.x * vector.x)) == 0.0) {
            this.cosY = 1.0;
            this.sinY = 0.0;
        } else {
            this.cosY = vector.z / distanceXZ;
            this.sinY = -(vector.x / distanceXZ);
        }
        double z0 = vector.z;
        vector.z = z0 * this.cosY - vector.x * this.sinY;
        vector.x = z0 * this.sinY + vector.x * this.cosY;
        double distanceYZ = Math.sqrt(vector.y * vector.y + vector.z * vector.z);
        if (distanceYZ == 0.0) {
            this.cosX = 1.0;
            this.sinX = 0.0;
        } else {
            this.cosX = vector.z / distanceYZ;
            this.sinX = -(vector.y / distanceYZ);
        }
    }

    @Override
    public void transform(E3DVector point) {
        double z0 = point.z;
        point.z = z0 * this.cosX - point.y * this.sinX;
        point.y = z0 * this.sinX + point.y * this.cosX;
        z0 = point.z;
        point.z = z0 * this.cosY - point.x * this.sinY;
        point.x = z0 * this.sinY + point.x * this.cosY;
    }
}

