/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean;

import e3d.euclidean.E3DVector;
import e3d.utils.MathUtils;

public class E3DTransform {
    private static final int AFFINE_BIT = 1;
    private static final int ORTHO_BIT = 2;
    private static final int CONGRUENT_BIT = 4;
    private static final int RIGID_BIT = 8;
    private static final int CLASSIFY_BIT = 16;
    private static final int SCALE_BIT = 32;
    private static final int ROTATION_BIT = 64;
    private static final int SVD_BIT = 128;
    private static final int CLASSIFY_ALL_DIRTY = 31;
    private static final int ROTSCALESVD_DIRTY = 224;
    private static final int ALL_DIRTY = 255;
    private static final double EPS = 1.110223024E-16;
    static final double EPSILON = 1.0E-10;
    static final double EPSILON_ABSOLUTE = 1.0E-5;
    static final double EPSILON_RELATIVE = 1.0E-4;
    public static final int ZERO = 1;
    public static final int IDENTITY = 2;
    public static final int SCALE = 4;
    public static final int TRANSLATION = 8;
    public static final int ORTHOGONAL = 16;
    public static final int RIGID = 32;
    public static final int CONGRUENT = 64;
    public static final int AFFINE = 128;
    public static final int NEGATIVE_DETERMINANT = 256;
    private static final int ORTHO = 0x40000000;
    double[] mat = new double[16];
    double[] rot = null;
    double[] scales = null;
    private int type = 0;
    private int dirtyBits;

    public E3DTransform(E3DTransform transform) {
        this.set(transform);
    }

    public E3DTransform() {
        this.setToIdentity();
    }

    public E3DTransform(double[] matrix) {
        this.set(matrix);
    }

    public final int getType() {
        if ((this.dirtyBits & 0x10) != 0) {
            this.classify();
        }
        return this.type & 0xBFFFFFFF;
    }

    protected final boolean isOrtho() {
        if ((this.dirtyBits & 2) != 0) {
            if (E3DTransform.isAlmostZero(this.mat[0] * this.mat[2] + this.mat[4] * this.mat[6] + this.mat[8] * this.mat[10]) && E3DTransform.isAlmostZero(this.mat[0] * this.mat[1] + this.mat[4] * this.mat[5] + this.mat[8] * this.mat[9]) && E3DTransform.isAlmostZero(this.mat[1] * this.mat[2] + this.mat[5] * this.mat[6] + this.mat[9] * this.mat[10])) {
                this.type |= 0x40000000;
                this.dirtyBits &= 0xFFFFFFFD;
                return true;
            }
            this.type &= 0xBFFFFFFF;
            this.dirtyBits &= 0xFFFFFFFD;
            return false;
        }
        return (this.type & 0x40000000) != 0;
    }

    protected final boolean isCongruent() {
        if ((this.dirtyBits & 4) != 0) {
            this.classifyRigid();
        }
        return (this.type & 0x40) != 0;
    }

    protected final boolean isAffine() {
        if ((this.dirtyBits & 1) != 0) {
            this.classifyAffine();
        }
        return (this.type & 0x80) != 0;
    }

    protected final boolean isRigid() {
        if ((this.dirtyBits & 8) != 0) {
            if ((this.dirtyBits & 4) != 0) {
                this.classifyRigid();
            } else {
                if ((this.type & 0x40) != 0) {
                    double s;
                    if ((this.dirtyBits & 0x20) != 0) {
                        s = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                    } else {
                        if (this.scales == null) {
                            this.scales = new double[3];
                        }
                        s = this.scales[0];
                    }
                    this.type = E3DTransform.isAlmostOne(s) ? (this.type |= 0x20) : (this.type &= 0xFFFFFFDF);
                } else {
                    this.type &= 0xFFFFFFDF;
                }
                this.dirtyBits &= 0xFFFFFFF7;
            }
        }
        return (this.type & 0x20) != 0;
    }

    public final int getBestType() {
        this.getType();
        if ((this.type & 1) != 0) {
            return 1;
        }
        if ((this.type & 2) != 0) {
            return 2;
        }
        if ((this.type & 4) != 0) {
            return 4;
        }
        if ((this.type & 8) != 0) {
            return 8;
        }
        if ((this.type & 0x10) != 0) {
            return 16;
        }
        if ((this.type & 0x20) != 0) {
            return 32;
        }
        if ((this.type & 0x40) != 0) {
            return 64;
        }
        if ((this.type & 0x80) != 0) {
            return 128;
        }
        if ((this.type & 0x100) != 0) {
            return 256;
        }
        return 0;
    }

    private final void classify() {
        if ((this.dirtyBits & 0xD) != 0) {
            this.classifyRigid();
        }
        if ((this.type & 0x80) != 0) {
            if ((this.type & 0x40) != 0) {
                if ((this.type & 0x20) != 0) {
                    if (!this.isTranslation()) {
                        this.type |= 0x10;
                        if (!this.isRotation() && this.mat[0] > 0.0 && this.mat[5] > 0.0 && this.mat[10] > 0.0) {
                            this.type |= 0xE;
                        }
                    } else if (!this.isRotation()) {
                        this.type |= 8;
                    }
                } else if (!this.isTranslation() && !this.isRotation()) {
                    this.type |= 4;
                }
            }
        } else if (E3DTransform.isAlmostZero(this.mat[12]) && E3DTransform.isAlmostZero(this.mat[13]) && E3DTransform.isAlmostZero(this.mat[14]) && E3DTransform.isAlmostZero(this.mat[15]) && !this.isTranslation() && !this.isRotation() && E3DTransform.isAlmostZero(this.mat[0]) && E3DTransform.isAlmostZero(this.mat[5]) && E3DTransform.isAlmostZero(this.mat[10])) {
            this.type |= 1;
        }
        if (!this.getDeterminantSign()) {
            this.type |= 0x100;
        }
        this.dirtyBits &= 0xFFFFFFEF;
    }

    public final boolean getDeterminantSign() {
        double det = this.getDeterminant();
        if (Double.isNaN(det)) {
            return true;
        }
        return det >= 0.0;
    }

    private final void classifyAffine() {
        this.type = this.isValid() && E3DTransform.isAlmostZero(this.mat[12]) && E3DTransform.isAlmostZero(this.mat[13]) && E3DTransform.isAlmostZero(this.mat[14]) && E3DTransform.isAlmostOne(this.mat[15]) ? (this.type |= 0x80) : (this.type &= 0xFFFFFF7F);
        this.dirtyBits &= 0xFFFFFFFE;
    }

    private final void classifyRigid() {
        if ((this.dirtyBits & 1) != 0) {
            this.type &= 0x40000000;
            this.classifyAffine();
        } else {
            this.type &= 0x40000080;
        }
        if ((this.type & 0x80) != 0 && this.isOrtho()) {
            if ((this.dirtyBits & 0x20) != 0) {
                double s2;
                double s0 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                double s1 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
                if (E3DTransform.isAlmostEqual(s0, s1) && E3DTransform.isAlmostEqual(s2 = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10], s0)) {
                    this.type |= 0x40;
                    if (E3DTransform.isAlmostOne(s0)) {
                        this.type |= 0x20;
                    }
                }
            } else {
                double s;
                if (this.scales == null) {
                    this.scales = new double[3];
                }
                if (E3DTransform.isAlmostEqual(s = this.scales[0], this.scales[1]) && E3DTransform.isAlmostEqual(s, this.scales[2])) {
                    this.type |= 0x40;
                    if (E3DTransform.isAlmostOne(s)) {
                        this.type |= 0x20;
                    }
                }
            }
        }
        this.dirtyBits &= 0xFFFFFFFF;
    }

    public final boolean isValid() {
        double d = 0.0;
        int i = 0;
        while (i < 16) {
            d *= this.mat[i];
            ++i;
        }
        return d == 0.0;
    }

    private final boolean isTranslation() {
        return !E3DTransform.isAlmostZero(this.mat[3]) || !E3DTransform.isAlmostZero(this.mat[7]) || !E3DTransform.isAlmostZero(this.mat[11]);
    }

    private final boolean isRotation() {
        return !E3DTransform.isAlmostZero(this.mat[1]) || !E3DTransform.isAlmostZero(this.mat[2]) || !E3DTransform.isAlmostZero(this.mat[4]) || !E3DTransform.isAlmostZero(this.mat[6]) || !E3DTransform.isAlmostZero(this.mat[8]) || !E3DTransform.isAlmostZero(this.mat[9]);
    }

    public String toString() {
        return String.valueOf(this.mat[0]) + ", " + this.mat[1] + ", " + this.mat[2] + ", " + this.mat[3] + "\n" + this.mat[4] + ", " + this.mat[5] + ", " + this.mat[6] + ", " + this.mat[7] + "\n" + this.mat[8] + ", " + this.mat[9] + ", " + this.mat[10] + ", " + this.mat[11] + "\n" + this.mat[12] + ", " + this.mat[13] + ", " + this.mat[14] + ", " + this.mat[15];
    }

    public boolean equals(E3DTransform t) {
        return t != null && this.mat[0] == t.mat[0] && this.mat[1] == t.mat[1] && this.mat[2] == t.mat[2] && this.mat[3] == t.mat[3] && this.mat[4] == t.mat[4] && this.mat[5] == t.mat[5] && this.mat[6] == t.mat[6] && this.mat[7] == t.mat[7] && this.mat[8] == t.mat[8] && this.mat[9] == t.mat[9] && this.mat[10] == t.mat[10] && this.mat[11] == t.mat[11] && this.mat[12] == t.mat[12] && this.mat[13] == t.mat[13] && this.mat[14] == t.mat[14] && this.mat[15] == t.mat[15];
    }

    public boolean equals(Object obj) {
        return obj instanceof E3DTransform && this.equals((E3DTransform)obj);
    }

    public int hashCode() {
        long bits = 1L;
        int i = 0;
        while (i < 16) {
            bits = 31L * bits + (this.mat[i] == 0.0 ? 0L : Double.doubleToLongBits(this.mat[i]));
            ++i;
        }
        return (int)(bits ^ bits >> 32);
    }

    public final void setToIdentity() {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 1073742078;
        this.dirtyBits = 96;
    }

    public final void setToZero() {
        this.mat[0] = 0.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 0.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 0.0;
        this.type = 0x40000001;
        this.dirtyBits = 96;
    }

    public final void add(E3DTransform transform) {
        int i = 0;
        while (i < 16) {
            int n = i;
            this.mat[n] = this.mat[n] + transform.mat[i];
            ++i;
        }
        this.dirtyBits = 255;
    }

    public final E3DTransform sum(E3DTransform transform) {
        double[] m = new double[16];
        int i = 0;
        while (i < 16) {
            m[i] = this.mat[i] + transform.mat[i];
            ++i;
        }
        return new E3DTransform(m);
    }

    public final void sub(E3DTransform transform) {
        int i = 0;
        while (i < 16) {
            int n = i;
            this.mat[n] = this.mat[n] - transform.mat[i];
            ++i;
        }
        this.dirtyBits = 255;
    }

    public final E3DTransform diff(E3DTransform transform) {
        double[] m = new double[16];
        int i = 0;
        while (i < 16) {
            m[i] = this.mat[i] - transform.mat[i];
            ++i;
        }
        return new E3DTransform(m);
    }

    public final E3DTransform scaleSum(double s, E3DTransform t) {
        double[] m = new double[16];
        int i = 0;
        while (i < 16) {
            m[i] = s * this.mat[i] + t.mat[i];
            ++i;
        }
        return new E3DTransform(m);
    }

    public final void scaleAdd(double s, E3DTransform t) {
        int i = 0;
        while (i < 16) {
            this.mat[i] = s * this.mat[i] + t.mat[i];
            ++i;
        }
        this.dirtyBits = 255;
    }

    public final void transpose() {
        double tmp = this.mat[4];
        this.mat[4] = this.mat[1];
        this.mat[1] = tmp;
        tmp = this.mat[8];
        this.mat[8] = this.mat[2];
        this.mat[2] = tmp;
        tmp = this.mat[12];
        this.mat[12] = this.mat[3];
        this.mat[3] = tmp;
        tmp = this.mat[9];
        this.mat[9] = this.mat[6];
        this.mat[6] = tmp;
        tmp = this.mat[13];
        this.mat[13] = this.mat[7];
        this.mat[7] = tmp;
        tmp = this.mat[14];
        this.mat[14] = this.mat[11];
        this.mat[11] = tmp;
        this.dirtyBits = 255;
    }

    public final E3DTransform transposed() {
        double[] m = new double[]{this.mat[0], this.mat[4], this.mat[8], this.mat[12], this.mat[1], this.mat[5], this.mat[9], this.mat[13], this.mat[2], this.mat[6], this.mat[10], this.mat[14], this.mat[3], this.mat[7], this.mat[11], this.mat[15]};
        return new E3DTransform(m);
    }

    public final void setToRotation(E3DVector axis, double angle) {
        double mag = axis.length();
        if (E3DTransform.isAlmostZero(mag)) {
            this.setToIdentity();
        } else {
            mag = 1.0 / mag;
            double ax = axis.x * mag;
            double ay = axis.y * mag;
            double az = axis.z * mag;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            double t = 1.0 - cos;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            this.mat[0] = t * ax * ax + cos;
            this.mat[1] = t * xy - sin * az;
            this.mat[2] = t * xz + sin * ay;
            this.mat[3] = 0.0;
            this.mat[4] = t * xy + sin * az;
            this.mat[5] = t * ay * ay + cos;
            this.mat[6] = t * yz - sin * ax;
            this.mat[7] = 0.0;
            this.mat[8] = t * xz - sin * ay;
            this.mat[9] = t * yz + sin * ax;
            this.mat[10] = t * az * az + cos;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            if (!axis.isValid() || Double.isInfinite(angle) || Double.isNaN(angle)) {
                this.dirtyBits = 255;
            } else {
                this.type = 0x400000E0;
                this.dirtyBits = 112;
            }
        }
    }

    public final void setRotation(E3DVector axis, double angle) {
        double mag;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if (E3DTransform.isAlmostZero(mag = axis.length())) {
            this.mat[0] = this.scales[0];
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = this.scales[1];
            this.mat[6] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = this.scales[2];
        } else {
            mag = 1.0 / mag;
            double ax = axis.x * mag;
            double ay = axis.y * mag;
            double az = axis.z * mag;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            double t = 1.0 - cos;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            this.mat[0] = (t * ax * ax + cos) * this.scales[0];
            this.mat[1] = (t * xy - sin * az) * this.scales[1];
            this.mat[2] = (t * xz + sin * ay) * this.scales[2];
            this.mat[4] = (t * xy + sin * az) * this.scales[0];
            this.mat[5] = (t * ay * ay + cos) * this.scales[1];
            this.mat[6] = (t * yz - sin * ax) * this.scales[2];
            this.mat[8] = (t * xz - sin * ay) * this.scales[0];
            this.mat[9] = (t * yz + sin * ax) * this.scales[1];
            this.mat[10] = (t * az * az + cos) * this.scales[2];
        }
        if (!axis.isValid() || Double.isInfinite(angle) || Double.isNaN(angle)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x50;
            this.dirtyBits &= 0xFFFFFFFD;
            this.type |= 0x40000000;
            this.type &= 0xFFFFFFE0;
        }
    }

    public void setToRotateX(double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = cos;
        this.mat[6] = -sin;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = sin;
        this.mat[10] = cos;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public void setToRotateY(double angle) {
        double cos;
        double sin = Math.sin(angle);
        this.mat[0] = cos = Math.cos(angle);
        this.mat[1] = 0.0;
        this.mat[2] = sin;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = -sin;
        this.mat[9] = 0.0;
        this.mat[10] = cos;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public void setToRotateZ(double angle) {
        double cos;
        double sin = Math.sin(angle);
        this.mat[0] = cos = Math.cos(angle);
        this.mat[1] = -sin;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = sin;
        this.mat[5] = cos;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void setToTranslation(E3DVector trans) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = trans.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = trans.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = trans.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (!trans.isValid()) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void setTranslation(E3DVector trans) {
        this.mat[3] = trans.x;
        this.mat[7] = trans.y;
        this.mat[11] = trans.z;
        if (!trans.isValid()) {
            this.dirtyBits = 255;
        } else {
            this.type &= 0xFFFFFFE0;
            this.dirtyBits |= 0x10;
        }
    }

    public final void setScale(double scale) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[1] = this.scales[2] = scale;
        this.scales[0] = this.scales[2];
        this.mat[0] = this.rot[0] * scale;
        this.mat[1] = this.rot[1] * scale;
        this.mat[2] = this.rot[2] * scale;
        this.mat[4] = this.rot[3] * scale;
        this.mat[5] = this.rot[4] * scale;
        this.mat[6] = this.rot[5] * scale;
        this.mat[8] = this.rot[6] * scale;
        this.mat[9] = this.rot[7] * scale;
        this.mat[10] = this.rot[8] * scale;
        if (Double.isInfinite(scale) || Double.isNaN(scale)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x9C;
            this.dirtyBits &= 0xFFFFFFDF;
        }
    }

    public final void setScale(E3DVector scale) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[0] = scale.x;
        this.scales[1] = scale.y;
        this.scales[2] = scale.z;
        this.mat[0] = this.rot[0] * scale.x;
        this.mat[1] = this.rot[1] * scale.y;
        this.mat[2] = this.rot[2] * scale.z;
        this.mat[4] = this.rot[3] * scale.x;
        this.mat[5] = this.rot[4] * scale.y;
        this.mat[6] = this.rot[5] * scale.z;
        this.mat[8] = this.rot[6] * scale.x;
        this.mat[9] = this.rot[7] * scale.y;
        this.mat[10] = this.rot[8] * scale.z;
        if (!scale.isValid()) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x9C;
            this.dirtyBits &= 0xFFFFFFDF;
        }
    }

    public final void set(E3DTransform t) {
        this.mat[0] = t.mat[0];
        this.mat[1] = t.mat[1];
        this.mat[2] = t.mat[2];
        this.mat[3] = t.mat[3];
        this.mat[4] = t.mat[4];
        this.mat[5] = t.mat[5];
        this.mat[6] = t.mat[6];
        this.mat[7] = t.mat[7];
        this.mat[8] = t.mat[8];
        this.mat[9] = t.mat[9];
        this.mat[10] = t.mat[10];
        this.mat[11] = t.mat[11];
        this.mat[12] = t.mat[12];
        this.mat[13] = t.mat[13];
        this.mat[14] = t.mat[14];
        this.mat[15] = t.mat[15];
        this.type = t.type;
        this.dirtyBits = t.dirtyBits | 0x40 | 0x20;
    }

    public final void set(double[] matrix) {
        this.mat[0] = matrix[0];
        this.mat[1] = matrix[1];
        this.mat[2] = matrix[2];
        this.mat[3] = matrix[3];
        this.mat[4] = matrix[4];
        this.mat[5] = matrix[5];
        this.mat[6] = matrix[6];
        this.mat[7] = matrix[7];
        this.mat[8] = matrix[8];
        this.mat[9] = matrix[9];
        this.mat[10] = matrix[10];
        this.mat[11] = matrix[11];
        this.mat[12] = matrix[12];
        this.mat[13] = matrix[13];
        this.mat[14] = matrix[14];
        this.mat[15] = matrix[15];
        this.dirtyBits = 255;
    }

    public final void setToEuler(E3DVector euler) {
        double sina = Math.sin(euler.x);
        double sinb = Math.sin(euler.y);
        double sinc = Math.sin(euler.z);
        double cosa = Math.cos(euler.x);
        double cosb = Math.cos(euler.y);
        double cosc = Math.cos(euler.z);
        this.mat[0] = cosb * cosc;
        this.mat[1] = -(cosa * sinc) + sina * sinb * cosc;
        this.mat[2] = sina * sinc + cosa * sinb * cosc;
        this.mat[3] = 0.0;
        this.mat[4] = cosb * sinc;
        this.mat[5] = cosa * cosc + sina * sinb * sinc;
        this.mat[6] = -(sina * cosc) + cosa * sinb * sinc;
        this.mat[7] = 0.0;
        this.mat[8] = -sinb;
        this.mat[9] = sina * cosb;
        this.mat[10] = cosa * cosb;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (!euler.isValid()) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final E3DTransform inverted() throws RuntimeException {
        if (this.isAffine()) {
            return this.invertedAffine();
        }
        return this.invertedGeneral();
    }

    public final void invert() throws RuntimeException {
        if (this.isAffine()) {
            this.invertAffine();
        } else {
            this.invertGeneral();
        }
    }

    private final E3DTransform invertedAffine() throws RuntimeException {
        double det = this.getAffineDeterminant();
        if (det == 0.0) {
            throw new RuntimeException("Singular Matrix");
        }
        double s = (this.mat[0] * this.mat[0] + this.mat[1] * this.mat[1] + this.mat[2] * this.mat[2] + this.mat[3] * this.mat[3]) * (this.mat[4] * this.mat[4] + this.mat[5] * this.mat[5] + this.mat[6] * this.mat[6] + this.mat[7] * this.mat[7]) * (this.mat[8] * this.mat[8] + this.mat[9] * this.mat[9] + this.mat[10] * this.mat[10] + this.mat[11] * this.mat[11]);
        if (det * det < 1.110223024E-16 * s) {
            return this.invertedGeneral();
        }
        s = 1.0 / det;
        double[] m = new double[16];
        m[0] = (this.mat[5] * this.mat[10] - this.mat[9] * this.mat[6]) * s;
        m[1] = -(this.mat[1] * this.mat[10] - this.mat[9] * this.mat[2]) * s;
        m[2] = (this.mat[1] * this.mat[6] - this.mat[5] * this.mat[2]) * s;
        m[4] = -(this.mat[4] * this.mat[10] - this.mat[8] * this.mat[6]) * s;
        m[5] = (this.mat[0] * this.mat[10] - this.mat[8] * this.mat[2]) * s;
        m[6] = -(this.mat[0] * this.mat[6] - this.mat[4] * this.mat[2]) * s;
        m[8] = (this.mat[4] * this.mat[9] - this.mat[8] * this.mat[5]) * s;
        m[9] = -(this.mat[0] * this.mat[9] - this.mat[8] * this.mat[1]) * s;
        m[10] = (this.mat[0] * this.mat[5] - this.mat[4] * this.mat[1]) * s;
        m[3] = -(this.mat[3] * m[0] + this.mat[7] * m[1] + this.mat[11] * m[2]);
        m[7] = -(this.mat[3] * m[4] + this.mat[7] * m[5] + this.mat[11] * m[6]);
        m[11] = -(this.mat[3] * m[8] + this.mat[7] * m[9] + this.mat[11] * m[10]);
        m[14] = 0.0;
        m[13] = 0.0;
        m[12] = 0.0;
        m[15] = 1.0;
        return new E3DTransform(m);
    }

    private final void invertAffine() throws RuntimeException {
        double det = this.getAffineDeterminant();
        if (det == 0.0) {
            throw new RuntimeException("Singular Matrix");
        }
        double s = (this.mat[0] * this.mat[0] + this.mat[1] * this.mat[1] + this.mat[2] * this.mat[2] + this.mat[3] * this.mat[3]) * (this.mat[4] * this.mat[4] + this.mat[5] * this.mat[5] + this.mat[6] * this.mat[6] + this.mat[7] * this.mat[7]) * (this.mat[8] * this.mat[8] + this.mat[9] * this.mat[9] + this.mat[10] * this.mat[10] + this.mat[11] * this.mat[11]);
        if (det * det < 1.110223024E-16 * s) {
            this.invertGeneral();
        } else {
            s = 1.0 / det;
            double tmp0 = (this.mat[5] * this.mat[10] - this.mat[9] * this.mat[6]) * s;
            double tmp1 = -(this.mat[1] * this.mat[10] - this.mat[9] * this.mat[2]) * s;
            double tmp2 = (this.mat[1] * this.mat[6] - this.mat[5] * this.mat[2]) * s;
            double tmp4 = -(this.mat[4] * this.mat[10] - this.mat[8] * this.mat[6]) * s;
            double tmp5 = (this.mat[0] * this.mat[10] - this.mat[8] * this.mat[2]) * s;
            double tmp6 = -(this.mat[0] * this.mat[6] - this.mat[4] * this.mat[2]) * s;
            double tmp8 = (this.mat[4] * this.mat[9] - this.mat[8] * this.mat[5]) * s;
            double tmp9 = -(this.mat[0] * this.mat[9] - this.mat[8] * this.mat[1]) * s;
            double tmp10 = (this.mat[0] * this.mat[5] - this.mat[4] * this.mat[1]) * s;
            double tmp3 = -(this.mat[3] * tmp0 + this.mat[7] * tmp1 + this.mat[11] * tmp2);
            double tmp7 = -(this.mat[3] * tmp4 + this.mat[7] * tmp5 + this.mat[11] * tmp6);
            this.mat[11] = -(this.mat[3] * tmp8 + this.mat[7] * tmp9 + this.mat[11] * tmp10);
            this.mat[0] = tmp0;
            this.mat[1] = tmp1;
            this.mat[2] = tmp2;
            this.mat[3] = tmp3;
            this.mat[4] = tmp4;
            this.mat[5] = tmp5;
            this.mat[6] = tmp6;
            this.mat[7] = tmp7;
            this.mat[8] = tmp8;
            this.mat[9] = tmp9;
            this.mat[10] = tmp10;
            this.mat[14] = 0.0;
            this.mat[13] = 0.0;
            this.mat[12] = 0.0;
            this.mat[15] = 1.0;
            this.dirtyBits |= 0xF2;
        }
    }

    private final E3DTransform invertedGeneral() throws RuntimeException {
        double[] m = new double[16];
        double[] tmp = new double[16];
        int[] rowPerm = new int[4];
        System.arraycopy(this.mat, 0, tmp, 0, tmp.length);
        if (!E3DTransform.luDecomposition(tmp, rowPerm)) {
            throw new RuntimeException("Singular Matrix");
        }
        m[0] = 1.0;
        m[1] = 0.0;
        m[2] = 0.0;
        m[3] = 0.0;
        m[4] = 0.0;
        m[5] = 1.0;
        m[6] = 0.0;
        m[7] = 0.0;
        m[8] = 0.0;
        m[9] = 0.0;
        m[10] = 1.0;
        m[11] = 0.0;
        m[12] = 0.0;
        m[13] = 0.0;
        m[14] = 0.0;
        m[15] = 1.0;
        E3DTransform.luBacksubstitution(tmp, rowPerm, m);
        return new E3DTransform(m);
    }

    private final void invertGeneral() throws RuntimeException {
        double[] tmp = new double[16];
        int[] rowPerm = new int[4];
        System.arraycopy(this.mat, 0, tmp, 0, tmp.length);
        if (!E3DTransform.luDecomposition(tmp, rowPerm)) {
            throw new RuntimeException("Singular Matrix");
        }
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        E3DTransform.luBacksubstitution(tmp, rowPerm, this.mat);
        this.type = 0;
        this.dirtyBits = 255;
    }

    public final void setToScale(double scale) {
        this.setScaleTranslation(0.0, 0.0, 0.0, scale);
    }

    public final void setTo(double scale, E3DVector translation) {
        this.setScaleTranslation(translation.x, translation.y, translation.z, scale);
    }

    public final void setTo(E3DVector translation, double scale) {
        this.setScaleTranslation(translation.x * scale, translation.y * scale, translation.z * scale, scale);
    }

    private final void setScaleTranslation(double x, double y, double z, double scale) {
        this.mat[0] = scale;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = x;
        this.mat[4] = 0.0;
        this.mat[5] = scale;
        this.mat[6] = 0.0;
        this.mat[7] = y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = scale;
        this.mat[11] = z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = scale;
        this.scales[0] = this.scales[2];
        if (Double.isInfinite(x) || Double.isNaN(x) || Double.isInfinite(y) || Double.isNaN(y) || Double.isInfinite(z) || Double.isNaN(z) || Double.isInfinite(scale) || Double.isNaN(scale)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000C0;
            this.dirtyBits = 88;
        }
    }

    public void setToLookAt(E3DVector eye, E3DVector center, E3DVector up) {
        double fwdX = eye.x - center.x;
        double fwdY = eye.y - center.y;
        double fwdZ = eye.z - center.z;
        double invMag = 1.0 / Math.sqrt(fwdX * fwdX + fwdY * fwdY + fwdZ * fwdZ);
        fwdX *= invMag;
        fwdY *= invMag;
        fwdZ *= invMag;
        invMag = 1.0 / Math.sqrt(up.x * up.x + up.y * up.y + up.z * up.z);
        double upX = up.x * invMag;
        double upY = up.y * invMag;
        double upZ = up.z * invMag;
        double sideX = upY * fwdZ - fwdY * upZ;
        double sideY = upZ * fwdX - upX * fwdZ;
        double sideZ = upX * fwdY - upY * fwdX;
        invMag = 1.0 / Math.sqrt(sideX * sideX + sideY * sideY + sideZ * sideZ);
        upX = fwdY * (sideZ *= invMag) - (sideY *= invMag) * fwdZ;
        upY = fwdZ * (sideX *= invMag) - fwdX * sideZ;
        upZ = fwdX * sideY - fwdY * sideX;
        this.mat[0] = sideX;
        this.mat[1] = sideY;
        this.mat[2] = sideZ;
        this.mat[4] = upX;
        this.mat[5] = upY;
        this.mat[6] = upZ;
        this.mat[8] = fwdX;
        this.mat[9] = fwdY;
        this.mat[10] = fwdZ;
        this.mat[3] = -eye.x * this.mat[0] + -eye.y * this.mat[1] + -eye.z * this.mat[2];
        this.mat[7] = -eye.x * this.mat[4] + -eye.y * this.mat[5] + -eye.z * this.mat[6];
        this.mat[11] = -eye.x * this.mat[8] + -eye.y * this.mat[9] + -eye.z * this.mat[10];
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public void setToFrustum(double left, double right, double bottom, double top, double near, double far) {
        double dx = 1.0 / (right - left);
        double dy = 1.0 / (top - bottom);
        double dz = 1.0 / (far - near);
        this.mat[0] = 2.0 * near * dx;
        this.mat[5] = 2.0 * near * dy;
        this.mat[10] = (far + near) * dz;
        this.mat[2] = (right + left) * dx;
        this.mat[6] = (top + bottom) * dy;
        this.mat[11] = 2.0 * far * near * dz;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 255;
    }

    public void setToPerspective(double fovx, double aspect, double zNear, double zFar) {
        double cotangent;
        double halfFOV = fovx * 0.5;
        double deltaZ = zFar - zNear;
        double sine = Math.sin(halfFOV);
        this.mat[0] = cotangent = Math.cos(halfFOV) / sine;
        this.mat[5] = cotangent * aspect;
        this.mat[10] = (zFar + zNear) / deltaZ;
        this.mat[11] = 2.0 * zNear * zFar / deltaZ;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 255;
    }

    public void setToOrtho(double left, double right, double bottom, double top, double near, double far) {
        double deltax = 1.0 / (right - left);
        double deltay = 1.0 / (top - bottom);
        double deltaz = 1.0 / (far - near);
        this.mat[0] = 2.0 * deltax;
        this.mat[3] = -(right + left) * deltax;
        this.mat[5] = 2.0 * deltay;
        this.mat[7] = -(top + bottom) * deltay;
        this.mat[10] = 2.0 * deltaz;
        this.mat[11] = (far + near) * deltaz;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void multiply(double scalar) {
        int i = 0;
        while (i < 16) {
            int n = i++;
            this.mat[n] = this.mat[n] * scalar;
        }
        this.dirtyBits = 255;
    }

    public final E3DTransform product(double scalar) {
        double[] m = new double[16];
        int i = 0;
        while (i < 16) {
            m[i] = this.mat[i] * scalar;
            ++i;
        }
        return new E3DTransform(m);
    }

    public final void multiply(E3DTransform t) {
        double tmp11;
        double tmp10;
        double tmp9;
        double tmp8;
        double tmp7;
        double tmp6;
        double tmp5;
        double tmp4;
        double tmp3;
        double tmp2;
        double tmp1;
        double tmp0;
        boolean aff = false;
        if (t.isAffine()) {
            tmp0 = this.mat[0] * t.mat[0] + this.mat[1] * t.mat[4] + this.mat[2] * t.mat[8];
            tmp1 = this.mat[0] * t.mat[1] + this.mat[1] * t.mat[5] + this.mat[2] * t.mat[9];
            tmp2 = this.mat[0] * t.mat[2] + this.mat[1] * t.mat[6] + this.mat[2] * t.mat[10];
            tmp3 = this.mat[0] * t.mat[3] + this.mat[1] * t.mat[7] + this.mat[2] * t.mat[11] + this.mat[3];
            tmp4 = this.mat[4] * t.mat[0] + this.mat[5] * t.mat[4] + this.mat[6] * t.mat[8];
            tmp5 = this.mat[4] * t.mat[1] + this.mat[5] * t.mat[5] + this.mat[6] * t.mat[9];
            tmp6 = this.mat[4] * t.mat[2] + this.mat[5] * t.mat[6] + this.mat[6] * t.mat[10];
            tmp7 = this.mat[4] * t.mat[3] + this.mat[5] * t.mat[7] + this.mat[6] * t.mat[11] + this.mat[7];
            tmp8 = this.mat[8] * t.mat[0] + this.mat[9] * t.mat[4] + this.mat[10] * t.mat[8];
            tmp9 = this.mat[8] * t.mat[1] + this.mat[9] * t.mat[5] + this.mat[10] * t.mat[9];
            tmp10 = this.mat[8] * t.mat[2] + this.mat[9] * t.mat[6] + this.mat[10] * t.mat[10];
            tmp11 = this.mat[8] * t.mat[3] + this.mat[9] * t.mat[7] + this.mat[10] * t.mat[11] + this.mat[11];
            if (this.isAffine()) {
                this.mat[14] = 0.0;
                this.mat[13] = 0.0;
                this.mat[12] = 0.0;
                this.mat[15] = 1.0;
                aff = true;
            } else {
                double tmp12 = this.mat[12] * t.mat[0] + this.mat[13] * t.mat[4] + this.mat[14] * t.mat[8];
                double tmp13 = this.mat[12] * t.mat[1] + this.mat[13] * t.mat[5] + this.mat[14] * t.mat[9];
                double tmp14 = this.mat[12] * t.mat[2] + this.mat[13] * t.mat[6] + this.mat[14] * t.mat[10];
                double tmp15 = this.mat[12] * t.mat[3] + this.mat[13] * t.mat[7] + this.mat[14] * t.mat[11] + this.mat[15];
                this.mat[12] = tmp12;
                this.mat[13] = tmp13;
                this.mat[14] = tmp14;
                this.mat[15] = tmp15;
            }
        } else {
            tmp0 = this.mat[0] * t.mat[0] + this.mat[1] * t.mat[4] + this.mat[2] * t.mat[8] + this.mat[3] * t.mat[12];
            tmp1 = this.mat[0] * t.mat[1] + this.mat[1] * t.mat[5] + this.mat[2] * t.mat[9] + this.mat[3] * t.mat[13];
            tmp2 = this.mat[0] * t.mat[2] + this.mat[1] * t.mat[6] + this.mat[2] * t.mat[10] + this.mat[3] * t.mat[14];
            tmp3 = this.mat[0] * t.mat[3] + this.mat[1] * t.mat[7] + this.mat[2] * t.mat[11] + this.mat[3] * t.mat[15];
            tmp4 = this.mat[4] * t.mat[0] + this.mat[5] * t.mat[4] + this.mat[6] * t.mat[8] + this.mat[7] * t.mat[12];
            tmp5 = this.mat[4] * t.mat[1] + this.mat[5] * t.mat[5] + this.mat[6] * t.mat[9] + this.mat[7] * t.mat[13];
            tmp6 = this.mat[4] * t.mat[2] + this.mat[5] * t.mat[6] + this.mat[6] * t.mat[10] + this.mat[7] * t.mat[14];
            tmp7 = this.mat[4] * t.mat[3] + this.mat[5] * t.mat[7] + this.mat[6] * t.mat[11] + this.mat[7] * t.mat[15];
            tmp8 = this.mat[8] * t.mat[0] + this.mat[9] * t.mat[4] + this.mat[10] * t.mat[8] + this.mat[11] * t.mat[12];
            tmp9 = this.mat[8] * t.mat[1] + this.mat[9] * t.mat[5] + this.mat[10] * t.mat[9] + this.mat[11] * t.mat[13];
            tmp10 = this.mat[8] * t.mat[2] + this.mat[9] * t.mat[6] + this.mat[10] * t.mat[10] + this.mat[11] * t.mat[14];
            tmp11 = this.mat[8] * t.mat[3] + this.mat[9] * t.mat[7] + this.mat[10] * t.mat[11] + this.mat[11] * t.mat[15];
            if (this.isAffine()) {
                this.mat[12] = t.mat[12];
                this.mat[13] = t.mat[13];
                this.mat[14] = t.mat[14];
                this.mat[15] = t.mat[15];
            } else {
                double tmp12 = this.mat[12] * t.mat[0] + this.mat[13] * t.mat[4] + this.mat[14] * t.mat[8] + this.mat[15] * t.mat[12];
                double tmp13 = this.mat[12] * t.mat[1] + this.mat[13] * t.mat[5] + this.mat[14] * t.mat[9] + this.mat[15] * t.mat[13];
                double tmp14 = this.mat[12] * t.mat[2] + this.mat[13] * t.mat[6] + this.mat[14] * t.mat[10] + this.mat[15] * t.mat[14];
                double tmp15 = this.mat[12] * t.mat[3] + this.mat[13] * t.mat[7] + this.mat[14] * t.mat[11] + this.mat[15] * t.mat[15];
                this.mat[12] = tmp12;
                this.mat[13] = tmp13;
                this.mat[14] = tmp14;
                this.mat[15] = tmp15;
            }
        }
        this.mat[0] = tmp0;
        this.mat[1] = tmp1;
        this.mat[2] = tmp2;
        this.mat[3] = tmp3;
        this.mat[4] = tmp4;
        this.mat[5] = tmp5;
        this.mat[6] = tmp6;
        this.mat[7] = tmp7;
        this.mat[8] = tmp8;
        this.mat[9] = tmp9;
        this.mat[10] = tmp10;
        this.mat[11] = tmp11;
        if ((this.dirtyBits & 4) == 0 && (this.type & 0x40) != 0 && (t.dirtyBits & 4) == 0 && (t.type & 0x40) != 0) {
            this.type &= t.type;
            this.dirtyBits |= t.dirtyBits | 0x10 | 0xE0 | 8;
        } else {
            this.dirtyBits = aff ? 254 : 255;
        }
    }

    public final E3DTransform product(E3DTransform t) {
        double[] m = new double[16];
        if (t.isAffine()) {
            m[0] = this.mat[0] * t.mat[0] + this.mat[1] * t.mat[4] + this.mat[2] * t.mat[8];
            m[1] = this.mat[0] * t.mat[1] + this.mat[1] * t.mat[5] + this.mat[2] * t.mat[9];
            m[2] = this.mat[0] * t.mat[2] + this.mat[1] * t.mat[6] + this.mat[2] * t.mat[10];
            m[3] = this.mat[0] * t.mat[3] + this.mat[1] * t.mat[7] + this.mat[2] * t.mat[11] + this.mat[3];
            m[4] = this.mat[4] * t.mat[0] + this.mat[5] * t.mat[4] + this.mat[6] * t.mat[8];
            m[5] = this.mat[4] * t.mat[1] + this.mat[5] * t.mat[5] + this.mat[6] * t.mat[9];
            m[6] = this.mat[4] * t.mat[2] + this.mat[5] * t.mat[6] + this.mat[6] * t.mat[10];
            m[7] = this.mat[4] * t.mat[3] + this.mat[5] * t.mat[7] + this.mat[6] * t.mat[11] + this.mat[7];
            m[8] = this.mat[8] * t.mat[0] + this.mat[9] * t.mat[4] + this.mat[10] * t.mat[8];
            m[9] = this.mat[8] * t.mat[1] + this.mat[9] * t.mat[5] + this.mat[10] * t.mat[9];
            m[10] = this.mat[8] * t.mat[2] + this.mat[9] * t.mat[6] + this.mat[10] * t.mat[10];
            m[11] = this.mat[8] * t.mat[3] + this.mat[9] * t.mat[7] + this.mat[10] * t.mat[11] + this.mat[11];
            if (this.isAffine()) {
                m[14] = 0.0;
                m[13] = 0.0;
                m[12] = 0.0;
                m[15] = 1.0;
            } else {
                m[12] = this.mat[12] * t.mat[0] + this.mat[13] * t.mat[4] + this.mat[14] * t.mat[8];
                m[13] = this.mat[12] * t.mat[1] + this.mat[13] * t.mat[5] + this.mat[14] * t.mat[9];
                m[14] = this.mat[12] * t.mat[2] + this.mat[13] * t.mat[6] + this.mat[14] * t.mat[10];
                m[15] = this.mat[12] * t.mat[3] + this.mat[13] * t.mat[7] + this.mat[14] * t.mat[11] + this.mat[15];
            }
        } else {
            m[0] = this.mat[0] * t.mat[0] + this.mat[1] * t.mat[4] + this.mat[2] * t.mat[8] + this.mat[3] * t.mat[12];
            m[1] = this.mat[0] * t.mat[1] + this.mat[1] * t.mat[5] + this.mat[2] * t.mat[9] + this.mat[3] * t.mat[13];
            m[2] = this.mat[0] * t.mat[2] + this.mat[1] * t.mat[6] + this.mat[2] * t.mat[10] + this.mat[3] * t.mat[14];
            m[3] = this.mat[0] * t.mat[3] + this.mat[1] * t.mat[7] + this.mat[2] * t.mat[11] + this.mat[3] * t.mat[15];
            m[4] = this.mat[4] * t.mat[0] + this.mat[5] * t.mat[4] + this.mat[6] * t.mat[8] + this.mat[7] * t.mat[12];
            m[5] = this.mat[4] * t.mat[1] + this.mat[5] * t.mat[5] + this.mat[6] * t.mat[9] + this.mat[7] * t.mat[13];
            m[6] = this.mat[4] * t.mat[2] + this.mat[5] * t.mat[6] + this.mat[6] * t.mat[10] + this.mat[7] * t.mat[14];
            m[7] = this.mat[4] * t.mat[3] + this.mat[5] * t.mat[7] + this.mat[6] * t.mat[11] + this.mat[7] * t.mat[15];
            m[8] = this.mat[8] * t.mat[0] + this.mat[9] * t.mat[4] + this.mat[10] * t.mat[8] + this.mat[11] * t.mat[12];
            m[9] = this.mat[8] * t.mat[1] + this.mat[9] * t.mat[5] + this.mat[10] * t.mat[9] + this.mat[11] * t.mat[13];
            m[10] = this.mat[8] * t.mat[2] + this.mat[9] * t.mat[6] + this.mat[10] * t.mat[10] + this.mat[11] * t.mat[14];
            m[11] = this.mat[8] * t.mat[3] + this.mat[9] * t.mat[7] + this.mat[10] * t.mat[11] + this.mat[11] * t.mat[15];
            if (this.isAffine()) {
                m[12] = t.mat[12];
                m[13] = t.mat[13];
                m[14] = t.mat[14];
                m[15] = t.mat[15];
            } else {
                m[12] = this.mat[12] * t.mat[0] + this.mat[13] * t.mat[4] + this.mat[14] * t.mat[8] + this.mat[15] * t.mat[12];
                m[13] = this.mat[12] * t.mat[1] + this.mat[13] * t.mat[5] + this.mat[14] * t.mat[9] + this.mat[15] * t.mat[13];
                m[14] = this.mat[12] * t.mat[2] + this.mat[13] * t.mat[6] + this.mat[14] * t.mat[10] + this.mat[15] * t.mat[14];
                m[15] = this.mat[12] * t.mat[3] + this.mat[13] * t.mat[7] + this.mat[14] * t.mat[11] + this.mat[15] * t.mat[15];
            }
        }
        return new E3DTransform(m);
    }

    public final void normalize() {
        if (!this.isAffine() && !this.isValid()) {
            return;
        }
        if ((this.dirtyBits & 0xC0) != 0) {
            this.computeScaleRotation(true);
        } else if ((this.dirtyBits & 0xA0) != 0) {
            this.computeScales(true);
        }
        this.mat[0] = this.rot[0] * this.scales[0];
        this.mat[1] = this.rot[1] * this.scales[1];
        this.mat[2] = this.rot[2] * this.scales[2];
        this.mat[4] = this.rot[3] * this.scales[0];
        this.mat[5] = this.rot[4] * this.scales[1];
        this.mat[6] = this.rot[5] * this.scales[2];
        this.mat[8] = this.rot[6] * this.scales[0];
        this.mat[9] = this.rot[7] * this.scales[1];
        this.mat[10] = this.rot[8] * this.scales[2];
        this.dirtyBits |= 0x10;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
    }

    public final E3DTransform normalized() {
        E3DTransform normalized = new E3DTransform(this);
        normalized.normalize();
        return normalized;
    }

    public final void normalizeCP() {
        double mag;
        if (!this.isAffine() && !this.isValid()) {
            return;
        }
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if ((mag = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]) != 0.0) {
            mag = 1.0 / Math.sqrt(mag);
            this.mat[0] = this.mat[0] * mag;
            this.mat[4] = this.mat[4] * mag;
            this.mat[8] = this.mat[8] * mag;
        }
        if ((mag = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]) != 0.0) {
            mag = 1.0 / Math.sqrt(mag);
            this.mat[1] = this.mat[1] * mag;
            this.mat[5] = this.mat[5] * mag;
            this.mat[9] = this.mat[9] * mag;
        }
        this.mat[2] = (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]) * this.scales[0];
        this.mat[6] = (this.mat[1] * this.mat[8] - this.mat[0] * this.mat[9]) * this.scales[1];
        this.mat[10] = (this.mat[0] * this.mat[5] - this.mat[1] * this.mat[4]) * this.scales[2];
        this.mat[0] = this.mat[0] * this.scales[0];
        this.mat[1] = this.mat[1] * this.scales[0];
        this.mat[4] = this.mat[4] * this.scales[1];
        this.mat[5] = this.mat[5] * this.scales[1];
        this.mat[8] = this.mat[8] * this.scales[2];
        this.mat[9] = this.mat[9] * this.scales[2];
        this.dirtyBits |= 0xDC;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
    }

    public final E3DTransform normalizedCP() {
        E3DTransform t = new E3DTransform(this);
        t.normalizeCP();
        return t;
    }

    public final double[] getMatrix() {
        return this.mat;
    }

    public final double getUniformScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        return MathUtils.max(this.scales);
    }

    public final E3DVector getScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        return new E3DVector(this.scales[0], this.scales[1], this.scales[2]);
    }

    public final E3DVector getTranslation() {
        return new E3DVector(this.mat[3], this.mat[7], this.mat[11]);
    }

    private final double getAffineDeterminant() {
        return this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) - this.mat[1] * (this.mat[4] * this.mat[10] - this.mat[6] * this.mat[8]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
    }

    public final double getDeterminant() {
        if (this.isAffine()) {
            return this.getAffineDeterminant();
        }
        return this.mat[0] * (this.mat[5] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) + this.mat[7] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13])) - this.mat[1] * (this.mat[4] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12])) + this.mat[2] * (this.mat[4] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12])) - this.mat[3] * (this.mat[4] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12]) + this.mat[6] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12]));
    }

    public final E3DVector transformedPoint(E3DVector point) {
        return new E3DVector(this.mat[0] * point.x + this.mat[1] * point.y + this.mat[2] * point.z + this.mat[3], this.mat[4] * point.x + this.mat[5] * point.y + this.mat[6] * point.z + this.mat[7], this.mat[8] * point.x + this.mat[9] * point.y + this.mat[10] * point.z + this.mat[11]);
    }

    public final void transformPoint(E3DVector point) {
        point.set(this.mat[0] * point.x + this.mat[1] * point.y + this.mat[2] * point.z + this.mat[3], this.mat[4] * point.x + this.mat[5] * point.y + this.mat[6] * point.z + this.mat[7], this.mat[8] * point.x + this.mat[9] * point.y + this.mat[10] * point.z + this.mat[11]);
    }

    public final E3DVector transformedNormal(E3DVector normal) {
        return new E3DVector(this.mat[0] * normal.x + this.mat[1] * normal.y + this.mat[2] * normal.z, this.mat[4] * normal.x + this.mat[5] * normal.y + this.mat[6] * normal.z, this.mat[8] * normal.x + this.mat[9] * normal.y + this.mat[10] * normal.z);
    }

    public final void transformNormal(E3DVector normal) {
        normal.set(this.mat[0] * normal.x + this.mat[1] * normal.y + this.mat[2] * normal.z, this.mat[4] * normal.x + this.mat[5] * normal.y + this.mat[6] * normal.z, this.mat[8] * normal.x + this.mat[9] * normal.y + this.mat[10] * normal.z);
    }

    private final void computeScales(boolean forceSVD) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!forceSVD || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFDF;
                    return;
                }
                this.scales[1] = this.scales[2] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[0] = this.scales[2];
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
            if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
        }
        if (this.rot == null) {
            this.rot = new double[9];
        }
        E3DTransform.computeSVD(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    private final void computeScaleRotation(boolean forceSVD) {
        if (this.rot == null) {
            this.rot = new double[9];
        }
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!forceSVD || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.rot[0] = this.mat[0];
                    this.rot[1] = this.mat[1];
                    this.rot[2] = this.mat[2];
                    this.rot[3] = this.mat[4];
                    this.rot[4] = this.mat[5];
                    this.rot[5] = this.mat[6];
                    this.rot[6] = this.mat[8];
                    this.rot[7] = this.mat[9];
                    this.rot[8] = this.mat[10];
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFFF;
                } else {
                    double s = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                    if (s == 0.0) {
                        E3DTransform.computeSVD(this, this.scales, this.rot);
                    } else {
                        this.scales[1] = this.scales[2] = s;
                        this.scales[0] = this.scales[2];
                        s = 1.0 / s;
                        this.rot[0] = this.mat[0] * s;
                        this.rot[1] = this.mat[1] * s;
                        this.rot[2] = this.mat[2] * s;
                        this.rot[3] = this.mat[4] * s;
                        this.rot[4] = this.mat[5] * s;
                        this.rot[5] = this.mat[6] * s;
                        this.rot[6] = this.mat[8] * s;
                        this.rot[7] = this.mat[9] * s;
                        this.rot[8] = this.mat[10] * s;
                        this.dirtyBits &= 0xFFFFFFFF;
                    }
                }
            } else if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                if (this.scales[0] == 0.0 || this.scales[1] == 0.0 || this.scales[2] == 0.0) {
                    E3DTransform.computeSVD(this, this.scales, this.rot);
                } else {
                    double s = 1.0 / this.scales[0];
                    this.rot[0] = this.mat[0] * s;
                    this.rot[3] = this.mat[4] * s;
                    this.rot[6] = this.mat[8] * s;
                    s = 1.0 / this.scales[1];
                    this.rot[1] = this.mat[1] * s;
                    this.rot[4] = this.mat[5] * s;
                    this.rot[7] = this.mat[9] * s;
                    s = 1.0 / this.scales[2];
                    this.rot[2] = this.mat[2] * s;
                    this.rot[5] = this.mat[6] * s;
                    this.rot[8] = this.mat[10] * s;
                    this.dirtyBits &= 0xFFFFFFFF;
                }
            }
            return;
        }
        E3DTransform.computeSVD(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    private static final boolean isAlmostZero(double a) {
        return a < 1.0E-5 && a > -1.0E-5;
    }

    private static final boolean isAlmostOne(double a) {
        return a < 1.00001 && a > 0.99999;
    }

    private static final boolean isAlmostEqual(double a, double b) {
        double diff = a - b;
        if (diff >= 0.0) {
            if (diff < 1.0E-10) {
                return true;
            }
            if (b > 0.0 || a > -b) {
                return diff < 1.0E-4 * a;
            }
            return diff < -1.0E-4 * b;
        }
        if (diff > -1.0E-10) {
            return true;
        }
        if (b < 0.0 || -a > b) {
            return diff > 1.0E-4 * a;
        }
        return diff > -1.0E-4 * b;
    }

    static boolean luDecomposition(double[] matrix0, int[] row_perm) {
        double[] row_scale = new double[4];
        int ptr = 0;
        int rs = 0;
        int i = 4;
        while (i-- != 0) {
            double big = 0.0;
            int j = 4;
            while (j-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            row_scale[rs++] = 1.0 / big;
        }
        int mtx = 0;
        int j = 0;
        while (j < 4) {
            i = 0;
            while (i < j) {
                int target = mtx + 4 * i + j;
                double sum = matrix0[target];
                int k = i;
                int p1 = mtx + 4 * i;
                int p2 = mtx + j;
                while (k-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 4;
                }
                matrix0[target] = sum;
                ++i;
            }
            double big = 0.0;
            int imax = -1;
            int i2 = j;
            while (i2 < 4) {
                int target = mtx + 4 * i2 + j;
                double sum = matrix0[target];
                int k = j;
                int p1 = mtx + 4 * i2;
                int p2 = mtx + j;
                while (k-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 4;
                }
                matrix0[target] = sum;
                double temp = row_scale[i2] * Math.abs(sum);
                if (temp >= big) {
                    big = temp;
                    imax = i2;
                }
                ++i2;
            }
            if (imax < 0) {
                return false;
            }
            if (j != imax) {
                int k = 4;
                int p1 = mtx + 4 * imax;
                int p2 = mtx + 4 * j;
                while (k-- != 0) {
                    double temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                row_scale[imax] = row_scale[j];
            }
            row_perm[j] = imax;
            if (matrix0[mtx + 4 * j + j] == 0.0) {
                return false;
            }
            if (j != 3) {
                double temp = 1.0 / matrix0[mtx + 4 * j + j];
                int target = mtx + 4 * (j + 1) + j;
                int i3 = 3 - j;
                while (i3-- != 0) {
                    int n = target;
                    matrix0[n] = matrix0[n] * temp;
                    target += 4;
                }
            }
            ++j;
        }
        return true;
    }

    static void luBacksubstitution(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        int k = 0;
        while (k < 4) {
            int cv = k;
            int ii = -1;
            int i = 0;
            while (i < 4) {
                int ip = row_perm[rp + i];
                double sum = matrix2[cv + 4 * ip];
                matrix2[cv + 4 * ip] = matrix2[cv + 4 * i];
                if (ii >= 0) {
                    int rv = i * 4;
                    int j = ii;
                    while (j <= i - 1) {
                        sum -= matrix1[rv + j] * matrix2[cv + 4 * j];
                        ++j;
                    }
                } else if (sum != 0.0) {
                    ii = i;
                }
                matrix2[cv + 4 * i] = sum;
                ++i;
            }
            int rv = 12;
            int n = cv + 12;
            matrix2[n] = matrix2[n] / matrix1[rv + 3];
            matrix2[cv + 8] = (matrix2[cv + 8] - matrix1[(rv -= 4) + 3] * matrix2[cv + 12]) / matrix1[rv + 2];
            matrix2[cv + 4] = (matrix2[cv + 4] - matrix1[(rv -= 4) + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 4) + 1] * matrix2[cv + 4] - matrix1[rv + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 0];
            ++k;
        }
    }

    private static void matrixMultiply(double[] m1, double[] m2, double[] m3) {
        double[] result = m3;
        if (m1 == m3 || m2 == m3) {
            result = new double[]{m1[0] * m2[0] + m1[1] * m2[3] + m1[2] * m2[6], m1[0] * m2[1] + m1[1] * m2[4] + m1[2] * m2[7], m1[0] * m2[2] + m1[1] * m2[5] + m1[2] * m2[8], m1[3] * m2[0] + m1[4] * m2[3] + m1[5] * m2[6], m1[3] * m2[1] + m1[4] * m2[4] + m1[5] * m2[7], m1[3] * m2[2] + m1[4] * m2[5] + m1[5] * m2[8], m1[6] * m2[0] + m1[7] * m2[3] + m1[8] * m2[6], m1[6] * m2[1] + m1[7] * m2[4] + m1[8] * m2[7], m1[6] * m2[2] + m1[7] * m2[5] + m1[8] * m2[8]};
        }
        if (result != m3) {
            int i = 0;
            while (i < 9) {
                m3[i] = result[i];
                ++i;
            }
        }
    }

    private static void transposeMatrix(double[] in, double[] out) {
        out[0] = in[0];
        out[1] = in[3];
        out[2] = in[6];
        out[3] = in[1];
        out[4] = in[4];
        out[5] = in[7];
        out[6] = in[2];
        out[7] = in[5];
        out[8] = in[8];
    }

    private static void computeSVD(E3DTransform matrix, double[] outScale, double[] outRot) {
        double g;
        double[] m = new double[9];
        double[] u1 = new double[9];
        double[] v1 = new double[9];
        double[] t1 = new double[9];
        double[] t2 = new double[9];
        double[] svdRot = new double[9];
        double[] e = new double[3];
        double[] svdScales = new double[3];
        int negCnt = 0;
        svdRot[0] = m[0] = matrix.mat[0];
        svdRot[1] = m[1] = matrix.mat[1];
        svdRot[2] = m[2] = matrix.mat[2];
        svdRot[3] = m[3] = matrix.mat[4];
        svdRot[4] = m[4] = matrix.mat[5];
        svdRot[5] = m[5] = matrix.mat[6];
        svdRot[6] = m[6] = matrix.mat[8];
        svdRot[7] = m[7] = matrix.mat[9];
        svdRot[8] = m[8] = matrix.mat[10];
        if (m[3] * m[3] < 1.110223024E-16) {
            u1[0] = 1.0;
            u1[1] = 0.0;
            u1[2] = 0.0;
            u1[3] = 0.0;
            u1[4] = 1.0;
            u1[5] = 0.0;
            u1[6] = 0.0;
            u1[7] = 0.0;
            u1[8] = 1.0;
        } else if (m[0] * m[0] < 1.110223024E-16) {
            t1[0] = m[0];
            t1[1] = m[1];
            t1[2] = m[2];
            m[0] = m[3];
            m[1] = m[4];
            m[2] = m[5];
            m[3] = -t1[0];
            m[4] = -t1[1];
            m[5] = -t1[2];
            u1[0] = 0.0;
            u1[1] = 1.0;
            u1[2] = 0.0;
            u1[3] = -1.0;
            u1[4] = 0.0;
            u1[5] = 0.0;
            u1[6] = 0.0;
            u1[7] = 0.0;
            u1[8] = 1.0;
        } else {
            g = 1.0 / Math.sqrt(m[0] * m[0] + m[3] * m[3]);
            double c1 = m[0] * g;
            double s1 = m[3] * g;
            t1[0] = c1 * m[0] + s1 * m[3];
            t1[1] = c1 * m[1] + s1 * m[4];
            t1[2] = c1 * m[2] + s1 * m[5];
            m[3] = -s1 * m[0] + c1 * m[3];
            m[4] = -s1 * m[1] + c1 * m[4];
            m[5] = -s1 * m[2] + c1 * m[5];
            m[0] = t1[0];
            m[1] = t1[1];
            m[2] = t1[2];
            u1[0] = c1;
            u1[1] = s1;
            u1[2] = 0.0;
            u1[3] = -s1;
            u1[4] = c1;
            u1[5] = 0.0;
            u1[6] = 0.0;
            u1[7] = 0.0;
            u1[8] = 1.0;
        }
        if (!(m[6] * m[6] < 1.110223024E-16)) {
            if (m[0] * m[0] < 1.110223024E-16) {
                t1[0] = m[0];
                t1[1] = m[1];
                t1[2] = m[2];
                m[0] = m[6];
                m[1] = m[7];
                m[2] = m[8];
                m[6] = -t1[0];
                m[7] = -t1[1];
                m[8] = -t1[2];
                t1[0] = u1[0];
                t1[1] = u1[1];
                t1[2] = u1[2];
                u1[0] = u1[6];
                u1[1] = u1[7];
                u1[2] = u1[8];
                u1[6] = -t1[0];
                u1[7] = -t1[1];
                u1[8] = -t1[2];
            } else {
                g = 1.0 / Math.sqrt(m[0] * m[0] + m[6] * m[6]);
                double c2 = m[0] * g;
                double s2 = m[6] * g;
                t1[0] = c2 * m[0] + s2 * m[6];
                t1[1] = c2 * m[1] + s2 * m[7];
                t1[2] = c2 * m[2] + s2 * m[8];
                m[6] = -s2 * m[0] + c2 * m[6];
                m[7] = -s2 * m[1] + c2 * m[7];
                m[8] = -s2 * m[2] + c2 * m[8];
                m[0] = t1[0];
                m[1] = t1[1];
                m[2] = t1[2];
                t1[0] = c2 * u1[0];
                t1[1] = c2 * u1[1];
                u1[2] = s2;
                t1[6] = -u1[0] * s2;
                t1[7] = -u1[1] * s2;
                u1[8] = c2;
                u1[0] = t1[0];
                u1[1] = t1[1];
                u1[6] = t1[6];
                u1[7] = t1[7];
            }
        }
        if (m[2] * m[2] < 1.110223024E-16) {
            v1[0] = 1.0;
            v1[1] = 0.0;
            v1[2] = 0.0;
            v1[3] = 0.0;
            v1[4] = 1.0;
            v1[5] = 0.0;
            v1[6] = 0.0;
            v1[7] = 0.0;
            v1[8] = 1.0;
        } else if (m[1] * m[1] < 1.110223024E-16) {
            t1[2] = m[2];
            t1[5] = m[5];
            t1[8] = m[8];
            m[2] = -m[1];
            m[5] = -m[4];
            m[8] = -m[7];
            m[1] = t1[2];
            m[4] = t1[5];
            m[7] = t1[8];
            v1[0] = 1.0;
            v1[1] = 0.0;
            v1[2] = 0.0;
            v1[3] = 0.0;
            v1[4] = 0.0;
            v1[5] = -1.0;
            v1[6] = 0.0;
            v1[7] = 1.0;
            v1[8] = 0.0;
        } else {
            g = 1.0 / Math.sqrt(m[1] * m[1] + m[2] * m[2]);
            double c3 = m[1] * g;
            double s3 = m[2] * g;
            t1[1] = c3 * m[1] + s3 * m[2];
            m[2] = -s3 * m[1] + c3 * m[2];
            m[1] = t1[1];
            t1[4] = c3 * m[4] + s3 * m[5];
            m[5] = -s3 * m[4] + c3 * m[5];
            m[4] = t1[4];
            t1[7] = c3 * m[7] + s3 * m[8];
            m[8] = -s3 * m[7] + c3 * m[8];
            m[7] = t1[7];
            v1[0] = 1.0;
            v1[1] = 0.0;
            v1[2] = 0.0;
            v1[3] = 0.0;
            v1[4] = c3;
            v1[5] = -s3;
            v1[6] = 0.0;
            v1[7] = s3;
            v1[8] = c3;
        }
        if (!(m[7] * m[7] < 1.110223024E-16)) {
            if (m[4] * m[4] < 1.110223024E-16) {
                t1[3] = m[3];
                t1[4] = m[4];
                t1[5] = m[5];
                m[3] = m[6];
                m[4] = m[7];
                m[5] = m[8];
                m[6] = -t1[3];
                m[7] = -t1[4];
                m[8] = -t1[5];
                t1[3] = u1[3];
                t1[4] = u1[4];
                t1[5] = u1[5];
                u1[3] = u1[6];
                u1[4] = u1[7];
                u1[5] = u1[8];
                u1[6] = -t1[3];
                u1[7] = -t1[4];
                u1[8] = -t1[5];
            } else {
                g = 1.0 / Math.sqrt(m[4] * m[4] + m[7] * m[7]);
                double c4 = m[4] * g;
                double s4 = m[7] * g;
                t1[3] = c4 * m[3] + s4 * m[6];
                m[6] = -s4 * m[3] + c4 * m[6];
                m[3] = t1[3];
                t1[4] = c4 * m[4] + s4 * m[7];
                m[7] = -s4 * m[4] + c4 * m[7];
                m[4] = t1[4];
                t1[5] = c4 * m[5] + s4 * m[8];
                m[8] = -s4 * m[5] + c4 * m[8];
                m[5] = t1[5];
                t1[3] = c4 * u1[3] + s4 * u1[6];
                u1[6] = -s4 * u1[3] + c4 * u1[6];
                u1[3] = t1[3];
                t1[4] = c4 * u1[4] + s4 * u1[7];
                u1[7] = -s4 * u1[4] + c4 * u1[7];
                u1[4] = t1[4];
                t1[5] = c4 * u1[5] + s4 * u1[8];
                u1[8] = -s4 * u1[5] + c4 * u1[8];
                u1[5] = t1[5];
            }
        }
        t2[0] = m[0];
        t2[1] = m[4];
        t2[2] = m[8];
        e[0] = m[1];
        e[1] = m[5];
        if (e[0] * e[0] > 1.110223024E-16 || e[1] * e[1] > 1.110223024E-16) {
            E3DTransform.computeGR(t2, e, u1, v1);
        }
        svdScales[0] = t2[0];
        svdScales[1] = t2[1];
        svdScales[2] = t2[2];
        if (E3DTransform.isAlmostOne(Math.abs(svdScales[0])) && E3DTransform.isAlmostOne(Math.abs(svdScales[1])) && E3DTransform.isAlmostOne(Math.abs(svdScales[2]))) {
            int i = 0;
            while (i < 3) {
                if (svdScales[i] < 0.0) {
                    ++negCnt;
                }
                ++i;
            }
            if (negCnt == 0 || negCnt == 2) {
                outScale[2] = 1.0;
                outScale[1] = 1.0;
                outScale[0] = 1.0;
                i = 0;
                while (i < 9) {
                    outRot[i] = svdRot[i];
                    ++i;
                }
                return;
            }
        }
        E3DTransform.transposeMatrix(u1, t1);
        E3DTransform.transposeMatrix(v1, t2);
        E3DTransform.svdReorder(m, t1, t2, svdRot, svdScales, outRot, outScale);
    }

    private static void svdReorder(double[] m, double[] t1, double[] t2, double[] rot, double[] scales, double[] outRot, double[] outScale) {
        int[] svdOut = new int[3];
        double[] svdMag = new double[3];
        if (scales[0] < 0.0) {
            scales[0] = -scales[0];
            t2[0] = -t2[0];
            t2[1] = -t2[1];
            t2[2] = -t2[2];
        }
        if (scales[1] < 0.0) {
            scales[1] = -scales[1];
            t2[3] = -t2[3];
            t2[4] = -t2[4];
            t2[5] = -t2[5];
        }
        if (scales[2] < 0.0) {
            scales[2] = -scales[2];
            t2[6] = -t2[6];
            t2[7] = -t2[7];
            t2[8] = -t2[8];
        }
        E3DTransform.matrixMultiply(t1, t2, rot);
        if (E3DTransform.isAlmostEqual(Math.abs(scales[0]), Math.abs(scales[1])) && E3DTransform.isAlmostEqual(Math.abs(scales[1]), Math.abs(scales[2]))) {
            int i = 0;
            while (i < 9) {
                outRot[i] = rot[i];
                ++i;
            }
            i = 0;
            while (i < 3) {
                outScale[i] = scales[i];
                ++i;
            }
        } else {
            int in1;
            int in2;
            int in0;
            if (scales[0] > scales[1]) {
                if (scales[0] > scales[2]) {
                    if (scales[2] > scales[1]) {
                        svdOut[0] = 0;
                        svdOut[1] = 2;
                        svdOut[2] = 1;
                    } else {
                        svdOut[0] = 0;
                        svdOut[1] = 1;
                        svdOut[2] = 2;
                    }
                } else {
                    svdOut[0] = 2;
                    svdOut[1] = 0;
                    svdOut[2] = 1;
                }
            } else if (scales[1] > scales[2]) {
                if (scales[2] > scales[0]) {
                    svdOut[0] = 1;
                    svdOut[1] = 2;
                    svdOut[2] = 0;
                } else {
                    svdOut[0] = 1;
                    svdOut[1] = 0;
                    svdOut[2] = 2;
                }
            } else {
                svdOut[0] = 2;
                svdOut[1] = 1;
                svdOut[2] = 0;
            }
            svdMag[0] = m[0] * m[0] + m[1] * m[1] + m[2] * m[2];
            svdMag[1] = m[3] * m[3] + m[4] * m[4] + m[5] * m[5];
            svdMag[2] = m[6] * m[6] + m[7] * m[7] + m[8] * m[8];
            if (svdMag[0] > svdMag[1]) {
                if (svdMag[0] > svdMag[2]) {
                    if (svdMag[2] > svdMag[1]) {
                        in0 = 0;
                        in2 = 1;
                        in1 = 2;
                    } else {
                        in0 = 0;
                        in1 = 1;
                        in2 = 2;
                    }
                } else {
                    in2 = 0;
                    in0 = 1;
                    in1 = 2;
                }
            } else if (svdMag[1] > svdMag[2]) {
                if (svdMag[2] > svdMag[0]) {
                    in1 = 0;
                    in2 = 1;
                    in0 = 2;
                } else {
                    in1 = 0;
                    in0 = 1;
                    in2 = 2;
                }
            } else {
                in2 = 0;
                in1 = 1;
                in0 = 2;
            }
            int index = svdOut[in0];
            outScale[0] = scales[index];
            index = svdOut[in1];
            outScale[1] = scales[index];
            index = svdOut[in2];
            outScale[2] = scales[index];
            index = svdOut[in0];
            outRot[0] = rot[index];
            index = svdOut[in0] + 3;
            outRot[3] = rot[index];
            index = svdOut[in0] + 6;
            outRot[6] = rot[index];
            index = svdOut[in1];
            outRot[1] = rot[index];
            index = svdOut[in1] + 3;
            outRot[4] = rot[index];
            index = svdOut[in1] + 6;
            outRot[7] = rot[index];
            index = svdOut[in2];
            outRot[2] = rot[index];
            index = svdOut[in2] + 3;
            outRot[5] = rot[index];
            index = svdOut[in2] + 6;
            outRot[8] = rot[index];
        }
    }

    private static int computeGR(double[] s, double[] e, double[] u, double[] v) {
        double vtemp;
        double utemp;
        boolean converged = false;
        int MAX_INTERATIONS = 10;
        double CONVERGE_TOL = 4.89E-15;
        double[] cosl = new double[2];
        double[] cosr = new double[2];
        double[] sinl = new double[2];
        double[] sinr = new double[2];
        double[] qr_m = new double[9];
        double c_b48 = 1.0;
        int first = 1;
        if (Math.abs(e[1]) < 4.89E-15 || Math.abs(e[0]) < 4.89E-15) {
            converged = true;
        }
        int k = 0;
        while (k < 10 && !converged) {
            double shift = E3DTransform.computeShift(s[1], e[1], s[2]);
            double f = (Math.abs(s[0]) - shift) * (E3DTransform.sign(c_b48, s[0]) + shift / s[0]);
            double g = e[0];
            double r = E3DTransform.computeRot(f, g, sinr, cosr, 0, first);
            f = cosr[0] * s[0] + sinr[0] * e[0];
            e[0] = cosr[0] * e[0] - sinr[0] * s[0];
            g = sinr[0] * s[1];
            s[1] = cosr[0] * s[1];
            r = E3DTransform.computeRot(f, g, sinl, cosl, 0, first);
            first = 0;
            s[0] = r;
            f = cosl[0] * e[0] + sinl[0] * s[1];
            s[1] = cosl[0] * s[1] - sinl[0] * e[0];
            g = sinl[0] * e[1];
            e[1] = cosl[0] * e[1];
            e[0] = r = E3DTransform.computeRot(f, g, sinr, cosr, 1, first);
            f = cosr[1] * s[1] + sinr[1] * e[1];
            e[1] = cosr[1] * e[1] - sinr[1] * s[1];
            g = sinr[1] * s[2];
            s[2] = cosr[1] * s[2];
            s[1] = r = E3DTransform.computeRot(f, g, sinl, cosl, 1, first);
            f = cosl[1] * e[1] + sinl[1] * s[2];
            s[2] = cosl[1] * s[2] - sinl[1] * e[1];
            e[1] = f;
            utemp = u[0];
            u[0] = cosl[0] * utemp + sinl[0] * u[3];
            u[3] = -sinl[0] * utemp + cosl[0] * u[3];
            utemp = u[1];
            u[1] = cosl[0] * utemp + sinl[0] * u[4];
            u[4] = -sinl[0] * utemp + cosl[0] * u[4];
            utemp = u[2];
            u[2] = cosl[0] * utemp + sinl[0] * u[5];
            u[5] = -sinl[0] * utemp + cosl[0] * u[5];
            utemp = u[3];
            u[3] = cosl[1] * utemp + sinl[1] * u[6];
            u[6] = -sinl[1] * utemp + cosl[1] * u[6];
            utemp = u[4];
            u[4] = cosl[1] * utemp + sinl[1] * u[7];
            u[7] = -sinl[1] * utemp + cosl[1] * u[7];
            utemp = u[5];
            u[5] = cosl[1] * utemp + sinl[1] * u[8];
            u[8] = -sinl[1] * utemp + cosl[1] * u[8];
            vtemp = v[0];
            v[0] = cosr[0] * vtemp + sinr[0] * v[1];
            v[1] = -sinr[0] * vtemp + cosr[0] * v[1];
            vtemp = v[3];
            v[3] = cosr[0] * vtemp + sinr[0] * v[4];
            v[4] = -sinr[0] * vtemp + cosr[0] * v[4];
            vtemp = v[6];
            v[6] = cosr[0] * vtemp + sinr[0] * v[7];
            v[7] = -sinr[0] * vtemp + cosr[0] * v[7];
            vtemp = v[1];
            v[1] = cosr[1] * vtemp + sinr[1] * v[2];
            v[2] = -sinr[1] * vtemp + cosr[1] * v[2];
            vtemp = v[4];
            v[4] = cosr[1] * vtemp + sinr[1] * v[5];
            v[5] = -sinr[1] * vtemp + cosr[1] * v[5];
            vtemp = v[7];
            v[7] = cosr[1] * vtemp + sinr[1] * v[8];
            v[8] = -sinr[1] * vtemp + cosr[1] * v[8];
            qr_m[0] = s[0];
            qr_m[1] = e[0];
            qr_m[2] = 0.0;
            qr_m[3] = 0.0;
            qr_m[4] = s[1];
            qr_m[5] = e[1];
            qr_m[6] = 0.0;
            qr_m[7] = 0.0;
            qr_m[8] = s[2];
            if (Math.abs(e[1]) < 4.89E-15 || Math.abs(e[0]) < 4.89E-15) {
                converged = true;
            }
            ++k;
        }
        if (Math.abs(e[1]) < 4.89E-15) {
            E3DTransform.compute2X2(s[0], e[0], s[1], s, sinl, cosl, sinr, cosr, 0);
            utemp = u[0];
            u[0] = cosl[0] * utemp + sinl[0] * u[3];
            u[3] = -sinl[0] * utemp + cosl[0] * u[3];
            utemp = u[1];
            u[1] = cosl[0] * utemp + sinl[0] * u[4];
            u[4] = -sinl[0] * utemp + cosl[0] * u[4];
            utemp = u[2];
            u[2] = cosl[0] * utemp + sinl[0] * u[5];
            u[5] = -sinl[0] * utemp + cosl[0] * u[5];
            vtemp = v[0];
            v[0] = cosr[0] * vtemp + sinr[0] * v[1];
            v[1] = -sinr[0] * vtemp + cosr[0] * v[1];
            vtemp = v[3];
            v[3] = cosr[0] * vtemp + sinr[0] * v[4];
            v[4] = -sinr[0] * vtemp + cosr[0] * v[4];
            vtemp = v[6];
            v[6] = cosr[0] * vtemp + sinr[0] * v[7];
            v[7] = -sinr[0] * vtemp + cosr[0] * v[7];
        } else {
            E3DTransform.compute2X2(s[1], e[1], s[2], s, sinl, cosl, sinr, cosr, 1);
            utemp = u[3];
            u[3] = cosl[0] * utemp + sinl[0] * u[6];
            u[6] = -sinl[0] * utemp + cosl[0] * u[6];
            utemp = u[4];
            u[4] = cosl[0] * utemp + sinl[0] * u[7];
            u[7] = -sinl[0] * utemp + cosl[0] * u[7];
            utemp = u[5];
            u[5] = cosl[0] * utemp + sinl[0] * u[8];
            u[8] = -sinl[0] * utemp + cosl[0] * u[8];
            vtemp = v[1];
            v[1] = cosr[0] * vtemp + sinr[0] * v[2];
            v[2] = -sinr[0] * vtemp + cosr[0] * v[2];
            vtemp = v[4];
            v[4] = cosr[0] * vtemp + sinr[0] * v[5];
            v[5] = -sinr[0] * vtemp + cosr[0] * v[5];
            vtemp = v[7];
            v[7] = cosr[0] * vtemp + sinr[0] * v[8];
            v[8] = -sinr[0] * vtemp + cosr[0] * v[8];
        }
        return 0;
    }

    private static final double sign(double a, double b) {
        double absA = a >= 0.0 ? a : -a;
        return b >= 0.0 ? absA : -absA;
    }

    private static final double computeShift(double f, double g, double h) {
        double ssmin;
        double fa = Math.abs(f);
        double ga = Math.abs(g);
        double ha = Math.abs(h);
        double fhmn = Math.min(fa, ha);
        double fhmx = Math.max(fa, ha);
        if (fhmn == 0.0) {
            ssmin = 0.0;
            if (fhmx != 0.0) {
                double d1 = Math.min(fhmx, ga) / Math.max(fhmx, ga);
            }
        } else if (ga < fhmx) {
            double as = fhmn / fhmx + 1.0;
            double at = (fhmx - fhmn) / fhmx;
            double d1 = ga / fhmx;
            double au = d1 * d1;
            double c = 2.0 / (Math.sqrt(as * as + au) + Math.sqrt(at * at + au));
            ssmin = fhmn * c;
        } else {
            double au = fhmx / ga;
            if (au == 0.0) {
                ssmin = fhmn * fhmx / ga;
            } else {
                double as = fhmn / fhmx + 1.0;
                double at = (fhmx - fhmn) / fhmx;
                double d1 = as * au;
                double d2 = at * au;
                double c = 1.0 / (Math.sqrt(d1 * d1 + 1.0) + Math.sqrt(d2 * d2 + 1.0));
                ssmin = fhmn * c * au;
                ssmin += ssmin;
            }
        }
        return ssmin;
    }

    private static int compute2X2(double f, double g, double h, double[] single_values, double[] snl, double[] csl, double[] snr, double[] csr, int index) {
        double gt;
        double ga;
        double c_b3 = 2.0;
        double c_b4 = 1.0;
        double ssmax = single_values[0];
        double ssmin = single_values[1];
        double tsign = 0.0;
        double srt = 0.0;
        double slt = 0.0;
        double crt = 0.0;
        double clt = 0.0;
        double ft = f;
        double fa = Math.abs(ft);
        double ht = h;
        double ha = Math.abs(h);
        int pmax = 1;
        boolean swap = ha > fa;
        if (swap) {
            pmax = 3;
            double temp = ft;
            ft = ht;
            ht = temp;
            temp = fa;
            fa = ha;
            ha = temp;
        }
        if ((ga = Math.abs(gt = g)) == 0.0) {
            single_values[1] = ha;
            single_values[0] = fa;
            clt = 1.0;
            crt = 1.0;
            slt = 0.0;
            srt = 0.0;
        } else {
            boolean gasmal = true;
            if (ga > fa) {
                pmax = 2;
                if (fa / ga < 1.110223024E-16) {
                    gasmal = false;
                    ssmax = ga;
                    ssmin = ha > 1.0 ? fa / (ga / ha) : fa / ga * ha;
                    clt = 1.0;
                    slt = ht / gt;
                    srt = 1.0;
                    crt = ft / gt;
                }
            }
            if (gasmal) {
                double d = fa - ha;
                double l = d == fa ? 1.0 : d / fa;
                double m = gt / ft;
                double t = 2.0 - l;
                double mm = m * m;
                double tt = t * t;
                double s = Math.sqrt(tt + mm);
                double r = l == 0.0 ? Math.abs(m) : Math.sqrt(l * l + mm);
                double a = (s + r) * 0.5;
                if (ga > fa) {
                    pmax = 2;
                    if (fa / ga < 1.110223024E-16) {
                        gasmal = false;
                        ssmax = ga;
                        ssmin = ha > 1.0 ? fa / (ga / ha) : fa / ga * ha;
                        clt = 1.0;
                        slt = ht / gt;
                        srt = 1.0;
                        crt = ft / gt;
                    }
                }
                if (gasmal) {
                    d = fa - ha;
                    l = d == fa ? 1.0 : d / fa;
                    m = gt / ft;
                    t = 2.0 - l;
                    mm = m * m;
                    tt = t * t;
                    s = Math.sqrt(tt + mm);
                    r = l == 0.0 ? Math.abs(m) : Math.sqrt(l * l + mm);
                    a = (s + r) * 0.5;
                    ssmin = ha / a;
                    ssmax = fa * a;
                    t = mm == 0.0 ? (l == 0.0 ? E3DTransform.sign(c_b3, ft) * E3DTransform.sign(c_b4, gt) : gt / E3DTransform.sign(d, ft) + m / t) : (m / (s + t) + m / (r + l)) * (a + 1.0);
                    l = Math.sqrt(t * t + 4.0);
                    crt = 2.0 / l;
                    srt = t / l;
                    clt = (crt + srt * m) / a;
                    slt = ht / ft * srt / a;
                }
            }
            if (swap) {
                csl[0] = srt;
                snl[0] = crt;
                csr[0] = slt;
                snr[0] = clt;
            } else {
                csl[0] = clt;
                snl[0] = slt;
                csr[0] = crt;
                snr[0] = srt;
            }
            if (pmax == 1) {
                tsign = E3DTransform.sign(c_b4, csr[0]) * E3DTransform.sign(c_b4, csl[0]) * E3DTransform.sign(c_b4, f);
            }
            if (pmax == 2) {
                tsign = E3DTransform.sign(c_b4, snr[0]) * E3DTransform.sign(c_b4, csl[0]) * E3DTransform.sign(c_b4, g);
            }
            if (pmax == 3) {
                tsign = E3DTransform.sign(c_b4, snr[0]) * E3DTransform.sign(c_b4, snl[0]) * E3DTransform.sign(c_b4, h);
            }
            single_values[index] = E3DTransform.sign(ssmax, tsign);
            double d1 = tsign * E3DTransform.sign(c_b4, f) * E3DTransform.sign(c_b4, h);
            single_values[index + 1] = E3DTransform.sign(ssmin, d1);
        }
        return 0;
    }

    private static double computeRot(double f, double g, double[] sin, double[] cos, int index, int first) {
        double r;
        double sn;
        double cs;
        double safmn2 = 2.002083095183101E-146;
        double safmx2 = 4.994797680505588E145;
        if (g == 0.0) {
            cs = 1.0;
            sn = 0.0;
            r = f;
        } else if (f == 0.0) {
            cs = 0.0;
            sn = 1.0;
            r = g;
        } else {
            double f1 = f;
            double g1 = g;
            double scale = Math.max(Math.abs(f1), Math.abs(g1));
            if (scale >= 4.994797680505588E145) {
                int count = 0;
                while (scale >= 4.994797680505588E145) {
                    ++count;
                    scale = Math.max(Math.abs(f1 *= 2.002083095183101E-146), Math.abs(g1 *= 2.002083095183101E-146));
                }
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
                int i = 1;
                while (i <= count) {
                    r *= 4.994797680505588E145;
                    ++i;
                }
            } else if (scale <= 2.002083095183101E-146) {
                int count = 0;
                while (scale <= 2.002083095183101E-146) {
                    ++count;
                    scale = Math.max(Math.abs(f1 *= 4.994797680505588E145), Math.abs(g1 *= 4.994797680505588E145));
                }
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
                int i = 1;
                while (i <= count) {
                    r *= 2.002083095183101E-146;
                    ++i;
                }
            } else {
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
            }
            if (Math.abs(f) > Math.abs(g) && cs < 0.0) {
                cs = -cs;
                sn = -sn;
                r = -r;
            }
        }
        sin[index] = sn;
        cos[index] = cs;
        return r;
    }
}

