/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DVector;

public class E3DPlane
implements Cloneable {
    public final E3DVector n = new E3DVector();
    public double d;

    public E3DPlane() {
    }

    public E3DPlane(E3DVector n, double d) {
        this.set(n, d);
    }

    public E3DPlane(E3DPlane plane) {
        this.n.set(plane.n);
        this.d = plane.d;
    }

    public E3DPlane(E3DVector n, E3DVector point) {
        this.set(n, point);
    }

    public E3DPlane(E3DVector point, E3DVector u, E3DVector v) {
        this.set(point, u, v);
    }

    public E3DPlane clone() {
        return new E3DPlane(this);
    }

    public void set(E3DVector n, double d) {
        this.n.set(n, 1.0);
        this.d = d;
    }

    public void set(E3DPlane plane) {
        this.n.set(plane.n);
        this.d = plane.d;
    }

    public void set(E3DVector n, E3DVector point) {
        this.n.set(n, 1.0);
        this.d = this.n.scalarProduct(point);
    }

    public void set(E3DVector point, E3DVector u, E3DVector v) {
        this.n.set(u.crossProduct(v), 1.0);
        this.d = this.n.scalarProduct(point);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof E3DPlane)) {
            return false;
        }
        E3DPlane v = (E3DPlane)o;
        return this.d == v.d && this.n.equals(v.n);
    }

    public int hashCode() {
        return Double.valueOf(this.d).hashCode() + this.n.hashCode();
    }

    public boolean isValid() {
        return this.n.isValid() && !Double.isNaN(this.d) && !Double.isInfinite(this.d);
    }

    public double angle(E3DVector vector) {
        return Math.asin(this.n.scalarProduct(vector) / (vector.length() * this.n.length()));
    }

    public E3DVector intersection(E3DLine line) {
        E3DVector intersection = new E3DVector();
        intersection.intersection(line, this);
        return intersection;
    }

    public E3DLine intersection(E3DPlane plane) {
        E3DLine line = new E3DLine();
        line.intersection(this, plane);
        return line;
    }

    public E3DVector projection(E3DVector point) {
        E3DLine line = new E3DLine(point, this.n);
        E3DVector intersection = this.intersection(line);
        return intersection;
    }

    public E3DVector mirrored(E3DVector point) {
        double f = 2.0 * this.dist(point) / this.n.length();
        return point.diff(this.n.x * f, this.n.y * f, this.n.z * f);
    }

    public void mirror(E3DVector point) {
        double f = 2.0 * this.dist(point) / this.n.length();
        point.substract(this.n.x * f, this.n.y * f, this.n.z * f);
    }

    public E3DLine reflection(E3DLine line) {
        E3DLine r = new E3DLine();
        E3DVector p = this.projection(line.a);
        r.a.set(this.intersection(line));
        r.b.set(r.a.diff(p.sum(p)).sum(line.a));
        return r;
    }

    public double dist(E3DVector point) {
        double s = this.n.scalarProduct(point);
        return s - this.d;
    }
}

