/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean;

import e3d.euclidean.E3DEllipsoid;
import e3d.euclidean.E3DPlane;
import e3d.euclidean.E3DSphere;
import e3d.euclidean.E3DVector;

public class E3DLine
implements Cloneable {
    public final E3DVector a = new E3DVector();
    public final E3DVector b = new E3DVector();

    public E3DLine() {
    }

    public E3DLine(E3DVector p, E3DVector n) {
        this.a.set(p);
        this.b.set(n);
    }

    public E3DLine(E3DVector p, E3DVector n, double norm) {
        this.a.set(p);
        this.b.set(n, norm);
    }

    public E3DLine(E3DLine l) {
        this.a.set(l.a);
        this.b.set(l.b);
    }

    public E3DLine clone() {
        return new E3DLine(this);
    }

    public void set(E3DVector p, E3DVector n) {
        this.a.set(p);
        this.b.set(n);
    }

    public void set(double x, double y, double z, double dx, double dy, double dz) {
        this.a.set(x, y, z);
        this.b.set(dx, dy, dz);
    }

    public void set(E3DVector p, E3DVector n, double norm) {
        this.a.set(p);
        this.b.set(n, norm);
    }

    public void set(E3DLine l) {
        this.a.set(l.a);
        this.b.set(l.b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof E3DLine)) {
            return false;
        }
        E3DLine line = (E3DLine)o;
        return this.a.equals(line.a) && this.b.equals(line.b);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }

    public boolean isValid() {
        return this.a.isValid() && this.b.isValid();
    }

    public E3DVector point(double t) {
        E3DVector point = this.b.product(t);
        point.add(this.a);
        return point;
    }

    public void point(double t, E3DVector point) {
        point.x = this.b.x * t + this.a.x;
        point.y = this.b.y * t + this.a.y;
        point.z = this.b.z * t + this.a.z;
    }

    public double squareDist(E3DVector p) {
        E3DVector pa = p.diff(this.a);
        E3DVector pab = p.diff(this.a.sum(this.b));
        double x = this.b.length();
        double y = pa.length();
        double z = pab.length();
        return (x * x * x * x + y * y * y * y + z * z * z * z - 2.0 * x * x * y * y - 2.0 * x * x * z * z - 2.0 * y * y * z * z) / (-4.0 * x * x);
    }

    public int direction(E3DVector p) {
        double d = this.b.scalarProduct(this.a) - this.b.scalarProduct(p);
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public double dist(E3DVector p) {
        return Math.sqrt(Math.max(this.squareDist(p), 0.0));
    }

    public void intersection(E3DPlane e1, E3DPlane e2) {
        this.b.set(e1.n.crossProduct(e2.n), 1.0);
        if (Math.abs(this.b.x) > Math.abs(this.b.y) && Math.abs(this.b.x) > Math.abs(this.b.z)) {
            this.a.x = 0.0;
            this.a.z = this.solve(e1.n.y, e1.n.z, e1.d, e2.n.y, e2.n.z, e2.d);
            this.a.y = this.solve(e1.n.y, e1.n.z, e1.d, e2.n.y, e2.n.z, e2.d, this.a.z);
        } else if (Math.abs(this.b.y) > Math.abs(this.b.z)) {
            this.a.y = 0.0;
            this.a.z = this.solve(e1.n.x, e1.n.z, e1.d, e2.n.x, e2.n.z, e2.d);
            this.a.x = this.solve(e1.n.x, e1.n.z, e1.d, e2.n.x, e2.n.z, e2.d, this.a.z);
        } else {
            this.a.z = 0.0;
            this.a.y = this.solve(e1.n.x, e1.n.y, e1.d, e2.n.x, e2.n.y, e2.d);
            this.a.x = this.solve(e1.n.x, e1.n.y, e1.d, e2.n.x, e2.n.y, e2.d, this.a.y);
        }
    }

    public E3DVector[] intersections(E3DSphere sphere) {
        double q;
        E3DVector v = this.a.diff(sphere.center);
        double w = this.b.squareLength();
        double p = 2.0 * v.scalarProduct(this.b) / w;
        double r = p * p - 4.0 * (q = v.squareLength() - sphere.radius * sphere.radius / w);
        if (r < 0.0) {
            return new E3DVector[0];
        }
        if (r == 0.0) {
            return new E3DVector[]{this.point(-p / 2.0)};
        }
        double t1 = -p / 2.0 + 0.5 * Math.sqrt(r);
        double t2 = -p / 2.0 - 0.5 * Math.sqrt(r);
        return new E3DVector[]{this.point(t1), this.point(t2)};
    }

    public double intersection(E3DEllipsoid ellipsoid) {
        double x0 = this.a.x - ellipsoid.center.x;
        double xr2 = ellipsoid.radii.x * ellipsoid.radii.x;
        double y0 = this.a.y - ellipsoid.center.y;
        double yr2 = ellipsoid.radii.y * ellipsoid.radii.y;
        double z0 = this.a.z - ellipsoid.center.z;
        double zr2 = ellipsoid.radii.z * ellipsoid.radii.z;
        double v = 2.0 * x0 * this.b.x / xr2 + 2.0 * y0 * this.b.y / yr2 + 2.0 * z0 * this.b.z / zr2;
        double u = this.b.x * this.b.x / xr2 + this.b.y * this.b.y / yr2 + this.b.z * this.b.z / zr2;
        double w = x0 * x0 / xr2 + y0 * y0 / yr2 + z0 * z0 / zr2 - 1.0;
        double d = v * v - 4.0 * u * w;
        if (d < 0.0) {
            return Double.NaN;
        }
        double sqrtd = Math.sqrt(d);
        double hit1 = (-v + sqrtd) / (2.0 * u);
        double hit2 = (-v - sqrtd) / (2.0 * u);
        return Math.min(hit1, hit2);
    }

    public E3DVector projection(E3DVector p) {
        E3DVector lp = new E3DVector();
        lp.projection(p, this);
        return lp;
    }

    private double solve(double a1, double b1, double c1, double a2, double b2, double c2) {
        return (a2 * c1 - a1 * c2) / (a2 * b1 - a1 * b2);
    }

    private double solve(double a1, double b1, double c1, double a2, double b2, double c2, double y) {
        return Math.abs(a1) > Math.abs(a2) ? (c1 - b1 * y) / a1 : (c2 - b2 * y) / a2;
    }
}

