/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Surface;
import e3d.bezier.Surfaces;
import e3d.texture.E3DTextureFile;
import e3d.utils.ProgressListener;
import e3d.utils.Tagger;
import e3d.utils.TaskUtils;
import e3d.visualization.colorizer.E3DProjectionBox;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageSWT;
import e3d.visualization.mesh.E3DMesh;
import e3d.visualization.mesh.E3DMeshPoint;
import e3d.visualization.scanner.Statistics;
import e3d.visualization.space.BinarySpace;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterialAtom;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;

public class SurfaceScan
extends BinarySpace<E3DAtom> {
    protected double density = 2.0;
    protected boolean randomizeColors = false;
    private final Random random = new Random();
    protected E3DProjectionBox projectionBox = null;
    protected E3DImage[] textures = null;
    protected TextureChoosingPolicy textureChoosingPolicy = TextureChoosingPolicy.RANDOM;
    protected int maxPixels = 4000000;
    private Statistics statistics = new Statistics();
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public SurfaceScan(E3DBoundingBox bounds, int width, int height, int depth) {
        super(bounds, width, height, depth);
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double density) {
        this.density = density;
    }

    public boolean isRandomizingColors() {
        return this.randomizeColors;
    }

    public void setRandomizeColors(boolean randomizeColors) {
        this.randomizeColors = randomizeColors;
    }

    public E3DProjectionBox getProjectionBox() {
        return this.projectionBox;
    }

    public void setProjectionBox(E3DProjectionBox projectionBox) {
        this.projectionBox = projectionBox;
    }

    public E3DImage[] getTextures() {
        return this.textures;
    }

    public void setTextures(E3DImage[] textures) {
        this.textures = textures;
    }

    public TextureChoosingPolicy getTextureChoosingPolicy() {
        return this.textureChoosingPolicy;
    }

    public void setTextureChoosingPolicy(TextureChoosingPolicy textureChoosingPolicy) {
        this.textureChoosingPolicy = textureChoosingPolicy;
    }

    public int getMaxPixels() {
        return this.maxPixels;
    }

    public void setMaxPixels(int maxPixels) {
        this.maxPixels = maxPixels;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public void setSurfaces(Surfaces surfaces) throws InterruptedException {
        int n = surfaces.size();
        for (ProgressListener listener : this.progressListeners) {
            listener.init(n, "CREATE SURFACE FROM BEZIER-MESHES");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(0, "Initializing...");
        }
        int i = 0;
        HashMap<String, E3DImage> name2image = new HashMap<String, E3DImage>();
        for (Surface surface : surfaces) {
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            if (surface.isValid()) {
                E3DMesh mesh = surface.getMesh(Math.max(3, (int)(surface.getWidth() * this.density)), Math.max(3, (int)(surface.getHeight() * this.density)));
                mesh.createNormals();
                this.colorize(mesh);
                this.setTextures(mesh, surface, this.textures, name2image, i);
                this.setTextures(mesh, surface, surfaces.tagger);
                this.add(mesh);
            }
            for (ProgressListener listener : this.progressListeners) {
                listener.done(++i, String.valueOf(i) + "/" + n + " meshes added to the surface");
            }
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }

    public void add(E3DMesh mesh) {
        int i = 0;
        while (i < mesh.width()) {
            int j = 0;
            while (j < mesh.height()) {
                int color;
                E3DMeshPoint meshPoint = (E3DMeshPoint)mesh.get(i, j);
                if (meshPoint != null && E3DColor.alpha(color = meshPoint.color()) > 0) {
                    E3DMaterialAtom atom = new E3DMaterialAtom(color, meshPoint.normal(), meshPoint.material());
                    this.setAtom(atom, meshPoint.x, meshPoint.y, meshPoint.z);
                }
                ++j;
            }
            ++i;
        }
    }

    private void colorize(E3DMesh mesh) {
        if (this.randomizeColors) {
            mesh.setAll(new Color(this.random.nextInt(64) + 192, this.random.nextInt(64) + 192, this.random.nextInt(64) + 192));
        }
    }

    private void setTextures(E3DMesh mesh, Surface surface, E3DImage[] textures, Map<String, E3DImage> name2image, int index) {
        if (surface.getTexture() != null) {
            try {
                E3DTextureFile file = surface.getTexture();
                E3DImage texture = name2image.get(file.getPath());
                if (texture == null) {
                    texture = new E3DImageSWT(file);
                    name2image.put(file.getPath(), texture);
                }
                mesh.colorize(texture, file.getX(), file.getY(), file.getWidth(), file.getHeight());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else if (textures != null) {
            switch (this.textureChoosingPolicy) {
                case FORWARD: {
                    mesh.colorize(textures[index % textures.length]);
                    break;
                }
                case BACKWARD: {
                    mesh.colorize(textures[textures.length - index % textures.length - 1]);
                    break;
                }
                case RANDOM: {
                    mesh.colorize(textures[this.random.nextInt(textures.length)]);
                }
            }
        }
    }

    private void setTextures(E3DMesh mesh, Surface surface, Tagger<Object> tagger) {
        if (this.projectionBox != null && tagger != null) {
            this.projectionBox.setEnabled(tagger.getTags(surface), "_FRONT", "_LEFT", "_TOP", "_BACK", "_RIGHT", "_BOTTOM");
            this.projectionBox.setProjections(mesh);
        }
    }

    public static enum TextureChoosingPolicy {
        FORWARD,
        BACKWARD,
        RANDOM;

    }
}

