/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Mesh;
import e3d.bezier.Position;
import e3d.bezier.Surface;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DTransformation;
import e3d.utils.ArrayFactory;
import e3d.utils.MathUtils;
import e3d.visualization.mesh.E3DMesh;
import e3d.visualization.mesh.E3DMeshPoint;
import e3d.visualization.util.E3DBoundingBox;

public class PointMesh
extends Mesh<Position>
implements Surface,
Cloneable {
    private final int overlap;
    private double var;
    private double min;

    public PointMesh() {
        super(ArrayFactory.POSITION);
        this.overlap = 0;
        this.setRoundness(1.0);
    }

    public PointMesh(int width, int height) {
        super(width, height, ArrayFactory.POSITION);
        this.overlap = 0;
        this.setRoundness(1.0);
    }

    public PointMesh(int width, int height, int overlap) {
        super(width, height, ArrayFactory.POSITION);
        this.overlap = overlap;
        this.setRoundness(1.0);
    }

    public PointMesh(PointMesh mesh) {
        super(mesh);
        this.overlap = mesh.overlap;
        this.setRoundness(mesh.roundness);
    }

    @Override
    public PointMesh clone() {
        return new PointMesh(this);
    }

    public double getOverlap() {
        return this.overlap;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void setRoundness(double roundness) {
        super.setRoundness(roundness);
        this.var = Math.pow(0.6 * roundness, 2.0);
        this.min = MathUtils.gauss(2.0, 0.0, this.var);
    }

    @Override
    public double getWidth() {
        double maxWidth = 0.0;
        int j = this.overlap;
        while (j < this.height - this.overlap) {
            double w = 0.0;
            Position prev = (Position)this.get(this.overlap, j);
            int i = 1 + this.overlap;
            while (i < this.width - this.overlap) {
                Position next = (Position)this.get(i, j);
                if (prev != null && next != null) {
                    w += prev.dist(next);
                }
                prev = next;
                ++i;
            }
            maxWidth = Math.max(maxWidth, w);
            ++j;
        }
        return maxWidth;
    }

    @Override
    public double getHeight() {
        double maxHeight = 0.0;
        int i = this.overlap;
        while (i < this.width - this.overlap) {
            double h = 0.0;
            Position prev = (Position)this.get(i, this.overlap);
            int j = 1 + this.overlap;
            while (j < this.height - this.overlap) {
                Position next = (Position)this.get(i, j);
                if (prev != null && next != null) {
                    h += prev.dist(next);
                }
                prev = next;
                ++j;
            }
            maxHeight = Math.max(maxHeight, h);
            ++i;
        }
        return maxHeight;
    }

    @Override
    public E3DBoundingBox getBounds() {
        E3DBoundingBox bounds = new E3DBoundingBox();
        bounds.x0 = Double.POSITIVE_INFINITY;
        bounds.y0 = Double.POSITIVE_INFINITY;
        bounds.z0 = Double.POSITIVE_INFINITY;
        bounds.x1 = Double.NEGATIVE_INFINITY;
        bounds.y1 = Double.NEGATIVE_INFINITY;
        bounds.z1 = Double.NEGATIVE_INFINITY;
        this.getBounds(bounds);
        return bounds;
    }

    @Override
    public void getBounds(E3DBoundingBox bounds) {
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                Position point = (Position)this.get(i, j);
                if (point != null) {
                    bounds.x0 = Math.min(bounds.x0, point.x);
                    bounds.y0 = Math.min(bounds.y0, point.y);
                    bounds.z0 = Math.min(bounds.z0, point.z);
                    bounds.x1 = Math.max(bounds.x1, point.x);
                    bounds.y1 = Math.max(bounds.y1, point.y);
                    bounds.z1 = Math.max(bounds.z1, point.z);
                }
                ++i;
            }
            ++j;
        }
    }

    @Override
    public PointMesh transformed(E3DTransformation transformation) {
        PointMesh mesh = new PointMesh(this.width, this.height, this.overlap);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                Position point = (Position)this.get(x, y);
                if (point != null) {
                    Position p = (Position)transformation.transformed(point);
                    mesh.set(x, y, p);
                }
                ++x;
            }
            ++y;
        }
        mesh.setColor(this.color);
        mesh.setTexture(this.texture);
        mesh.setMaterial(this.material);
        mesh.setRoundness(this.roundness);
        return mesh;
    }

    @Override
    public E3DMesh getMesh(int width, int height) {
        return this.roundness > 0.0 ? this.getRoundMesh(width, height) : this.getFlatMesh(width, height);
    }

    public E3DMesh getRoundMesh(int width, int height) {
        E3DMesh mesh = new E3DMesh(width, height);
        --width;
        --height;
        int w = this.width - 1;
        int h = this.height - 1;
        double fx = (double)(w - 2 * this.overlap) / (double)w;
        double dx = (double)this.overlap / (double)w;
        double fy = (double)(h - 2 * this.overlap) / (double)h;
        double dy = (double)this.overlap / (double)h;
        int j = 0;
        while (j <= height) {
            int i = 0;
            while (i <= width) {
                E3DMeshPoint point = new E3DMeshPoint();
                double x = (double)i / (double)width * fx + dx;
                double y = (double)j / (double)height * fy + dy;
                int c = (int)(x * (double)w);
                int r = (int)(y * (double)h);
                double n = 0.0;
                int dr = -1;
                while (dr <= 2) {
                    int dc = -1;
                    while (dc <= 2) {
                        Position p = (Position)this.get(c + dc, r + dr);
                        if (p != null) {
                            double x0 = (double)(c + dc) / (double)w;
                            double y0 = (double)(r + dr) / (double)h;
                            double weight = this.getWeight((x - x0) * (double)w, (y - y0) * (double)h);
                            n += point.add(weight, (E3DVector)p);
                        }
                        ++dc;
                    }
                    ++dr;
                }
                point.divide(n);
                mesh.set(i, j, point);
                ++i;
            }
            ++j;
        }
        mesh.setAll(this.getColor());
        mesh.setAll(this.getMaterial());
        return mesh;
    }

    private double getWeight(double dx, double dy) {
        return this.getWeight(dx) * this.getWeight(dy);
    }

    private double getWeight(double dist) {
        return MathUtils.gauss(dist, 0.0, this.var) - this.min;
    }

    public E3DMesh getFlatMesh(int width, int height) {
        E3DMesh mesh = new E3DMesh(width, height);
        --width;
        --height;
        int w = this.width - 1;
        int h = this.height - 1;
        int o2 = 2 * this.overlap;
        int j = 0;
        while (j <= height) {
            int i = 0;
            while (i <= width) {
                E3DMeshPoint point = new E3DMeshPoint();
                int c = i * (w - o2) / width + this.overlap;
                int r = j * (h - o2) / height + this.overlap;
                double n = 0.0;
                double a = (double)(i * w % width) / (double)width;
                double b = (double)(j * h % height) / (double)height;
                n += point.add((1.0 - a) * (1.0 - b), (E3DVector)this.get(c, r));
                n += point.add(a * (1.0 - b), (E3DVector)this.get(c + 1, r));
                n += point.add(a * b, (E3DVector)this.get(c + 1, r + 1));
                point.divide(n += point.add((1.0 - a) * b, (E3DVector)this.get(c, r + 1)));
                mesh.set(i, j, point);
                ++i;
            }
            ++j;
        }
        mesh.setAll(this.getColor());
        mesh.setAll(this.getMaterial());
        return mesh;
    }
}

