/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Position;
import e3d.bezier.Surface;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DTransformation;
import e3d.texture.E3DTextureFile;
import e3d.utils.MathUtils;
import e3d.visualization.mesh.E3DMesh;
import e3d.visualization.mesh.E3DMeshPoint;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DMaterial;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class PointHood
implements Surface,
Cloneable {
    protected static final int N = 1;
    protected static final int E = 2;
    protected static final int S = 4;
    protected static final int W = 8;
    protected final Corner[][] corners;
    protected Color color = new Color(255, 255, 255);
    protected E3DMaterial material;
    protected E3DTextureFile texture;
    protected double roundness;
    private double var;
    private double min;

    public PointHood(Position nw, Position ne, Position sw, Position se) {
        this.corners = new Corner[][]{{new Corner(nw), new Corner(ne)}, {new Corner(sw), new Corner(se)}};
        this.setRoundness(1.0);
    }

    public PointHood(PointHood hood) {
        this(hood.corners[0][0].point, hood.corners[0][1].point, hood.corners[1][0].point, hood.corners[1][1].point);
        this.material = hood.material;
        this.color = hood.color;
        this.texture = hood.texture;
        this.setRoundness(hood.roundness);
        int j = 0;
        while (j < 2) {
            int i = 0;
            while (i < 2) {
                for (Neighbor neighbor : hood.corners[j][i].hood) {
                    this.corners[j][j].addNeighbor(neighbor.point, neighbor.dx, neighbor.dy);
                }
                ++i;
            }
            ++j;
        }
    }

    public PointHood clone() {
        return new PointHood(this);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public E3DMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void setMaterial(E3DMaterial material) {
        this.material = material;
    }

    @Override
    public E3DTextureFile getTexture() {
        return this.texture;
    }

    @Override
    public void setTexture(E3DTextureFile texture) {
        this.texture = texture;
    }

    @Override
    public double getRoundness() {
        return this.roundness;
    }

    @Override
    public void setRoundness(double roundness) {
        this.roundness = roundness;
        this.var = Math.pow(0.6 * roundness, 2.0);
        this.min = MathUtils.gauss(2.0, 0.0, this.var);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public double getWidth() {
        return Math.max(this.corners[0][0].point.dist(this.corners[0][1].point), this.corners[1][0].point.dist(this.corners[1][1].point));
    }

    @Override
    public double getHeight() {
        return Math.max(this.corners[0][0].point.dist(this.corners[1][0].point), this.corners[0][1].point.dist(this.corners[1][1].point));
    }

    @Override
    public E3DBoundingBox getBounds() {
        E3DBoundingBox bounds = new E3DBoundingBox();
        bounds.x0 = Double.POSITIVE_INFINITY;
        bounds.y0 = Double.POSITIVE_INFINITY;
        bounds.z0 = Double.POSITIVE_INFINITY;
        bounds.x1 = Double.NEGATIVE_INFINITY;
        bounds.y1 = Double.NEGATIVE_INFINITY;
        bounds.z1 = Double.NEGATIVE_INFINITY;
        this.getBounds(bounds);
        return bounds;
    }

    @Override
    public void getBounds(E3DBoundingBox bounds) {
        int j = 0;
        while (j < 2) {
            int i = 0;
            while (i < 2) {
                Position point = this.corners[j][i].point;
                if (point != null) {
                    bounds.x0 = Math.min(bounds.x0, point.x);
                    bounds.y0 = Math.min(bounds.y0, point.y);
                    bounds.z0 = Math.min(bounds.z0, point.z);
                    bounds.x1 = Math.max(bounds.x1, point.x);
                    bounds.y1 = Math.max(bounds.y1, point.y);
                    bounds.z1 = Math.max(bounds.z1, point.z);
                }
                ++i;
            }
            ++j;
        }
    }

    @Override
    public PointHood transformed(E3DTransformation transformation) {
        PointHood hood = new PointHood((Position)transformation.transformed(this.corners[0][0].point), (Position)transformation.transformed(this.corners[0][1].point), (Position)transformation.transformed(this.corners[1][0].point), (Position)transformation.transformed(this.corners[1][1].point));
        int j = 0;
        while (j < 2) {
            int i = 0;
            while (i < 2) {
                for (Neighbor neighbor : this.corners[j][i].hood) {
                    Position point = (Position)transformation.transformed(neighbor.point);
                    hood.corners[j][i].addNeighbor(point, neighbor.dx, neighbor.dy);
                }
                ++i;
            }
            ++j;
        }
        hood.setColor(this.color);
        hood.setTexture(this.texture);
        hood.setMaterial(this.material);
        hood.setRoundness(this.roundness);
        return hood;
    }

    public void getPosition(double x, double y, E3DVector point) {
        if (this.roundness > 0.0) {
            this.getRoundPosition(x, y, point);
        } else {
            this.getFlatPosition(x, y, point);
        }
    }

    private void getRoundPosition(double x, double y, E3DVector point) {
        double n = 0.0;
        int r = 0;
        while (r < 2) {
            int c = 0;
            while (c < 2) {
                Corner corner = this.corners[r][c];
                double dx = Math.abs(x - (double)c);
                double dy = Math.abs(y - (double)r);
                double w0 = this.getWeight(dx, dy);
                n += point.add(w0, (E3DVector)corner.point);
                for (Neighbor neighbor : corner.hood) {
                    double w = this.getWeight(dx + neighbor.dx, dy + neighbor.dy);
                    n += point.add(w, (E3DVector)neighbor.point);
                }
                ++c;
            }
            ++r;
        }
        point.divide(n);
    }

    private void getFlatPosition(double x, double y, E3DVector point) {
        double n = 0.0;
        int r = 0;
        while (r < 2) {
            int c = 0;
            while (c < 2) {
                Corner corner = this.corners[r][c];
                double dx = x - (double)c;
                double dy = y - (double)r;
                double a = Math.max(0.0, 1.0 - Math.abs(dx));
                double b = Math.max(0.0, 1.0 - Math.abs(dy));
                n += point.add(a * b, (E3DVector)corner.point);
                ++c;
            }
            ++r;
        }
        point.divide(n);
    }

    private double getWeight(double dx, double dy) {
        return this.getWeight(dx) * this.getWeight(dy);
    }

    private double getWeight(double dist) {
        return MathUtils.gauss(dist, 0.0, this.var) - this.min;
    }

    @Override
    public E3DMesh getMesh(int width, int height) {
        return this.roundness > 0.0 ? this.getRoundMesh(width, height) : this.getFlatMesh(width, height);
    }

    public E3DMesh getRoundMesh(int width, int height) {
        E3DMesh mesh = new E3DMesh(width, height);
        --width;
        --height;
        int j = 0;
        while (j <= height) {
            int i = 0;
            while (i <= width) {
                E3DMeshPoint point = new E3DMeshPoint();
                double x = (double)i / (double)width;
                double y = (double)j / (double)height;
                this.getRoundPosition(x, y, point);
                mesh.set(i, j, point);
                ++i;
            }
            ++j;
        }
        mesh.setAll(this.getColor());
        mesh.setAll(this.getMaterial());
        return mesh;
    }

    public E3DMesh getFlatMesh(int width, int height) {
        E3DMesh mesh = new E3DMesh(width, height);
        --width;
        --height;
        int j = 0;
        while (j <= height) {
            int i = 0;
            while (i <= width) {
                E3DMeshPoint point = new E3DMeshPoint();
                double x = (double)i / (double)width;
                double y = (double)j / (double)height;
                this.getFlatPosition(x, y, point);
                mesh.set(i, j, point);
                ++i;
            }
            ++j;
        }
        mesh.setAll(this.getColor());
        mesh.setAll(this.getMaterial());
        return mesh;
    }

    public static class Corner {
        protected final Position point;
        protected final List<Neighbor> hood = new ArrayList<Neighbor>();

        public Corner(Position point) {
            this.point = point;
        }

        public void addNeighbor(Position pos, double dx, double dy) {
            if (pos != null) {
                this.hood.add(new Neighbor(pos, dx, dy));
            }
        }

        public void addNeighbors(Neighbor[] pos) {
            if (pos != null) {
                Neighbor[] neighborArray = pos;
                int n = pos.length;
                int n2 = 0;
                while (n2 < n) {
                    Neighbor p = neighborArray[n2];
                    if (p != null && p.point != null) {
                        this.hood.add(p);
                    }
                    ++n2;
                }
            }
        }
    }

    public static class Neighbor {
        protected final Position point;
        protected final double dx;
        protected final double dy;

        public Neighbor(Position point, double dx, double dy) {
            this.point = point;
            this.dx = dx;
            this.dy = dy;
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Neighbor && this.point.equals(((Neighbor)obj).point);
        }
    }
}

