/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Mesh;
import e3d.bezier.Needle;
import e3d.euclidean.transformations.E3DTransformation;
import e3d.utils.ArrayFactory;

public class NeedleMesh
extends Mesh<Needle>
implements Cloneable {
    public NeedleMesh() {
        super(ArrayFactory.NEEDLE);
    }

    public NeedleMesh(int width, int height) {
        super(width, height, ArrayFactory.NEEDLE);
    }

    public NeedleMesh(NeedleMesh mesh) {
        super(mesh);
    }

    @Override
    public NeedleMesh clone() {
        return new NeedleMesh(this);
    }

    public NeedleMesh transformed(E3DTransformation transformation) {
        NeedleMesh mesh = new NeedleMesh(this.width, this.height);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                Needle needle = (Needle)mesh.get(x, y);
                if (needle != null) {
                    Needle transformed = new Needle(transformation.transformed(needle.point), transformation.transformed(needle.normal));
                    mesh.set(x, y, transformed);
                }
                ++x;
            }
            ++y;
        }
        return mesh;
    }
}

