/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Bezier;
import e3d.bezier.Needle;
import e3d.bezier.NeedleMesh;
import e3d.bezier.NeedleMeshes;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DTransformation;
import e3d.texture.E3DTextureFile;
import e3d.utils.Tagger;
import e3d.visualization.util.E3DBoundingBox;
import java.util.Set;
import java.util.Vector;

public class Beziers
extends Vector<Bezier> {
    private static final long serialVersionUID = 1L;

    public Beziers() {
    }

    public Beziers(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Beziers transformed(E3DTransformation transformation, Tagger<Object> tagger) {
        Beziers transformed = new Beziers(this.size());
        for (Bezier bezier : this) {
            Bezier trans = bezier.transformed(transformation);
            transformed.add(trans);
            if (tagger == null) continue;
            tagger.addTags((Object)trans, tagger.getTags(bezier));
        }
        return transformed;
    }

    public E3DBoundingBox getBounds() {
        E3DBoundingBox bounds = new E3DBoundingBox();
        bounds.x0 = Double.POSITIVE_INFINITY;
        bounds.y0 = Double.POSITIVE_INFINITY;
        bounds.z0 = Double.POSITIVE_INFINITY;
        bounds.x1 = Double.NEGATIVE_INFINITY;
        bounds.y1 = Double.NEGATIVE_INFINITY;
        bounds.z1 = Double.NEGATIVE_INFINITY;
        for (Bezier bezier : this) {
            int i = 0;
            while (i < 4) {
                if (bezier.getCorners()[i] != null) {
                    E3DVector point = bezier.getCorners()[i].point;
                    bounds.x0 = Math.min(bounds.x0, point.x);
                    bounds.y0 = Math.min(bounds.y0, point.y);
                    bounds.z0 = Math.min(bounds.z0, point.z);
                    bounds.x1 = Math.max(bounds.x1, point.x);
                    bounds.y1 = Math.max(bounds.y1, point.y);
                    bounds.z1 = Math.max(bounds.z1, point.z);
                }
                ++i;
            }
        }
        return bounds;
    }

    public void add(NeedleMesh mesh, Tagger<Object> tagger) {
        double roundness = mesh.getRoundness();
        int width = mesh.width();
        int height = mesh.height();
        if (roundness == 0.0) {
            roundness = 1.0;
        }
        Set<String> tags = tagger.getTags(mesh);
        double cols = width - 1;
        double rows = height - 1;
        int y = 1;
        while (y < height) {
            int x = 1;
            while (x < width) {
                E3DTextureFile file = mesh.getTexture() == null ? null : new E3DTextureFile(mesh.getTexture().getPath(), (double)(x - 1) / cols, (double)(y - 1) / rows, 1.0 / cols, 1.0 / rows);
                Needle needle1 = (Needle)mesh.get(x - 1, y - 1);
                Needle needle2 = (Needle)mesh.get(x, y - 1);
                Needle needle3 = (Needle)mesh.get(x, y);
                Needle needle4 = (Needle)mesh.get(x - 1, y);
                if (needle1 != null && needle2 != null && needle3 != null && needle4 != null) {
                    Bezier bezier = new Bezier(needle1, needle2, needle3, needle4, roundness, roundness, roundness, roundness, mesh.getColor(), mesh.getMaterial(), file);
                    this.add(bezier);
                    tagger.addTags((Object)bezier, tags);
                }
                ++x;
            }
            ++y;
        }
    }

    public void add(NeedleMeshes meshes, Tagger<Object> tagger) {
        if (meshes != null) {
            for (NeedleMesh mesh : meshes) {
                this.add(mesh, tagger);
            }
        }
    }
}

