/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Position;
import e3d.euclidean.E3DVector;

public class BezierCurve4P {
    public final E3DVector point = new E3DVector();
    protected final E3DVector delta1 = new E3DVector();
    protected final E3DVector delta2 = new E3DVector();
    protected final E3DVector delta3 = new E3DVector();

    public BezierCurve4P() {
    }

    public BezierCurve4P(BezierCurve4P curve) {
        this.set(curve);
    }

    public BezierCurve4P(E3DVector point1, E3DVector point2, E3DVector point3, E3DVector point4, int steps) {
        this.set(point1, point2, point3, point4, steps);
    }

    public void set(BezierCurve4P curve) {
        this.point.set(curve.point);
        this.delta1.set(curve.delta1);
        this.delta2.set(curve.delta2);
        this.delta3.set(curve.delta3);
    }

    public void set(E3DVector point1, E3DVector point2, E3DVector point3, E3DVector point4, int steps) {
        this.point.set(point1);
        this.forwDiff(steps, point1, point2, point3, point4);
    }

    public E3DVector next() {
        this.point.add(this.delta1);
        this.delta1.add(this.delta2);
        this.delta2.add(this.delta3);
        return this.point;
    }

    public E3DVector current() {
        return this.point;
    }

    public E3DVector previous() {
        this.delta2.substract(this.delta3);
        this.delta1.substract(this.delta2);
        this.point.substract(this.delta1);
        return this.point;
    }

    public Position direct(double t, E3DVector point1, E3DVector point2, E3DVector point3, E3DVector point4) {
        double t2 = t * t;
        double t3 = t2 * t;
        double a = -t3 + 3.0 * t2 - 3.0 * t;
        double b = 3.0 * t3 - 6.0 * t2 + 3.0 * t;
        double c = -3.0 * t3 + 3.0 * t2;
        double d = t3;
        Position p = new Position(point1.x + point1.x * a + point2.x * b + point3.x * c + point4.x * d, point1.y + point1.y * a + point2.y * b + point3.y * c + point4.y * d, point1.z + point1.z * a + point2.z * b + point3.z * c + point4.z * d);
        return p;
    }

    public E3DVector deviation(double t, E3DVector point1, E3DVector point2, E3DVector point3, E3DVector point4) {
        double t2 = t * t;
        double t11 = t - 1.0;
        double t12 = -(t11 * t11);
        E3DVector d = new E3DVector(3.0 * (t12 * point1.x + (3.0 * t2 - 4.0 * t + 1.0) * point2.x + (-3.0 * t2 + 2.0 * t) * point3.x + t2 * point4.x), 3.0 * (t12 * point1.y + (3.0 * t2 - 4.0 * t + 1.0) * point2.y + (-3.0 * t2 + 2.0 * t) * point3.y + t2 * point4.y), 3.0 * (t12 * point1.z + (3.0 * t2 - 4.0 * t + 1.0) * point2.z + (-3.0 * t2 + 2.0 * t) * point3.z + t2 * point4.z));
        return d;
    }

    protected void forwDiff(int steps, E3DVector point1, E3DVector point2, E3DVector point3, E3DVector point4) {
        double t = 1.0 / (double)(steps - 1);
        double t2 = t * t;
        double t3 = t2 * t;
        E3DVector a = new E3DVector(-point1.x + 3.0 * point2.x - 3.0 * point3.x + point4.x, -point1.y + 3.0 * point2.y - 3.0 * point3.y + point4.y, -point1.z + 3.0 * point2.z - 3.0 * point3.z + point4.z);
        E3DVector b = new E3DVector(3.0 * point1.x - 6.0 * point2.x + 3.0 * point3.x, 3.0 * point1.y - 6.0 * point2.y + 3.0 * point3.y, 3.0 * point1.z - 6.0 * point2.z + 3.0 * point3.z);
        E3DVector c = new E3DVector(-3.0 * point1.x + 3.0 * point2.x, -3.0 * point1.y + 3.0 * point2.y, -3.0 * point1.z + 3.0 * point2.z);
        this.delta1.set(a.x * t3 + b.x * t2 + c.x * t, a.y * t3 + b.y * t2 + c.y * t, a.z * t3 + b.z * t2 + c.z * t);
        this.delta2.set(6.0 * a.x * t3 + 2.0 * b.x * t2, 6.0 * a.y * t3 + 2.0 * b.y * t2, 6.0 * a.z * t3 + 2.0 * b.z * t2);
        this.delta3.set(6.0 * a.x * t3, 6.0 * a.y * t3, 6.0 * a.z * t3);
    }
}

