/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.BezierCurve4P;
import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DPlane;
import e3d.euclidean.E3DVector;

public class BezierCurve2P2N
extends BezierCurve4P {
    public BezierCurve2P2N() {
    }

    public BezierCurve2P2N(BezierCurve4P curve) {
        super.set(curve);
    }

    public BezierCurve2P2N(E3DVector point1, E3DVector normal1, double roundness1, E3DVector point2, E3DVector normal2, double roundness2, int steps) {
        this.set(point1, normal1, roundness1, point2, normal2, roundness2, steps);
    }

    public void set(E3DVector point1, E3DVector normal1, double roundness1, E3DVector point2, E3DVector normal2, double roundness2, int steps) {
        this.point.set(point1);
        E3DVector[] intermediates = this.intermediates(point1, normal1, roundness1, point2, normal2, roundness2);
        this.forwDiff(steps, point1, intermediates[0], intermediates[1], point2);
    }

    public E3DVector[] intermediates(E3DVector point1, E3DVector normal1, double roundness1, E3DVector point2, E3DVector normal2, double roundness2) {
        E3DVector[] intermediates = new E3DVector[2];
        E3DLine line1 = new E3DLine(point2, normal1);
        E3DLine line2 = new E3DLine(point1, normal2);
        E3DPlane plane1 = new E3DPlane(normal1, point1);
        E3DPlane plane2 = new E3DPlane(normal2, point2);
        intermediates[0] = plane1.intersection(line1);
        intermediates[1] = plane2.intersection(line2);
        E3DVector vector12 = point2.diff(point1);
        double dist12 = vector12.length();
        double f = 1.0 / (3.0 * Math.abs(vector12.cosinus(point1.diff(intermediates[0])))) * roundness1;
        double g = 1.0 / (3.0 * Math.abs(vector12.cosinus(point2.diff(intermediates[1])))) * roundness2;
        intermediates[0].substract(point1);
        intermediates[1].substract(point2);
        intermediates[0].multiplicate(Math.min(1.0, dist12 / intermediates[0].length() * f));
        intermediates[1].multiplicate(Math.min(1.0, dist12 / intermediates[1].length() * g));
        intermediates[0].add(point1);
        intermediates[1].add(point2);
        if (!intermediates[0].isValid()) {
            intermediates[0].set(point1);
        }
        if (!intermediates[1].isValid()) {
            intermediates[1].set(point2);
        }
        return intermediates;
    }
}

