/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Bezier4P4N;
import e3d.bezier.Needle;
import e3d.bezier.PointMesh;
import e3d.bezier.Position;
import e3d.bezier.Surface;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DTransformation;
import e3d.texture.E3DTextureFile;
import e3d.visualization.mesh.E3DMesh;
import e3d.visualization.mesh.E3DMeshPoint;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DMaterial;
import java.awt.Color;

public class Bezier
implements Surface,
Cloneable {
    protected final double[] roundness = new double[]{1.0, 1.0, 1.0, 1.0};
    protected final Needle[] corners = new Needle[]{new Needle(), new Needle(), new Needle(), new Needle()};
    protected Color color = new Color(255, 255, 255);
    protected E3DMaterial material;
    protected E3DTextureFile texture;

    public Bezier() {
    }

    public Bezier(Bezier bezier) {
        this.set(bezier);
    }

    public Bezier(Needle corner1, Needle corner2, Needle corner3, Needle corner4, double roundness12, double roundness23, double roundness34, double roundness41, Color color, E3DMaterial material, E3DTextureFile texture) {
        this.set(corner1, corner2, corner3, corner4, roundness12, roundness23, roundness34, roundness41, color, material, texture);
    }

    public Bezier clone() {
        return new Bezier(this);
    }

    @Override
    public Bezier transformed(E3DTransformation transformation) {
        Needle corner1 = this.transformed(this.corners[0], transformation);
        Needle corner2 = this.transformed(this.corners[1], transformation);
        Needle corner3 = this.transformed(this.corners[2], transformation);
        Needle corner4 = this.transformed(this.corners[3], transformation);
        return new Bezier(corner1, corner2, corner3, corner4, this.roundness[0], this.roundness[1], this.roundness[2], this.roundness[3], this.color, this.material, this.texture);
    }

    protected Needle transformed(Needle corner, E3DTransformation transformation) {
        if (corner == null) {
            return null;
        }
        Needle transformed = corner.clone();
        transformed.normal.add(transformed.point);
        transformation.transform(transformed.point);
        transformation.transform(transformed.normal);
        transformed.normal.substract(transformed.point);
        return transformed;
    }

    public double[] getRoundnesses() {
        return this.roundness;
    }

    @Override
    public double getRoundness() {
        return (this.roundness[0] + this.roundness[1] + this.roundness[2] + this.roundness[3]) / 4.0;
    }

    @Override
    public void setRoundness(double roundness) {
        this.roundness[2] = this.roundness[3] = roundness;
        this.roundness[1] = this.roundness[3];
        this.roundness[0] = this.roundness[3];
    }

    public Needle[] getCorners() {
        return this.corners;
    }

    @Override
    public boolean isValid() {
        return this.corners[0] != null && this.corners[1] != null && this.corners[2] != null && this.corners[3] != null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public E3DMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void setMaterial(E3DMaterial material) {
        this.material = material;
    }

    @Override
    public E3DTextureFile getTexture() {
        return this.texture;
    }

    @Override
    public void setTexture(E3DTextureFile texture) {
        this.texture = texture;
    }

    @Override
    public double getWidth() {
        return Math.max(this.corners[0].point.dist(this.corners[1].point), this.corners[3].point.dist(this.corners[2].point));
    }

    @Override
    public double getHeight() {
        return Math.max(this.corners[0].point.dist(this.corners[3].point), this.corners[1].point.dist(this.corners[2].point));
    }

    @Override
    public E3DBoundingBox getBounds() {
        E3DBoundingBox bounds = new E3DBoundingBox();
        bounds.x0 = Double.POSITIVE_INFINITY;
        bounds.y0 = Double.POSITIVE_INFINITY;
        bounds.z0 = Double.POSITIVE_INFINITY;
        bounds.x1 = Double.NEGATIVE_INFINITY;
        bounds.y1 = Double.NEGATIVE_INFINITY;
        bounds.z1 = Double.NEGATIVE_INFINITY;
        this.getBounds(bounds);
        return bounds;
    }

    @Override
    public void getBounds(E3DBoundingBox bounds) {
        int i = 0;
        while (i < 4) {
            if (this.corners[i] != null) {
                E3DVector point = this.corners[i].point;
                bounds.x0 = Math.min(bounds.x0, point.x);
                bounds.y0 = Math.min(bounds.y0, point.y);
                bounds.z0 = Math.min(bounds.z0, point.z);
                bounds.x1 = Math.max(bounds.x1, point.x);
                bounds.y1 = Math.max(bounds.y1, point.y);
                bounds.z1 = Math.max(bounds.z1, point.z);
            }
            ++i;
        }
    }

    public void set(Bezier bezier) {
        this.roundness[0] = bezier.roundness[0];
        this.roundness[1] = bezier.roundness[1];
        this.roundness[2] = bezier.roundness[2];
        this.roundness[3] = bezier.roundness[3];
        this.corners[0] = bezier.corners[0];
        this.corners[1] = bezier.corners[1];
        this.corners[2] = bezier.corners[2];
        this.corners[3] = bezier.corners[3];
        this.color = bezier.color;
        this.material = bezier.material;
        this.texture = bezier.texture;
    }

    public void set(Needle corner1, Needle corner2, Needle corner3, Needle corner4, double roundness12, double roundness23, double roundness34, double roundness41, Color color, E3DMaterial material, E3DTextureFile texture) {
        this.roundness[0] = roundness12;
        this.roundness[1] = roundness23;
        this.roundness[2] = roundness34;
        this.roundness[3] = roundness41;
        this.corners[0] = corner1;
        this.corners[1] = corner2;
        this.corners[2] = corner3;
        this.corners[3] = corner4;
        this.color = color;
        this.material = material;
        this.texture = texture;
    }

    @Override
    public E3DMesh getMesh(int width, int height) {
        E3DMesh mesh = new E3DMesh(width, height);
        Bezier4P4N bezierSurface = new Bezier4P4N(this.corners, this.roundness, width, height);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                E3DMeshPoint point = new E3DMeshPoint();
                point.set(bezierSurface.point);
                mesh.set(i, j, point);
                bezierSurface.nextRow();
                ++j;
            }
            bezierSurface.nextCol();
            ++i;
        }
        mesh.setAll(this.getColor());
        mesh.setAll(this.getMaterial());
        return mesh;
    }

    public PointMesh getPointMesh(int width, int height) {
        PointMesh mesh = new PointMesh(width, height);
        Bezier4P4N bezierSurface = new Bezier4P4N(this.corners, this.roundness, width, height);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                Position point = new Position();
                point.set(bezierSurface.point);
                mesh.set(i, j, point);
                bezierSurface.nextRow();
                ++j;
            }
            bezierSurface.nextCol();
            ++i;
        }
        mesh.setColor(this.getColor());
        mesh.setMaterial(this.getMaterial());
        return mesh;
    }
}

