/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    int boxHandle;
    int arrowHandle;
    int arrowBoxHandle;
    int separatorHandle;
    int labelHandle;
    int imageHandle;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    boolean drawHotImage;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        this.createWidget(toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        int n3 = toolBar.getItemCount();
        if (n2 < 0 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 2) == 0) {
            int n2 = this.boxHandle = (this.parent.style & 0x20000) != 0 ? OS.gtk_hbox_new(false, 0) : OS.gtk_vbox_new(false, 0);
            if (this.boxHandle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            if ((this.parent.style & 0x200) != 0) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 2, 0);
            }
        }
        int n3 = 62;
        switch (this.style & n3) {
            case 2: {
                this.handle = OS.gtk_hbox_new(false, 0);
                if (this.handle == 0) {
                    this.error(2);
                }
                boolean bl = (this.parent.style & 0x200) != 0;
                int n4 = this.separatorHandle = bl ? OS.gtk_hseparator_new() : OS.gtk_vseparator_new();
                if (this.separatorHandle == 0) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request(this.separatorHandle, bl ? 15 : 6, bl ? 6 : 15);
                OS.gtk_widget_set_size_request(this.handle, bl ? 15 : 6, bl ? 6 : 15);
                OS.gtk_container_add(this.handle, this.separatorHandle);
                break;
            }
            case 4: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.arrowBoxHandle = OS.gtk_hbox_new(false, 0);
                if (this.arrowBoxHandle == 0) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new(1, 0);
                if (this.arrowHandle == 0) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request(this.arrowHandle, 8, 6);
                OS.gtk_container_add(this.handle, this.arrowBoxHandle);
                OS.gtk_container_add(this.arrowBoxHandle, this.boxHandle);
                OS.gtk_container_add(this.arrowBoxHandle, this.arrowHandle);
                break;
            }
            case 16: 
            case 32: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.gtk_toggle_button_set_mode(this.handle, false);
                OS.gtk_container_add(this.handle, this.boxHandle);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.gtk_container_add(this.handle, this.boxHandle);
            }
        }
        if ((this.style & 2) == 0) {
            int[] nArray = new int[1];
            OS.gtk_widget_style_get(this.parent.handle, OS.button_relief, nArray, 0);
            OS.gtk_button_set_relief(this.handle, nArray[0]);
        }
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        if ((this.parent.state & 0x1000) != 0) {
            this.setForegroundColor(this.parent.getForegroundColor());
        }
        if ((this.parent.state & 0x4000) != 0) {
            this.setFontDescription(this.parent.getFontDescription());
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.showWidget(n);
        this.parent.relayout();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    void deregister() {
        super.deregister();
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar toolBar = this.parent;
        super.dispose();
        toolBar.relayout();
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        this.parent.forceResize();
        int n5 = this.topHandle();
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.control != null && !this.control.isDisposed()) {
            int n6 = OS.gtk_container_get_border_width(this.parent.handle);
            byte[] byArray = Converter.wcsToMbcs(null, "shadow_type", true);
            int[] nArray = new int[1];
            OS.gtk_widget_style_get(this.parent.handle, byArray, nArray, 0);
            if (nArray[0] != 0) {
                n6 += OS.gtk_style_get_xthickness(OS.gtk_widget_get_style(this.parent.handle));
            }
            if ((this.parent.style & 0x200) != 0) {
                n4 = n6;
                n3 = OS.GTK_WIDGET_Y(n5) + n6;
                n2 = OS.GTK_WIDGET_WIDTH(this.parent.handle) - n6 * 2;
                n = OS.GTK_WIDGET_HEIGHT(n5);
            } else {
                n4 = OS.GTK_WIDGET_X(n5) + n6;
                n3 = n6;
                n2 = OS.GTK_WIDGET_WIDTH(n5);
                n = OS.GTK_WIDGET_HEIGHT(this.parent.handle) - n6 * 2;
            }
        } else {
            n4 = OS.GTK_WIDGET_X(n5);
            n3 = OS.GTK_WIDGET_Y(n5);
            n2 = OS.GTK_WIDGET_WIDTH(n5);
            n = OS.GTK_WIDGET_HEIGHT(n5);
        }
        if ((this.parent.style & 0x8000000) != 0) {
            n4 = this.parent.getClientWidth() - n2 - n4;
        }
        if ((this.style & 2) != 0 && this.control != null) {
            n = Math.max(n, 23);
        }
        return new Rectangle(n4, n3, n2, n);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int n = this.topHandle();
        return OS.GTK_WIDGET_SENSITIVE(n);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        this.parent.forceResize();
        int n = this.topHandle();
        return OS.GTK_WIDGET_WIDTH(n);
    }

    int gtk_button_press_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        double d = gdkEventButton.x;
        gdkEventButton.x += (double)OS.GTK_WIDGET_X(this.handle);
        double d2 = gdkEventButton.y;
        gdkEventButton.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        int n3 = this.parent.gtk_button_press_event(n, n2);
        gdkEventButton.x = d;
        gdkEventButton.y = d2;
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        return n3;
    }

    int gtk_button_release_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        double d = gdkEventButton.x;
        gdkEventButton.x += (double)OS.GTK_WIDGET_X(this.handle);
        double d2 = gdkEventButton.y;
        gdkEventButton.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        int n3 = this.parent.gtk_button_release_event(n, n2);
        gdkEventButton.x = d;
        gdkEventButton.y = d2;
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        return n3;
    }

    int gtk_clicked(int n) {
        int n2;
        Event event = new Event();
        if ((this.style & 4) != 0 && (n2 = OS.gtk_get_current_event()) != 0) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: {
                    double[] dArray = new double[1];
                    double[] dArray2 = new double[1];
                    OS.gdk_event_get_coords(n2, dArray, dArray2);
                    int n3 = OS.GTK_WIDGET_X(this.arrowHandle) - OS.GTK_WIDGET_X(this.handle);
                    int n4 = OS.GTK_WIDGET_WIDTH(this.arrowHandle);
                    if (((this.parent.style & 0x4000000) != 0 || n3 > (int)dArray[0]) && ((this.parent.style & 0x4000000) == 0 || (int)dArray[0] > n3 + n4)) break;
                    event.detail = 4;
                    int n5 = this.topHandle();
                    event.x = OS.GTK_WIDGET_X(n5);
                    if ((this.parent.style & 0x8000000) != 0) {
                        event.x = this.parent.getClientWidth() - OS.GTK_WIDGET_WIDTH(n5) - event.x;
                    }
                    event.y = OS.GTK_WIDGET_Y(n5) + OS.GTK_WIDGET_HEIGHT(n5);
                }
            }
            OS.gdk_event_free(n2);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13, event, false);
        return 0;
    }

    int gtk_enter_notify_event(int n, int n2) {
        int n3;
        ImageList imageList;
        this.parent.gtk_enter_notify_event(n, n2);
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && this.imageHandle != 0 && (imageList = this.parent.imageList) != null && (n3 = imageList.indexOf(this.hotImage)) != -1) {
            int n4 = imageList.getPixbuf(n3);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, n4);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
            }
        }
        return 0;
    }

    int gtk_focus_out_event(int n, int n2) {
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        this.parent.lastFocus = this;
        return 0;
    }

    int gtk_leave_notify_event(int n, int n2) {
        this.parent.gtk_leave_notify_event(n, n2);
        if (this.drawHotImage) {
            int n3;
            ImageList imageList;
            this.drawHotImage = false;
            if (this.imageHandle != 0 && this.image != null && (imageList = this.parent.imageList) != null && (n3 = imageList.indexOf(this.image)) != -1) {
                int n4 = imageList.getPixbuf(n3);
                OS.gtk_image_set_from_pixbuf(this.imageHandle, n4);
            }
        }
        return 0;
    }

    int gtk_map(int n) {
        this.parent.fixZOrder();
        return 0;
    }

    int gtk_mnemonic_activate(int n, int n2) {
        return this.parent.gtk_mnemonic_activate(n, n2);
    }

    boolean hasFocus() {
        return OS.GTK_WIDGET_HAS_FOCUS(this.handle);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.closures[8], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[29], 0, this.display.closures[29], false);
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.closures[22], false);
        int n = 32518;
        OS.gtk_widget_add_events(this.handle, n);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[4], 0, this.display.closures[4], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.closures[16], false);
        int n2 = this.topHandle();
        OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[30], 0, this.display.closures[30], true);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        int n;
        ToolItem[] toolItemArray = this.parent._getTabItemList();
        if (toolItemArray != null) {
            n = 0;
            while (n < toolItemArray.length) {
                if (toolItemArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        n = this.parent.indexOf(this);
        if (n == 0) {
            return true;
        }
        ToolItem toolItem = this.parent.getItem(n - 1);
        return (toolItem.getStyle() & 2) != 0;
    }

    void register() {
        super.register();
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.separatorHandle = 0;
        this.arrowHandle = 0;
        this.boxHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            if (this.separatorHandle != 0) {
                OS.gtk_widget_hide(this.separatorHandle);
            }
            Rectangle rectangle = this.getBounds();
            this.control.setSize(rectangle.width, rectangle.height);
            OS.gtk_widget_set_size_request(this.handle, rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.control.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.control.setLocation(rectangle2.x, rectangle2.y);
        } else if (this.separatorHandle != 0) {
            OS.gtk_widget_show(this.separatorHandle);
        }
    }

    void selectRadio() {
        int n = 0;
        ToolItem[] toolItemArray = this.parent.getItems();
        while (n < toolItemArray.length && toolItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && toolItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < toolItemArray.length && toolItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.parent.relayout();
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        int n = this.topHandle();
        if (OS.GTK_WIDGET_SENSITIVE(n) == bl) {
            return;
        }
        OS.gtk_widget_set_sensitive(n, bl);
        if (bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_window_get_pointer(this.parent.paintWindow(), nArray, nArray2, null);
            if (this.getBounds().contains(nArray[0], nArray2[0])) {
                OS.gtk_widget_hide(this.handle);
                OS.gtk_widget_show(this.handle);
            }
        } else if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_widget_set_state(n, 0);
        }
    }

    boolean setFocus() {
        if ((this.style & 2) != 0) {
            return false;
        }
        if (!OS.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        OS.gtk_widget_grab_focus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        boolean bl = OS.gtk_widget_is_focus(this.handle);
        if (!bl) {
            OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        }
        return bl;
    }

    void setFontDescription(int n) {
        OS.gtk_widget_modify_font(this.handle, n);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_font(this.labelHandle, n);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_font(this.imageHandle, n);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor);
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, gdkColor);
        }
        if (this.imageHandle != 0) {
            this.setForegroundColor(this.imageHandle, gdkColor);
        }
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (this.imageHandle == 0) {
            return;
        }
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            int n2 = imageList.getPixbuf(n);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, n2);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_hide(this.imageHandle);
        }
        this.parent.relayout();
    }

    void setOrientation(boolean bl) {
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0) {
                OS.gtk_widget_set_direction(this.handle, n);
            }
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction(this.labelHandle, n);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction(this.imageHandle, n);
            }
            if (this.separatorHandle != 0) {
                OS.gtk_widget_set_direction(this.separatorHandle, n);
            }
            if (this.arrowHandle != 0) {
                OS.gtk_widget_set_direction(this.arrowHandle, n);
            }
            if (this.boxHandle != 0) {
                OS.gtk_widget_set_direction(this.boxHandle, n);
            }
            if (this.arrowBoxHandle != 0) {
                OS.gtk_widget_set_direction(this.arrowBoxHandle, n);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 8);
        OS.gtk_toggle_button_set_active(this.handle, bl);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 8);
    }

    boolean setTabItemFocus(boolean bl) {
        return this.setFocus();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0) {
            return;
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.parent.toolTipText == null) {
            Shell shell = this.parent._getShell();
            this.setToolTipText(shell, string);
        }
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.handle, string);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        boolean bl = (this.parent.style & 0x200) != 0;
        OS.gtk_widget_set_size_request(this.separatorHandle, n, bl ? 6 : 15);
        OS.gtk_widget_set_size_request(this.handle, n, bl ? 6 : 15);
        this.parent.relayout();
    }

    void showWidget(int n) {
        if (this.handle != 0) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.boxHandle != 0) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.separatorHandle != 0) {
            OS.gtk_widget_show(this.separatorHandle);
        }
        if (this.arrowBoxHandle != 0) {
            OS.gtk_widget_show(this.arrowBoxHandle);
        }
        if (this.arrowHandle != 0) {
            OS.gtk_widget_show(this.arrowHandle);
        }
        OS.gtk_toolbar_insert_widget(this.parent.handle, this.handle, null, null, n);
    }
}

